/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.event;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.BizConfigRes;
import com.kingdee.eas.ep.FuncTypeEnum;
import com.kingdee.eas.ep.FunctionRes;
import com.kingdee.eas.ep.client.editor.editui.designer.event.AbstractRuleFunctionDialog;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.UictEvent;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.StringEnum;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public final class RuleFunctionDialog
extends AbstractRuleFunctionDialog {
    private static final Logger logger = CoreUIObject.getLogger(RuleFunctionDialog.class);
    private ActionListener eventRuleManager = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setUserObject(null);
        this.destroyWindow();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.listFunction.getSelectedIndex() != -1) {
            this.handleFunctionSelectedConfirm(e);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)BizConfigRes.getString("RuleFunctionDialog.PLEASE_SELECT_FUNCTION"));
        }
    }

    private void handleFunctionSelectedConfirm(AWTEvent e) {
        int funcSelectedIndex = this.listFunction.getSelectedIndex();
        String selectedFunc = (String)FunctionRes.getInstance().getFuncFormulaVector(this.getSelectFuncType()).get(funcSelectedIndex);
        UictEvent uictEvent = new UictEvent(e.getSource(), e.getID(), null);
        uictEvent.setEventCode(1);
        uictEvent.setAttachment(selectedFunc);
        if (this.eventRuleManager != null) {
            this.eventRuleManager.actionPerformed(uictEvent);
        }
        this.destroyWindow();
    }

    @Override
    protected void cmbFunctionType_actionPerformed(ActionEvent e) throws Exception {
        String funcType = this.getSelectFuncType();
        if (funcType != null) {
            this.refreshFunctionList(funcType);
        }
    }

    private String getSelectFuncType() {
        Object obj = this.cmbFunctionType.getSelectedItem();
        if (obj instanceof StringEnum) {
            String funcType = ((StringEnum)obj).getName();
            return funcType;
        }
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initListFunction();
        this.eventRuleManager = (ActionListener)this.getUIContext().get("BIZ_EVENT_RULE_MANAGER");
        this.refreshFunctionList(FuncTypeEnum.ALL_FUNC.getName());
    }

    private void initListFunction() {
        this.listFunction.setAutoscrolls(true);
        this.listFunction.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int index = RuleFunctionDialog.this.listFunction.getSelectedIndex();
                    Vector descriptions = FunctionRes.getInstance().getFuncDescriptionVector(RuleFunctionDialog.this.getSelectFuncType());
                    if (index != -1) {
                        String funcDescription = (String)descriptions.get(index);
                        RuleFunctionDialog.this.showFuncDescription(funcDescription);
                    }
                }
            }
        });
        this.listFunction.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RuleFunctionDialog.this.handleFunctionSelectedConfirm(e);
                }
            }
        });
    }

    private void showFuncDescription(String funcDescription) {
        this.lbFuncDescription.setText(StringUtils.isEmpty((String)funcDescription) ? "" : funcDescription);
    }

    private void refreshFunctionList(String funcType) {
        this.listFunction.removeAll();
        Vector aVector = FunctionRes.getInstance().getFuncNameVector(funcType);
        if (aVector != null && aVector.size() > 0) {
            this.listFunction.setListData(aVector);
            this.listFunction.setSelectedIndex(0);
        }
    }
}

