/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.event;

import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIDialog;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.BizConfigRes;
import com.kingdee.eas.ep.client.editor.editui.designer.event.AbstractRuleLinkPropTab;
import com.kingdee.eas.ep.client.editor.editui.designer.event.RuleLinkPropDialog;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.BizEventDefHelper;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.IEventHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class RuleLinkPropTab
extends AbstractRuleLinkPropTab
implements IEventHandler {
    private static final Logger logger = CoreUIObject.getLogger(RuleLinkPropTab.class);
    private static final String COLUMN_TARGET_FIELD = "targetField";
    private static final String COLUMN_SOURCE_FIELD = "sourceField";
    private static final String COLUMN_SOURCE_FIELD_PROP = "sourceFieldProp";
    private BizUnitInfo bizUnitInfo = null;
    private BizFieldInfo bizField = null;
    private IObjectValue bizFieldOwner = null;
    private Map aliasFieldMap = null;
    private String oprtState = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        this.tableContent.addRow();
        this.configureButtonStatus();
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        super.btnDelete_actionPerformed(e);
        KDTSelectBlock selectBlock = this.tableContent.getSelectManager().get();
        if (selectBlock == null) {
            MsgBox.showInfo((Component)((Object)this), (String)BizConfigRes.getString("Tab.PLEASE_SELECT_ONE_ROW"));
            return;
        }
        int row = selectBlock.getEndRow();
        if (row != -1 && MsgBox.showConfirm2New((Component)((Object)this), (String)BizConfigRes.getString("Tab.WHETHER_DELETE_OR_NOT")) == 0) {
            this.tableContent.removeRow(row);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map values = (Map)this.getUserObject();
        this.bizUnitInfo = (BizUnitInfo)values.get("BizUnitInfo");
        this.oprtState = (String)values.get("OPRT_STATE");
        this.bizField = (BizFieldInfo)values.get("BizFieldInfo");
        this.bizFieldOwner = (IObjectValue)values.get("BizFieldOwner");
        this.initTable();
    }

    private void initTable() {
        this.tableContent.checkParsed();
        this.tableContent.getSelectManager().setSelectMode(1);
        this.initTableEditor();
        this.tableContent.getColumn(COLUMN_SOURCE_FIELD_PROP).getStyleAttributes().setLocked(true);
        this.tableContent.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (!"VIEW".equals(RuleLinkPropTab.this.oprtState) && e.getType() == 1 && e.getButton() == 1) {
                    int currRow = e.getRowIndex();
                    int currCol = e.getColIndex();
                    if (currCol == 2) {
                        String targetFieldAlais = (String)RuleLinkPropTab.this.tableContent.getCell(currRow, 0).getValue();
                        String sourceFieldAlais = (String)RuleLinkPropTab.this.tableContent.getCell(currRow, 1).getValue();
                        if (!StringUtils.isEmpty((String)targetFieldAlais) && !StringUtils.isEmpty((String)sourceFieldAlais)) {
                            String selectedItem;
                            RuleLinkPropDialog ruleLinkPropDialog;
                            targetFieldAlais = targetFieldAlais.trim();
                            sourceFieldAlais = sourceFieldAlais.trim();
                            BizDataType bizDataType = ((BizFieldInfo)RuleLinkPropTab.this.aliasFieldMap.get(targetFieldAlais)).getBizDataType();
                            EntityObjectInfo entityObjectInfo = ((BizFieldInfo)RuleLinkPropTab.this.aliasFieldMap.get(sourceFieldAlais)).getDataSource();
                            EntityObjectInfo targetEntityObjectInfo = null;
                            if (BizDataType.OBJECT == bizDataType) {
                                targetEntityObjectInfo = ((BizFieldInfo)RuleLinkPropTab.this.aliasFieldMap.get(targetFieldAlais)).getDataSource();
                            }
                            if ((ruleLinkPropDialog = RuleLinkPropTab.this.showPropSelectDialog(bizDataType, entityObjectInfo, targetEntityObjectInfo)) != null && !StringUtils.isEmpty((String)(selectedItem = ruleLinkPropDialog.getSelectedItem()))) {
                                RuleLinkPropTab.this.tableContent.getCell(currRow, currCol).setValue((Object)selectedItem);
                            }
                        }
                    }
                }
            }
        });
        this.configureButtonStatus();
    }

    private void configureButtonStatus() {
        if (this.tableContent.getRowCount() <= 0) {
            this.btnDelete.setEnabled(false);
        } else {
            this.btnDelete.setEnabled(true);
        }
    }

    private RuleLinkPropDialog showPropSelectDialog(BizDataType bizDataType, EntityObjectInfo entityObjectInfo, EntityObjectInfo targetEntityObjectInfo) {
        try {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put("BIZ_DATA_TYPE", bizDataType);
            uiContext.put("ENTITY_OBJECT_INFO", entityObjectInfo);
            uiContext.put("TARGET_ENTITY_OBJECT_INFO", targetEntityObjectInfo);
            UIDialog dialog = (UIDialog)UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RuleLinkPropDialog.class.getName(), (Map)uiContext);
            dialog.show();
            return (RuleLinkPropDialog)dialog.getUIObject();
        }
        catch (Exception err) {
            logger.error((Object)err.getMessage());
            return null;
        }
    }

    private void initTableEditor() {
        KDComboBox editor4TargetField = new KDComboBox();
        KDComboBox editor4SourceField = new KDComboBox();
        this.aliasFieldMap = new HashMap();
        BizFieldCollection fields = this.bizFieldOwner instanceof BizGroupFieldInfo ? ((BizGroupFieldInfo)this.bizFieldOwner).getFields() : this.bizUnitInfo.getFields();
        BizFieldInfo fieldInfo = null;
        int m = fields.size();
        for (int i = 0; i < m; ++i) {
            String fieldAlias;
            fieldInfo = fields.get(i);
            if (!fieldInfo.isFieldsManageVisible() || "id".equalsIgnoreCase(fieldInfo.getName()) || ObjectStateType.DELETED.equals((Object)fieldInfo.getObjectState()) || fieldInfo instanceof BizGroupFieldInfo) continue;
            String string = fieldAlias = fieldInfo.getAlias() == null ? fieldInfo.getName().trim() : fieldInfo.getAlias().trim();
            if (this.bizFieldOwner instanceof BizGroupFieldInfo) {
                BizGroupFieldInfo groupField = (BizGroupFieldInfo)this.bizFieldOwner;
                String entry = StringUtils.isEmpty((String)groupField.getAlias()) ? groupField.getName() : groupField.getAlias();
                fieldAlias = entry + "." + fieldAlias;
            }
            this.aliasFieldMap.put(fieldAlias, fieldInfo);
            if (DataSourceType.BASEDATA.equals((Object)fieldInfo.getDataSourceType())) {
                editor4SourceField.addItem((Object)fieldAlias);
            }
            editor4TargetField.addItem((Object)fieldAlias);
        }
        this.tableContent.getColumn(COLUMN_TARGET_FIELD).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)editor4TargetField));
        this.tableContent.getColumn(COLUMN_SOURCE_FIELD).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)editor4SourceField));
    }

    @Override
    public List getActions() {
        int rowCount = this.tableContent.getRowCount();
        if (rowCount <= 0) {
            return null;
        }
        LinkedList<String> actions = new LinkedList<String>();
        String[] strs = null;
        String expression = null;
        for (int i = 0; i < rowCount; ++i) {
            strs = new String[]{(String)this.tableContent.getCell(i, 0).getValue(), (String)this.tableContent.getCell(i, 1).getValue(), (String)this.tableContent.getCell(i, 2).getValue()};
            expression = this.compoundToExpression(strs);
            if (StringUtils.isEmpty((String)expression)) continue;
            actions.add(expression);
        }
        return actions;
    }

    @Override
    public void setActions(List actions) {
        if (actions != null) {
            String expression = null;
            String[] rowData = null;
            int m = actions.size();
            for (int i = 0; i < m; ++i) {
                expression = (String)actions.get(i);
                rowData = new String[]{this.parseExpression(expression, 0), this.parseExpression(expression, 1), this.parseExpression(expression, 2)};
                BizEventDefHelper.addRowData2Table(this.tableContent, rowData);
            }
        }
        this.configureButtonStatus();
    }

    private String compoundToExpression(String[] strs) {
        if (StringUtils.isEmpty((String)strs[0]) || StringUtils.isEmpty((String)strs[1]) || StringUtils.isEmpty((String)strs[2])) {
            return null;
        }
        String expr = "";
        String str1 = "";
        String str2 = "";
        String str3 = "";
        for (int i = 0; i < this.bizUnitInfo.getFields().size(); ++i) {
            BizFieldInfo field = this.bizUnitInfo.getFields().get(i);
            if (field instanceof BizGroupFieldInfo) {
                String sGroupFieldAlias = "";
                String sGroupFieldName = "";
                BizFieldCollection bizGroupFields = null;
                sGroupFieldAlias = field.getAlias();
                sGroupFieldName = field.getName();
                bizGroupFields = ((BizGroupFieldInfo)field).getFields();
                if (bizGroupFields == null) continue;
                int n = bizGroupFields.size();
                for (int j = 0; j < n; ++j) {
                    BizFieldInfo bizFieldInfo = bizGroupFields.get(j);
                    if (bizFieldInfo.getAlias() == null || StringUtils.isEmpty((String)sGroupFieldAlias) || ObjectStateType.DELETED.equals((Object)bizFieldInfo.getObjectState())) continue;
                    if (strs[0].equalsIgnoreCase(sGroupFieldAlias + "." + bizFieldInfo.getAlias())) {
                        str1 = sGroupFieldName + "." + bizFieldInfo.getName();
                    }
                    if (strs[1].equalsIgnoreCase(sGroupFieldAlias + "." + bizFieldInfo.getAlias())) {
                        str2 = sGroupFieldName + "." + bizFieldInfo.getName();
                        EntityObjectInfo entity = bizFieldInfo.getDataSource();
                        if (entity != null) {
                            str3 = this.getNameDeep(strs[2], entity);
                        }
                    }
                    if (!(bizFieldInfo instanceof BizGroupFieldInfo)) continue;
                    BizFieldInfo bizfield2 = bizFieldInfo;
                    BizFieldCollection bizGroupFields2 = ((BizGroupFieldInfo)bizfield2).getFields();
                    for (int k = 0; k < bizGroupFields2.size(); ++k) {
                        BizFieldInfo tempBizFieldInfo = bizGroupFields2.get(k);
                        if (tempBizFieldInfo.getAlias() == null || ObjectStateType.DELETED.equals((Object)tempBizFieldInfo.getObjectState())) continue;
                        if (strs[0].equalsIgnoreCase(sGroupFieldAlias + "." + bizfield2.getAlias() + "." + tempBizFieldInfo.getAlias())) {
                            str1 = sGroupFieldName + "." + bizfield2.getName() + "." + tempBizFieldInfo.getName();
                        }
                        if (!strs[1].equalsIgnoreCase(sGroupFieldAlias + "." + bizfield2.getAlias() + "." + tempBizFieldInfo.getAlias())) continue;
                        str2 = sGroupFieldName + "." + bizfield2.getName() + "." + tempBizFieldInfo.getName();
                        EntityObjectInfo entity = tempBizFieldInfo.getDataSource();
                        if (entity == null) continue;
                        str3 = this.getNameDeep(strs[2], entity);
                    }
                }
                continue;
            }
            if (strs[0].equals(field.getAlias())) {
                str1 = field.getName();
            }
            if (!strs[1].equals(field.getAlias())) continue;
            str2 = field.getName();
            EntityObjectInfo entity = field.getDataSource();
            str3 = this.getNameDeep(strs[2], entity);
        }
        expr = str1 + " = " + str2 + "." + str3;
        return expr;
    }

    private String parseStr3(String str3, EntityObjectInfo entity, boolean isAlais) {
        String displayName = "";
        String curAlias = "";
        PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
        int pos = str3.indexOf(".");
        if (pos == -1) {
            for (int i = 0; i < props.size(); ++i) {
                if (isAlais) {
                    if (props.get(i) == null || props.get(i).getAlias() == null || !props.get(i).getAlias().equals(str3)) continue;
                    curAlias = props.get(i).getName();
                    return curAlias;
                }
                if (props.get(i) == null || props.get(i).getName() == null || !props.get(i).getName().equals(str3)) continue;
                curAlias = props.get(i).getAlias();
                return curAlias;
            }
        } else {
            String alias = str3.substring(0, pos);
            for (int i = 0; i < props.size(); ++i) {
                if (isAlais) {
                    if (!(props.get(i) instanceof LinkPropertyInfo) || props.get(i) == null || props.get(i).getAlias() == null || !props.get(i).getAlias().equals(alias)) continue;
                    displayName = ((LinkPropertyInfo)props.get(i)).getName();
                    entity = ((LinkPropertyInfo)props.get(i)).getRelationship().getSupplierObject();
                    break;
                }
                if (!(props.get(i) instanceof LinkPropertyInfo) || props.get(i) == null || props.get(i).getName() == null || !props.get(i).getName().equals(alias)) continue;
                displayName = ((LinkPropertyInfo)props.get(i)).getAlias();
                entity = ((LinkPropertyInfo)props.get(i)).getRelationship().getSupplierObject();
                break;
            }
            if (!StringUtils.isEmpty((String)displayName)) {
                str3 = str3.substring(pos + 1);
                displayName = displayName + "." + this.parseStr3(str3, entity, isAlais);
                return displayName;
            }
            return "";
        }
        return displayName;
    }

    private String getAliasDeep(String str3, EntityObjectInfo entity) {
        String disPlayName = "";
        if (!StringUtils.isEmpty((String)str3) && entity != null) {
            int index = str3.indexOf(".");
            if (index != -1) {
                String first = str3.substring(0, index);
                String last = str3.substring(index + 1, str3.length());
                PropertyInfo propertyInfo = entity.getPropertyByName(first);
                if (propertyInfo != null) {
                    disPlayName = propertyInfo.getAlias();
                    if (propertyInfo instanceof LinkPropertyInfo && !StringUtils.isEmpty((String)last)) {
                        disPlayName = disPlayName + "." + this.getAliasDeep(last, ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject());
                    }
                }
            } else {
                PropertyInfo propertyInfo = entity.getPropertyByName(str3);
                if (propertyInfo != null) {
                    disPlayName = propertyInfo.getAlias();
                }
            }
        }
        return disPlayName;
    }

    private String getNameDeep(String str3, EntityObjectInfo entity) {
        String name = "";
        if (!StringUtils.isEmpty((String)str3) && entity != null) {
            int index = str3.indexOf(".");
            if (index != -1) {
                String first = str3.substring(0, index);
                String last = str3.substring(index + 1, str3.length());
                PropertyInfo property = this.getPropertyByAlias(entity, first);
                if (property != null) {
                    name = property.getName();
                    if (property instanceof LinkPropertyInfo && !StringUtils.isEmpty((String)last)) {
                        name = name + "." + this.getNameDeep(last, ((LinkPropertyInfo)property).getRelationship().getSupplierObject());
                    }
                }
            } else {
                PropertyInfo property = this.getPropertyByAlias(entity, str3);
                if (property != null) {
                    name = property.getName();
                }
            }
        }
        return name;
    }

    private PropertyInfo getPropertyByAlias(EntityObjectInfo entity, String alias) {
        PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
        PropertyInfo property = null;
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            property = props.get(i);
            if (!alias.equals(property.getAlias())) continue;
            return property;
        }
        return null;
    }

    private String parseExpression(String expr, int columnIndex) {
        if (StringUtils.isEmpty((String)expr)) {
            return "";
        }
        BizFieldCollection fields = this.bizUnitInfo.getFields();
        switch (columnIndex) {
            case 0: {
                String str = expr.substring(0, expr.indexOf(61)).trim();
                String sGroupFieldName = "";
                String sGroupFieldAlias = "";
                BizFieldCollection bizFields = null;
                for (int i = 0; i < this.bizUnitInfo.getFields().size(); ++i) {
                    BizFieldInfo bizField = this.bizUnitInfo.getFields().get(i);
                    if (bizField instanceof BizGroupFieldInfo) {
                        sGroupFieldName = bizField.getName();
                        sGroupFieldAlias = bizField.getAlias();
                        bizFields = ((BizGroupFieldInfo)bizField).getFields();
                        int n = bizFields.size();
                        for (int j = 0; j < n; ++j) {
                            if (!str.equalsIgnoreCase(sGroupFieldName + "." + bizFields.get(j).getName())) continue;
                            str = sGroupFieldAlias + "." + bizFields.get(j).getAlias();
                            return str;
                        }
                        continue;
                    }
                    if (!bizField.getName().equals(str)) continue;
                    str = bizField.getAlias();
                    break;
                }
                return str;
            }
            case 1: {
                String str = expr.substring(expr.indexOf(61) + 1).trim();
                String sGroupFieldAlias = "";
                String str1 = str.substring(0, str.indexOf("."));
                if (StringUtils.isEmpty((String)str)) {
                    return "";
                }
                BizGroupFieldInfo bizField = this.getGroupFieldByPropertyName(fields, str1);
                if (bizField == null) {
                    bizField = this.bizUnitInfo.getFieldByName(str1);
                    if (bizField != null) {
                        return bizField.getAlias();
                    }
                } else {
                    String str2 = str.substring(str.indexOf(".") + 1);
                    if (str2.indexOf(".") > 0) {
                        str2 = str2.substring(0, str2.indexOf("."));
                        sGroupFieldAlias = bizField.getAlias();
                        BizFieldCollection bizFields = bizField.getFields();
                        int n = bizFields.size();
                        for (int j = 0; j < n; ++j) {
                            BizFieldInfo bf = bizFields.get(j);
                            if (!str2.equalsIgnoreCase(bf.getName())) continue;
                            str = sGroupFieldAlias + "." + bf.getAlias();
                            return str;
                        }
                    }
                }
                return str;
            }
            case 2: {
                String str3 = expr.substring(expr.indexOf(61) + 1).trim();
                String str2 = str3.substring(0, str3.indexOf("."));
                String str1 = str3.substring(str3.indexOf(".") + 1);
                if (StringUtils.isEmpty((String)str3)) {
                    return "";
                }
                String sGroupFieldName = "";
                EntityObjectInfo entity = null;
                BizFieldCollection bizFields = null;
                for (int i = 0; i < fields.size(); ++i) {
                    BizFieldInfo bizField = fields.get(i);
                    if (!bizField.getName().equals(str2)) continue;
                    if (bizField instanceof BizGroupFieldInfo) {
                        if (str1.indexOf(".") <= 0) continue;
                        String _str2 = str1.substring(0, str1.indexOf("."));
                        String _str1 = str1.substring(str1.indexOf(".") + 1);
                        sGroupFieldName = bizField.getName();
                        bizFields = ((BizGroupFieldInfo)bizField).getFields();
                        int n = bizFields.size();
                        for (int j = 0; j < n; ++j) {
                            BizFieldInfo bf = bizFields.get(j);
                            if (!_str2.equalsIgnoreCase(bf.getName())) continue;
                            entity = bf.getDataSource();
                            str3 = this.getAliasDeep(_str1, entity);
                            return str3;
                        }
                        continue;
                    }
                    if (!bizField.getName().equals(str2)) continue;
                    entity = bizField.getDataSource();
                    str3 = this.getAliasDeep(str1, entity);
                    return str3;
                }
                if (entity != null) {
                    str3 = this.parseStr3(str1, entity, true);
                }
                return str3;
            }
        }
        return "";
    }

    protected BizGroupFieldInfo getGroupFieldByPropertyName(BizFieldCollection bizFields, String propertyName) {
        if (bizFields == null) {
            return null;
        }
        for (int i = 0; i < bizFields.size(); ++i) {
            BizFieldInfo bizField = bizFields.get(i);
            if (!bizField.getName().equals(propertyName) || !(bizField instanceof BizGroupFieldInfo)) continue;
            return (BizGroupFieldInfo)bizFields.get(i);
        }
        return null;
    }
}

