/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.event;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.client.editor.editui.designer.event.AbstractRuleOperationPanel;
import com.kingdee.eas.ep.client.editor.editui.designer.event.RuleFunctionDialog;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.UictEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import org.apache.log4j.Logger;

public class RuleOperationPanel
extends AbstractRuleOperationPanel
implements ActionListener {
    private static final Logger logger = CoreUIObject.getLogger(RuleOperationPanel.class);
    private boolean showInsertFunctionButton = true;
    private ActionListener bizRuleManager = null;

    public RuleOperationPanel() throws Exception {
    }

    public RuleOperationPanel(ActionListener bizRuleManager, boolean showInsertFunctionButton) throws Exception {
        this.bizRuleManager = bizRuleManager;
        this.showInsertFunctionButton = showInsertFunctionButton;
        this.initLayout();
        this.onLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.disableButtonsLimitedSize();
        this.setButtonRuleOperation();
        if (!this.showInsertFunctionButton) {
            this.btnInsertFunction.setVisible(false);
        }
        this.addLitenerToButtons();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof KDButton) {
            UictEvent uictEvent = new UictEvent(2, ((KDButton)obj).getUserObject(), e);
            if (this.bizRuleManager != null) {
                this.bizRuleManager.actionPerformed(uictEvent);
            }
        }
    }

    @Override
    protected void btnInsertFunction_actionPerformed(ActionEvent e) throws Exception {
        try {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put("BIZ_EVENT_RULE_MANAGER", this.bizRuleManager);
            IUIWindow funcDialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RuleFunctionDialog.class.getName(), (Map)uiContext);
            funcDialog.show();
        }
        catch (Exception err) {
            logger.error((Object)err.getMessage());
        }
    }

    private void disableButtonsLimitedSize() {
        this.btnAdd.setLimitedSize(false);
        this.btnMinus.setLimitedSize(false);
        this.btnMore.setLimitedSize(false);
        this.btnLess.setLimitedSize(false);
        this.btnAssign.setLimitedSize(false);
        this.btnEqual.setLimitedSize(false);
        this.btnMultiply.setLimitedSize(false);
        this.btnDivide.setLimitedSize(false);
        this.btnLeftBracket.setLimitedSize(false);
        this.btnRightBracket.setLimitedSize(false);
        this.btnAnd.setLimitedSize(false);
        this.btnOr.setLimitedSize(false);
    }

    private void setButtonRuleOperation() {
        this.btnAdd.setUserObject((Object)"+");
        this.btnMinus.setUserObject((Object)"-");
        this.btnMore.setUserObject((Object)">");
        this.btnLess.setUserObject((Object)"<");
        this.btnAssign.setUserObject((Object)"=");
        this.btnEqual.setUserObject((Object)"==");
        this.btnMultiply.setUserObject((Object)"*");
        this.btnDivide.setUserObject((Object)"/");
        this.btnLeftBracket.setUserObject((Object)"(");
        this.btnRightBracket.setUserObject((Object)")");
        this.btnAnd.setUserObject((Object)"AND");
        this.btnOr.setUserObject((Object)"OR");
    }

    private void addLitenerToButtons() {
        this.btnAdd.addActionListener((ActionListener)this);
        this.btnMinus.addActionListener((ActionListener)this);
        this.btnMore.addActionListener((ActionListener)this);
        this.btnLess.addActionListener((ActionListener)this);
        this.btnAssign.addActionListener((ActionListener)this);
        this.btnEqual.addActionListener((ActionListener)this);
        this.btnMultiply.addActionListener((ActionListener)this);
        this.btnDivide.addActionListener((ActionListener)this);
        this.btnLeftBracket.addActionListener((ActionListener)this);
        this.btnRightBracket.addActionListener((ActionListener)this);
        this.btnAnd.addActionListener((ActionListener)this);
        this.btnOr.addActionListener((ActionListener)this);
    }
}

