/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.event;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.BizConfigRes;
import com.kingdee.eas.ep.client.editor.editui.designer.event.AbstractRulePrecisionTab;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.BizEventDefHelper;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.IEventHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class RulePrecisionTab
extends AbstractRulePrecisionTab
implements IEventHandler {
    private static final Logger logger = CoreUIObject.getLogger(RulePrecisionTab.class);
    private static final String[] COLUMN_NAMES = new String[]{"targetField", "sourceField", "sourceFieldProp"};
    private static final String PERFIX = ".precision ";
    private BizUnitInfo bizUnitInfo = null;
    private BizFieldInfo bizField = null;
    private IObjectValue bizFieldOwner = null;
    private Map aliasFieldMap = null;
    private KDComboBox editor4TargetField = null;
    private KDComboBox editor4SourceField = null;
    private KDComboBox editor4SourceFieldProp = null;
    private int lastSelectedRow = -1;
    private String lastSourceField = null;
    private String oprtState = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        this.tableContent.addRow();
        this.configureButtonStatus();
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        super.btnDelete_actionPerformed(e);
        KDTSelectBlock selectBlock = this.tableContent.getSelectManager().get();
        if (selectBlock == null) {
            MsgBox.showInfo((Component)((Object)this), (String)BizConfigRes.getString("Tab.PLEASE_SELECT_ONE_ROW"));
            return;
        }
        int row = selectBlock.getEndRow();
        if (row != -1 && MsgBox.showConfirm2New((Component)((Object)this), (String)BizConfigRes.getString("Tab.WHETHER_DELETE_OR_NOT")) == 0) {
            this.tableContent.removeRow(row);
        }
    }

    @Override
    protected void tableContent_tableClicked(KDTMouseEvent e) throws Exception {
        if (!"VIEW".equals(this.oprtState) && e.getType() == 1 && e.getButton() == 1) {
            int currRow = e.getRowIndex();
            int currCol = e.getColIndex();
            if (currCol == this.tableContent.getColumnIndex(COLUMN_NAMES[2]) && currRow != this.lastSelectedRow) {
                String sourceFieldAlias = (String)this.tableContent.getRow(currRow).getCell(COLUMN_NAMES[1]).getValue();
                this.refreshPropComb(currRow, sourceFieldAlias);
            }
            this.lastSelectedRow = currRow;
        }
    }

    private void refreshPropComb(int currRow, String sourceFieldAlais) {
        BizFieldInfo bizFieldInfo;
        EntityObjectInfo entity;
        IRow selectedRow = this.tableContent.getRow(currRow);
        selectedRow.getCell(COLUMN_NAMES[2]).setValue((Object)"");
        this.editor4SourceFieldProp.removeAllItems();
        if (!StringUtils.isEmpty((String)sourceFieldAlais) && !StringUtils.isEmpty((String)((String)selectedRow.getCell(COLUMN_NAMES[0]).getValue())) && (entity = (bizFieldInfo = (BizFieldInfo)this.aliasFieldMap.get(sourceFieldAlais)).getDataSource()) != null) {
            PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
            int size = props.size();
            for (int j = 0; j < size; ++j) {
                OwnPropertyInfo prop;
                if (props.get(j) instanceof LinkPropertyInfo || props.get(j).getAlias() == null || !DataType.INTEGER.equals((Object)(prop = (OwnPropertyInfo)props.get(j)).getDataType()) && !DataType.SHORT.equals((Object)prop.getDataType()) && !DataType.LONG.equals((Object)prop.getDataType()) && !DataType.BYTE.equals((Object)prop.getDataType())) continue;
                this.editor4SourceFieldProp.addItem((Object)prop.getAlias());
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map values = (Map)this.getUserObject();
        this.bizUnitInfo = (BizUnitInfo)values.get("BizUnitInfo");
        this.oprtState = (String)values.get("OPRT_STATE");
        this.bizField = (BizFieldInfo)values.get("BizFieldInfo");
        this.bizFieldOwner = (IObjectValue)values.get("BizFieldOwner");
        this.initTable();
    }

    private void initTable() {
        this.tableContent.checkParsed();
        this.tableContent.getSelectManager().setSelectMode(1);
        this.initTableEditor();
        this.configureButtonStatus();
    }

    private void configureButtonStatus() {
        if (this.tableContent.getRowCount() <= 0) {
            this.btnDelete.setEnabled(false);
        } else {
            this.btnDelete.setEnabled(true);
        }
    }

    private void initTableEditor() {
        this.editor4TargetField = new KDComboBox();
        this.editor4SourceField = new KDComboBox();
        this.editor4SourceFieldProp = new KDComboBox();
        this.aliasFieldMap = new HashMap();
        BizFieldCollection fields = this.bizFieldOwner instanceof BizGroupFieldInfo ? ((BizGroupFieldInfo)this.bizFieldOwner).getFields() : this.bizUnitInfo.getFields();
        BizFieldInfo fieldInfo = null;
        for (int i = 0; i < fields.size(); ++i) {
            String entry;
            BizGroupFieldInfo groupField;
            fieldInfo = fields.get(i);
            if (fieldInfo.getAlias() == null || !fieldInfo.isFieldsManageVisible() || ObjectStateType.DELETED.equals((Object)fieldInfo.getObjectState()) || fieldInfo instanceof BizGroupFieldInfo) continue;
            BizDataType type = fieldInfo.getBizDataType();
            if (type == null) {
                type = BizDataType.STRING;
            }
            if (type.equals((Object)BizDataType.AMOUNT) || type.equals((Object)BizDataType.DECIMAL) || type.equals((Object)BizDataType.PRICE) || type.equals((Object)BizDataType.QUANTITY)) {
                if (this.bizFieldOwner instanceof BizGroupFieldInfo) {
                    groupField = (BizGroupFieldInfo)this.bizFieldOwner;
                    entry = StringUtils.isEmpty((String)groupField.getAlias()) ? groupField.getName() : groupField.getAlias();
                    this.editor4TargetField.addItem((Object)(entry + "." + fieldInfo.getAlias()));
                    this.aliasFieldMap.put(entry + "." + fieldInfo.getAlias(), fieldInfo);
                } else {
                    this.editor4TargetField.addItem((Object)fieldInfo.getAlias());
                    this.aliasFieldMap.put(fieldInfo.getAlias(), fieldInfo);
                }
            }
            if (this.bizFieldOwner instanceof BizGroupFieldInfo) {
                groupField = (BizGroupFieldInfo)this.bizFieldOwner;
                String string = entry = StringUtils.isEmpty((String)groupField.getAlias()) ? groupField.getName() : groupField.getAlias();
                if (!DataSourceType.BASEDATA.equals((Object)fieldInfo.getDataSourceType())) continue;
                this.editor4SourceField.addItem((Object)(entry + "." + fieldInfo.getAlias()));
                this.aliasFieldMap.put(entry + "." + fieldInfo.getAlias(), fieldInfo);
                continue;
            }
            if (!DataSourceType.BASEDATA.equals((Object)fieldInfo.getDataSourceType())) continue;
            this.editor4SourceField.addItem((Object)fieldInfo.getAlias());
            this.aliasFieldMap.put(fieldInfo.getAlias(), fieldInfo);
        }
        this.editor4SourceField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    KDTSelectBlock selectBlock = RulePrecisionTab.this.tableContent.getSelectManager().get();
                    if (selectBlock == null) {
                        return;
                    }
                    int currRow = selectBlock.getEndRow();
                    RulePrecisionTab.this.refreshPropComb(currRow, (String)RulePrecisionTab.this.editor4SourceField.getSelectedItem());
                }
            }
        });
        this.tableContent.getColumn(COLUMN_NAMES[0]).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.editor4TargetField));
        this.tableContent.getColumn(COLUMN_NAMES[1]).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.editor4SourceField));
        this.tableContent.getColumn(COLUMN_NAMES[2]).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.editor4SourceFieldProp));
    }

    @Override
    public List getActions() {
        int rowCount = this.tableContent.getRowCount();
        if (rowCount <= 0) {
            return null;
        }
        LinkedList<String> actions = new LinkedList<String>();
        String[] strs = null;
        String expression = null;
        for (int i = 0; i < rowCount; ++i) {
            strs = new String[]{(String)this.tableContent.getCell(i, 0).getValue(), (String)this.tableContent.getCell(i, 1).getValue(), (String)this.tableContent.getCell(i, 2).getValue()};
            expression = this.compoundToExpression(strs);
            if (StringUtils.isEmpty((String)expression)) continue;
            actions.add(expression);
        }
        return actions;
    }

    @Override
    public void setActions(List actions) {
        if (actions != null) {
            String expression = null;
            String[] rowData = null;
            int m = actions.size();
            for (int i = 0; i < m; ++i) {
                expression = (String)actions.get(i);
                rowData = new String[]{this.parseExpression(expression, 0), this.parseExpression(expression, 1), this.parseExpression(expression, 2)};
                BizEventDefHelper.addRowData2Table(this.tableContent, rowData);
            }
        }
        this.configureButtonStatus();
    }

    private String compoundToExpression(String[] strs) {
        if (StringUtils.isEmpty((String)strs[0]) || StringUtils.isEmpty((String)strs[1]) || StringUtils.isEmpty((String)strs[2])) {
            return null;
        }
        String expr = "";
        String str1 = "";
        String str2 = "";
        String str3 = "";
        for (int i = 0; i < this.bizUnitInfo.getFields().size(); ++i) {
            BizFieldInfo field = this.bizUnitInfo.getFields().get(i);
            if (field instanceof BizGroupFieldInfo) {
                String sGroupFieldAlias = "";
                String sGroupFieldName = "";
                BizFieldCollection bizGroupFields = null;
                sGroupFieldAlias = field.getAlias();
                sGroupFieldName = field.getName();
                bizGroupFields = ((BizGroupFieldInfo)field).getFields();
                if (bizGroupFields == null) continue;
                BizFieldInfo bizFieldInfo = null;
                int n = bizGroupFields.size();
                for (int j = 0; j < n; ++j) {
                    bizFieldInfo = bizGroupFields.get(j);
                    if (bizFieldInfo.getAlias() == null || !bizFieldInfo.isFieldsManageVisible() || StringUtils.isEmpty((String)sGroupFieldAlias) || ObjectStateType.DELETED.equals((Object)bizFieldInfo.getObjectState())) continue;
                    if (strs[0].equalsIgnoreCase(sGroupFieldAlias + "." + bizFieldInfo.getAlias())) {
                        str1 = sGroupFieldName + "." + bizFieldInfo.getName() + PERFIX;
                    }
                    if (!strs[1].equalsIgnoreCase(sGroupFieldAlias + "." + bizFieldInfo.getAlias())) continue;
                    str2 = sGroupFieldName + "." + bizFieldInfo.getName();
                    EntityObjectInfo entity = bizFieldInfo.getDataSource();
                    if (entity == null) continue;
                    PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
                    for (int k = 0; k < props.size(); ++k) {
                        if (!strs[2].equals(props.get(k).getAlias())) continue;
                        str3 = props.get(k).getName();
                    }
                }
                continue;
            }
            if (strs[0].equals(field.getAlias())) {
                str1 = field.getName() + PERFIX;
            }
            if (!strs[1].equals(field.getAlias())) continue;
            str2 = field.getName();
            EntityObjectInfo entity = field.getDataSource();
            PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
            for (int j = 0; j < props.size(); ++j) {
                if (!strs[2].equals(props.get(j).getAlias())) continue;
                str3 = props.get(j).getName();
            }
        }
        expr = str1 + " = " + str2 + "." + str3;
        return expr;
    }

    private String parseExpression(String expr, int columnIndex) {
        if (StringUtils.isEmpty((String)expr)) {
            return "";
        }
        switch (columnIndex) {
            case 0: {
                if (expr.lastIndexOf(PERFIX) >= 0) {
                    expr = expr.replaceAll(PERFIX, "");
                }
                String str = expr.substring(0, expr.indexOf(61)).trim();
                String sGroupFieldName = "";
                String sGroupFieldAlias = "";
                BizFieldCollection bizFields = null;
                for (int i = 0; i < this.bizUnitInfo.getFields().size(); ++i) {
                    BizFieldInfo bizField = this.bizUnitInfo.getFields().get(i);
                    if (bizField instanceof BizGroupFieldInfo) {
                        sGroupFieldName = bizField.getName();
                        sGroupFieldAlias = bizField.getAlias();
                        bizFields = ((BizGroupFieldInfo)bizField).getFields();
                        int n = bizFields.size();
                        for (int j = 0; j < n; ++j) {
                            if (!str.equalsIgnoreCase(sGroupFieldName + "." + bizFields.get(j).getName())) continue;
                            str = sGroupFieldAlias + "." + bizFields.get(j).getAlias();
                            return str;
                        }
                        continue;
                    }
                    if (!bizField.getName().equals(str)) continue;
                    str = bizField.getAlias();
                    break;
                }
                return str;
            }
            case 1: {
                if (expr.lastIndexOf(PERFIX) >= 0) {
                    expr = expr.replaceAll(PERFIX, "");
                }
                String str = expr.substring(expr.indexOf(61) + 1).trim();
                str = str.substring(0, str.lastIndexOf("."));
                String sGroupFieldName = "";
                String sGroupFieldAlias = "";
                BizFieldCollection bizFields = null;
                for (int i = 0; i < this.bizUnitInfo.getFields().size(); ++i) {
                    BizFieldInfo bizField = this.bizUnitInfo.getFields().get(i);
                    if (bizField instanceof BizGroupFieldInfo) {
                        sGroupFieldName = bizField.getName();
                        sGroupFieldAlias = bizField.getAlias();
                        bizFields = ((BizGroupFieldInfo)bizField).getFields();
                        int n = bizFields.size();
                        for (int j = 0; j < n; ++j) {
                            if (!str.equalsIgnoreCase(sGroupFieldName + "." + bizFields.get(j).getName())) continue;
                            str = sGroupFieldAlias + "." + bizFields.get(j).getAlias();
                            return str;
                        }
                        continue;
                    }
                    if (!bizField.getName().equals(str)) continue;
                    str = bizField.getAlias();
                    break;
                }
                return str;
            }
            case 2: {
                if (expr.lastIndexOf(PERFIX) >= 0) {
                    expr = expr.replaceAll(PERFIX, "");
                }
                String str3 = expr.substring(expr.indexOf(61) + 1).trim();
                String str2 = str3.substring(0, str3.lastIndexOf("."));
                EntityObjectInfo entity = null;
                String sGroupFieldName = "";
                BizFieldCollection bizFields = null;
                for (int i = 0; i < this.bizUnitInfo.getFields().size(); ++i) {
                    BizFieldInfo bizField = this.bizUnitInfo.getFields().get(i);
                    if (bizField instanceof BizGroupFieldInfo) {
                        sGroupFieldName = bizField.getName();
                        bizFields = ((BizGroupFieldInfo)bizField).getFields();
                        boolean bFind = false;
                        int n = bizFields.size();
                        for (int j = 0; j < n; ++j) {
                            if (!str2.equalsIgnoreCase(sGroupFieldName + "." + bizFields.get(j).getName())) continue;
                            entity = bizFields.get(j).getDataSource();
                            bFind = true;
                            break;
                        }
                        if (!bFind) continue;
                        break;
                    }
                    if (!bizField.getName().equals(str2)) continue;
                    entity = bizField.getDataSource();
                    break;
                }
                str3 = str3.substring(str3.lastIndexOf(".") + 1);
                PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
                int size = props.size();
                for (int i = 0; i < size; ++i) {
                    if (!props.get(i).getName().equals(str3)) continue;
                    str3 = props.get(i).getAlias();
                    break;
                }
                return str3;
            }
        }
        return "";
    }
}

