/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.event;

import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.BizConfigRes;
import com.kingdee.eas.ep.client.editor.editui.designer.event.AbstractRuleSetPropTab;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.BizEventDefHelper;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.IEventHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class RuleSetPropTab
extends AbstractRuleSetPropTab
implements IEventHandler {
    private static final Logger logger = CoreUIObject.getLogger(RuleSetPropTab.class);
    private static final String[] COLUMN_NAMES = new String[]{"fieldName", "fieldProperty", "propValue"};
    private static final String[] PROPERTY_NAMES = new String[]{BizConfigRes.getString("RuleSetPropTab.enabled"), BizConfigRes.getString("RuleSetPropTab.visuable")};
    private static final String[] BOOLEAN = new String[]{BizConfigRes.getString("RuleSetPropTab.yes"), BizConfigRes.getString("RuleSetPropTab.no")};
    private BizUnitInfo bizUnitInfo = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        this.tableContent.addRow();
        this.configureButtonStatus();
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        super.btnDelete_actionPerformed(e);
        KDTSelectBlock selectBlock = this.tableContent.getSelectManager().get();
        if (selectBlock == null) {
            MsgBox.showInfo((Component)((Object)this), (String)BizConfigRes.getString("Tab.PLEASE_SELECT_ONE_ROW"));
            return;
        }
        int row = selectBlock.getEndRow();
        if (row != -1 && MsgBox.showConfirm2New((Component)((Object)this), (String)BizConfigRes.getString("Tab.WHETHER_DELETE_OR_NOT")) == 0) {
            this.tableContent.removeRow(row);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map values = (Map)this.getUserObject();
        this.bizUnitInfo = (BizUnitInfo)values.get("BizUnitInfo");
        this.initTable();
    }

    private void initTable() {
        this.tableContent.checkParsed();
        this.tableContent.getSelectManager().setSelectMode(1);
        this.initTableEditor();
        this.configureButtonStatus();
    }

    private void initTableEditor() {
        int i;
        KDComboBox editor4FieldName = new KDComboBox();
        BizFieldCollection fields = this.bizUnitInfo.getFields();
        BizFieldInfo fieldInfo = null;
        for (i = 0; i < fields.size(); ++i) {
            fieldInfo = fields.get(i);
            if (fieldInfo.getAlias() == null || !fieldInfo.isFieldsManageVisible() || ObjectStateType.DELETED.equals((Object)fieldInfo.getObjectState()) || StringUtils.isEmpty((String)fieldInfo.getControlName()) && StringUtils.isEmpty((String)fieldInfo.getWebControlName())) continue;
            editor4FieldName.addItem((Object)fieldInfo.getAlias());
        }
        for (i = 0; i < fields.size(); ++i) {
            fieldInfo = fields.get(i);
            if (fieldInfo.getAlias() == null || !fieldInfo.isFieldsManageVisible() || ObjectStateType.DELETED.equals((Object)fieldInfo.getObjectState()) || !(fieldInfo instanceof BizGroupFieldInfo)) continue;
            this.fillComboField((BizGroupFieldInfo)fieldInfo, editor4FieldName, "");
        }
        KDComboBox editor4FieldProp = new KDComboBox();
        editor4FieldProp.addItems((Object[])PROPERTY_NAMES);
        KDComboBox editor4FieldPropValue = new KDComboBox();
        editor4FieldPropValue.addItems((Object[])BOOLEAN);
        this.tableContent.getColumn(COLUMN_NAMES[0]).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)editor4FieldName));
        this.tableContent.getColumn(COLUMN_NAMES[1]).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)editor4FieldProp));
        this.tableContent.getColumn(COLUMN_NAMES[2]).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)editor4FieldPropValue));
    }

    private void fillComboField(BizGroupFieldInfo groupfield, KDComboBox combo, String parentAlias) {
        String sGroupFieldAlias = "";
        sGroupFieldAlias = groupfield.getAlias();
        BizFieldCollection bizGroupFields = groupfield.getFields();
        BizFieldInfo fieldInfo = null;
        if (bizGroupFields != null) {
            int n = bizGroupFields.size();
            for (int j = 0; j < n; ++j) {
                fieldInfo = bizGroupFields.get(j);
                if (fieldInfo.getAlias() != null && fieldInfo.isFieldsManageVisible() && !StringUtils.isEmpty((String)sGroupFieldAlias) && !ObjectStateType.DELETED.equals((Object)fieldInfo.getObjectState())) {
                    combo.addItem((Object)(parentAlias + sGroupFieldAlias + "." + fieldInfo.getAlias()));
                }
                if (!(fieldInfo instanceof BizGroupFieldInfo)) continue;
                this.fillComboField((BizGroupFieldInfo)fieldInfo, combo, parentAlias + sGroupFieldAlias + ".");
            }
        }
    }

    private void configureButtonStatus() {
        if (this.tableContent.getRowCount() <= 0) {
            this.btnDelete.setEnabled(false);
        } else {
            this.btnDelete.setEnabled(true);
        }
    }

    @Override
    public List getActions() {
        int rowCount = this.tableContent.getRowCount();
        if (rowCount <= 0) {
            return null;
        }
        LinkedList<String> actions = new LinkedList<String>();
        String[] strs = null;
        String expression = null;
        for (int i = 0; i < rowCount; ++i) {
            strs = new String[]{(String)this.tableContent.getCell(i, 0).getValue(), (String)this.tableContent.getCell(i, 1).getValue(), (String)this.tableContent.getCell(i, 2).getValue()};
            expression = this.compoundToExpression(strs);
            if (StringUtils.isEmpty((String)expression)) continue;
            actions.add(expression);
        }
        return actions;
    }

    @Override
    public void setActions(List actions) {
        if (actions != null) {
            String expression = null;
            String[] rowData = null;
            int m = actions.size();
            for (int i = 0; i < m; ++i) {
                expression = (String)actions.get(i);
                rowData = new String[]{this.parseExpression(expression, 0), this.parseExpression(expression, 1), this.parseExpression(expression, 2)};
                BizEventDefHelper.addRowData2Table(this.tableContent, rowData);
            }
        }
        this.configureButtonStatus();
    }

    private String compoundToExpression(String[] strs) {
        if (StringUtils.isEmpty((String)strs[0]) || StringUtils.isEmpty((String)strs[1]) || StringUtils.isEmpty((String)strs[2])) {
            return "";
        }
        String expr = "";
        String sReturn = "";
        for (int i = 0; i < this.bizUnitInfo.getFields().size(); ++i) {
            BizFieldInfo bizField = this.bizUnitInfo.getFields().get(i);
            if (bizField instanceof BizGroupFieldInfo) {
                sReturn = this.compoundGroupField((BizGroupFieldInfo)bizField, bizField.getName(), bizField.getAlias(), strs[0]);
                if (!StringUtils.isEmpty((String)sReturn)) {
                    expr = sReturn;
                    break;
                }
                if (!strs[0].equals(bizField.getAlias())) continue;
                expr = bizField.getName();
                break;
            }
            if (!strs[0].equals(bizField.getAlias())) continue;
            expr = bizField.getName();
            break;
        }
        if (StringUtils.isEmpty((String)expr)) {
            expr = strs[0];
        }
        if (strs[1].equals(PROPERTY_NAMES[0])) {
            expr = expr + ".enabled";
            expr = expr + " = ";
            expr = strs[2].equals(BOOLEAN[0]) ? expr + "false" : expr + "true";
        } else {
            expr = expr + ".visible";
            expr = expr + " = ";
            expr = strs[2].equals(BOOLEAN[0]) ? expr + "true" : expr + "false";
        }
        return expr;
    }

    private String compoundGroupField(BizGroupFieldInfo bizGroupfields, String sParentName, String parentAlias, String str) {
        String sGroupFieldName = "";
        String sGroupFieldAlias = "";
        String sReturnStr = "";
        BizFieldCollection bizFields = bizGroupfields.getFields();
        BizFieldInfo bizFieldInfo = null;
        int n = bizFields.size();
        for (int j = 0; j < n; ++j) {
            bizFieldInfo = bizFields.get(j);
            if (str.equalsIgnoreCase(parentAlias + "." + bizFieldInfo.getAlias())) {
                sReturnStr = sParentName + "." + bizFieldInfo.getName();
                return sReturnStr;
            }
            if (!(bizFieldInfo instanceof BizGroupFieldInfo)) continue;
            sGroupFieldName = bizFieldInfo.getName();
            sGroupFieldAlias = bizFieldInfo.getAlias();
            sReturnStr = this.compoundGroupField((BizGroupFieldInfo)bizFieldInfo, sParentName + "." + sGroupFieldName, parentAlias + "." + sGroupFieldAlias, str);
            if (StringUtils.isEmpty((String)sReturnStr)) continue;
            return sReturnStr;
        }
        return sReturnStr;
    }

    private String parseExpression(String expr, int columnIndex) {
        if (StringUtils.isEmpty((String)expr)) {
            return "";
        }
        switch (columnIndex) {
            case 0: {
                String sReturn = "";
                String str = expr.substring(0, expr.indexOf(61)).trim();
                str = str.substring(0, str.lastIndexOf("."));
                for (int i = 0; i < this.bizUnitInfo.getFields().size(); ++i) {
                    BizFieldInfo bizField = this.bizUnitInfo.getFields().get(i);
                    if (bizField instanceof BizGroupFieldInfo) {
                        sReturn = this.pareseGroupField((BizGroupFieldInfo)bizField, bizField.getName(), bizField.getAlias(), str);
                        if (StringUtils.isEmpty((String)sReturn)) continue;
                        return sReturn;
                    }
                    if (!bizField.getName().equals(str)) continue;
                    str = bizField.getAlias();
                    break;
                }
                return str;
            }
            case 1: {
                String str = expr.substring(0, expr.indexOf(61)).trim();
                str = str.substring(str.lastIndexOf(".") + 1);
                return str.equals("enabled") ? PROPERTY_NAMES[0] : PROPERTY_NAMES[1];
            }
            case 2: {
                String strProp = expr.substring(0, expr.indexOf(61)).trim();
                strProp = strProp.substring(strProp.lastIndexOf(".") + 1);
                String str = expr.substring(expr.indexOf(61) + 1).trim();
                if ("enabled".equalsIgnoreCase(strProp)) {
                    return str.equals("true") ? BOOLEAN[1] : BOOLEAN[0];
                }
                return str.equals("true") ? BOOLEAN[0] : BOOLEAN[1];
            }
        }
        return "";
    }

    private String pareseGroupField(BizGroupFieldInfo bizGroupfields, String sParentName, String parentAlias, String str) {
        String sGroupFieldName = "";
        String sGroupFieldAlias = "";
        String sReturnStr = "";
        if (str.equalsIgnoreCase(sParentName)) {
            sReturnStr = parentAlias;
            return sReturnStr;
        }
        BizFieldCollection bizFields = bizGroupfields.getFields();
        BizFieldInfo bizFieldInfo = null;
        int n = bizFields.size();
        for (int j = 0; j < n; ++j) {
            bizFieldInfo = bizFields.get(j);
            if (str.equalsIgnoreCase(sParentName + "." + bizFieldInfo.getName())) {
                sReturnStr = parentAlias + "." + bizFieldInfo.getAlias();
                return sReturnStr;
            }
            if (!(bizFieldInfo instanceof BizGroupFieldInfo)) continue;
            sGroupFieldName = bizFieldInfo.getName();
            sGroupFieldAlias = bizFieldInfo.getAlias();
            sReturnStr = this.pareseGroupField((BizGroupFieldInfo)bizFieldInfo, sParentName + "." + sGroupFieldName, parentAlias + "." + sGroupFieldAlias, str);
            if (StringUtils.isEmpty((String)sReturnStr)) continue;
            return sReturnStr;
        }
        return sReturnStr;
    }
}

