/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.event.expression;

import com.kingdee.eas.ep.client.editor.editui.designer.event.expression.BizExpressionType;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BizSettingExpression {
    private String key;
    private Object value;
    private BizExpressionType expressionType;
    public static final String UNKOWN = "unkown";
    public static final String ENABLED = "enabled";
    public static final String VISIBLE = "visible";
    public static final String LABEL = "label";
    public static final String INDEX = "index";
    public static final String SUMFIELDS = "sumFields";
    public static final String REQUIRED = "required";
    public static final String DEFAULTVALUE = "defaultValue";
    public static final String FROZEN = "frozen";
    public static final String WIDTH = "width";
    public static final String HORIZONALIGN = "horizonAlign";
    private static final Logger logger = Logger.getLogger(BizSettingExpression.class);

    public BizSettingExpression(String key, Object value, BizExpressionType expressionType) {
        this.key = key;
        this.value = value;
        this.expressionType = expressionType;
    }

    public static BizSettingExpression create(String source) {
        if (StringUtils.isEmpty((String)source)) {
            return null;
        }
        int index = source.indexOf("=");
        if (index > 0) {
            String key = null;
            Object objValue = null;
            BizExpressionType expressionType = null;
            String keyWithProperty = source.substring(0, index).trim();
            String value = source.substring(index + 1).trim();
            int lastIndexOfDot = keyWithProperty.lastIndexOf(".");
            if (lastIndexOfDot > 0) {
                key = keyWithProperty.substring(0, lastIndexOfDot).trim();
                String propertyName = keyWithProperty.substring(lastIndexOfDot + 1).trim();
                if (ENABLED.equalsIgnoreCase(propertyName)) {
                    objValue = Boolean.valueOf(value);
                    expressionType = BizExpressionType.SETUIENABLED;
                } else if (VISIBLE.equalsIgnoreCase(propertyName)) {
                    objValue = Boolean.valueOf(value);
                    expressionType = BizExpressionType.SETUIVISIBLE;
                } else if (INDEX.equalsIgnoreCase(propertyName)) {
                    ArrayList<String> list = new ArrayList<String>();
                    if (!StringUtils.isEmpty((String)value)) {
                        String[] items = StringUtils.split((String)value, (String)",");
                        int n = items.length;
                        for (int i = 0; i < n; ++i) {
                            list.add(items[i]);
                        }
                    }
                    objValue = list;
                    expressionType = BizExpressionType.SETUIINDEX;
                } else if (SUMFIELDS.equalsIgnoreCase(propertyName)) {
                    ArrayList<String> list = new ArrayList<String>();
                    if (!StringUtils.isEmpty((String)value)) {
                        String[] items = StringUtils.split((String)value, (String)",");
                        int n = items.length;
                        for (int i = 0; i < n; ++i) {
                            list.add(items[i]);
                        }
                    }
                    objValue = list;
                    expressionType = BizExpressionType.SETSUM;
                } else if (LABEL.equalsIgnoreCase(propertyName)) {
                    objValue = value;
                    expressionType = BizExpressionType.SETUILABEL;
                } else if (REQUIRED.equalsIgnoreCase(propertyName)) {
                    objValue = Boolean.valueOf(value);
                    expressionType = BizExpressionType.SETREQUIRED;
                } else if (DEFAULTVALUE.equalsIgnoreCase(propertyName)) {
                    objValue = value;
                    expressionType = BizExpressionType.SETDEFAULTVALUE;
                } else if (FROZEN.equalsIgnoreCase(propertyName)) {
                    objValue = Boolean.valueOf(value);
                    expressionType = BizExpressionType.SETFROZEN;
                } else if (WIDTH.equalsIgnoreCase(propertyName)) {
                    objValue = new Integer(value);
                    expressionType = BizExpressionType.SETWIDTH;
                } else if (HORIZONALIGN.equalsIgnoreCase(propertyName)) {
                    objValue = value;
                    expressionType = BizExpressionType.SETHORIZONALIGN;
                }
                return new BizSettingExpression(key, objValue, expressionType);
            }
        }
        return null;
    }

    public BizExpressionType getExpressionType() {
        return this.expressionType;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        if (this.value == null) {
            return "";
        }
        return this.value;
    }

    public String toString() {
        String propertyName = UNKOWN;
        String objValue = "";
        if (this.value != null) {
            objValue = this.value.toString();
        }
        if (BizExpressionType.SETUIENABLED.equals((Object)this.expressionType)) {
            propertyName = ENABLED;
        } else if (BizExpressionType.SETUIVISIBLE.equals((Object)this.expressionType)) {
            propertyName = VISIBLE;
        } else if (BizExpressionType.SETUILABEL.equals((Object)this.expressionType)) {
            propertyName = LABEL;
        } else if (BizExpressionType.SETDEFAULTVALUE.equals((Object)this.expressionType)) {
            propertyName = DEFAULTVALUE;
        } else if (BizExpressionType.SETUIINDEX.equals((Object)this.expressionType)) {
            propertyName = INDEX;
            objValue = "";
            List list = (List)this.value;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                objValue = i == 0 ? list.get(i).toString() : objValue + "," + list.get(i).toString();
            }
        } else if (BizExpressionType.SETREQUIRED.equals((Object)this.expressionType)) {
            propertyName = REQUIRED;
        } else if (BizExpressionType.SETSUM.equals((Object)this.expressionType)) {
            propertyName = SUMFIELDS;
            objValue = "";
            List list = (List)this.value;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                objValue = i == 0 ? list.get(i).toString() : objValue + "," + list.get(i).toString();
            }
        } else if (BizExpressionType.SETFROZEN.equals((Object)this.expressionType)) {
            propertyName = FROZEN;
        } else if (BizExpressionType.SETWIDTH.equals((Object)this.expressionType)) {
            propertyName = WIDTH;
        } else if (BizExpressionType.SETHORIZONALIGN.equals((Object)this.expressionType)) {
            propertyName = HORIZONALIGN;
        }
        return this.key + "." + propertyName + " = " + objValue;
    }

    public static void main(String[] args) {
        String source = "abc.enabled=true";
        BizSettingExpression exp = BizSettingExpression.create(source);
        logger.info((Object)("source:" + exp.getKey()));
        logger.info((Object)("key:" + exp.getKey()));
        logger.info((Object)("expression type:" + (Object)((Object)exp.getExpressionType())));
        logger.info((Object)("value:" + exp.getValue()));
        logger.error((Object)exp);
    }
}

