/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.event.util;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class ScriptScanner {
    protected Hashtable fgKeys = null;
    protected StringBuffer fBuffer = new StringBuffer();
    protected String fDoc;
    protected int fPos;
    protected int fEnd;
    protected int fStartToken;
    protected boolean fEofSeen = false;
    protected boolean fBeginTran = false;
    public static final int EOF = -1;
    public static final int EOL = 10;
    public static final int OPERATOR = 0;
    public static final int WHITE = 1;
    public static final int KEY = 2;
    public static final int COMMENT = 3;
    public static final int STRING = 4;
    public static final int NUMBER = 5;
    public static final int TRANSFER = 6;
    public static final int OTHER = 7;
    public static final int MAXIMUM_TOKEN = 8;
    public static final Set scriptKeyWordCharacters = new HashSet(5);
    private String[] fgKeywords = new String[]{"IF", "THEN", "ELSE", "AND", "OR"};

    public ScriptScanner() {
        this.initialize();
    }

    void registerKeyWord(String keyword) {
        this.fgKeys.put(keyword, new Integer(2));
    }

    void unregisterKeyWord(String keyword) {
        this.fgKeys.remove(keyword);
    }

    public final int getLength() {
        return this.fPos - this.fStartToken;
    }

    void initialize() {
        this.fgKeys = new Hashtable();
        Integer k = new Integer(2);
        for (int i = 0; i < this.fgKeywords.length; ++i) {
            this.fgKeys.put(this.fgKeywords[i], k);
        }
    }

    public final int getStartOffset() {
        return this.fStartToken;
    }

    public int nextToken() {
        this.fStartToken = this.fPos;
        int c = this.read();
        switch (c) {
            case -1: {
                return -1;
            }
            case 47: {
                c = this.read();
                if (c == 47) {
                    while ((c = this.read()) != -1 && c != 10) {
                    }
                    this.unread(c);
                    return 3;
                }
                this.unread(c);
                return 0;
            }
            case 34: {
                while (true) {
                    c = this.read();
                    switch (c) {
                        case 34: {
                            return 4;
                        }
                        case -1: {
                            this.unread(c);
                            return 7;
                        }
                        case 92: {
                            c = this.read();
                        }
                    }
                }
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 60: 
            case 61: 
            case 62: {
                return 0;
            }
            case 91: {
                this.fBeginTran = true;
                return 6;
            }
            case 93: {
                this.fBeginTran = false;
                return 6;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                while (Character.isDigit((char)(c = this.read())) || c == 46) {
                }
                this.unread(c);
                return 5;
            }
        }
        if (Character.isWhitespace((char)c)) {
            while (Character.isWhitespace((char)(c = this.read()))) {
            }
            this.unread(c);
            return 1;
        }
        if (Character.isJavaIdentifierStart((char)c)) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while (this.isScriptCharacter((char)(c = this.read())) && c != -1);
            this.unread(c);
            Integer i = (Integer)this.fgKeys.get(this.fBuffer.toString());
            if (i != null) {
                return i;
            }
            return 7;
        }
        return 7;
    }

    private boolean isScriptCharacter(char c) {
        if (Character.isJavaIdentifierPart(c)) {
            return true;
        }
        if (scriptKeyWordCharacters.contains(new Character(c))) {
            return true;
        }
        return this.fBeginTran && !String.valueOf(c).equalsIgnoreCase("]");
    }

    protected int read() {
        if (this.fPos <= this.fEnd) {
            return this.fDoc.charAt(this.fPos++);
        }
        this.fBeginTran = false;
        return -1;
    }

    public void setRange(String text) {
        this.fDoc = text;
        this.fPos = 0;
        this.fEnd = this.fDoc.length() - 1;
    }

    protected void unread(int c) {
        if (c != -1) {
            --this.fPos;
        }
    }

    static {
        scriptKeyWordCharacters.add(new Character('.'));
    }
}

