/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.model.property;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.eas.ep.client.editor.bind.DataBindUtils;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.ObjectProperty;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemInfo;
import com.kingdee.eas.ep.client.validate.imp.DataBindValidater;
import com.kingdee.util.StringUtils;

public class DataBindProperty
extends ObjectProperty {
    @Override
    public void setValue(Object value, boolean fireEvent) {
        Object old = this.value;
        this.value = value;
        if (value != old && (value == null || !value.equals(old)) && fireEvent) {
            AbstractBizConfigureItemInfo item = this.getOwner().getItem();
            ComponentInfo component = item.getComponent();
            String[] names = DataBindUtils.getAllPropertyNames(component);
            if (names.length < 1) {
                return;
            }
            PropertyBindingCollection bindings = component.getPropertyBindings();
            PropertyBindingInfo oldBindInfo = (PropertyBindingInfo)old;
            if (value == null) {
                bindings.removeObject((IObjectValue)oldBindInfo);
                this.resetComponent(component, oldBindInfo, -1);
                DataBindUtils.delProBindDesc(component, oldBindInfo);
                item.setProperty(null);
            } else if (!value.equals(old) && value instanceof PropertyBindingInfo) {
                PropertyBindingInfo bindInfo = (PropertyBindingInfo)value;
                EntityObjectInfo bindEntity = ((Context)this.context).getEditorUI().getModel().getEntity();
                if (bindEntity == null) {
                    throw new RuntimeException("\u6b64\u754c\u9762\u65e0\u7ed1\u5b9a\u5b9e\u4f53\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u6570\u636e\u7ed1\u5b9a");
                }
                bindInfo.setPropertyName(names[0]);
                DataBindValidater validater = new DataBindValidater((Context)this.getContext());
                boolean flag = validater.validate(component, (PropertyBindingInfo)value);
                if (!flag) {
                    throw new RuntimeException(validater.getMessage());
                }
                if (oldBindInfo == null) {
                    bindings.add(bindInfo);
                    this.resetComponent(component, bindInfo, 1);
                    DataBindUtils.addProBindDesc(component, bindInfo);
                } else {
                    DataBindUtils.delProBindDesc(component, oldBindInfo);
                    oldBindInfo.setPropertyName(bindInfo.getPropertyName());
                    oldBindInfo.setBingdingField(bindInfo.getBingdingField());
                    oldBindInfo.setFieldType(bindInfo.getFieldType());
                    oldBindInfo.setBindingObject(bindInfo.getBindingObject());
                    this.resetComponent(component, oldBindInfo, 1);
                    DataBindUtils.addProBindDesc(component, oldBindInfo);
                }
                this.resetBindProperty((Context)this.context, item, bindInfo.getBingdingField());
            }
            this.getContext().setDirty(true);
        }
    }

    private void resetBindProperty(Context context, AbstractBizConfigureItemInfo item, String propertyName) {
        EntityObjectInfo entity = context.getEditorUI().getModel().getEntity();
        PropertyInfo propertyInfo = entity.getPropertyByName(propertyName);
        if (propertyInfo != null) {
            item.setProperty(propertyInfo);
        }
    }

    private void resetComponent(ComponentInfo cInfo, PropertyBindingInfo bindInfo, int type) {
        if (bindInfo == null || cInfo == null) {
            return;
        }
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(cInfo.getClassType())) {
            this.extractPropertyToTable(cInfo, bindInfo, type);
        } else {
            EntityObjectInfo bindEntity = ((Context)this.context).getEditorUI().getModel().getEntity();
            DataBindUtils.extractPropertyToComponentInfo(bindEntity, cInfo, bindInfo, type);
        }
    }

    private void extractPropertyToTable(ComponentInfo cInfo, PropertyBindingInfo bindInfo, int type) {
        if (bindInfo != null && !StringUtils.isEmpty((String)bindInfo.getBindingObject())) {
            EntityObjectInfo bindEntity = ((Context)this.context).getEditorUI().getModel().getEntity();
            DataBindUtils.extractPropertyToTable(cInfo, null, bindEntity, bindInfo, type);
        }
    }

    @Override
    public String getName() {
        return "Databind";
    }

    @Override
    public String getDisplayName() {
        return "\u7ed1\u5b9a\u5b9e\u4f53\u5b57\u6bb5";
    }
}

