/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.model.property;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.IContext;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.PropertyValueChangeCommand;
import com.kingdee.eas.ep.client.editor.editui.designer.model.AbstractItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.Property;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.log4j.Logger;

public class ObjectProperty
implements Property {
    protected Object value;
    protected AbstractItemInfoAdapter owner;
    protected String category;
    protected String name;
    protected String displayName;
    protected boolean visible = true;
    protected boolean isEditable = true;
    protected Class editorType;
    protected Class[] editorClassParamType;
    protected Object[] editorClassParams;
    protected IContext context;
    private transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    protected static final Logger logger = CoreUIObject.getLogger(ObjectProperty.class);

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.setValue(value, true);
    }

    public void setValue(Object value, boolean fireEvent) {
        Object old = this.value;
        this.value = value;
        if (value != old && (value == null || !value.equals(old)) && fireEvent) {
            this.innerSetValue(this.value);
        }
    }

    protected void innerSetValue(Object value) {
        String disPlayText = "";
        if (value != null) {
            disPlayText = value.toString();
        }
        PropertyValueChangeCommand command = new PropertyValueChangeCommand(this.getName(), (BizConfigureItemInfoAdapter)this.getOwner(), value, disPlayText);
        command.setContext((Context)this.context);
        this.context.getCommandStack().execute(command);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
        Property[] subProperties = this.getSubProperties();
        if (subProperties != null) {
            for (int i = 0; i < subProperties.length; ++i) {
                subProperties[i].addPropertyChangeListener(listener);
            }
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
        Property[] subProperties = this.getSubProperties();
        if (subProperties != null) {
            for (int i = 0; i < subProperties.length; ++i) {
                subProperties[i].removePropertyChangeListener(listener);
            }
        }
    }

    protected void firePropertyChange(Object oldValue, Object newValue) {
        this.listeners.firePropertyChange("value", oldValue, newValue);
    }

    @Override
    public AbstractItemInfoAdapter getOwner() {
        return this.owner;
    }

    public void setOwner(AbstractItemInfoAdapter owner) {
        this.owner = owner;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String disPlayName) {
        this.displayName = disPlayName;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    @Override
    public Class getType() {
        return this.editorType;
    }

    public void setType(Class type) {
        this.editorType = type;
    }

    @Override
    public Class[] getEditorClassParamType() {
        return this.editorClassParamType;
    }

    @Override
    public Object[] getEditorClassParams() {
        return this.editorClassParams;
    }

    public void setEditorClassParamType(Class[] cls) {
        this.editorClassParamType = cls;
    }

    public void setEditorClassParams(Object[] params) {
        this.editorClassParams = params;
    }

    @Override
    public String getShortDescription() {
        return null;
    }

    @Override
    public Property getParentProperty() {
        return null;
    }

    @Override
    public Property[] getSubProperties() {
        return null;
    }

    @Override
    public IContext getContext() {
        return this.context;
    }

    public void setContext(IContext context) {
        this.context = context;
    }
}

