/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.policy;

import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPolicy;
import com.kingdee.eas.ep.client.editor.editui.designer.Request;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.ResizeCommand;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.request.ResizeRequest;

public class ResizePolicy
implements EditPolicy {
    private EditPart editpart;

    @Override
    public boolean understandsRequest(Request request) {
        return request != null && "resize".equals(request.getType());
    }

    @Override
    public Command getCommand(Request request) {
        if (request != null && "resize".equals(request.getType())) {
            ResizeRequest resizeRequest = (ResizeRequest)request;
            EditPart source = resizeRequest.getSourceEditPart();
            BizConfigureItemInfoAdapter model = (BizConfigureItemInfoAdapter)source.getModel();
            KDRectangle newSize = new KDRectangle(model.getBounds());
            KDRectangle oldSize = model.getBounds();
            int coordinate = resizeRequest.getCoordinate();
            switch (resizeRequest.getBorder()) {
                case 8: {
                    int offset = oldSize.getY() - coordinate;
                    newSize.setY(coordinate);
                    newSize.setHeight(newSize.getHeight() + offset);
                    break;
                }
                case 9: {
                    newSize.setHeight(coordinate - oldSize.getY());
                    break;
                }
                case 10: {
                    int offset = oldSize.getX() - coordinate;
                    newSize.setX(coordinate);
                    newSize.setWidth(newSize.getWidth() + offset);
                    break;
                }
                case 11: {
                    newSize.setWidth(coordinate - oldSize.getX());
                }
            }
            ResizeCommand command = new ResizeCommand(model, newSize);
            return command;
        }
        return null;
    }

    @Override
    public EditPart getHost() {
        return this.editpart;
    }

    @Override
    public EditPart getTargetEditPart(Request request) {
        return null;
    }

    @Override
    public void setHost(EditPart editpart) {
        this.editpart = editpart;
    }
}

