/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.ui;

import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartFactory;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartManager;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.IContext;
import com.kingdee.eas.ep.client.editor.editui.designer.UictEditPartFactory;
import com.kingdee.eas.ep.client.editor.editui.designer.action.ActionRegistry;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.CommandStack;
import com.kingdee.eas.ep.client.editor.editui.designer.listener.ISelectionChangedListener;
import com.kingdee.eas.ep.client.editor.editui.designer.listener.SelectionChangedEvent;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.request.MultiSelectedRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.request.SelectedRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.request.UnSelectedRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.util.UictEditorHelper;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class UictKDTabbedPane
extends KDTabbedPane
implements EditPartViewer,
MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = -6572788437357426307L;
    private static Logger logger = Logger.getLogger(UictKDTabbedPane.class);
    private UictEditPartFactory factory;
    private EditPartManager partManager;
    protected Context context;
    private BizConfigureTreeNode node;
    private CommandStack commandStack;
    private ActionRegistry actionRegistry;
    private EditPartViewer parentViewer;
    private List childViewer = new ArrayList();
    private Map itemAdapterMap = new HashMap();

    public UictKDTabbedPane(BizConfigureTreeNode node, Context context) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addHeadMouseListener(this);
        this.setOpaque(false);
        this.node = node;
        this.context = context;
        this.commandStack = context.getCommandStack();
        this.factory = new UictEditPartFactory(node, context);
        this.actionRegistry = new ActionRegistry();
        this.partManager = new EditPartManager();
        this.regestListeners();
        this.createEditPart();
    }

    private void regestListeners() {
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent event) {
                UictKDTabbedPane.this.context.getEditorUI().editPartSelectionChanged(event);
            }
        };
        this.addSelectionChangedListener(listener);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dispatchEvent2ParentViewer(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.dispatchEvent2ParentViewer(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            Component comp = this.getSelectedComponent();
            if (comp != null) {
                Point p;
                Rectangle rect = comp.getBounds();
                if (rect.contains(p = e.getPoint())) {
                    int index = this.getSelectedIndex();
                    EditPart part = (EditPart)this.partManager.getPartList().get(index);
                    if (!this.isMutiSelectModel(e)) {
                        this.setAllEditPartUnSelected();
                        this.partManager.select(part);
                        part.performRequest(new SelectedRequest());
                    }
                } else {
                    this.dispatchEvent2ParentViewer(e);
                }
            }
        } else {
            this.dispatchEvent2ParentViewer(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Component comp;
        if (SwingUtilities.isLeftMouseButton(e) && (comp = this.getSelectedComponent()) != null) {
            Point p;
            Rectangle rect = comp.getBounds();
            if (rect.contains(p = e.getPoint())) {
                int index = this.getSelectedIndex();
                EditPart part = (EditPart)this.partManager.getPartList().get(index);
                if (!this.isMutiSelectModel(e)) {
                    this.setAllEditPartUnSelected();
                    this.partManager.select(part);
                    part.performRequest(new SelectedRequest());
                } else {
                    this.partManager.addMultiSelected(part);
                    part.performRequest(new MultiSelectedRequest());
                }
            } else {
                this.dispatchEvent2ParentViewer(e);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dispatchEvent2ParentViewer(e);
    }

    private void dispatchEvent2ParentViewer(MouseEvent e) {
        UictEditorHelper.dispatchEvent2ParentViewer((JComponent)((Object)this), e);
    }

    @Override
    public EditPartFactory getEditPartFactory() {
        return this.factory;
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.partManager.addSelectionChangedListener(listener);
    }

    @Override
    public void removeSelectionChangedListener(ISelectionChangedListener l) {
        this.partManager.removeSelectionChangedListener(l);
    }

    @Override
    public void select(EditPart editpart) {
        this.partManager.select(editpart);
    }

    @Override
    public EditPart getSelection() {
        return this.partManager.getSelection();
    }

    @Override
    public CommandStack getCommandStack() {
        return this.commandStack;
    }

    @Override
    public IContext getContext() {
        return this.context;
    }

    @Override
    public ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    @Override
    public EditPartViewer getParentViewer() {
        return this.parentViewer;
    }

    @Override
    public void setParentViewer(EditPartViewer parentViewer) {
        this.parentViewer = parentViewer;
    }

    @Override
    public List getChildViewer() {
        return this.childViewer;
    }

    @Override
    public void addChildViewer(EditPartViewer viewer) {
        this.childViewer.add(viewer);
    }

    @Override
    public JComponent getMaskPanel() {
        return this;
    }

    @Override
    public EditPartManager getPartManager() {
        return this.partManager;
    }

    public void createEditPart() {
        if (this.factory == null) {
            logger.info((Object)"factory is null...");
            throw new NullPointerException("factory is null...");
        }
        Iterator iter = this.node.getConfigureItems().iterator();
        while (iter.hasNext()) {
            EditPart part;
            BizConfigureItemInfoAdapter item = new BizConfigureItemInfoAdapter((BizConfigureItemInfo)iter.next());
            if (UictEditorHelper.contains(this.partManager, (BizConfigureItemInfo)item.getItem()) || (part = this.factory.createEditPart(item)) == null) continue;
            part.setViewer(this);
            this.partManager.add(part);
            this.itemAdapterMap.put(item.getItem(), item);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setAllEditPartUnSelected() {
        if (this.partManager != null) {
            List selected = this.partManager.getMultiSelected();
            for (int i = 0; i < selected.size(); ++i) {
                ((EditPart)selected.get(i)).performRequest(new UnSelectedRequest());
            }
            this.partManager.clearMultiSelected();
            this.partManager.select(null);
            this.partManager.source(null);
        }
    }

    public void paintComponent(Graphics g) {
        Component comp;
        super.paintComponent(g);
        List selected = this.partManager.getMultiSelected();
        if (!selected.isEmpty() && (comp = this.getComponentAt(0)) != null) {
            Rectangle r = comp.getBounds();
            Stroke stroke = ((Graphics2D)g).getStroke();
            Color color = ((Graphics2D)g).getColor();
            ((Graphics2D)g).setStroke(new BasicStroke(3.0f));
            g.setColor(Color.orange);
            g.drawRect(r.x, r.y + 1, r.width, r.height - 1);
            g.setColor(color);
            ((Graphics2D)g).setStroke(stroke);
        }
    }

    private boolean isMutiSelectModel(MouseEvent e) {
        return e.isControlDown() || 3 == this.getContext().getStatus();
    }
}

