/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.ui.property;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class CellEditorAdapter
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    private static final String KEY_MSG = "msg";
    private static final String KEY_MSG_TITLE = "msgTitle";
    protected PropertyEditor editor;
    protected int clickCountToStart = 1;

    public CellEditorAdapter(PropertyEditor editor) {
        this.editor = editor;
        Component component = editor.getCustomEditor();
        if (component instanceof JTextField) {
            JTextField field = (JTextField)component;
            field.addFocusListener(new SelectOnFocus());
            field.addActionListener(new CommitEditing());
            field.registerKeyboardAction(new CancelEditing(), KeyStroke.getKeyStroke(27, 0), 0);
        }
        editor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean success = CellEditorAdapter.this.stopCellEditing();
                if (!success) {
                    CellEditorAdapter.this.cancelCellEditing();
                }
            }
        });
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        return this.getEditor(value);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
        return this.getEditor(value);
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getValue();
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        if (event instanceof MouseEvent) {
            return ((MouseEvent)event).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    public static String getLocalText(String key) {
        return LanguageManager.getLangMessage((String)key, CellEditorAdapter.class, (String)"NotFound");
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.fireEditingStopped();
        }
        catch (RuntimeException e) {
            Throwable throwable = e.getCause();
            final JTable table = (JTable)this.editor.getCustomEditor().getParent();
            table.putClientProperty("terminateEditOnFocusLost", Boolean.FALSE);
            if (throwable instanceof InvocationTargetException) {
                MessageDialog.show((Component)this.editor.getCustomEditor(), (Object)CellEditorAdapter.getLocalText(KEY_MSG), (String)CellEditorAdapter.getLocalText(KEY_MSG_TITLE), (int)-1, (int)3, (int)0, null);
            } else {
                MsgBox.showError((Component)table, (String)("\u4e0d\u5408\u6cd5\u7684\u8f93\u5165 : " + e.getMessage()));
            }
            this.cancelCellEditing();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
                }
            });
        }
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    private Component getEditor(Object value) {
        this.editor.setValue(value);
        final Component cellEditor = this.editor.getCustomEditor();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                cellEditor.requestFocus();
            }
        });
        return cellEditor;
    }

    class SelectOnFocus
    implements FocusListener {
        SelectOnFocus() {
        }

        @Override
        public void focusGained(final FocusEvent e) {
            if (!(e.getSource() instanceof JTextField)) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JTextField)e.getSource()).selectAll();
                }
            });
        }

        @Override
        public void focusLost(final FocusEvent e) {
            if (!(e.getSource() instanceof JTextField)) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JTextField)e.getSource()).select(0, 0);
                }
            });
        }
    }

    class CancelEditing
    implements ActionListener {
        CancelEditing() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CellEditorAdapter.this.cancelCellEditing();
        }
    }

    class CommitEditing
    implements ActionListener {
        CommitEditing() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean success = CellEditorAdapter.this.stopCellEditing();
            if (!success) {
                CellEditorAdapter.this.cancelCellEditing();
            }
        }
    }
}

