/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.eas.ep.BizDataTypeEnum;
import com.kingdee.eas.ep.DataSourceEnum;
import com.kingdee.eas.ep.client.depend.ctrl.DepBizPromptBox;
import com.kingdee.eas.ep.client.editor.editui.designer.IContext;
import com.kingdee.eas.ep.client.editor.editui.designer.PropertyDescriptorUI;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class DefaultValuePropertyEditor
implements PropertyEditor {
    private IContext context;
    private Component customEditor;

    public DefaultValuePropertyEditor(IContext context, BizConfigureItemInfo item) {
        this.context = context;
        this.customEditor = this.createCustomEditor(item);
        if (this.customEditor == null) {
            throw new IllegalArgumentException("can't suport set default value for this compoenet : " + item.getComponent().getClassType());
        }
    }

    private Component createCustomEditor(BizConfigureItemInfo item) {
        DataSourceEnum dstype = item.getDataSourceType();
        BizDataTypeEnum dtype = item.getDataType();
        Object component = null;
        if (DataSourceEnum.SELF.equals((Object)dstype) || DataSourceEnum.BASEDATAEXT.equals((Object)dstype)) {
            if (BizDataTypeEnum.STRING.equals((Object)dtype) || BizDataTypeEnum.NOTE.equals((Object)dtype)) {
                component = new KDTextField();
            } else if (BizDataTypeEnum.INTEGER.equals((Object)dtype)) {
                component = new KDFormattedTextField(0);
            } else if (BizDataTypeEnum.DECIMAL.equals((Object)dtype) || BizDataTypeEnum.AMOUNT.equals((Object)dtype) || BizDataTypeEnum.PRICE.equals((Object)dtype) || BizDataTypeEnum.QUANTITY.equals((Object)dtype)) {
                component = new KDFormattedTextField(1);
                PropertyDescriptorUI.setFormattedTextField(item, (KDFormattedTextField)component);
            } else if (BizDataTypeEnum.DATE.equals((Object)dtype)) {
                component = new KDDatePicker();
            } else if (BizDataTypeEnum.BOOLEAN.equals((Object)dtype)) {
                component = new KDComboBox();
                ((KDComboBox)component).addItems((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE});
            }
        } else if (DataSourceEnum.BASEDATA.equals((Object)dstype)) {
            if (item.getDataSource() != null) {
                String sQueryPK = item.getDataSource().getExtendedProperty("defaultF7Query");
                if (!StringUtils.isEmpty((String)sQueryPK)) {
                    component = new DepBizPromptBox();
                    ((DepBizPromptBox)((Object)component)).setProject(this.context.getDepend());
                    ((DepBizPromptBox)((Object)component)).setQueryInfo(sQueryPK);
                    ((DepBizPromptBox)((Object)component)).setDisplayFormat("$number$");
                    ((DepBizPromptBox)((Object)component)).setEditFormat("$number$");
                    ((DepBizPromptBox)((Object)component)).setCommitFormat("$number$");
                    KDCommonPromptDialog selector = new KDCommonPromptDialog();
                    Component btnFilter = this.findBtnFilter((Container)selector);
                    btnFilter.setVisible(false);
                    ((DepBizPromptBox)((Object)component)).setSelector((KDPromptSelector)selector);
                } else {
                    component = new KDTextField();
                }
            }
        } else if (DataSourceEnum.LIST.equals((Object)dstype)) {
            component = new KDComboBox();
            if (item.getEnumPK() != null) {
                List list = null;
                String enumPK = item.getEnumPK();
                BizEnumInfo bizEnum = UictUtils.loadBizEnum((IMetaDataPK)MetaDataPK.create((String)enumPK), this.context.getDepend());
                if (bizEnum != null) {
                    list = bizEnum.isDynamic() ? DynamicEnum.getEnumList((String)enumPK) : EnumUtils.getEnumList((String)enumPK);
                }
                if (list != null) {
                    ((KDComboBox)component).addItems(list.toArray());
                }
            }
        }
        return component;
    }

    private Component findBtnFilter(Container root) {
        for (Component temp : root.getComponents()) {
            Component ret;
            if (temp instanceof KDWorkButton && "\u67e5\u8be2".equals(((KDWorkButton)temp).getText())) {
                return temp;
            }
            if (!(temp instanceof Container) || (ret = this.findBtnFilter((Container)temp)) == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public void setValue(Object value) {
        if (this.customEditor instanceof KDTextField) {
            ((KDTextField)this.customEditor).setText((String)value);
        } else if (this.customEditor instanceof KDFormattedTextField) {
            ((KDFormattedTextField)this.customEditor).setText((String)value);
        } else if (this.customEditor instanceof KDDatePicker) {
            if (value != null && value instanceof String) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                Date date = new Date();
                try {
                    date = format.parse((String)value);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                ((KDDatePicker)this.customEditor).setValue((Object)date);
            }
        } else if (this.customEditor instanceof KDCheckBox) {
            if (value == null) {
                value = Boolean.FALSE;
            }
            ((KDCheckBox)this.customEditor).setSelected(((Boolean)value).booleanValue());
        } else if (this.customEditor instanceof KDBizPromptBox) {
            ((KDBizPromptBox)this.customEditor).setValue(value);
        } else if (this.customEditor instanceof KDComboBox && value != null) {
            ((KDComboBox)this.customEditor).setSelectedItem(value);
        }
    }

    @Override
    public Object getValue() {
        Object value = null;
        if (this.customEditor instanceof KDTextField) {
            value = ((KDTextField)this.customEditor).getText();
        } else if (this.customEditor instanceof KDFormattedTextField) {
            value = ((KDFormattedTextField)this.customEditor).getText();
        } else if (this.customEditor instanceof KDDatePicker) {
            value = ((KDDatePicker)this.customEditor).getText();
        } else if (this.customEditor instanceof KDCheckBox) {
            value = ((KDCheckBox)this.customEditor).isSelected();
        } else if (this.customEditor instanceof KDBizPromptBox) {
            value = ((KDBizPromptBox)this.customEditor).getText();
        } else if (this.customEditor instanceof KDComboBox) {
            value = ((KDComboBox)this.customEditor).getSelectedItem();
        }
        return value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String getAsText() {
        return "";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return this.customEditor;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }
}

