/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor;

import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryFilterItemCollection;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.IContext;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.ButtonCellEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.FilterItemsUI;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.Map;

public class FilterItemsEditor
extends ButtonCellEditor {
    protected IContext context;
    protected FilterInfo filterInfo;
    protected String value;

    public FilterItemsEditor(IContext context) {
        this.context = context;
    }

    @Override
    protected void button_actionPerformed(ActionEvent e) {
        try {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put("Owner", this);
            uiContext.put("context", this.context);
            uiContext.put("filter", this.filterInfo);
            IUIEditor editor = ((Context)this.context).getEditorUI();
            if (editor instanceof EditUIEditor) {
                EditPart part = ((EditUIEditor)editor).getCurrentPart();
                BizConfigureItemInfoAdapter model = null;
                if (part != null) {
                    model = (BizConfigureItemInfoAdapter)part.getModel();
                    BizConfigureItemInfo item = (BizConfigureItemInfo)model.getItem();
                    PropertyInfo prop = item.getProperty();
                    this.doAction((Map)uiContext, prop);
                }
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handleError(this, ex, "\u6570\u636e\u7ed1\u5b9a\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
        }
    }

    protected void doAction(Map uiContext, PropertyInfo prop) throws Exception {
        EntityObjectInfo supplyEntityInfo = ((LinkPropertyInfo)prop).getRelationship().getSupplierObject();
        String sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query");
        if (StringUtils.isEmpty((String)sQueryPK)) {
            MsgBox.showInfo((String)("\u5b9e\u4f53 " + supplyEntityInfo.getFullName() + "\u7f3a\u5c11\u6269\u5c55\u5c5e\u6027defaultF7Query\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff0c\u901a\u77e5\u8be5\u5355\u636e\u5f00\u53d1\u4eba\u5458\u5c06\u6269\u5c55\u5c5e\u6027\u8865\u5145\u5b8c\u6574\u3002"));
            return;
        }
        uiContext.put("sQueryPK", sQueryPK);
        uiContext.put("filter", this.filterInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FilterItemsUI.class.getName(), uiContext);
        FilterItemsUI ui = (FilterItemsUI)uiWindow.getUIObject();
        JoinQueryInfo queryInfo = ui.getQueryInfo();
        String maskString = ui.getFilterExper();
        this.filterInfo = this.getDynFilter(queryInfo);
        this.filterInfo.setMaskString(maskString);
        String old = this.filterInfo.toString();
        uiWindow.show();
        FilterInfo info = this.getDynFilter(queryInfo);
        maskString = ui.getFilterExper();
        info.setMaskString(maskString);
        this.setValue(info.toString());
        this.firePropertyChange("f7FilterItem", old, this.value);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.valueText.setText("");
        } else {
            this.valueText.setText(value.toString());
            this.value = value.toString();
            try {
                if (this.value.length() > 0) {
                    this.filterInfo = new FilterInfo(this.value);
                }
            }
            catch (ParserException parserException) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getAsText() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    private FilterInfo getDynFilter(JoinQueryInfo queryInfo) {
        FilterInfo info = new FilterInfo();
        QueryFilterItemCollection itemCol = queryInfo.getDefaultFilter().getFilterItems();
        int j = itemCol.size();
        for (int i = 0; i < j; ++i) {
            if (!itemCol.get(i).isConfigured()) continue;
            FilterItemInfo filterItemInfo = new FilterItemInfo();
            filterItemInfo.setCompareType(itemCol.get(i).getCompareType());
            filterItemInfo.setCompareValue(itemCol.get(i).getCompareValue());
            filterItemInfo.setPropertyName(itemCol.get(i).getPropertyName());
            info.getFilterItems().add(filterItemInfo);
        }
        return info;
    }
}

