/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.eas.ep.client.AbstractSelectBizUI;
import com.kingdee.eas.ep.client.editor.bind.javaext.EntityFilteredTreeModel;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.IContext;
import com.kingdee.eas.ep.client.wizard.bind.BindPropertyWizardPage2;
import com.kingdee.eas.ep.client.wizard.bind.DataBindTreeBuilder;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeModel;

public class PropertySelectUI
extends AbstractSelectBizUI {
    private DataObjectInfo bindObject;
    private IContext context;
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";
    private String EXIT_STATUS = "cancel";
    private PropertyBindingInfo value;
    private KDCheckBox cb_showStatic;

    public PropertySelectUI() throws Exception {
        this.setUITitle("\u9009\u62e9\u7ed1\u5b9a\u5b57\u6bb5");
    }

    public void onLoad() throws Exception {
        this.value = new PropertyBindingInfo();
        Map uiContext = this.getUIContext();
        this.context = (IContext)uiContext.get("context");
        this.initTree();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.field_pk.setVisible(false);
        this.treeView.setBounds(new Rectangle(11, 40, 380, 428));
        this.cb_showStatic = new KDCheckBox();
        this.cb_showStatic.setText("\u663e\u793a\u9759\u6001\u5b57\u6bb5");
        this.cb_showStatic.setVisible(true);
        this.cb_showStatic.setBounds(20, 474, 100, 21);
        this.add((Component)this.cb_showStatic);
        this.cb_showStatic.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PropertySelectUI.this.reloadPropertyTree();
            }
        });
    }

    private void initTree() {
        AbstractUIObjectInfo uiInfo = this.context.getUiModel();
        DataObjectCollection dataObjects = uiInfo.getDataObjects();
        if (!dataObjects.isEmpty()) {
            this.bindObject = dataObjects.get(0);
            this.value.setBindingObject(this.bindObject.getName());
            DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode();
            EntityFilteredTreeModel valueTreeModel = new EntityFilteredTreeModel(rootNode);
            valueTreeModel.setIsShowStaticEntity(this.cb_showStatic.isSelected());
            this.baseDataTree.setModel((TreeModel)((Object)valueTreeModel));
            EntityObjectInfo bindEntity = ((Context)this.context).getEditorUI().getModel().getEntity();
            if (bindEntity != null) {
                rootNode.setText(bindEntity.getAlias());
                DataBindTreeBuilder.generateDataObjectPropertyTree(this.baseDataTree, rootNode, bindEntity, this.context.getDepend());
            } else {
                DataBindTreeBuilder.generateDataObjectPropertyTree(this.baseDataTree, rootNode, this.bindObject, this.context.getDepend());
            }
        }
    }

    private void reloadPropertyTree() {
        EntityFilteredTreeModel model = (EntityFilteredTreeModel)((Object)this.baseDataTree.getModel());
        model.setIsShowStaticEntity(this.cb_showStatic.isSelected());
        this.baseDataTree.repaint();
    }

    @Override
    protected void okBtn_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.baseDataTree.getLastSelectedPathComponent();
        if (node != null && node.getUserObject() != null) {
            String fieldName = BindPropertyWizardPage2.getBindField(node);
            String fieldType = BindPropertyWizardPage2.getFiledType(node.getUserObject(), this.bindObject);
            boolean isMultiLan = node.getUserObject() instanceof OwnPropertyInfo ? ((OwnPropertyInfo)node.getUserObject()).isMultilingual() : false;
            ComponentInfo component = (ComponentInfo)this.getUIContext().get("component");
            if (!PropertySelectUI.checkLegal(component, fieldType, isMultiLan)) {
                MsgBox.showWarning((Component)((Object)this), (String)"\u63a7\u4ef6\u7c7b\u578b\u5fc5\u987b\u4e0e\u5b9e\u4f53\u5b57\u6bb5\u7c7b\u578b\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
                return;
            }
            this.value.setFieldType(fieldType);
            this.value.setBingdingField(fieldName);
            this.value.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            this.EXIT_STATUS = CONFIRM_EXIT;
        }
        this.disposeUIWindow();
    }

    private static boolean checkLegal(ComponentInfo component, String fieldType, boolean isMultiLan) {
        String classType = component.getClassType();
        try {
            if (("com.kingdee.bos.ctrl.swing.KDTextField".equals(classType) || "com.kingdee.bos.ctrl.swing.KDTextArea".equals(classType)) && fieldType.equals("String") && !isMultiLan) {
                return true;
            }
            if (("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox".equals(classType) || "com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea".equals(classType)) && fieldType.equals("String") && isMultiLan) {
                return true;
            }
            if ("com.kingdee.bos.ctrl.swing.KDDatePicker".equals(classType) && fieldType.equals("java.util.Date")) {
                return true;
            }
            if ("com.kingdee.bos.ctrl.swing.KDCheckBox".equals(classType) && fieldType.equals("boolean")) {
                return true;
            }
            if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(classType) && IObjectValue.class.isAssignableFrom(Class.forName(fieldType))) {
                return true;
            }
            if ("com.kingdee.bos.ctrl.swing.KDComboBox".equals(classType)) {
                List enumList = DynamicEnum.getEnumList((String)fieldType);
                if (enumList != null && !enumList.isEmpty()) {
                    return true;
                }
                return Enum.class.isAssignableFrom(Class.forName(fieldType));
            }
            if ("com.kingdee.bos.ctrl.swing.KDFormattedTextField".equals(classType) && (fieldType.equals("java.math.BigDecimal") || fieldType.equals("int"))) {
                return true;
            }
            if ("com.kingdee.eas.ep.client.KDPictureBox".equals(classType) && "byte[]".equals(fieldType)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected void cancelBtn_actionPerformed(ActionEvent e) throws Exception {
        this.EXIT_STATUS = CANCEL_EXIT;
        this.disposeUIWindow();
    }

    public String getExitStatus() {
        return this.EXIT_STATUS;
    }

    public Object getReturnValue() {
        return this.value;
    }
}

