/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.ui.property.render;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class StringCellRenderer
extends JTextArea
implements ListCellRenderer,
TableCellRenderer {
    private static final long serialVersionUID = 5698079429922617759L;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public StringCellRenderer() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setBorder(null);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setBorder(null);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setValue(value);
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setAppearance(table, isSelected, hasFocus, row, column);
        int maxPreferredHeight = 0;
        this.setText("" + table.getValueAt(row, column));
        this.setSize(table.getColumnModel().getColumn(column).getWidth(), table.getRowHeight(row));
        maxPreferredHeight = Math.max(maxPreferredHeight, this.getPreferredSize().height);
        if (table.getRowHeight(row) < maxPreferredHeight) {
            table.setRowHeight(row, maxPreferredHeight);
        }
        this.setText(value == null ? "" : value.toString());
        return this;
    }

    private void setAppearance(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(table.getForeground());
            super.setBackground(table.getBackground());
        }
        if (hasFocus && !isSelected && table.isCellEditable(row, column)) {
            Color col = UIManager.getColor("Table.focusCellForeground");
            if (col != null) {
                super.setForeground(col);
            }
            if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                super.setBackground(col);
            }
        }
    }

    public void setValue(Object value) {
        String text = this.convertToString(value);
        this.setText(text == null ? "" : text);
    }

    protected String convertToString(Object value) {
        return value == null ? null : value.toString();
    }

    protected Icon convertToIcon(Object value) {
        return null;
    }
}

