/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.util;

import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.dtp.ActionServicePropertyHelper;
import com.kingdee.bos.ui.dtp.ControlConstant;
import com.kingdee.bos.ui.dtp.ServiceItem;
import com.kingdee.bos.ui.dtp.StringConverter;
import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import com.kingdee.bos.ui.dtp.model.layout.LabelContainerLayout;
import com.kingdee.bos.ui.dtp.model.layout.Layout;
import com.kingdee.bos.ui.dtp.model.layout.LayoutConverter;
import com.kingdee.bos.ui.dtp.model.layout.SameGridLayout;
import com.kingdee.eas.ep.client.depend.mutiLan.MutiLanUtil;
import com.kingdee.eas.ep.client.editor.action.ConfigManager;
import com.kingdee.eas.ep.client.model.dtc.ControlStaticInfo;
import com.kingdee.eas.ep.client.model.dtc.DTCConfigInfo;
import com.kingdee.eas.ep.client.model.dtc.DTCConfigManager;
import com.kingdee.eas.ep.client.model.dtc.DTControlHelper;
import com.kingdee.util.StringUtils;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;

public class ComponentHelper {
    private static double MaxFloat = 3.4028234663852886E38;
    private static double MinFloat = -3.4028234663852886E38;

    public static ComponentInfo createCheckBox(UIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo checkBox = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDCheckBox");
        checkBox.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        String useName = uiModel.getNameManager().getNameByName(ComponentHelper.getPrefix("com.kingdee.bos.ctrl.swing.KDCheckBox") + name);
        checkBox.setName(useName);
        PropertyCollection props = checkBox.getProperties();
        props.add(ComponentHelper.createLabelTextProperty(labelText));
        props.add(ComponentHelper.createVisibleProperty(true));
        return checkBox;
    }

    public static ComponentInfo createTextField(UIObjectInfo uiModel, String name, String labelText, boolean isMultiLanguage) {
        ComponentInfo labelContainer = ComponentHelper.createLabelContainer(name, labelText, uiModel);
        if (labelContainer == null) {
            return null;
        }
        ComponentHelper.createTextFieldForLabelContainer(uiModel, labelContainer, name, isMultiLanguage);
        return labelContainer;
    }

    public static ComponentInfo createTextArea(UIObjectInfo uiModel, String name, String labelText, boolean isMultiLanguage) {
        ComponentInfo labelContainer = ComponentHelper.createLabelContainer(name, labelText, uiModel);
        if (labelContainer == null) {
            return null;
        }
        String scrollPaneName = uiModel.getNameManager().getNameByName("scrollPane" + name);
        ComponentInfo scrollPane = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDScrollPane");
        scrollPane.setName(scrollPaneName);
        scrollPane.setConstraint((Object)String.valueOf(7));
        scrollPane.setContainer(true);
        scrollPane.setLayoutInfo(LayoutConverter.convertToInfo((Layout)new SameGridLayout(1, 1)));
        labelContainer.addChild((AbstractUIObjectInfo)uiModel, scrollPane);
        ComponentHelper.createTextAreaForLabelContainer(uiModel, scrollPane, name, isMultiLanguage);
        return labelContainer;
    }

    public static ComponentInfo createFormattedTextField(UIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo labelContainer = ComponentHelper.createLabelContainer(name, labelText, uiModel);
        if (labelContainer == null) {
            return null;
        }
        ComponentHelper.createFormattedTextFieldForLabelContainer(uiModel, labelContainer, name);
        return labelContainer;
    }

    public static ComponentInfo createDatePicker(UIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo labelContainer = ComponentHelper.createLabelContainer(name, labelText, uiModel);
        if (labelContainer == null) {
            return null;
        }
        ComponentHelper.createDatePickerForLabelContainer(uiModel, labelContainer, name);
        return labelContainer;
    }

    public static ComponentInfo createTimePicker(UIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo labelContainer = ComponentHelper.createLabelContainer(name, labelText, uiModel);
        if (labelContainer == null) {
            return null;
        }
        ComponentHelper.createTimePickerForLabelContainer(uiModel, labelContainer, name);
        return labelContainer;
    }

    public static ComponentInfo createComboBox(UIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo labelContainer = ComponentHelper.createLabelContainer(name, labelText, uiModel);
        if (labelContainer == null) {
            return null;
        }
        ComponentHelper.createComboBoxForLabelContainer(uiModel, labelContainer, name);
        return labelContainer;
    }

    public static ComponentInfo createBizPromptBox(UIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo labelContainer = ComponentHelper.createLabelContainer(name, labelText, uiModel);
        if (labelContainer == null) {
            return null;
        }
        ComponentHelper.createBizPromptBoxForLabelContainer(uiModel, labelContainer, name);
        return labelContainer;
    }

    public static ComponentInfo createLabelContainer(String name, String labelText, UIObjectInfo uiModel) {
        ComponentInfo labelContainer = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDLabelContainer");
        String useName = uiModel.getNameManager().getNameByName("cont" + name);
        labelContainer.setName(useName);
        labelContainer.setContainer(true);
        labelContainer.setLayoutInfo(LayoutConverter.convertToInfo((Layout)new LabelContainerLayout()));
        PropertyCollection props = labelContainer.getProperties();
        props.add(ComponentHelper.createBoundLabelTextProperty(labelText));
        props.add(ComponentHelper.createBoundLabelLengthProperty());
        props.add(ComponentHelper.createBoundLabelUnderlineProperty());
        props.add(ComponentHelper.createVisibleProperty(true));
        return labelContainer;
    }

    public static ComponentInfo createEntry(UIObjectInfo uiModel, String name, String text, Layout layout) {
        ComponentInfo component = ComponentHelper.createComponent(uiModel, "com.kingdee.bos.ctrl.kdf.table.KDTable", name, text, layout);
        component.setExtendedProperty("buildDetail", "true");
        return component;
    }

    public static ComponentInfo createComponent(UIObjectInfo uiModel, String classType, String name, String text, Layout layout) {
        ComponentInfo component = new ComponentInfo(classType);
        String useName = uiModel.getNameManager().getNameByName(name);
        component.setName(useName);
        component.setContainer(DTControlHelper.isContainer(classType));
        component.setLayoutInfo(LayoutConverter.convertToInfo((Layout)layout));
        if ("com.kingdee.bos.ctrl.swing.KDButton".equals(classType) || "com.kingdee.bos.ctrl.swing.KDCheckBox".equals(classType) || "com.kingdee.bos.ctrl.swing.KDLabel".equals(classType) || "com.kingdee.bos.ctrl.swing.KDRadioButton".equals(classType) || "com.kingdee.bos.ctrl.swing.KDMenuItem".equals(classType) || "com.kingdee.bos.ctrl.swing.KDWorkButton".equals(classType) || "com.kingdee.bos.ctrl.swing.KDMenu".equals(classType)) {
            ComponentHelper.setPropertyValue(component, "text", text);
        } else if ("com.kingdee.bos.ctrl.swing.KDContainer".equals(classType)) {
            ComponentHelper.setPropertyValue(component, "title", text);
        } else if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(classType)) {
            // empty if block
        }
        return component;
    }

    public static ActionInfo createAction(UIObjectInfo uiModel, String className, String name) {
        ActionInfo action = new ActionInfo();
        action.setName(name, false);
        action.setClassName(className, false);
        action.setServices(ComponentHelper.getDefaultService());
        action.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        return action;
    }

    private static String getDefaultService() {
        ServiceItem[] items = ConfigManager.getInstance().getServiceItems();
        ArrayList<ServiceItem> list = new ArrayList<ServiceItem>();
        int j = items.length;
        for (int i = 0; i < j; ++i) {
            if (!items[i].isCompulsory()) continue;
            list.add(items[i]);
        }
        return ActionServicePropertyHelper.toXmlString(list);
    }

    public static void createTextFieldForLabelContainer(UIObjectInfo uiModel, ComponentInfo container, String name, boolean isMultiLanguage) {
        ComponentInfo text = null;
        String useName = null;
        if (isMultiLanguage) {
            text = new ComponentInfo("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox");
            useName = uiModel.getNameManager().getNameByName(ComponentHelper.getPrefix("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox") + name);
        } else {
            text = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDTextField");
            useName = uiModel.getNameManager().getNameByName(ComponentHelper.getPrefix("com.kingdee.bos.ctrl.swing.KDTextField") + name);
        }
        text.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        text.setName(useName);
        text.setConstraint((Object)String.valueOf(3));
        container.addChild((AbstractUIObjectInfo)uiModel, text);
        PropertyCollection props = text.getProperties();
        props.add(ComponentHelper.createVisibleProperty(true));
    }

    public static void createTextAreaForLabelContainer(UIObjectInfo uiModel, ComponentInfo container, String name, boolean isMultiLanguage) {
        ComponentInfo text = null;
        String useName = null;
        if (isMultiLanguage) {
            text = new ComponentInfo("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea");
            useName = uiModel.getNameManager().getNameByName(ComponentHelper.getPrefix("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea") + name);
        } else {
            text = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDTextArea");
            useName = uiModel.getNameManager().getNameByName(ComponentHelper.getPrefix("com.kingdee.bos.ctrl.swing.KDTextArea") + name);
        }
        text.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        text.setName(useName);
        text.setConstraint((Object)"0,0,1,1");
        container.addChild((AbstractUIObjectInfo)uiModel, text);
        PropertyCollection props = text.getProperties();
        props.add(ComponentHelper.createVisibleProperty(true));
    }

    public static void createFormattedTextFieldForLabelContainer(UIObjectInfo uiModel, ComponentInfo container, String name) {
        ComponentInfo text = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDFormattedTextField");
        text.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        String useName = uiModel.getNameManager().getNameByName(ComponentHelper.getPrefix("com.kingdee.bos.ctrl.swing.KDFormattedTextField") + name);
        text.setName(useName);
        text.setConstraint((Object)String.valueOf(7));
        container.addChild((AbstractUIObjectInfo)uiModel, text);
        PropertyCollection props = text.getProperties();
        props.add(ComponentHelper.createVisibleProperty(true));
    }

    public static void createDatePickerForLabelContainer(UIObjectInfo uiModel, ComponentInfo container, String name) {
        ComponentInfo picker = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDDatePicker");
        picker.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        String useName = uiModel.getNameManager().getNameByName(ComponentHelper.getPrefix("com.kingdee.bos.ctrl.swing.KDDatePicker") + name);
        picker.setName(useName);
        picker.setConstraint((Object)String.valueOf(7));
        container.addChild((AbstractUIObjectInfo)uiModel, picker);
        PropertyCollection props = picker.getProperties();
        props.add(ComponentHelper.createVisibleProperty(true));
    }

    public static void createTimePickerForLabelContainer(UIObjectInfo uiModel, ComponentInfo container, String name) {
        ComponentInfo picker = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDTimePicker");
        picker.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        String useName = uiModel.getNameManager().getNameByName(ComponentHelper.getPrefix("com.kingdee.bos.ctrl.swing.KDTimePicker") + name);
        picker.setName(useName);
        picker.setConstraint((Object)String.valueOf(7));
        container.addChild((AbstractUIObjectInfo)uiModel, picker);
        PropertyCollection props = picker.getProperties();
        props.add(ComponentHelper.createVisibleProperty(true));
    }

    public static void createListForLabelContainer(UIObjectInfo uiModel, ComponentInfo container, String name) {
        ComponentInfo list = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDList");
        list.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        String useName = uiModel.getNameManager().getNameByName(ComponentHelper.getPrefix("com.kingdee.bos.ctrl.swing.KDList") + name);
        list.setName(useName);
        list.setConstraint((Object)String.valueOf(7));
        container.addChild((AbstractUIObjectInfo)uiModel, list);
        PropertyCollection props = list.getProperties();
        props.add(ComponentHelper.createVisibleProperty(true));
    }

    public static void createComboBoxForLabelContainer(UIObjectInfo uiModel, ComponentInfo container, String name) {
        ComponentInfo combo = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDComboBox");
        combo.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        String useName = uiModel.getNameManager().getNameByName(ComponentHelper.getPrefix("com.kingdee.bos.ctrl.swing.KDComboBox") + name);
        combo.setName(useName);
        combo.setConstraint((Object)String.valueOf(7));
        container.addChild((AbstractUIObjectInfo)uiModel, combo);
        PropertyCollection props = combo.getProperties();
        props.add(ComponentHelper.createVisibleProperty(true));
    }

    public static void createBizPromptBoxForLabelContainer(UIObjectInfo uiModel, ComponentInfo container, String name) {
        ComponentInfo f7 = new ComponentInfo("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox");
        f7.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        String useName = uiModel.getNameManager().getNameByName(ComponentHelper.getPrefix("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox") + name);
        f7.setName(useName);
        f7.setConstraint((Object)String.valueOf(7));
        container.addChild((AbstractUIObjectInfo)uiModel, f7);
        f7.setExtendedProperty("displayFormat", "$name$");
        PropertyCollection props = f7.getProperties();
        props.add(ComponentHelper.createVisibleProperty(true));
        props.add(ComponentHelper.createEditableProperty(true));
        props.add(ComponentHelper.createEditFormatProperty());
        props.add(ComponentHelper.createCommitFormatProperty());
    }

    public static Object createContraint(ComponentInfo parent, Rectangle rect) {
        LayoutInfo layout = parent.getLayoutInfo();
        String layoutType = "XYLayout";
        if (layout != null) {
            layoutType = layout.getType();
        }
        if ("XYLayout".equalsIgnoreCase(layoutType)) {
            return new Rectangle(rect);
        }
        if ("KDLayout".equalsIgnoreCase(layoutType)) {
            return new KDLayoutConstraint(rect);
        }
        return null;
    }

    public static PropertyInfo createLabelTextProperty(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("text");
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue(text);
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createBoundLabelTextProperty(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("boundLabelText");
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        MutiLanUtil.setValue(prop, text);
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createBoundLabelLengthProperty() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("boundLabelLength");
        prop.setType("int");
        prop.setValue(String.valueOf(100));
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createHorizontalAlignmentProperty() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("horizontalAlignment");
        prop.setType("int");
        prop.setValue(String.valueOf(2));
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createBoundLabelUnderlineProperty() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("boundLabelUnderline");
        prop.setType("boolean");
        prop.setValue(String.valueOf(true));
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createRequiredProperty(boolean isRequired) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("required");
        prop.setType("boolean");
        prop.setValue(String.valueOf(isRequired));
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createVisibleProperty(boolean visible) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("visible");
        prop.setType("boolean");
        prop.setValue(String.valueOf(visible));
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createEditableProperty(boolean editable) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("editable");
        prop.setType("boolean");
        prop.setValue(String.valueOf(editable));
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createDisplayFormatProperty() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("displayFormat");
        prop.setType(String.class.getName());
        prop.setValue("$name$");
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createEditFormatProperty() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("editFormat");
        prop.setType(String.class.getName());
        prop.setValue("$number$");
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createCommitFormatProperty() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("commitFormat");
        prop.setType(String.class.getName());
        prop.setValue("$number$");
        prop.setOverride(true);
        return prop;
    }

    public static String getPrefix(String classType) {
        if (StringUtils.isEmpty((String)classType)) {
            return "";
        }
        String value = ControlConstant.getControlNamePrefix((String)classType);
        if (value == null) {
            return "";
        }
        return value;
    }

    public static void setPropertyValue(ComponentInfo cInfo, String propName, Object value) {
        PropertyInfo prop = cInfo.getPropertyByName(propName);
        ControlStaticInfo.PropertyStaticInfo sinfo = DTControlHelper.getControlStaticInfo(cInfo.getClassType()).getPropStaticInfo(propName);
        if (sinfo != null && !sinfo.isEmpty()) {
            if (prop == null) {
                prop = new PropertyInfo();
                prop.setName(propName);
                prop.setType(sinfo.getType());
                prop.setMultiLanguage(sinfo.isMultiLan());
                cInfo.getProperties().add(prop);
            }
        } else {
            return;
        }
        String stringValue = null;
        stringValue = ComponentHelper.object2String(prop.getType(), value);
        if (prop.isMultiLanguage()) {
            MutiLanUtil.setValue(prop, stringValue);
        } else {
            prop.setValue(stringValue);
        }
        if (cInfo.isHerited()) {
            prop.setOverride(true);
        }
    }

    public static Object getPropertyValue(ComponentInfo cInfo, String propName) {
        PropertyInfo pInfo = cInfo.getProperties().get(propName);
        String stringValue = null;
        String type = null;
        if (pInfo != null) {
            stringValue = pInfo.getValue();
            type = pInfo.getType();
        }
        if (stringValue == null) {
            ControlStaticInfo.PropertyStaticInfo propStaticInfo = DTControlHelper.getControlStaticInfo(cInfo.getClassType()).getPropStaticInfo(propName);
            stringValue = propStaticInfo.getDefaultValue();
            type = propStaticInfo.getType();
        }
        return ComponentHelper.string2Object(type, stringValue);
    }

    public static String object2String(String type, Object obj) {
        String wrapperType = null;
        wrapperType = "int".equals(type) ? "java.lang.Integer" : ("boolean".equals(type) ? "java.lang.Boolean" : ("long".equals(type) ? "java.lang.Long" : ("short".equals(type) ? "java.lang.Short" : ("byte".equals(type) ? "java.lang.Byte" : ("float".equals(type) ? "java.lang.Float" : ("double".equals(type) ? "java.lang.Double" : ("char".equals(type) ? "java.lang.Character" : type)))))));
        return StringConverter.convertToString((String)wrapperType, (Object)obj);
    }

    public static Object string2Object(String type, String strValue) {
        String wrapperType = null;
        wrapperType = "int".equals(type) ? "java.lang.Integer" : ("boolean".equals(type) ? "java.lang.Boolean" : ("long".equals(type) ? "java.lang.Long" : ("short".equals(type) ? "java.lang.Short" : ("byte".equals(type) ? "java.lang.Byte" : ("float".equals(type) ? "java.lang.Float" : ("double".equals(type) ? "java.lang.Double" : ("char".equals(type) ? "java.lang.Character" : type)))))));
        return StringConverter.convertToObject((String)wrapperType, (String)strValue);
    }

    public static PropertyInfo createMinimumValueProperty(int length, int scale) {
        if (length <= scale) {
            return null;
        }
        String format = ComponentHelper.getMininumValue(length, scale);
        format = "\"" + format + "\"";
        PropertyInfo prop = new PropertyInfo();
        prop.setName("minimumValue");
        prop.setType(BigDecimal.class.getName());
        prop.setValue(format);
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createMaximumValueProperty(int length, int scale) {
        if (length <= scale) {
            return null;
        }
        String format = ComponentHelper.getMaximumValue(length, scale);
        format = "\"" + format + "\"";
        PropertyInfo prop = new PropertyInfo();
        prop.setName("maximumValue");
        prop.setType(BigDecimal.class.getName());
        prop.setValue(format);
        prop.setOverride(true);
        return prop;
    }

    public static String getMininumValue(int length, int scale) {
        int i;
        if (length <= scale) {
            return null;
        }
        int realLength = length - scale;
        String format = "-";
        double minValue = MinFloat;
        for (i = 0; i < realLength; ++i) {
            format = format + "9";
        }
        if (scale > 0) {
            format = format + ".";
            for (i = 0; i < scale; ++i) {
                format = format + "9";
            }
        }
        try {
            if (Double.parseDouble(format) > minValue) {
                minValue = Double.parseDouble(format);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(minValue);
    }

    public static String getMaximumValue(int length, int scale) {
        int i;
        if (length <= scale) {
            return null;
        }
        int realLength = length - scale;
        String format = "";
        double maxValue = MaxFloat;
        for (i = 0; i < realLength; ++i) {
            format = format + "9";
        }
        if (scale > 0) {
            format = format + ".";
            for (i = 0; i < scale; ++i) {
                format = format + "9";
            }
        }
        try {
            if (Double.parseDouble(format) < maxValue) {
                maxValue = Double.parseDouble(format);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(maxValue);
    }

    public static PropertyInfo createPrecisionProperty(int precision) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("precision");
        prop.setType("int");
        prop.setValue(String.valueOf(precision));
        prop.setOverride(true);
        return prop;
    }

    public static Icon getComponentIcon(String classType) {
        DTCConfigInfo info = DTCConfigManager.getInstance().getDTCConfig(classType);
        if (info != null) {
            return info.getSmallIcon();
        }
        return null;
    }

    public static void addChild(AbstractUIObjectInfo uiModel, ComponentInfo parent, ComponentInfo child) {
        ComponentHelper.removeChild(uiModel, parent, child);
        parent.addChild(uiModel, child);
        ComponentHelper.allocateNameForComponentTree(uiModel, child);
    }

    public static void addChild(AbstractUIObjectInfo uiModel, ComponentInfo parent, ComponentInfo child, int index) {
        if (index == -1) {
            ComponentHelper.addChild(uiModel, parent, child);
            return;
        }
        ComponentHelper.removeChild(uiModel, parent, child);
        parent.addChild(uiModel, child);
        ComponentCollection collection = parent.getComponents();
        collection.move(collection.size() - 1, index - 1);
        ComponentHelper.allocateNameForComponentTree(uiModel, child);
    }

    public static void removeChild(AbstractUIObjectInfo uiModel, ComponentInfo parent, ComponentInfo child) {
        parent.removeChild(uiModel, child);
        HashSet names = new HashSet();
        ComponentHelper.recycleNameForComponentTree(uiModel, child, names);
        uiModel.getStatuses().deleteComponent(names);
    }

    private static void allocateNameForComponentTree(AbstractUIObjectInfo uiModel, ComponentInfo model) {
        uiModel.getNameManager().put(model.getName());
        if (model.isContainer()) {
            uiModel.getNameManager().put(model.getLayoutInfo().getName());
        }
        ComponentCollection cols = model.getComponents();
        int size = cols.size();
        for (int i = 0; i < size; ++i) {
            ComponentInfo child = cols.get(i);
            ComponentHelper.allocateNameForComponentTree(uiModel, child);
        }
    }

    private static void recycleNameForComponentTree(AbstractUIObjectInfo uiModel, ComponentInfo model, Set names) {
        if (names != null) {
            names.add(model.getName());
        }
        uiModel.getNameManager().remove(model.getName());
        ComponentCollection cols = model.getComponents();
        int size = cols.size();
        for (int i = 0; i < size; ++i) {
            ComponentInfo child = cols.get(i);
            ComponentHelper.recycleNameForComponentTree(uiModel, child, names);
        }
    }

    public static void resetOrderConstraint(ComponentInfo parent) {
        ComponentCollection cols = parent.getComponents();
        int size = cols.size();
        for (int i = 0; i < size; ++i) {
            ComponentInfo child = cols.get(i);
            if (child.isHerited()) {
                child.setOverrideConstraint(true);
            }
            child.setExtendedProperty("order", String.valueOf(i));
        }
    }

    public static ComponentInfo createKDPictueBox(UIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo labelContainer = ComponentHelper.createLabelContainer(name, labelText, uiModel);
        if (labelContainer == null) {
            return null;
        }
        ComponentHelper.createKDPictueBoxForLabelContainer(uiModel, labelContainer, name);
        return labelContainer;
    }

    public static void createKDPictueBoxForLabelContainer(UIObjectInfo uiModel, ComponentInfo container, String name) {
        ComponentInfo kdpictueviwer = new ComponentInfo("com.kingdee.eas.ep.client.KDPictureBox");
        kdpictueviwer.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        String useName = uiModel.getNameManager().getNameByName(ComponentHelper.getPrefix("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox") + name);
        kdpictueviwer.setName(useName);
        kdpictueviwer.setConstraint((Object)String.valueOf(7));
        container.addChild((AbstractUIObjectInfo)uiModel, kdpictueviwer);
        kdpictueviwer.setExtendedProperty("displayFormat", "$name$");
        PropertyCollection props = kdpictueviwer.getProperties();
        props.add(ComponentHelper.createVisibleProperty(true));
        props.add(ComponentHelper.createEditableProperty(true));
        props.add(ComponentHelper.createEditFormatProperty());
        props.add(ComponentHelper.createCommitFormatProperty());
    }
}

