/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.util;

import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import com.kingdee.eas.ep.client.cursor.CursorHelper;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;

public class ComponentResizeManager {
    private Cursor cursor;
    private boolean isResizing;
    private int deviation = 3;

    public boolean isResizing(Component comp, Point p) {
        if (comp == null || p == null) {
            return false;
        }
        Rectangle rec = comp.getBounds();
        this.doCalculate(rec, p);
        return this.isResizing;
    }

    public boolean isResizing(ComponentInfo comp, Point p) {
        Rectangle rec;
        if (comp == null || p == null) {
            return false;
        }
        Object constraint = comp.getConstraint();
        if (constraint instanceof Rectangle) {
            rec = (Rectangle)constraint;
        } else if (constraint instanceof KDLayoutConstraint) {
            rec = ((KDLayoutConstraint)constraint).toRectangle();
        } else {
            return false;
        }
        this.doCalculate(rec, p);
        return this.isResizing;
    }

    private void doCalculate(Rectangle rec, Point p) {
        int x = p.x;
        int y = p.y;
        if (x >= rec.x - this.deviation && x <= rec.x + this.deviation && y >= rec.y - this.deviation && y <= rec.y + this.deviation) {
            this.isResizing = true;
            this.setCursor(CursorHelper.NW_RESIZE_CURSOR);
        } else if (x >= rec.x + rec.width - this.deviation && x <= rec.x + rec.width + this.deviation && y >= rec.y - this.deviation && y <= rec.y + this.deviation) {
            this.isResizing = true;
            this.setCursor(CursorHelper.NE_RESIZE_CURSOR);
        } else if (x >= rec.x - this.deviation && x <= rec.x + this.deviation && y >= rec.y + rec.height - this.deviation && y <= rec.y + rec.height + this.deviation) {
            this.isResizing = true;
            this.setCursor(CursorHelper.SW_RESIZE_CURSOR);
        } else if (x >= rec.x + rec.width - this.deviation && x <= rec.x + rec.width + this.deviation && y >= rec.y + rec.height - this.deviation && y <= rec.y + rec.height + this.deviation) {
            this.isResizing = true;
            this.setCursor(CursorHelper.SE_RESIZE_CURSOR);
        } else if (x >= rec.x - this.deviation && x <= rec.x + this.deviation && y >= rec.y && y <= rec.y + rec.height) {
            this.isResizing = true;
            this.setCursor(CursorHelper.W_RESIZE_CURSOR);
        } else if (x >= rec.x + rec.width - this.deviation && x <= rec.x + rec.width + this.deviation && y >= rec.y && y <= rec.y + rec.height) {
            this.isResizing = true;
            this.setCursor(CursorHelper.E_RESIZE_CURSOR);
        } else if (x >= rec.x + 1 && x <= rec.x + rec.width - 1 && y >= rec.y - this.deviation && y <= rec.y + this.deviation) {
            this.isResizing = true;
            this.setCursor(CursorHelper.N_RESIZE_CURSOR);
        } else if (x >= rec.x + 1 && x <= rec.x + rec.width - 1 && y >= rec.y + rec.height - this.deviation && y <= rec.y + rec.height + this.deviation) {
            this.isResizing = true;
            this.setCursor(CursorHelper.S_RESIZE_CURSOR);
        } else {
            this.isResizing = false;
            this.setCursor(CursorHelper.getDefaultCursor());
        }
    }

    private void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        return this.cursor;
    }
}

