/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.util.EPUtils;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CustomSchemeUtil {
    private static final Logger logger = CoreUIObject.getLogger(CustomSchemeUtil.class);
    public static final String SYSTEM_SCHEME = "CS_SYSTEM";
    public static final String CUSTOM_SCHEME = "CS_USERDEFINE";

    public static boolean isSystemScheme(String schemeId) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)schemeId));
            CustomizedSchemeInfo ov = (CustomizedSchemeInfo)CustomizedSchemeFactory.getRemoteInstance().getValue((IObjectPK)pk);
            return CustomSchemeUtil.isSystemScheme(ov);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public static boolean isSystemScheme(CustomizedSchemeInfo ov) {
        String buildNumber;
        return ov != null && SYSTEM_SCHEME.equals(buildNumber = ov.getBuildNumber());
    }

    public static void enableScheme(String scheme) throws EASBizException, BOSException {
        CustomSchemeUtil.enableScheme(new String[]{scheme});
    }

    public static void disableScheme(String scheme) throws EASBizException, BOSException {
        CustomSchemeUtil.disableScheme(new String[]{scheme});
    }

    public static void enableScheme(String[] ids) {
        try {
            CustomizedSchemeFactory.getRemoteInstance().update4Used(ids, true);
        }
        catch (Exception ex) {
            MsgBox.showInfo((String)("\u542f\u7528\u65b9\u6848\u5931\u8d25  " + ex.getMessage()));
            return;
        }
        try {
            EPUtils.clearCache();
            CustomSchemeUtil.doStructureConfig(ids, true);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static void disableScheme(String[] ids) {
        try {
            CustomizedSchemeFactory.getRemoteInstance().update4Used(ids, false);
        }
        catch (Exception ex) {
            MsgBox.showInfo((String)("\u53cd\u542f\u7528\u65b9\u6848\u5931\u8d25  " + ex.getMessage()));
            return;
        }
        try {
            EPUtils.clearCache();
            CustomSchemeUtil.doStructureConfig(ids, false);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static boolean isStartScheme(String schemeId) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)schemeId));
            CustomizedSchemeInfo ov = (CustomizedSchemeInfo)CustomizedSchemeFactory.getRemoteInstance().getValue((IObjectPK)pk);
            return ov.isStart();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public static void doStructureConfig(String[] idList, boolean isEnable) {
        try {
            if (idList == null || idList.length < 1) {
                return;
            }
            Class<?> depStructure = Class.forName("com.kingdee.eas.hr.base.util.DEPStructureConfigUtil");
            Object sturctureHandler = depStructure.newInstance();
            StringBuffer buf = new StringBuffer(" '");
            int size = idList.length - 1;
            for (int i = 0; i < size; ++i) {
                buf.append(idList[i]);
                buf.append("','");
            }
            buf.append(idList[idList.length - 1]).append("' ");
            ISQLExecutor sqlexec = SQLExecutorFactory.getRemoteInstance((String)("SELECT FENTITYPK FROM T_EP_SQL WHERE FCUSTOMIZEDSCHEMEID IN (" + buf.toString() + ")"));
            IRowSet rowSet = sqlexec.executeSQL();
            ArrayList<String> entityPks = new ArrayList<String>();
            if (rowSet != null) {
                try {
                    while (rowSet.next()) {
                        entityPks.add(rowSet.getString("FENTITYPK"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
            }
            HashMap<String, ArrayList<String>> param = new HashMap<String, ArrayList<String>>();
            param.put("entityKey", entityPks);
            if (isEnable) {
                Method depEnable = depStructure.getMethod("depEnable", HashMap.class);
                depEnable.invoke(sturctureHandler, param);
            } else {
                Method depDisable = depStructure.getMethod("depDisable", HashMap.class);
                depDisable.invoke(sturctureHandler, param);
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage());
        }
        catch (SecurityException e) {
            logger.error((Object)e.getMessage());
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e.getMessage());
        }
        catch (InstantiationException e) {
            logger.error((Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage());
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
    }
}

