/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.DBUpdateInfo;
import com.kingdee.bos.db.DBUpdateInfoSet;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.BIMNameFactory;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.configure.IMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.ForeignKeyCollection;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityToTable;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.TablePrefixInfo;
import com.kingdee.bos.metadata.event.EventCollection;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.event.FormalParameterCollection;
import com.kingdee.bos.metadata.event.FormalParameterInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ep.AbstractCustomizedUnitInfo;
import com.kingdee.eas.ep.CustomizedUnitCollection;
import com.kingdee.eas.ep.CustomizedUnitFactory;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.ICustomizedUnit;
import com.kingdee.eas.ep.IUpdateSql;
import com.kingdee.eas.ep.NodeTypeEnum;
import com.kingdee.eas.ep.UpdateSqlFactory;
import com.kingdee.eas.ep.UpdateSqlInfo;
import com.kingdee.eas.ep.client.editor.editui.designer.util.EntityCreator;
import com.kingdee.eas.ep.client.editor.editui.designer.util.RelationshipCreator;
import com.kingdee.eas.ep.client.util.SqlBuilder;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfo;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfoConverter;
import com.kingdee.eas.ep.updater.ImportBizUnitHelper4Update;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class EntryCreator {
    private EntityObjectInfo head;
    private EntityObjectInfo entryInfo;
    private IMetaDataPK entrypk;
    private String alias;
    private IMetadataStore mds = null;
    private String projectId;
    private static final Logger logger = Logger.getLogger(EntryCreator.class);
    public static final String WEB_DYNAMIC = "web_dynamic";
    public static final int ID_LENTH = 44;
    public static final String ENUMTYPE = "enum_type";
    public static final int STR_ENUM = 0;
    public static final int INT_ENUM = 1;
    private static final String BOSTYPE = "A286FAC9";
    private IMetaDataLoader loader = null;

    public EntryCreator(EntityObjectInfo head, IMetaDataPK entrypk, String alias, String projectId) {
        this.head = head;
        this.entrypk = entrypk;
        this.alias = alias;
        this.projectId = projectId;
    }

    public List creatorEntry() throws Exception {
        EntityObjectInfo entry = this.createEntity(this.entrypk, null, this.alias);
        DataTableInfo tableInfo = this.createTableInfo(entry);
        LinkPropertyInfo lp_entry = EntryCreator.createLinkProperty(this.head, "entry", entry.getAlias());
        LinkPropertyInfo lp_head = EntryCreator.createLinkProperty(entry, "bill", this.head.getAlias());
        RelationshipInfo relationShip = this.createRelationShip(this.head, entry, lp_entry, lp_head);
        lp_entry.setRelationship(relationShip);
        lp_head.setRelationship(relationShip);
        this.head.getProperties().add((PropertyInfo)lp_entry);
        entry.getProperties().add((PropertyInfo)lp_head);
        this.createColumn(entry, (PropertyInfo)lp_head);
        this.createTable(entry);
        this.entryInfo = entry;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(entry);
        list.add(tableInfo);
        list.add(relationShip);
        return list;
    }

    public RelationshipInfo creatorRelationship(EntityObjectInfo entry, LinkPropertyInfo lp_entry) throws Exception {
        LinkPropertyInfo lp_head = EntryCreator.createLinkProperty(entry, "parent", this.head.getAlias());
        lp_head.setConfigured(false);
        RelationshipInfo relationShip = this.createRelationShip(this.head, entry, lp_entry, lp_head);
        lp_entry.setRelationship(relationShip);
        lp_head.setRelationship(relationShip);
        entry.getProperties().add((PropertyInfo)lp_head);
        this.createColumn(entry, (PropertyInfo)lp_head);
        this.entryInfo = entry;
        return relationShip;
    }

    public EntityObjectInfo createEntity(IMetaDataPK pk, EntityObjectInfo baseEntity, String alias) throws BOSException {
        EntityCreator creator = new EntityCreator();
        creator.setMetaDataPk(pk);
        creator.setBaseEntity(baseEntity);
        creator.setAlias(alias);
        EntityObjectInfo entity = creator.createEntity();
        return entity;
    }

    private void createTable(EntityObjectInfo entity) throws Exception {
        CoreBaseCollection sqlCol = new CoreBaseCollection();
        DataTableInfo table = entity.getTable();
        String tableSql = SqlBuilder.buildTableSql(table);
        DBUpdateInfo sqlObj = new DBUpdateInfo(10, table.getRealName(), table.getRealName(), tableSql, 0);
        DBUpdateInfoSet sqlSet = new DBUpdateInfoSet();
        sqlSet.addDBUpdateInfo(sqlObj);
        UpdateSqlInfo sqlInfo = new UpdateSqlInfo();
        sqlInfo.setId(BOSUuid.create((BOSObjectType)sqlInfo.getBOSType()));
        sqlInfo.setCustomizedSchemeID(this.projectId);
        sqlInfo.setEntityPK(entity.getRealPackage() + "." + entity.getRealName());
        sqlInfo.setTablePK(table.getRealPackage() + "." + table.getRealName());
        sqlInfo.setSql(sqlSet.toJSONObject().toString());
        sqlCol.add((CoreBaseInfo)sqlInfo);
        if (sqlCol.size() > 0) {
            IUpdateSql instance = UpdateSqlFactory.getRemoteInstance();
            instance.submit(sqlCol);
        }
    }

    public IMetadataStore getMetadataStore(Context ctx) {
        if (this.mds == null) {
            this.mds = MetadataStoreFactory.getMetadataStore((Context)ctx);
        }
        return this.mds;
    }

    private void setExtendedProperty(EntityObjectInfo eo) {
        if (eo == null) {
            return;
        }
        eo.setExtendedProperty("codingRuleEnabled", "false");
        eo.setExtendedProperty("OrgType", "NONE");
    }

    public static EntityObjectInfo getEntityInfo(Context ctx, String packageName, String entityName) {
        MetaDataPK pk = new MetaDataPK(packageName, entityName);
        EntityObjectInfo mainEO = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)pk);
        return mainEO;
    }

    public static PropertyCollection getAllEntityProperties(EntityObjectInfo entity) {
        PropertyCollection properties = new PropertyCollection();
        properties.addObjectCollection((IObjectCollection)entity.getProperties());
        while (entity.getBaseEntity() != null) {
            properties.addObjectCollection((IObjectCollection)entity.getBaseEntity().getProperties());
            entity = entity.getBaseEntity();
        }
        return properties;
    }

    private static void setExtendedPropertyForBotp(PropertyInfo prop) {
        if (prop != null) {
            prop.setExtendedProperty("isForMapping", "false");
            prop.setExtendedProperty("isForMatching", "false");
            prop.setExtendedProperty("isForGrouping", "false");
            prop.setExtendedProperty("isForWrittenBack", "false");
            prop.setExtendedProperty("dynExtendPropertyList", "isForMapping|isForMatching|isForGrouping|isForWrittenBack");
        }
    }

    private String createThirdName() {
        String thirdName = BOSUuid.create((String)BOSTYPE).toString();
        String tmp = "";
        for (int k = 0; k < thirdName.length(); ++k) {
            char achar = thirdName.charAt(k);
            if (!(achar >= '0' && achar <= '9' || achar >= 'a' && achar <= 'z') && (achar < 'A' || achar > 'Z')) continue;
            tmp = tmp + achar;
        }
        thirdName = tmp.length() <= 10 ? tmp : tmp.substring(0, 10);
        return thirdName;
    }

    public DataTableInfo createTableInfo(EntityObjectInfo entity) throws BOSException {
        DataTableInfo table = EntityToTable.CreateDataTable((EntityObjectInfo)entity, null);
        table.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        EntityToTable.autoCreateForeignKey((EntityObjectInfo)entity, (DataTableInfo)table, new ArrayList());
        return table;
    }

    private RelationshipInfo createRelationShip(EntityObjectInfo client, EntityObjectInfo suppler, LinkPropertyInfo clientProperty, LinkPropertyInfo supplyProperty) throws BOSException {
        RelationshipCreator creator = new RelationshipCreator();
        creator.setClientEntity(client);
        creator.setSupplyEntity(suppler);
        creator.setClientProperty((PropertyInfo)clientProperty);
        creator.setSupplyProperty((PropertyInfo)supplyProperty);
        creator.setType(RelationshipType.COMPOSITION);
        RelationshipInfo relationShip = creator.createRelationShip();
        return relationShip;
    }

    private void createColumn(EntityObjectInfo entity, PropertyInfo prop) {
        ColumnInfo col = new ColumnInfo();
        TablePrefixInfo prefixInfo = new TablePrefixInfo();
        col.setName(prefixInfo.genColumnName(prop.getName(), true));
        col.setDescription(prop.getDescription());
        col.setLength(44);
        col.setTypeName(SQLType.VARCHAR);
        prop.setMappingField(col);
        DataTableInfo table = entity.getTable();
        ColumnCollection cols = table.getColumns();
        if (!cols.containsObject((IObjectValue)col)) {
            cols.add(col);
        }
    }

    private LinkPropertyInfo createALinkPropertyInfo(Context ctx, EntityObjectInfo mainEO, EntityObjectInfo supplyEO, String propetyName, boolean isMustInput, boolean isComposition) {
        LinkPropertyInfo property = new LinkPropertyInfo();
        RelationshipInfo relation = new RelationshipInfo();
        relation.setType(isComposition ? RelationshipType.COMPOSITION : RelationshipType.ASSOCIATION);
        relation.setPackage(mainEO.getPackage());
        relation.setName("R_" + mainEO.getName() + "_" + supplyEO.getName() + "_" + propetyName);
        relation.setClientObject(mainEO);
        relation.setSupplierObject(supplyEO);
        relation.setClientCardinality(CardinalityType.ZERO_TO_ONE);
        if (!isComposition) {
            if (isMustInput) {
                relation.setSupplierCardinality(CardinalityType.ONE);
            } else {
                relation.setSupplierCardinality(CardinalityType.ZERO_TO_ONE);
            }
        } else if (isMustInput) {
            relation.setSupplierCardinality(CardinalityType.ONE_TO_UNBOUNDED);
        } else {
            relation.setSupplierCardinality(CardinalityType.ZERO_TO_UNBOUNDED);
        }
        property.setRelationship(relation);
        return property;
    }

    public void createACustomizedUnit(String projectId) {
        EntryCreator.createACustomizedUnit(null, this.head, this.entryInfo, projectId);
    }

    public static void createACustomizedUnit(Context ctx, EntityObjectInfo parent_info, EntityObjectInfo entity_info, String projectId) {
        try {
            ICustomizedUnit bizInterface = null;
            bizInterface = ctx != null ? CustomizedUnitFactory.getLocalInstance(ctx) : CustomizedUnitFactory.getRemoteInstance();
            AbstractCustomizedUnitInfo parent = null;
            CustomizedUnitCollection items = bizInterface.getCustomizedUnitCollection();
            for (int i = 0; i < items.size(); ++i) {
                if (!parent_info.getName().equals(items.get(i).getName()) || !projectId.equals(items.get(i).getCustomizedSchemeID())) continue;
                parent = items.get(i);
                break;
            }
            if (parent != null) {
                CustomizedUnitNodeInfo cunInfo = CustomizedUnitNodeInfoConverter.converter2Object(parent.getCustomizedUnitObject());
                CustomizedUnitNodeInfo.MetaDataInfo md = new CustomizedUnitNodeInfo.MetaDataInfo(entity_info.getPackage(), entity_info.getName(), entity_info.getAlias());
                cunInfo.getEntity().add(md);
                String xml = CustomizedUnitNodeInfoConverter.coverter2xml(cunInfo);
                parent.setCustomizedUnitObject(xml);
                ObjectUuidPK pk = new ObjectUuidPK(parent.getId());
                bizInterface.update((IObjectPK)pk, (CoreBaseInfo)parent);
            } else {
                String name = parent_info.getName();
                String alias = parent_info.getAlias();
                String entityPK = parent_info.getPackage() + "." + parent_info.getName();
                EntryCreator.createACustomizedUnit(ctx, name, alias, entityPK, new ArrayList(), projectId);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    public static void createACustomizedUnit(Context ctx, String name, String alias, String entityPK, List queryObjList, String projectId) throws Exception {
        CustomizedUnitNodeInfo.MetaDataInfo md;
        String sListUIPK = null;
        String sEditUIPK = null;
        String entityFunctionPK = null;
        String editUIFunctionPK = null;
        String listUIFunctionPK = null;
        EntityObjectInfo mainEntityObject = null;
        if (StringUtils.isEmpty((String)entityPK)) {
            throw new BOSException("entityPK\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        mainEntityObject = UictUtils.loadEntity((IMetaDataPK)MetaDataPK.create((String)entityPK));
        ICustomizedUnit bizInterface = null;
        bizInterface = ctx != null ? CustomizedUnitFactory.getLocalInstance(ctx) : CustomizedUnitFactory.getRemoteInstance();
        CustomizedUnitNodeInfo cunInfo = new CustomizedUnitNodeInfo();
        cunInfo.setPackagePK(mainEntityObject.getPackage().substring(0, mainEntityObject.getPackage().length() - 4));
        cunInfo.setName(name);
        cunInfo.setAlias(alias);
        cunInfo.setCustomizedType("bizunit");
        if (!StringUtils.isEmpty((String)entityPK)) {
            EntityObjectInfo entityObject = UictUtils.loadEntity((IMetaDataPK)MetaDataPK.create((String)entityPK));
            ArrayList entitys = new ArrayList();
            ImportBizUnitHelper4Update.getEntitys(entityObject, entitys);
            for (EntityObjectInfo eoi : entitys) {
                CustomizedUnitNodeInfo.MetaDataInfo md2 = new CustomizedUnitNodeInfo.MetaDataInfo(eoi.getPackage(), eoi.getName(), eoi.getAlias());
                cunInfo.getEntity().add(md2);
            }
        }
        for (int i = 0; i < queryObjList.size(); ++i) {
            QueryInfo query = (QueryInfo)queryObjList.get(i);
            if (query == null) continue;
            CustomizedUnitNodeInfo.MetaDataInfo md3 = new CustomizedUnitNodeInfo.MetaDataInfo(query.getPackage(), query.getName(), query.getAlias());
            cunInfo.getQuery().add(md3);
        }
        if (!StringUtils.isEmpty(sListUIPK)) {
            UIObjectInfo listui = UictUtils.loadUI((IMetaDataPK)MetaDataPK.create(sListUIPK));
            md = new CustomizedUnitNodeInfo.MetaDataInfo(listui.getPackage(), listui.getName(), listui.getAlias());
            cunInfo.getUi().getListui().add(md);
        }
        if (!StringUtils.isEmpty(sEditUIPK)) {
            UIObjectInfo editui = UictUtils.loadUI((IMetaDataPK)MetaDataPK.create(sEditUIPK));
            md = new CustomizedUnitNodeInfo.MetaDataInfo(editui.getPackage(), editui.getName(), editui.getAlias());
            cunInfo.getUi().getEditui().add(md);
        }
        if (!StringUtils.isEmpty(entityFunctionPK)) {
            FunctionObjectInfo function = UictUtils.loadFunction((IMetaDataPK)MetaDataPK.create(entityFunctionPK));
            md = new CustomizedUnitNodeInfo.MetaDataInfo(function.getPackage(), function.getName(), function.getAlias());
            cunInfo.getFunction().add(md);
        }
        if (!StringUtils.isEmpty(editUIFunctionPK)) {
            FunctionObjectInfo function = UictUtils.loadFunction((IMetaDataPK)MetaDataPK.create(editUIFunctionPK));
            md = new CustomizedUnitNodeInfo.MetaDataInfo(function.getPackage(), function.getName(), function.getAlias());
            cunInfo.getFunction().add(md);
        }
        if (!StringUtils.isEmpty(listUIFunctionPK)) {
            FunctionObjectInfo function = UictUtils.loadFunction((IMetaDataPK)MetaDataPK.create(listUIFunctionPK));
            md = new CustomizedUnitNodeInfo.MetaDataInfo(function.getPackage(), function.getName(), function.getAlias());
            cunInfo.getFunction().add(md);
        }
        String xml = CustomizedUnitNodeInfoConverter.coverter2xml(cunInfo);
        CustomizedUnitInfo parent = new CustomizedUnitInfo();
        parent.setCustomizedSchemeID(projectId);
        parent.setId(BOSUuid.read((String)projectId));
        CustomizedUnitInfo dataObj = new CustomizedUnitInfo();
        dataObj.setId(BOSUuid.create((BOSObjectType)dataObj.getBOSType()));
        dataObj.setNumber(dataObj.getId().toString());
        dataObj.setName(cunInfo.getName());
        dataObj.setDisplayName(cunInfo.getAlias());
        dataObj.setNodeType(NodeTypeEnum.CUSTOMIZED_UNIT);
        dataObj.setCustomizedUnitObject(xml);
        dataObj.setIsLeaf(false);
        dataObj.setLevel(1);
        dataObj.setParent(parent);
        dataObj.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        dataObj.setCustomizedSchemeID(parent.getCustomizedSchemeID());
        bizInterface.addnew((CoreBaseInfo)dataObj);
    }

    private String createLinkPropName(EntityObjectInfo headEO, String prefix) {
        if (StringUtils.isEmpty((String)prefix)) {
            prefix = "prefix";
        }
        int i = 1;
        while (headEO.getPropertyByName(prefix + i) != null) {
            ++i;
        }
        return prefix + i;
    }

    private String createSql() {
        return null;
    }

    private UIObjectInfo createComponent() {
        return null;
    }

    public EntityObjectInfo getHead() {
        return this.head;
    }

    public IMetaDataPK getEntrypk() {
        return this.entrypk;
    }

    public static LinkPropertyInfo createLinkProperty(EntityObjectInfo entity, String name, String alias) {
        String propertyName;
        if (StringUtils.isEmpty((String)name)) {
            name = "prefix";
        }
        if (entity.getPropertyByName(propertyName = name) != null) {
            int i = 1;
            while (entity.getPropertyByName(propertyName + i) != null) {
                ++i;
            }
            propertyName = name + i;
        }
        LinkPropertyInfo linkProp = new LinkPropertyInfo();
        linkProp.setName(propertyName);
        linkProp.setAlias(alias);
        linkProp.setDescription(alias);
        EntryCreator.setExtendedPropertyForBotp((PropertyInfo)linkProp);
        return linkProp;
    }

    public void clearMetaDataCache(AbstractMetaDataValue[] metas) {
        for (int i = 0; i < metas.length; ++i) {
            AbstractMetaDataValue md = metas[i];
            if (md instanceof UIObjectInfo) continue;
            logger.info((Object)(" clear md cache --- > [" + md.getBOSType() + "]" + md.getFullName()));
            if (md == null) continue;
            this.getMetadataLoader(null).clear(md.getBOSType(), (IMetaDataPK)new MetaDataPK(md.getFullName()));
        }
    }

    public IMetaDataLoader getMetadataLoader(Context ctx) {
        if (this.loader == null) {
            this.loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        }
        return this.loader;
    }

    public void updateEntity(EntityObjectInfo entity, String newName) {
        entity.setName(newName);
        entity.setType(this.genBOSType(entity.getRealFullName()));
        MethodCollection methods = entity.getMethods();
        int n = methods.size();
        for (int i = 0; i < n; ++i) {
            MethodInfo method = methods.get(i);
            if (!StringUtils.isEmpty((String)method.getMetaDataRef())) {
                method.setMetadataRef(entity.getRealFullName());
            }
            method.setString("innerID", Uuid.create().toString());
            ParameterCollection col = method.getParameters();
            int m = col.size();
            for (int j = 0; j < m; ++j) {
                ParameterInfo param = col.get(j);
                if (StringUtils.isEmpty((String)param.getMetaDataRef())) continue;
                param.setMetadataRef(entity.getRealFullName());
            }
        }
        EventCollection events = entity.getEvents();
        int l = events.size();
        for (int i = 0; i < l; ++i) {
            EventInfo event = events.get(i);
            FormalParameterCollection formalParams = event.getFormalParameters();
            int m = formalParams.size();
            for (int j = 0; j < m; ++j) {
                FormalParameterInfo formalParam = formalParams.get(j);
                if (formalParam.getParameter() == null) continue;
                formalParam.getParameter().setMetadataRef(entity.getRealFullName());
            }
        }
        entity.setBusinessControllerName(entity.getRealPackage() + "." + newName + "Controller");
        entity.setBusinessImplName(this.removePackageSuffix(entity.getRealPackage()) + "." + newName);
    }

    private String removePackageSuffix(String packageName) {
        if (StringUtils.endsWithIgnoreCase((String)packageName, (String)".client")) {
            return packageName.substring(0, packageName.length() - ".client".length());
        }
        if (StringUtils.endsWithIgnoreCase((String)packageName, (String)".app")) {
            return packageName.substring(0, packageName.length() - ".app".length());
        }
        return packageName;
    }

    private BOSObjectType genBOSType(String name) {
        int hash = name.hashCode();
        String type = Integer.toHexString(hash).toUpperCase();
        if (type.length() > 8) {
            type = type.substring(0, 8);
        } else if (type.length() < 8) {
            int n = type.length();
            for (int i = 0; i < 8 - n; ++i) {
                type = "0" + type;
            }
        }
        return BOSObjectType.create((String)type);
    }

    public void updateTable(DataTableInfo table, String newName) throws BOSException {
        newName = this.validateTableName(newName, 0);
        table.setName(newName);
        if (table.getPrimaryKey() != null) {
            String pkName;
            pkName = pkName.substring(0, (pkName = BIMNameFactory.createTablePKName((String)table.getRealPackage(), (String)table.getRealName(), (String)"FID", (boolean)true)).length() > 18 ? 18 : pkName.length());
            pkName = pkName.replace('.', '_');
            table.getPrimaryKey().setName(pkName);
        }
        ForeignKeyCollection fkcol = table.getForeignKeys();
        int n = fkcol.size();
        for (int i = 0; i < n; ++i) {
            ForeignKeyInfo fk = fkcol.get(i);
            String fkName = "";
            if (fk == null) continue;
            if (fk.getRefTable() != null && fk.getFKColumnPairs() != null && fk.getFKColumnPairs().get(0) != null && fk.getFKColumnPairs().get(0).getForeignKeyColumn() != null && fk.getFKColumnPairs().get(0).getForeignKeyColumn().getName() != null) {
                fkName = BIMNameFactory.createTableFKName((String)table.getRealPackage(), (String)table.getRealName(), (String)fk.getRefTable().getRealName(), (String)fk.getFKColumnPairs().get(0).getForeignKeyColumn().getName(), (boolean)true);
            }
            fkName = fkName.replace('.', '_');
            fk.setName(fkName);
        }
    }

    private String validateTableName(String tableName, int i) throws BOSException {
        String newTableName = tableName;
        if (i > 0) {
            newTableName = tableName + i;
        }
        if (this.isTableExists(newTableName) || this.isDynTableExists(newTableName)) {
            return this.validateTableName(tableName, ++i);
        }
        return newTableName;
    }

    private boolean isTableExists(String tableName) throws BOSException {
        IUpdateSql instance = UpdateSqlFactory.getRemoteInstance();
        return instance.isTableExists(tableName);
    }

    private boolean isDynTableExists(String tableName) throws BOSException {
        IUpdateSql instance = UpdateSqlFactory.getRemoteInstance();
        CoreBaseCollection col = instance.getCollection();
        if (col != null && col.size() > 0 && col.get(0) instanceof UpdateSqlInfo) {
            int j = col.size();
            for (int i = 0; i < j; ++i) {
                String tablepk = ((UpdateSqlInfo)col.get(i)).getTablePK();
                if (!tablepk.toLowerCase(Locale.ENGLISH).endsWith(tableName.toLowerCase(Locale.ENGLISH))) continue;
                return true;
            }
        }
        return false;
    }
}

