/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.util;

import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.dtp.model.ComponentNameManager;
import com.kingdee.eas.ep.client.editor.editui.designer.util.ComponentHelper;
import com.kingdee.eas.ep.client.util.ImportBizUnitHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class FieldNameManager {
    private List entitys;
    private UIObjectInfo editUI;

    public FieldNameManager(BizUnitInfo bizunit) throws Exception {
        EntityObjectInfo entity = bizunit.getEntity();
        this.entitys = new ArrayList();
        ImportBizUnitHelper.getEntitys(entity, this.entitys);
        this.editUI = bizunit.getEditUI();
    }

    public String getFieldName(String classType) {
        String tempName;
        String fieldName = tempName = this.getTempName(classType);
        for (int i = 1; i < Integer.MAX_VALUE && this.isUsed(fieldName, classType); ++i) {
            fieldName = tempName + i;
        }
        return fieldName;
    }

    private boolean isUsed(String name, String classType) {
        String prefix = ComponentHelper.getPrefix(classType);
        for (int i = 0; i < this.entitys.size(); ++i) {
            EntityObjectInfo entity = (EntityObjectInfo)this.entitys.get(i);
            if (!this.isUsed(entity, name)) continue;
            return true;
        }
        return this.isUsed(this.editUI, prefix + name);
    }

    private boolean isUsed(EntityObjectInfo entity, String propertyName) {
        if (entity == null) {
            return false;
        }
        PropertyInfo propertyInfo = entity.getPropertyByName(propertyName);
        return propertyInfo != null || entity.getName().equalsIgnoreCase(propertyName);
    }

    private boolean isUsed(UIObjectInfo uiobj, String name) {
        ComponentNameManager nameManager = uiobj.getNameManager();
        return nameManager.isUsed(name);
    }

    public String getTempName(String classType) {
        int index;
        String name = "";
        if (!StringUtils.isEmpty((String)classType) && (index = classType.lastIndexOf(46)) >= 0) {
            name = classType.substring(classType.lastIndexOf(46) + 1);
            name = name.length() > 1 ? name.substring(0, 1).toLowerCase() + name.substring(1) : name.toLowerCase();
        }
        return name;
    }
}

