/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.eas.ep.client.util.UictUtils;

public class RelationshipCreator {
    private PropertyInfo clientProperty;
    private PropertyInfo supplyProperty;
    private EntityObjectInfo clientEntity;
    private EntityObjectInfo supplyEntity;
    private RelationshipType type;
    private IMetaDataPK metadataPK;

    public RelationshipInfo createRelationShip() throws BOSException {
        if (RelationshipType.COMPOSITION.equals((Object)this.type)) {
            return this.createCompositionRelation();
        }
        return null;
    }

    private RelationshipInfo createCompositionRelation() throws BOSException {
        RelationshipInfo relation = new RelationshipInfo();
        relation.setType(this.getType());
        IMetaDataPK metadataPK = this.getMetadataPK();
        if (this.getMetadataPK() != null) {
            relation.setPackage(metadataPK.getPackage());
            relation.setName(metadataPK.getName());
        } else {
            relation.setPackage(this.getClientEntity().getPackage());
            String name = this.createRelationName(this.getClientEntity().getPackage());
            relation.setName(name);
        }
        relation.setClientObject(this.getClientEntity());
        relation.setSupplierObject(this.getSupplyEntity());
        relation.setClientCardinality(CardinalityType.ONE);
        relation.setSupplierCardinality(CardinalityType.ZERO_TO_UNBOUNDED);
        return relation;
    }

    private String createRelationName(String _package) throws BOSException {
        String name = "R_" + this.getClientEntity().getName() + "_" + this.getSupplyEntity().getName() + this.getClientProperty().getName();
        MetaDataPK pk = MetaDataPK.create((String)_package, (String)name);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        for (long i = 0L; i < Long.MAX_VALUE && !UictUtils.isEmptyMD((AbstractMDValue)loader.get(MetaDataTypeList.RELATIONSHIP, (IMetaDataPK)pk)); ++i) {
            pk = MetaDataPK.create((String)_package, (String)(name + i));
        }
        if (!UictUtils.isEmptyMD((AbstractMDValue)loader.get(MetaDataTypeList.RELATIONSHIP, (IMetaDataPK)pk))) {
            throw new BOSException("failed create RelationShip because all the suitable name has been used!");
        }
        return pk.getName();
    }

    public PropertyInfo getClientProperty() {
        return this.clientProperty;
    }

    public void setClientProperty(PropertyInfo clientProperty) {
        this.clientProperty = clientProperty;
    }

    public PropertyInfo getSupplyProperty() {
        return this.supplyProperty;
    }

    public void setSupplyProperty(PropertyInfo supplyProperty) {
        this.supplyProperty = supplyProperty;
    }

    public EntityObjectInfo getClientEntity() {
        return this.clientEntity;
    }

    public void setClientEntity(EntityObjectInfo clientEntity) {
        this.clientEntity = clientEntity;
    }

    public EntityObjectInfo getSupplyEntity() {
        return this.supplyEntity;
    }

    public void setSupplyEntity(EntityObjectInfo supplyEntity) {
        this.supplyEntity = supplyEntity;
    }

    public RelationshipType getType() {
        return this.type;
    }

    public void setType(RelationshipType type) {
        this.type = type;
    }

    public IMetaDataPK getMetadataPK() {
        return this.metadataPK;
    }

    public void setMetadataPK(IMetaDataPK metadataPK) {
        this.metadataPK = metadataPK;
    }
}

