/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.util;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.MergeBlockInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.util.STConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TableInfoUtils {
    private static Logger logger = Logger.getLogger(TableInfoUtils.class);
    private Locale targetLocale;
    private Locale currentLocale;

    public void synTableInfo(TableInfo otableInfo, TableInfo tableInfo) {
        this.synHeaderInfo(otableInfo, tableInfo);
        this.synColumnInfo(otableInfo, tableInfo);
    }

    private void synColumnInfo(TableInfo otableInfo, TableInfo tableInfo) {
        ColumnInfo ocolumn;
        int i;
        List columns = tableInfo.getColumns();
        List ocolumns = otableInfo.getColumns();
        ColumnInfo column = null;
        for (i = 0; i < columns.size(); ++i) {
            column = (ColumnInfo)columns.get(i);
            ocolumn = this.findColumnByName(column.getName(), ocolumns);
            if (ocolumn == null) {
                this.addColumn(otableInfo, tableInfo, i);
                continue;
            }
            int index = ocolumns.indexOf(ocolumn);
            ocolumns.remove(index);
            ocolumns.add(index, column);
        }
        for (i = 0; i < ocolumns.size(); ++i) {
            ocolumn = (ColumnInfo)ocolumns.get(i);
            column = this.findColumnByName(ocolumn.getName(), columns);
            if (column != null) continue;
            ocolumns.remove(i);
            List headers = otableInfo.getHeaders();
            HeaderInfo header = null;
            for (int j = 0; j < headers.size(); ++j) {
                header = (HeaderInfo)headers.get(j);
                if (header.getCellCount() <= i) continue;
                header.getCells().remove(i);
            }
        }
    }

    public void addColumn(TableInfo tblNew, TableInfo tblOld, int oldIndex) {
        ColumnInfo colOld = (ColumnInfo)tblOld.getColumns().get(oldIndex);
        List cols = tblNew.getColumns();
        colOld.setParent(tblNew);
        int maxIndex = cols.size();
        int newIndex = colOld.getIndex() != -1 ? (colOld.getIndex() > maxIndex ? maxIndex : colOld.getIndex()) : (oldIndex > maxIndex ? maxIndex : oldIndex);
        cols.add(newIndex, colOld);
        List rowsNew = tblNew.getHeaders();
        if (rowsNew.size() != tblOld.getHeaderCount()) {
            logger.info((Object)("Table header rows are not equal : tblNew " + rowsNew.size() + "    tblOld " + tblOld.getHeaderCount()));
        }
        for (int i = 0; i < rowsNew.size(); ++i) {
            CellInfo cell = this.getCellInfo(tblOld, i, oldIndex);
            if (cell == null) continue;
            HeaderInfo hi = (HeaderInfo)rowsNew.get(i);
            ArrayList rowNew = hi.getCells();
            cell = this.cloneCell(cell);
            this.translateLan(cell, colOld);
            cell.setParent(hi);
            if (newIndex > rowNew.size()) {
                newIndex = rowNew.size();
            }
            if (rowNew.size() >= cols.size()) continue;
            rowNew.add(newIndex, cell);
        }
        this.adjustMergeInfo(tblNew, newIndex);
    }

    private void translateLan(CellInfo cell, ColumnInfo col) {
        String targetCode;
        String currentCode = BOSLocaleUtil.getShortCode((Locale)this.currentLocale);
        if (currentCode != null && currentCode.equals(BOSLocaleUtil.getShortCode((Locale)BOSLocaleUtil.ZH_CN)) && (targetCode = BOSLocaleUtil.getShortCode((Locale)this.targetLocale)) != null) {
            String name = cell.getName();
            if (targetCode.equals(BOSLocaleUtil.getShortCode((Locale)BOSLocaleUtil.ZH_TW)) && !StringUtils.isEmpty((String)name)) {
                name = STConverter.sc2tc((String)name);
                cell.setName(name);
            }
            if (targetCode.equals(BOSLocaleUtil.getShortCode((Locale)BOSLocaleUtil.ZH_CN))) {
                if (!StringUtils.isEmpty((String)name)) {
                    name = STConverter.tc2sc((String)name);
                    cell.setName(name);
                }
            } else if (targetCode.equals(BOSLocaleUtil.getShortCode((Locale)BOSLocaleUtil.EN_US))) {
                cell.setName(col.getName());
            }
        }
    }

    private CellInfo getCellInfo(TableInfo tbl, int rowIndex, int colIndex) {
        HeaderInfo hi;
        ArrayList cells;
        List rows = tbl.getHeaders();
        if (rows != null && rows.size() > rowIndex && (cells = (hi = (HeaderInfo)rows.get(rowIndex)).getCells()) != null && cells.size() > colIndex) {
            return (CellInfo)cells.get(colIndex);
        }
        return null;
    }

    private void adjustMergeInfo(TableInfo tbl, int index) {
        List blocks = tbl.getMergeBlocks();
        if (blocks != null) {
            for (MergeBlockInfo mb : blocks) {
                if (index <= mb.getLeft()) {
                    mb.setLeft(mb.getLeft() + 1);
                    mb.setRight(mb.getRight() + 1);
                    continue;
                }
                if (index > mb.getRight()) continue;
                mb.setRight(mb.getRight() + 1);
            }
        }
    }

    private HeaderInfo cloneHeader(HeaderInfo header) {
        HeaderInfo clone = new HeaderInfo();
        if (header != null) {
            clone.setConfigured(header.isConfigured());
            clone.setHeight(header.getHeight());
            clone.setMergeable(header.isMergeable());
            clone.setName(header.getName());
            clone.setResizeable(header.isResizeable());
            ArrayList cells = header.getCells();
            for (int i = 0; i < cells.size(); ++i) {
                CellInfo cell = (CellInfo)cells.get(i);
                CellInfo cloneCell = this.cloneCell(cell);
                clone.getCells().add(cloneCell);
            }
        }
        return clone;
    }

    private CellInfo cloneCell(CellInfo cell) {
        CellInfo clone = new CellInfo();
        if (cell != null) {
            clone.setColSpan(cell.getColSpan());
            clone.setConfigured(cell.isConfigured());
            clone.setIndex(cell.getIndex());
            clone.setName(cell.getName());
            clone.setRowSpan(cell.getRowSpan());
        }
        return clone;
    }

    private void synHeaderInfo(TableInfo otableInfo, TableInfo tableInfo) {
        HeaderInfo oheader;
        int i;
        List headers = tableInfo.getHeaders();
        List oheaders = otableInfo.getHeaders();
        HeaderInfo header = null;
        for (i = 0; i < headers.size(); ++i) {
            header = (HeaderInfo)headers.get(i);
            oheader = this.findHeaderByName(header.getName(), oheaders);
            if (oheader != null) continue;
            header = this.cloneHeader(header);
            if (i < oheaders.size()) {
                oheaders.add(i, header);
                continue;
            }
            oheaders.add(header);
        }
        for (i = 0; i < oheaders.size(); ++i) {
            header = (HeaderInfo)oheaders.get(i);
            oheader = this.findHeaderByName(header.getName(), headers);
            if (oheader != null) continue;
            oheaders.remove(i);
        }
    }

    private ColumnInfo findColumnByName(String name, List columns) {
        if (name == null) {
            return null;
        }
        ColumnInfo column = null;
        for (int col = 0; col < columns.size(); ++col) {
            column = (ColumnInfo)columns.get(col);
            if (!name.equals(column.getName())) continue;
            return column;
        }
        return null;
    }

    private HeaderInfo findHeaderByName(String name, List headers) {
        if (name == null) {
            return null;
        }
        HeaderInfo header = null;
        for (int col = 0; col < headers.size(); ++col) {
            header = (HeaderInfo)headers.get(col);
            if (!name.equals(header.getName())) continue;
            return header;
        }
        return null;
    }

    public void setTargetLocal(Locale locale) {
        this.targetLocale = locale;
    }

    public void setCurrentLocale(Locale locale) {
        this.currentLocale = locale;
    }
}

