/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.entity;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.db.DBUpdateInfo;
import com.kingdee.bos.db.DBUpdateInfoSet;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.configure.Saver4;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.ExtendPropertyInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.util.CloneUtils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.CustomizedUnitFactory;
import com.kingdee.eas.ep.ICustomizedScheme;
import com.kingdee.eas.ep.IUpdateSql;
import com.kingdee.eas.ep.UpdateSqlFactory;
import com.kingdee.eas.ep.UpdateSqlInfo;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.IEditorTabPanel;
import com.kingdee.eas.ep.client.editor.editui.designer.util.CustomSchemeUtil;
import com.kingdee.eas.ep.client.editor.entity.AbstractEntityEditorUI;
import com.kingdee.eas.ep.client.editor.query.ui.ExtendedPropertySelectUI;
import com.kingdee.eas.ep.client.editor.query.ui.QueryFieldExtendPropertyUI;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.handle.PropertyDefineUIManager;
import com.kingdee.eas.ep.client.model.extendproperty.ExdPropertyDelegate;
import com.kingdee.eas.ep.client.model.extendproperty.GroupComparator;
import com.kingdee.eas.ep.client.model.extendproperty.ReadBosConfigUtil;
import com.kingdee.eas.ep.client.util.EntityEditorHelper;
import com.kingdee.eas.ep.client.util.SqlBuilder;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.ep.util.ExcelExportHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;

public class EntityEditor
extends AbstractEntityEditorUI
implements IEditorTabPanel {
    private PropertyDefineUIManager manager;
    private CustomizedUnitUI ui;
    private String customizedSchemeID;
    private Project depend;
    private EntityObjectInfo base;
    private EntityObjectInfo entityInfo;
    private DataTableInfo table;
    private Saver4 saver4;
    private UpdateSqlInfo sqlInfo;
    private static final Logger logger = CoreUIObject.getLogger(EntityEditor.class);
    private boolean isAbstract;
    private int status;

    public EntityEditor() throws Exception {
    }

    public EntityEditor(EntityObjectInfo base, EntityObjectInfo entityInfo, Project depend, String customizedSchemeID) throws Exception {
        this.init();
        this.initUIContentLayout();
        this.saver4 = new Saver4(MetaDataLoaderFactory.getRemoteMetaDataLoader());
        this.base = base;
        this.entityInfo = entityInfo;
        this.table = entityInfo.getTable();
        this.depend = depend;
        this.customizedSchemeID = customizedSchemeID;
        if (this.table != null) {
            this.manager = new PropertyDefineUIManager((KDPanel)this, this.entityInfo, this.table, depend);
            IUpdateSql instance = UpdateSqlFactory.getRemoteInstance();
            CoreBaseCollection col = instance.getCollection(" where customizedSchemeID = '" + customizedSchemeID + "' and entityPK='" + base.getFullName() + "' and tablePK = '" + this.table.getFullName() + "'");
            if (col != null && col.size() > 0 && col.get(0) instanceof UpdateSqlInfo) {
                this.sqlInfo = (UpdateSqlInfo)col.get(0);
                this.status = 0;
            } else {
                this.sqlInfo = this.createSqlInfo();
                this.status = 2;
            }
        } else {
            this.isAbstract = true;
        }
        this.entityTable.getColumn("cfgColumn").getStyleAttributes().setHided(true);
        this.loadData();
    }

    private UpdateSqlInfo createSqlInfo() {
        UpdateSqlInfo sqlInfo = new UpdateSqlInfo();
        sqlInfo.setCustomizedSchemeID(this.customizedSchemeID);
        sqlInfo.setEntityPK(this.base.getFullName());
        sqlInfo.setTablePK(this.base.getTable().getFullName());
        return sqlInfo;
    }

    private void init() throws Exception {
        this.entityTable.setColumnsAutoResizeMode(3);
        this.tb_EntityExtend.setColumnsAutoResizeMode(3);
        this.tb_PropertyExtend.setColumnsAutoResizeMode(3);
        this.entityTable.setAutoResize(true);
        this.tb_EntityExtend.setAutoResize(true);
        this.tb_PropertyExtend.setAutoResize(true);
        this.entityTable.checkParsed(true);
        this.entityTable.setEditable(false);
        this.entityTable.getSelectManager().setSelectMode(10);
        ExcelExportHelper.enableExportExcel(this.entityTable);
        this.tb_EntityExtend.checkParsed(false);
        this.tb_EntityExtend.setEditable(false);
        this.tb_EntityExtend.getSelectManager().setSelectMode(2);
        this.tb_PropertyExtend.checkParsed(false);
        this.tb_PropertyExtend.setEditable(false);
        this.tb_PropertyExtend.getSelectManager().setSelectMode(2);
        this.tb_PropertyExtend.getStyleAttributes().setWrapText(true);
        this.tb_EntityExtend.getStyleAttributes().setWrapText(true);
        this.txtAlias.setMaxLength(40);
        this.txtDesc.setMaxLength(100);
        this.txtAlias.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                EntityEditor.this.alias_CaretUpdate(e);
            }
        });
        this.txtDesc.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                EntityEditor.this.desc_CaretUpdate(e);
            }
        });
        this.kDSplitPane1.setDividerLocation(0.5);
        this.btnEntityExtendDel.setEnabled(false);
        this.btnEntityExtendEdit.setEnabled(false);
        this.btnEditExtendProperty.setEnabled(false);
        this.btnDelExtendProperty.setEnabled(false);
    }

    @Override
    public void loadData() {
        if (this.entityInfo == null) {
            return;
        }
        this.txtName.setText(this.entityInfo.getName());
        this.txtAlias.setText(this.entityInfo.getAlias());
        this.txtDesc.setText(this.entityInfo.getDescription());
        if (this.entityInfo.getTable() != null) {
            this.txtTable.setText(this.entityInfo.getTable().getName());
        }
        this.loadProperties();
        this.resetComponentstatus();
        this.refreshEntityExtends();
        this.autoSelect(this.entityTable);
    }

    private void autoSelect(KDTable table) {
        if (table.getRowCount() > 0) {
            table.getSelectManager().select(0, 0);
        }
    }

    private void loadProperties() {
        this.entityTable.removeRows();
        PropertyCollection propertyCol = this.entityInfo.getInheritedProperties();
        int size = propertyCol.size();
        for (int i = size - 1; i >= 0; --i) {
            PropertyInfo info = propertyCol.get(i);
            IRow row = this.entityTable.addRow();
            row.setUserObject((Object)info);
            row.getCell("nameColumn").setValue((Object)info.getName());
            row.getCell("aliasColumn").setValue((Object)info.getAlias());
            row.getCell("typeColumn").setValue((Object)EntityEditorHelper.getDataTypeAlias(info));
            ColumnInfo column = info.getMappingField();
            if (column != null) {
                row.getCell("dbNameColumn").setValue((Object)column.getName());
            }
            if (!info.isConfigured()) continue;
            row.getStyleAttributes().setFontColor(Color.BLUE);
        }
    }

    private void resetComponentstatus() {
        if (this.isAbstract) {
            this.btnAddProperty.setEnabled(false);
            this.btnEditProperty.setEnabled(false);
            this.btnDeleteProperty.setEnabled(false);
            this.btnViewProperty.setEnabled(false);
            this.btnEntityExtendAdd.setEnabled(false);
            this.btnEntityExtendEdit.setEnabled(false);
            this.btnEntityExtendDel.setEnabled(false);
            this.btnTableField.setEnabled(false);
            this.btnEditExtendProperty.setEnabled(false);
            this.btnAddExtendProperty.setEnabled(false);
            this.btnDelExtendProperty.setEnabled(false);
        }
    }

    protected void validateTree() {
        int i;
        super.validateTree();
        if (this.tb_EntityExtend != null) {
            for (i = 0; i < this.tb_EntityExtend.getRowCount(); ++i) {
                KDTableHelper.autoFitRowHeight((KDTable)this.tb_EntityExtend, (int)i);
            }
        }
        if (this.tb_PropertyExtend != null) {
            for (i = 0; i < this.tb_PropertyExtend.getRowCount(); ++i) {
                KDTableHelper.autoFitRowHeight((KDTable)this.tb_PropertyExtend, (int)i);
            }
        }
        this.entityTable.setAutoResize(false);
    }

    public void refreshEntityExtends() {
        List epCollection = this.getExtendCollection(this.entityInfo);
        this.tb_EntityExtend.removeRows();
        this.fillExtendTable(this.tb_EntityExtend, epCollection, (AbstractMDValue)this.entityInfo);
        if (this.tb_EntityExtend.getRowCount() > 0) {
            this.tb_EntityExtend.getSelectManager().select(0, 0);
        }
    }

    public void refreshPropertyExtends() {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.entityTable);
        if (rowIndex != null && rowIndex.length == 1) {
            this.btnAddExtendProperty.setEnabled(!this.isAbstract);
            PropertyInfo pInfo = (PropertyInfo)this.entityTable.getRow(rowIndex[0]).getUserObject();
            List epCollection = this.getExtendCollection(pInfo);
            this.tb_PropertyExtend.removeRows();
            this.fillExtendTable(this.tb_PropertyExtend, epCollection, (AbstractMDValue)pInfo);
            if (this.tb_PropertyExtend.getRowCount() > 0) {
                this.tb_PropertyExtend.getSelectManager().select(0, 0);
            }
        } else {
            this.tb_PropertyExtend.removeRows();
            this.btnAddExtendProperty.setEnabled(false);
            this.btnEditExtendProperty.setEnabled(false);
            this.btnDelExtendProperty.setEnabled(false);
        }
    }

    public void fillExtendTable(KDTable table, List list, AbstractMDValue object) {
        if (table == null || list == null || object == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            ExdPropertyDelegate extend;
            Object obj = list.get(i);
            if (!(obj instanceof ExdPropertyDelegate) || !(extend = (ExdPropertyDelegate)((Object)obj)).isUseAble()) continue;
            String name = extend.getName();
            IRow row = this.fillExtendTable(table, extend);
            if (row == null) continue;
            KDTableHelper.autoFitRowHeight((KDTable)table, (int)row.getRowIndex());
            if (!EntityEditor.isDynamic(object, name)) continue;
            row.getStyleAttributes().setFontColor(Color.BLUE);
            if (row.getRowIndex() == 0) continue;
            table.moveRow(row.getRowIndex(), 0);
        }
        table.setUserObject((Object)object);
    }

    public IRow fillExtendTable(KDTable table, ExdPropertyDelegate delegate) {
        if (table == null || delegate == null) {
            return null;
        }
        IRow row = table.addRow();
        row.getCell("group").setValue((Object)delegate.getGroup());
        row.getCell("name").setValue((Object)delegate.getTempName());
        row.getCell("value").setValue((Object)delegate.getTempExtendProperty().getValue());
        row.getCell("alias").setValue((Object)delegate.getAlias());
        row.getCell("description").setValue((Object)delegate.getDescription());
        row.setUserObject((Object)delegate);
        return row;
    }

    @Override
    public void doSave() throws Exception {
        ICustomizedScheme ics = CustomizedSchemeFactory.getRemoteInstance();
        CustomizedSchemeInfo csInfo = ics.getCustomizedSchemeInfo("where id='" + this.customizedSchemeID + "'");
        if (csInfo != null && csInfo.isStart()) {
            boolean confirm;
            boolean bl = confirm = MsgBox.showConfirm2((Component)((Object)this), (String)"\u5f53\u524d\u52a8\u6001\u6269\u5c55\u65b9\u6848\u5904\u4e8e\u542f\u52a8\u72b6\u6001\uff0c\u662f\u5426\u786e\u8ba4\u53cd\u542f\u7528\u5e76\u4fdd\u5b58\u65b9\u6848?") == 0;
            if (!confirm) {
                SysUtil.abort();
            } else {
                CustomSchemeUtil.disableScheme(this.customizedSchemeID);
                this.ui.actionCancel_actionPerformed(null);
            }
        }
        if (this.isAbstract) {
            UictUtils.saveMetadata((AbstractMetaDataValue)this.entityInfo, this.customizedSchemeID, this.depend);
        } else {
            PropertyCollection col = this.entityInfo.getProperties();
            ArrayList<RelationshipInfo> link = new ArrayList<RelationshipInfo>();
            ArrayList sqlObjs = new ArrayList();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                PropertyInfo pInfo = col.get(i);
                if (!pInfo.isConfigured()) continue;
                if (pInfo instanceof LinkPropertyInfo) {
                    RelationshipInfo relationShipInfo = ((LinkPropertyInfo)pInfo).getRelationship();
                    if (relationShipInfo.validate().getItems(1).length == 0) {
                        link.add(relationShipInfo);
                    } else {
                        MsgBox.showError((Component)((Object)this), (String)"\u5f53\u524d\u5b9e\u4f53\u5bf9\u8c61\u5b57\u6bb5\u68c0\u9a8c\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u4f9d\u8d56\u7684\u65b9\u6848\u662f\u5426\u542f\u7528\u6216\u5173\u7cfb\u5143\u6570\u636e\u662f\u5426\u6b63\u786e");
                        SysUtil.abort();
                    }
                }
                this.addSQL4DynCol(sqlObjs, pInfo.getMappingField());
            }
            DBUpdateInfoSet sqlSet = new DBUpdateInfoSet();
            DBUpdateInfo createTable = this.getSql4CreateTable();
            if (createTable != null) {
                sqlSet.addDBUpdateInfo(createTable);
            }
            sqlSet.addDBUpdateInfo(sqlObjs);
            this.sqlInfo.setSql(sqlSet.toJSONObject().toString());
            AbstractMetaDataValue[] mds = new AbstractMetaDataValue[link.size() + 2];
            mds[0] = this.table;
            mds[1] = this.entityInfo;
            for (int i = 2; i < mds.length; ++i) {
                mds[i] = (AbstractMetaDataValue)link.get(i - 2);
            }
            UictUtils.saveMetadata(mds, this.customizedSchemeID, this.depend);
            if (2 == this.status) {
                IUpdateSql instance = UpdateSqlFactory.getRemoteInstance();
                IObjectPK pk = instance.submit(this.sqlInfo);
                this.sqlInfo.setId(BOSUuid.read((String)pk.toString()));
                this.status = 0;
            } else if (0 == this.status) {
                IUpdateSql instance = UpdateSqlFactory.getRemoteInstance();
                instance.submit(this.sqlInfo);
            }
            this.deleteSomeRelation();
        }
        this.loadData();
        this.base = CloneUtils.clone((EntityObjectInfo)this.entityInfo);
    }

    private void deleteSomeRelation() throws Exception {
        List deleteRelation = this.manager.getShouldDeleteRelation();
        if (deleteRelation == null || deleteRelation.size() == 0) {
            return;
        }
        StringBuffer metaStr = null;
        int size = deleteRelation.size();
        for (int i = 0; i < size; ++i) {
            if (metaStr == null) {
                metaStr = new StringBuffer();
            } else {
                metaStr.append(",");
            }
            metaStr.append("'");
            metaStr.append(deleteRelation.get(i));
            metaStr.append("'");
        }
        String sql = "delete from T_CON_DynamicMetadata where FProjectID = '" + this.depend.getId().toString() + "' and FMetaDataPK in ( " + metaStr + ")";
        CustomizedUnitFactory.getRemoteInstance().delete(sql);
    }

    private DBUpdateInfo getSql4CreateTable() {
        String bcn = this.entityInfo.getExtendedProperty("commonControllerName");
        if (StringUtils.isEmpty((String)bcn)) {
            return null;
        }
        String tableSql = SqlBuilder.buildTableSql(this.table);
        DBUpdateInfo sqlObj = new DBUpdateInfo(10, this.table.getRealName(), this.table.getRealName(), tableSql, 0);
        return sqlObj;
    }

    private void addSQL4DynCol(List sqlObjs, ColumnInfo column) throws Exception {
        if (sqlObjs == null || column == null) {
            return;
        }
        if (!column.isMultilingual()) {
            DBUpdateInfo info = new DBUpdateInfo(11, this.table.getName(), column.getName(), SqlBuilder.buildColumnSql((AbstractTableInfo)this.table, column), 0);
            sqlObjs.add(info);
        } else {
            for (int i = 1; i <= 3; ++i) {
                DBUpdateInfo info = new DBUpdateInfo(11, this.table.getName(), column.getName() + "_l" + i, SqlBuilder.buildColumnSqlInMultiLanguage((AbstractTableInfo)this.table, column, i), 0);
                sqlObjs.add(info);
            }
        }
    }

    protected void alias_CaretUpdate(CaretEvent e) {
        this.entityInfo.setAlias(this.txtAlias.getText());
    }

    protected void desc_CaretUpdate(CaretEvent e) {
        this.entityInfo.setDescription(this.txtDesc.getText());
    }

    @Override
    protected void entityTable_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            this.btnViewProperty_actionPerformed(null);
        }
    }

    @Override
    protected void entityTable_editStopped(KDTEditEvent e) throws Exception {
    }

    @Override
    protected void btnAddProperty_actionPerformed(ActionEvent e) throws Exception {
        boolean success = this.manager.addNew();
        if (success) {
            this.loadProperties();
            this.autoSelect(this.entityTable);
        }
    }

    private PropertyInfo getRowSelected() {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.entityTable);
        if (rowIndex.length > 0) {
            PropertyInfo pInfo = (PropertyInfo)this.entityTable.getRow(rowIndex[0]).getUserObject();
            return pInfo;
        }
        MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u5b57\u6bb5");
        return null;
    }

    @Override
    protected void btnEditProperty_actionPerformed(ActionEvent e) throws Exception {
        boolean success;
        PropertyInfo pInfo = this.getRowSelected();
        if (pInfo != null && (success = this.manager.edit(pInfo, false, false))) {
            this.loadProperties();
            this.autoSelect(this.entityTable);
        }
    }

    @Override
    protected void btnViewProperty_actionPerformed(ActionEvent e) throws Exception {
        PropertyInfo pInfo = this.getRowSelected();
        if (pInfo != null && this.manager != null) {
            this.manager.view(pInfo, false, false);
        }
    }

    @Override
    protected void btnDeleteProperty_actionPerformed(ActionEvent e) throws Exception {
        PropertyInfo pInfo = this.getRowSelected();
        if (pInfo != null) {
            if (!pInfo.isConfigured()) {
                MsgBox.showInfo((String)"\u975e\u52a8\u6001\u5b57\u6bb5\u4e0d\u53ef\u5220\u9664");
                return;
            }
            int confirm = MsgBox.showConfirm2((String)("\u5220\u9664[" + pInfo.getAlias() + "]"));
            if (confirm != 0) {
                return;
            }
            this.manager.delete(pInfo);
            this.loadProperties();
            this.autoSelect(this.entityTable);
        }
    }

    @Override
    protected void btnPropertyExt_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.kDSplitPane1.getClientProperty((Object)"KDLayoutConstraints");
        if (obj != null && obj instanceof KDLayout.Constraints) {
            KDLayout.Constraints rec = (KDLayout.Constraints)obj;
            int originalWidth = rec.originalBounds.width;
            int divider = (int)((double)(this.kDSplitPane1.getWidth() - this.kDSplitPane1.getDividerSize()) * 0.5);
            int divider1 = (int)((double)(originalWidth - this.kDSplitPane1.getDividerSize()) * 0.5);
            int local = this.kDSplitPane1.getDividerLocation();
            if (local == divider || local == divider1) {
                this.kDSplitPane1.setDividerLocation(1.0);
            } else {
                this.kDSplitPane1.setDividerLocation(0.5);
            }
        }
    }

    @Override
    protected void btnTableField_actionPerformed(ActionEvent e) throws Exception {
        PropertyInfo pInfo = this.getRowSelected();
        if (pInfo != null) {
            if (!pInfo.isConfigured()) {
                MsgBox.showInfo((String)"\u975e\u52a8\u6001\u5b57\u6bb5\u4e0d\u80fd\u66f4\u6539\u8868\u5b57\u6bb5");
                return;
            }
            boolean isAlter = this.manager.alterTableField(pInfo);
            if (isAlter) {
                this.loadData();
            }
        }
    }

    @Override
    protected void btnEntityExtendAdd_actionPerformed(ActionEvent e) throws Exception {
        List epCollection = this.getExtendCollection(this.entityInfo);
        UIContext uiContext = new UIContext((Object)this);
        try {
            uiContext.put((Object)"model", (Object)this.entityInfo);
            uiContext.put((Object)"epCollection", (Object)epCollection);
            uiContext.put((Object)"mdtype", (Object)"entity");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ExtendedPropertySelectUI.class.getName(), (Map)uiContext);
            ExtendedPropertySelectUI qfs = (ExtendedPropertySelectUI)uiWindow.getUIObject();
            uiWindow.show();
            if (qfs.isConfirmExit()) {
                int i;
                String name = "";
                String value = "";
                ArrayList _old = new ArrayList();
                ArrayList<String> _new = new ArrayList<String>();
                Iterator iterator = this.entityInfo.getExtendedProperties().keySet().iterator();
                while (iterator.hasNext()) {
                    _old.add(iterator.next());
                }
                this.entityInfo.getExtendedProperties().clear();
                List rightList = qfs.getRightList();
                int size = rightList.size();
                for (i = 0; i < size; ++i) {
                    ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)rightList.get(i));
                    name = delegate.getName();
                    value = delegate.getValue();
                    _new.add(name);
                    if (!_old.contains(name)) {
                        String type = delegate.getType();
                        if ("boolean".equalsIgnoreCase(type)) {
                            value = "true";
                        }
                        this.refreshExtendPropertiesList((AbstractMDValue)this.entityInfo, name, 1);
                    }
                    this.entityInfo.setExtendedProperty(name, value);
                }
                for (i = 0; i < _old.size(); ++i) {
                    name = _old.get(i).toString();
                    if (_new.contains(name)) continue;
                    this.refreshExtendPropertiesList((AbstractMDValue)this.entityInfo, name, -1);
                }
                this.refreshEntityExtends();
            }
        }
        catch (UIException e1) {
            logger.error((Object)e1);
        }
    }

    public static boolean isDynamic(AbstractMDValue object, String name) {
        if (object == null || StringUtils.isEmpty((String)name)) {
            return false;
        }
        String dynProBinds = object.getExtendedProperty("dynExtendPropertyList");
        if (StringUtils.isEmpty((String)dynProBinds)) {
            return false;
        }
        String[] pros = StringUtils.split((String)dynProBinds, (String)"|");
        if (pros != null) {
            for (int i = 0; i < pros.length; ++i) {
                if (!name.equals(pros[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void refreshExtendPropertiesList(AbstractMDValue object, String name, int operate) {
        if (object == null || StringUtils.isEmpty((String)name)) {
            return;
        }
        if (operate == -1) {
            String dynProBinds = object.getExtendedProperty("dynExtendPropertyList");
            if (!StringUtils.isEmpty((String)dynProBinds)) {
                int i;
                boolean exists = false;
                String[] pros = StringUtils.split((String)dynProBinds, (String)"|");
                if (pros != null && pros.length > 0) {
                    for (i = 0; i < pros.length; ++i) {
                        if (!name.equals(pros[i])) continue;
                        pros[i] = null;
                        exists = true;
                    }
                }
                if (exists) {
                    dynProBinds = null;
                    for (i = 0; i < pros.length; ++i) {
                        if (StringUtils.isEmpty((String)pros[i])) continue;
                        dynProBinds = dynProBinds == null ? pros[i] : dynProBinds + "|" + pros[i];
                    }
                    if (!StringUtils.isEmpty((String)dynProBinds)) {
                        object.setExtendedProperty("dynExtendPropertyList", dynProBinds);
                    } else {
                        object.removeExtendedProperty("dynExtendPropertyList");
                    }
                }
            }
        } else if (operate == 1) {
            String dynProBinds = object.getExtendedProperty("dynExtendPropertyList");
            if (StringUtils.isEmpty((String)dynProBinds)) {
                object.setExtendedProperty("dynExtendPropertyList", name);
            } else {
                String[] pros = StringUtils.split((String)dynProBinds, (String)"|");
                boolean exists = false;
                if (pros != null && pros.length > 0) {
                    for (int i = 0; i < pros.length; ++i) {
                        if (!name.equals(pros[i])) continue;
                        exists = true;
                        break;
                    }
                }
                if (!exists) {
                    dynProBinds = dynProBinds + "|" + name;
                    object.setExtendedProperty("dynExtendPropertyList", dynProBinds);
                }
            }
        }
    }

    public List getExtendCollection(EntityObjectInfo object) {
        if (object == null) {
            return null;
        }
        Iterator it = object.getExtendedProperties().keySet().iterator();
        ArrayList<ExdPropertyDelegate> tempList = new ArrayList<ExdPropertyDelegate>();
        while (it.hasNext()) {
            String keyName = (String)it.next();
            if (keyName.indexOf("_") != -1) continue;
            String value = object.getExtendedProperty(keyName);
            ExtendPropertyInfo epInfo = new ExtendPropertyInfo();
            epInfo.setName(keyName);
            epInfo.setValue(value);
            ExdPropertyDelegate tempInfo = new ExdPropertyDelegate();
            tempInfo.setTempExtendProperty(epInfo);
            ExdPropertyDelegate deletage = ReadBosConfigUtil.getExdPropertyByName(keyName, (AbstractMDValue)object);
            String tempName = deletage.getName() == null || deletage.getName().equals("") ? keyName : deletage.getName();
            tempInfo.setTempName(tempName);
            tempInfo.setName(tempName);
            tempInfo.setValue(deletage.getValue());
            tempInfo.setTempValue(deletage.getValue());
            tempInfo.setGroup(deletage.getGroup());
            tempInfo.setAlias(deletage.getAlias());
            tempInfo.setType(deletage.getType());
            tempInfo.setRequired(deletage.getRequired());
            tempInfo.setDescription(deletage.getDescription());
            tempInfo.setUseAble(deletage.isUseAble());
            tempList.add(tempInfo);
        }
        if (tempList.size() > 0) {
            Object[] objs = tempList.toArray();
            GroupComparator comparator = new GroupComparator();
            Arrays.sort(objs, comparator);
            tempList.clear();
            for (int i = 0; i < objs.length; ++i) {
                tempList.add((ExdPropertyDelegate)((Object)objs[i]));
            }
        }
        return tempList;
    }

    public List getExtendCollection(PropertyInfo pInfo) {
        if (pInfo == null) {
            return null;
        }
        Iterator it = pInfo.getExtendedProperties().keySet().iterator();
        ArrayList<ExdPropertyDelegate> tempList = new ArrayList<ExdPropertyDelegate>();
        while (it.hasNext()) {
            String keyName = (String)it.next();
            if (keyName.indexOf("_") != -1) continue;
            String value = pInfo.getExtendedProperty(keyName);
            ExtendPropertyInfo epInfo = new ExtendPropertyInfo();
            epInfo.setName(keyName);
            epInfo.setValue(value);
            ExdPropertyDelegate tempInfo = new ExdPropertyDelegate();
            tempInfo.setTempExtendProperty(epInfo);
            ExdPropertyDelegate deletage = ReadBosConfigUtil.getExdPropertyByName(keyName, (AbstractMDValue)pInfo);
            String tempName = deletage.getName() == null || deletage.getName().equals("") ? keyName : deletage.getName();
            tempInfo.setTempName(tempName);
            tempInfo.setName(tempName);
            tempInfo.setValue(deletage.getValue());
            tempInfo.setTempValue(deletage.getValue());
            tempInfo.setGroup(deletage.getGroup());
            tempInfo.setAlias(deletage.getAlias());
            tempInfo.setType(deletage.getType());
            tempInfo.setRequired(deletage.getRequired());
            tempInfo.setDescription(deletage.getDescription());
            tempInfo.setUseAble(deletage.isUseAble());
            tempList.add(tempInfo);
        }
        if (tempList.size() > 0) {
            Object[] objs = tempList.toArray();
            GroupComparator comparator = new GroupComparator();
            Arrays.sort(objs, comparator);
            tempList.clear();
            for (int i = 0; i < objs.length; ++i) {
                tempList.add((ExdPropertyDelegate)((Object)objs[i]));
            }
        }
        return tempList;
    }

    @Override
    protected void btnEntityExtendEdit_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex;
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tb_EntityExtend);
        if (rows == null || rows.length < 1) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u884c");
            return;
        }
        if (rows.length > 1) {
            MsgBox.showInfo((String)"\u65e0\u6cd5\u7f16\u8f91\u591a\u884c");
        }
        if (!(this.tb_EntityExtend.getRow(rowIndex = rows[0]).getUserObject() instanceof ExdPropertyDelegate)) {
            logger.error((Object)"EntityEditor : Userobject is not a ExdPropertyDelegate !");
            return;
        }
        ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)this.tb_EntityExtend.getRow(rowIndex).getUserObject());
        ExtendPropertyInfo item = delegate.getTempExtendProperty();
        if (item == null) {
            logger.error((Object)"EntityEditor : error when get ExtendPropertyInfo from Delegate !");
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        try {
            uiContext.put((Object)"model", (Object)item);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(QueryFieldExtendPropertyUI.class.getName(), (Map)uiContext);
            QueryFieldExtendPropertyUI qfs = (QueryFieldExtendPropertyUI)uiWindow.getUIObject();
            uiWindow.show();
            if (qfs.isConfirmExit()) {
                this.entityInfo.setExtendedProperty(item.getName(), item.getValue());
                this.refreshEntityExtends();
            }
        }
        catch (UIException e1) {
            logger.error((Object)e1);
        }
    }

    @Override
    protected void btnEntityExtendDel_actionPerformed(ActionEvent e) throws Exception {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tb_EntityExtend);
        if (rows == null || rows.length < 1) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u884c");
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            int rowIndex = rows[i];
            IRow row = this.tb_EntityExtend.getRow(rowIndex);
            if (row == null || row.getUserObject() == null || !(row.getUserObject() instanceof ExdPropertyDelegate)) {
                logger.error((Object)"EntityEditor : Userobject is not a ExdPropertyDelegate !");
                continue;
            }
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
            ExtendPropertyInfo item = delegate.getTempExtendProperty();
            if (item == null) {
                logger.error((Object)"EntityEditor : error when get ExtendPropertyInfo from Delegate !");
                continue;
            }
            if (StringUtils.isEmpty((String)item.getName())) {
                logger.error((Object)"EntityEditor : ExtendPropertyInfo get Name is null !");
                continue;
            }
            String name = item.getName();
            if (!EntityEditor.isDynamic((AbstractMDValue)this.entityInfo, name)) {
                MsgBox.showInfo((String)"\u9759\u6001\u7684\u6269\u5c55\u5c5e\u6027\u4e0d\u5141\u8bb8\u5220\u9664");
                continue;
            }
            this.entityInfo.removeExtendedProperty(item.getName());
        }
        this.refreshEntityExtends();
    }

    @Override
    protected void btnAddExtendProperty_actionPerformed(ActionEvent e) throws Exception {
        PropertyInfo pInfo = this.getRowSelected();
        if (pInfo == null) {
            return;
        }
        List epCollection = this.getExtendCollection(pInfo);
        UIContext uiContext = new UIContext((Object)this);
        try {
            uiContext.put((Object)"model", (Object)pInfo);
            uiContext.put((Object)"epCollection", (Object)epCollection);
            uiContext.put((Object)"mdtype", (Object)"property");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ExtendedPropertySelectUI.class.getName(), (Map)uiContext);
            ExtendedPropertySelectUI qfs = (ExtendedPropertySelectUI)uiWindow.getUIObject();
            uiWindow.show();
            if (qfs.isConfirmExit()) {
                int i;
                String name = "";
                String value = "";
                ArrayList _old = new ArrayList();
                ArrayList<String> _new = new ArrayList<String>();
                Iterator iterator = pInfo.getExtendedProperties().keySet().iterator();
                while (iterator.hasNext()) {
                    _old.add(iterator.next());
                }
                pInfo.getExtendedProperties().clear();
                List rightList = qfs.getRightList();
                int size = rightList.size();
                for (i = 0; i < size; ++i) {
                    ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)rightList.get(i));
                    name = delegate.getName();
                    value = delegate.getValue();
                    _new.add(name);
                    if (!_old.contains(name)) {
                        String type = delegate.getType();
                        if ("boolean".equalsIgnoreCase(type)) {
                            value = "true";
                        }
                        this.refreshExtendPropertiesList((AbstractMDValue)pInfo, name, 1);
                    }
                    pInfo.setExtendedProperty(name, value);
                }
                for (i = 0; i < _old.size(); ++i) {
                    name = _old.get(i).toString();
                    if (_new.contains(name)) continue;
                    this.refreshExtendPropertiesList((AbstractMDValue)pInfo, name, -1);
                }
                this.entityInfo.getProperties().add(pInfo);
                this.refreshPropertyExtends();
            }
        }
        catch (UIException e1) {
            logger.error((Object)e1);
        }
    }

    @Override
    protected void btnEditExtendProperty_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex;
        IRow row;
        int[] rows;
        PropertyInfo pro = this.getRowSelected();
        if (pro == null) {
            MsgBox.showInfo((String)"\u9009\u4e2d\u7684\u5b9e\u4f53\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((rows = KDTableUtil.getSelectedRows((KDTable)this.tb_PropertyExtend)) == null || rows.length < 1) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u884c");
            return;
        }
        if (rows.length > 1) {
            MsgBox.showInfo((String)"\u65e0\u6cd5\u7f16\u8f91\u591a\u884c");
        }
        if ((row = this.tb_PropertyExtend.getRow(rowIndex = rows[0])).getUserObject() == null || !(row.getUserObject() instanceof ExdPropertyDelegate)) {
            logger.error((Object)"EntityEditor : Userobject is not a ExdPropertyDelegate !");
            return;
        }
        ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
        ExtendPropertyInfo item = delegate.getTempExtendProperty();
        if (item == null) {
            logger.error((Object)"EntityEditor : error when get ExtendPropertyInfo from Delegate !");
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        try {
            uiContext.put((Object)"model", (Object)item);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(QueryFieldExtendPropertyUI.class.getName(), (Map)uiContext);
            QueryFieldExtendPropertyUI qfs = (QueryFieldExtendPropertyUI)uiWindow.getUIObject();
            uiWindow.show();
            if (qfs.isConfirmExit()) {
                pro.setExtendedProperty(item.getName(), item.getValue());
                this.entityInfo.getProperties().add(pro);
                this.refreshPropertyExtends();
            }
        }
        catch (UIException e1) {
            logger.error((Object)e1);
        }
    }

    @Override
    protected void btnDelExtendProperty_actionPerformed(ActionEvent e) throws Exception {
        PropertyInfo pInfo = this.getRowSelected();
        if (pInfo == null) {
            return;
        }
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tb_PropertyExtend);
        if (rows == null || rows.length < 1) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u884c");
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            int rowIndex = rows[i];
            IRow row = this.tb_PropertyExtend.getRow(rowIndex);
            if (row.getUserObject() == null || !(row.getUserObject() instanceof ExdPropertyDelegate)) {
                logger.error((Object)"EntityEditor : Userobject is not a ExdPropertyDelegate !");
                continue;
            }
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
            ExtendPropertyInfo item = delegate.getTempExtendProperty();
            if (item == null) {
                logger.error((Object)"EntityEditor : error when get ExtendPropertyInfo from Delegate !");
                continue;
            }
            if (StringUtils.isEmpty((String)item.getName())) {
                logger.error((Object)"EntityEditor : error when get ExtendPropertyInfo from Delegate !");
                continue;
            }
            String name = item.getName();
            if (!EntityEditor.isDynamic((AbstractMDValue)pInfo, name) && !pInfo.isConfigured()) {
                MsgBox.showInfo((String)"\u9759\u6001\u7684\u6269\u5c55\u5c5e\u6027\u4e0d\u5141\u8bb8\u5220\u9664");
                continue;
            }
            pInfo.removeExtendedProperty(name);
            this.entityInfo.getProperties().add(pInfo);
            this.refreshExtendPropertiesList((AbstractMDValue)pInfo, item.getName(), -1);
        }
        this.refreshPropertyExtends();
    }

    @Override
    protected void tb_PropertyExtend_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.btnEditExtendProperty.isEnabled() && e.getClickCount() == 2) {
            this.btnEditExtendProperty_actionPerformed(null);
        }
    }

    @Override
    protected void tb_EntityExtend_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.btnEntityExtendEdit_actionPerformed(null);
        }
    }

    @Override
    protected void entityTable_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.refreshPropertyExtends();
    }

    @Override
    protected void tb_PropertyExtend_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.btnEditExtendProperty.setEnabled(false);
        this.btnDelExtendProperty.setEnabled(false);
        PropertyInfo pInfo = this.getRowSelected();
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tb_PropertyExtend);
        if (this.isAbstract || pInfo == null || rows == null || rows.length < 1) {
            return;
        }
        this.btnEditExtendProperty.setEnabled(true);
        if (!pInfo.isConfigured()) {
            for (int i = 0; i < rows.length; ++i) {
                String name;
                ExdPropertyDelegate delegate;
                ExtendPropertyInfo item;
                int rowIndex = rows[i];
                IRow row = this.tb_PropertyExtend.getRow(rowIndex);
                if (!(row.getUserObject() instanceof ExdPropertyDelegate) || (item = (delegate = (ExdPropertyDelegate)((Object)row.getUserObject())).getTempExtendProperty()) == null || StringUtils.isEmpty((String)item.getName()) || !EntityEditor.isDynamic((AbstractMDValue)pInfo, name = item.getName())) continue;
                this.btnDelExtendProperty.setEnabled(true);
            }
        } else {
            this.btnDelExtendProperty.setEnabled(true);
        }
    }

    @Override
    protected void tb_EntityExtend_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.btnEntityExtendDel.setEnabled(false);
        this.btnEntityExtendEdit.setEnabled(false);
        if (this.entityInfo == null || this.isAbstract) {
            return;
        }
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tb_EntityExtend);
        if (rows == null || rows.length < 1) {
            return;
        }
        this.btnEntityExtendEdit.setEnabled(true);
        if (!this.entityInfo.isDynamic()) {
            for (int i = 0; i < rows.length; ++i) {
                int rowIndex = rows[i];
                IRow row = this.tb_EntityExtend.getRow(rowIndex);
                if (row.getUserObject() == null || !(row.getUserObject() instanceof ExdPropertyDelegate)) {
                    logger.error((Object)"EntityEditor : Userobject is not a ExdPropertyDelegate !");
                    return;
                }
                ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
                ExtendPropertyInfo item = delegate.getTempExtendProperty();
                if (item == null) {
                    logger.error((Object)"EntityEditor : error when get ExtendPropertyInfo from Delegate !");
                    return;
                }
                if (StringUtils.isEmpty((String)item.getName())) {
                    logger.error((Object)"EntityEditor : error when get ExtendPropertyInfo from Delegate !");
                    return;
                }
                String name = item.getName();
                if (!EntityEditor.isDynamic((AbstractMDValue)this.entityInfo, name)) continue;
                this.btnEntityExtendDel.setEnabled(true);
                return;
            }
        } else {
            this.btnEntityExtendDel.setEnabled(true);
        }
    }

    public void handUIException(Exception e) {
        ExceptionHandler.handleError((Component)((Object)this), e, e.getMessage());
    }

    @Override
    public void destory() {
    }

    @Override
    public boolean isDirty() {
        try {
            return this.saver4.diffStore((AbstractMetaDataValue)this.entityInfo, (AbstractMetaDataValue)this.base) != null || this.saver4.diffStore((AbstractMetaDataValue)this.base, (AbstractMetaDataValue)this.entityInfo) != null;
        }
        catch (Exception e) {
            logger.error((Object)"Error,", (Throwable)e);
            return false;
        }
    }

    @Override
    public CustomizedUnitUI getCustomizedUnitUI() {
        return this.ui;
    }

    @Override
    public void setCustomizedUnitUI(CustomizedUnitUI ui) {
        this.ui = ui;
    }

    @Override
    public void setBosObjectType(BOSObjectType type) {
    }

    @Override
    public void setCustomizedSchemeID(String id) {
        this.customizedSchemeID = id;
    }

    @Override
    public void setMetadataPK(String pk) {
    }

    @Override
    public void setDepends(Project depend) {
        this.depend = depend;
    }

    @Override
    public Project getDepends() {
        return this.depend;
    }

    @Override
    public void beforeSave() throws Exception {
    }

    public void setCustomizedSchemeAlias(String customizedSchemeAlias) {
    }
}

