/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.entity;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.ExtendPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.ui.util.UICommonUtils;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.client.editor.entity.AbstractEntityEditorUI;
import com.kingdee.eas.ep.client.editor.query.ui.ExtendedPropertySelectUI;
import com.kingdee.eas.ep.client.editor.query.ui.QueryFieldExtendPropertyUI;
import com.kingdee.eas.ep.client.model.extendproperty.ExdPropertyDelegate;
import com.kingdee.eas.ep.client.model.extendproperty.GroupComparator;
import com.kingdee.eas.ep.client.model.extendproperty.ReadBosConfigUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PropertyExtendPanel
extends KDPanel {
    protected KDTable tb_PropertyExtend;
    protected KDWorkButton btnAddExtendProperty;
    protected KDWorkButton btnEditExtendProperty;
    protected KDWorkButton btnDelExtendProperty;
    protected ResourceBundleHelper resHelper = null;
    protected EntityObjectInfo entity;
    protected PropertyInfo pInfo;
    private static final Logger logger = CoreUIObject.getLogger(PropertyExtendPanel.class);

    public PropertyExtendPanel(EntityObjectInfo entity) {
        this.entity = entity;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.initUIContentLayout();
    }

    private void jbInit() throws Exception {
        this.resHelper = new ResourceBundleHelper(AbstractEntityEditorUI.class.getName());
        this.tb_PropertyExtend = new KDTable();
        this.btnAddExtendProperty = new KDWorkButton();
        this.btnEditExtendProperty = new KDWorkButton();
        this.btnDelExtendProperty = new KDWorkButton();
        this.tb_PropertyExtend.setName("tb_PropertyExtend");
        this.tb_PropertyExtend.setAutoResize(true);
        this.tb_PropertyExtend.getStyleAttributes().setWrapText(true);
        String tb_PropertyExtendStrXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><DocRoot xmlns:c=\"http://www.kingdee.com/Common\" xmlns:f=\"http://www.kingdee.com/Form\" xmlns:t=\"http://www.kingdee.com/Table\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.kingdee.com/KDF KDFSchema.xsd\" version=\"0.0\"><Styles /><Table id=\"KDTable\"><t:Sheet name=\"sheet1\"><t:Table t:selectMode=\"15\" t:mergeMode=\"0\" t:dataRequestMode=\"0\" t:pageRowCount=\"100\"><t:ColumnGroup><t:Column t:key=\"name\" t:width=\"120\" t:mergeable=\"true\" t:resizeable=\"true\" t:moveable=\"true\" t:group=\"false\" t:required=\"false\" t:index=\"-1\" t:configured=\"false\" /><t:Column t:key=\"value\" t:width=\"135\" t:mergeable=\"true\" t:resizeable=\"true\" t:moveable=\"true\" t:group=\"false\" t:required=\"false\" t:index=\"-1\" t:configured=\"false\" /><t:Column t:key=\"alias\" t:width=\"150\" t:mergeable=\"true\" t:resizeable=\"true\" t:moveable=\"true\" t:group=\"false\" t:required=\"false\" t:index=\"-1\" t:configured=\"false\" /><t:Column t:key=\"group\" t:width=\"70\" t:mergeable=\"true\" t:resizeable=\"true\" t:moveable=\"true\" t:group=\"false\" t:required=\"false\" t:index=\"-1\" t:configured=\"false\" /><t:Column t:key=\"description\" t:width=\"320\" t:mergeable=\"true\" t:resizeable=\"true\" t:moveable=\"true\" t:group=\"false\" t:required=\"false\" t:index=\"-1\" t:configured=\"false\" /></t:ColumnGroup><t:Head><t:Row t:name=\"header1\" t:height=\"-1\" t:mergeable=\"true\" t:resizeable=\"true\" t:configured=\"false\"><t:Cell t:configured=\"false\">\u540d\u79f0</t:Cell><t:Cell t:configured=\"false\">\u503c</t:Cell><t:Cell t:configured=\"false\">\u522b\u540d</t:Cell><t:Cell t:configured=\"false\">\u7ec4\u522b</t:Cell><t:Cell t:configured=\"false\">\u63cf\u8ff0</t:Cell></t:Row></t:Head></t:Table><t:SheetOptions><t:MergeBlocks><t:Head /></t:MergeBlocks></t:SheetOptions></t:Sheet></Table></DocRoot>";
        this.tb_PropertyExtend.setFormatXml(this.resHelper.translateString("tb_PropertyExtend", tb_PropertyExtendStrXML));
        this.tb_PropertyExtend.checkParsed();
        this.tb_PropertyExtend.setEditable(false);
        this.tb_PropertyExtend.getSelectManager().setSelectMode(2);
        this.tb_PropertyExtend.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    PropertyExtendPanel.this.tb_PropertyExtend_tableClicked(e);
                }
                catch (Exception exc) {
                    PropertyExtendPanel.this.handUIException(exc);
                }
            }
        });
        this.tb_PropertyExtend.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    PropertyExtendPanel.this.tb_PropertyExtend_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    PropertyExtendPanel.this.handUIException(exc);
                }
            }
        });
        this.btnAddExtendProperty.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddExtendProperty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PropertyExtendPanel.this.btnAddExtendProperty_actionPerformed(e);
                }
                catch (Exception exc) {
                    PropertyExtendPanel.this.handUIException(exc);
                }
            }
        });
        this.btnEditExtendProperty.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnEditExtendProperty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PropertyExtendPanel.this.btnEditExtendProperty_actionPerformed(e);
                }
                catch (Exception exc) {
                    PropertyExtendPanel.this.handUIException(exc);
                }
            }
        });
        this.btnDelExtendProperty.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnDelExtendProperty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PropertyExtendPanel.this.btnDelExtendProperty_actionPerformed(e);
                }
                catch (Exception exc) {
                    PropertyExtendPanel.this.handUIException(exc);
                }
            }
        });
    }

    public void initUIContentLayout() {
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, 1003, 221));
        this.tb_PropertyExtend.setBounds(new Rectangle(0, 21, 1000, 203));
        this.add((Component)this.tb_PropertyExtend, new KDLayout.Constraints(0, 21, 1000, 203, 15));
        this.btnAddExtendProperty.setBounds(new Rectangle(925, 1, 22, 19));
        this.add((Component)this.btnAddExtendProperty, new KDLayout.Constraints(925, 1, 22, 19, 8));
        this.btnEditExtendProperty.setBounds(new Rectangle(950, 1, 22, 19));
        this.add((Component)this.btnEditExtendProperty, new KDLayout.Constraints(950, 1, 22, 19, 8));
        this.btnDelExtendProperty.setBounds(new Rectangle(975, 1, 22, 19));
        this.add((Component)this.btnDelExtendProperty, new KDLayout.Constraints(975, 1, 22, 19, 8));
    }

    protected void tb_PropertyExtend_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.btnEditExtendProperty.isEnabled() && e.getClickCount() == 2) {
            this.btnEditExtendProperty_actionPerformed(null);
        }
    }

    protected void validateTree() {
        super.validateTree();
        if (this.tb_PropertyExtend != null) {
            for (int i = 0; i < this.tb_PropertyExtend.getRowCount(); ++i) {
                KDTableHelper.autoFitRowHeight((KDTable)this.tb_PropertyExtend, (int)i);
            }
        }
    }

    protected void tb_PropertyExtend_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.btnDelExtendProperty.setEnabled(false);
        this.btnEditExtendProperty.setEnabled(false);
        if (this.pInfo == null) {
            return;
        }
        PropertyCollection properties = this.entity.getProperties();
        if (!properties.containsObject((IObjectValue)this.pInfo)) {
            return;
        }
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tb_PropertyExtend);
        if (rows == null || rows.length < 1) {
            return;
        }
        this.btnEditExtendProperty.setEnabled(true);
        if (!this.pInfo.isConfigured()) {
            for (int i = 0; i < rows.length; ++i) {
                int rowIndex = rows[i];
                IRow row = this.tb_PropertyExtend.getRow(rowIndex);
                if (row.getUserObject() == null || !(row.getUserObject() instanceof ExdPropertyDelegate)) {
                    logger.error((Object)"EntityEditor : Userobject is not a ExdPropertyDelegate !");
                    return;
                }
                ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
                ExtendPropertyInfo item = delegate.getTempExtendProperty();
                if (item == null) {
                    logger.error((Object)"EntityEditor : error when get ExtendPropertyInfo from Delegate !");
                    return;
                }
                if (StringUtils.isEmpty((String)item.getName())) {
                    logger.error((Object)"EntityEditor : error when get ExtendPropertyInfo from Delegate !");
                    return;
                }
                String name = item.getName();
                if (!this.isDynamic((AbstractMDValue)this.pInfo, name)) continue;
                this.btnDelExtendProperty.setEnabled(true);
            }
        } else {
            this.btnDelExtendProperty.setEnabled(true);
        }
    }

    protected void btnAddExtendProperty_actionPerformed(ActionEvent e) throws Exception {
        if (this.pInfo == null) {
            return;
        }
        List epCollection = this.getExtendCollection(this.pInfo);
        UIContext uiContext = new UIContext((Object)this);
        try {
            uiContext.put((Object)"model", (Object)this.pInfo);
            uiContext.put((Object)"epCollection", (Object)epCollection);
            uiContext.put((Object)"mdtype", (Object)"property");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ExtendedPropertySelectUI.class.getName(), (Map)uiContext);
            ExtendedPropertySelectUI qfs = (ExtendedPropertySelectUI)uiWindow.getUIObject();
            uiWindow.show();
            if (qfs.isConfirmExit()) {
                int i;
                String name = "";
                String value = "";
                ArrayList _old = new ArrayList();
                ArrayList<String> _new = new ArrayList<String>();
                Iterator iterator = this.pInfo.getExtendedProperties().keySet().iterator();
                while (iterator.hasNext()) {
                    _old.add(iterator.next());
                }
                this.pInfo.getExtendedProperties().clear();
                List rightList = qfs.getRightList();
                int size = rightList.size();
                for (i = 0; i < size; ++i) {
                    ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)rightList.get(i));
                    name = delegate.getName();
                    value = delegate.getValue();
                    _new.add(name);
                    if (!_old.contains(name)) {
                        String type = delegate.getType();
                        if ("boolean".equalsIgnoreCase(type)) {
                            value = "true";
                        }
                        this.refreshExtendPropertiesList((AbstractMDValue)this.pInfo, name, 1);
                    }
                    this.pInfo.setExtendedProperty(name, value);
                }
                for (i = 0; i < _old.size(); ++i) {
                    name = _old.get(i).toString();
                    if (_new.contains(name)) continue;
                    this.refreshExtendPropertiesList((AbstractMDValue)this.pInfo, name, -1);
                }
                this.refreshPropertyExtends();
                this.firePropertyChange("extendproperty", null, value);
            }
        }
        catch (UIException e1) {
            logger.error((Object)e1);
        }
    }

    public void refreshExtendPropertiesList(AbstractMDValue object, String name, int operate) {
        if (object == null || StringUtils.isEmpty((String)name)) {
            return;
        }
        if (operate == -1) {
            String dynProBinds = object.getExtendedProperty("dynExtendPropertyList");
            if (!StringUtils.isEmpty((String)dynProBinds)) {
                int i;
                boolean exists = false;
                String[] pros = StringUtils.split((String)dynProBinds, (String)"|");
                if (pros != null && pros.length > 0) {
                    for (i = 0; i < pros.length; ++i) {
                        if (!name.equals(pros[i])) continue;
                        pros[i] = null;
                        exists = true;
                    }
                }
                if (exists) {
                    dynProBinds = null;
                    for (i = 0; i < pros.length; ++i) {
                        if (StringUtils.isEmpty((String)pros[i])) continue;
                        dynProBinds = dynProBinds == null ? pros[i] : dynProBinds + "|" + pros[i];
                    }
                    if (!StringUtils.isEmpty((String)dynProBinds)) {
                        object.setExtendedProperty("dynExtendPropertyList", dynProBinds);
                    } else {
                        object.removeExtendedProperty("dynExtendPropertyList");
                    }
                }
            }
        } else if (operate == 1) {
            String dynProBinds = object.getExtendedProperty("dynExtendPropertyList");
            if (StringUtils.isEmpty((String)dynProBinds)) {
                object.setExtendedProperty("dynExtendPropertyList", name);
            } else {
                String[] pros = StringUtils.split((String)dynProBinds, (String)"|");
                boolean exists = false;
                if (pros != null && pros.length > 0) {
                    for (int i = 0; i < pros.length; ++i) {
                        if (!name.equals(pros[i])) continue;
                        exists = true;
                        break;
                    }
                }
                if (!exists) {
                    dynProBinds = dynProBinds + "|" + name;
                    object.setExtendedProperty("dynExtendPropertyList", dynProBinds);
                }
            }
        }
    }

    protected void btnEditExtendProperty_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex;
        IRow row;
        int[] rows;
        if (this.pInfo == null) {
            MsgBox.showInfo((String)"\u9009\u4e2d\u7684\u5b9e\u4f53\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((rows = KDTableUtil.getSelectedRows((KDTable)this.tb_PropertyExtend)) == null || rows.length < 1) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u884c");
            return;
        }
        if (rows.length > 1) {
            MsgBox.showInfo((String)"\u65e0\u6cd5\u7f16\u8f91\u591a\u884c");
        }
        if ((row = this.tb_PropertyExtend.getRow(rowIndex = rows[0])).getUserObject() == null || !(row.getUserObject() instanceof ExdPropertyDelegate)) {
            logger.error((Object)"EntityEditor : Userobject is not a ExdPropertyDelegate !");
            return;
        }
        ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
        ExtendPropertyInfo item = delegate.getTempExtendProperty();
        if (item == null) {
            logger.error((Object)"EntityEditor : error when get ExtendPropertyInfo from Delegate !");
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        try {
            uiContext.put((Object)"model", (Object)item);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(QueryFieldExtendPropertyUI.class.getName(), (Map)uiContext);
            QueryFieldExtendPropertyUI qfs = (QueryFieldExtendPropertyUI)uiWindow.getUIObject();
            uiWindow.show();
            if (qfs.isConfirmExit()) {
                String oldvalue = this.pInfo.getExtendedProperty(item.getName());
                this.pInfo.setExtendedProperty(item.getName(), item.getValue());
                this.refreshPropertyExtends();
                this.firePropertyChange("extendproperty", oldvalue, item.getValue());
            }
        }
        catch (UIException e1) {
            logger.error((Object)e1);
        }
    }

    protected void btnDelExtendProperty_actionPerformed(ActionEvent e) throws Exception {
        if (this.pInfo == null) {
            return;
        }
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tb_PropertyExtend);
        if (rows == null || rows.length < 1) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u884c");
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            int rowIndex = rows[i];
            IRow row = this.tb_PropertyExtend.getRow(rowIndex);
            if (row.getUserObject() == null || !(row.getUserObject() instanceof ExdPropertyDelegate)) {
                logger.error((Object)"EntityEditor : Userobject is not a ExdPropertyDelegate !");
                continue;
            }
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
            ExtendPropertyInfo item = delegate.getTempExtendProperty();
            if (item == null) {
                logger.error((Object)"EntityEditor : error when get ExtendPropertyInfo from Delegate !");
                continue;
            }
            if (StringUtils.isEmpty((String)item.getName())) {
                logger.error((Object)"EntityEditor : error when get ExtendPropertyInfo from Delegate !");
                continue;
            }
            String name = item.getName();
            if (!this.isDynamic((AbstractMDValue)this.pInfo, name) && !this.pInfo.isConfigured()) {
                MsgBox.showInfo((String)"\u9759\u6001\u7684\u6269\u5c55\u5c5e\u6027\u4e0d\u5141\u8bb8\u5220\u9664");
                continue;
            }
            String value = this.pInfo.getExtendedProperty(name);
            this.pInfo.removeExtendedProperty(name);
            this.refreshExtendPropertiesList((AbstractMDValue)this.pInfo, item.getName(), -1);
            this.firePropertyChange("extendproperty", value, null);
        }
        this.refreshPropertyExtends();
    }

    public void handUIException(Throwable throwable) {
        UICommonUtils.handleException((Throwable)throwable, (Component)((Object)this));
    }

    public void setProperty(PropertyInfo pInfo) {
        this.pInfo = pInfo;
        this.refreshPropertyExtends();
    }

    public void refreshPropertyExtends() {
        this.btnAddExtendProperty.setEnabled(false);
        this.btnEditExtendProperty.setEnabled(false);
        this.btnDelExtendProperty.setEnabled(false);
        if (this.pInfo == null) {
            this.tb_PropertyExtend.removeRows();
        } else {
            PropertyCollection properties = this.entity.getProperties();
            if (properties.containsObject((IObjectValue)this.pInfo)) {
                this.btnAddExtendProperty.setEnabled(true);
                this.btnEditExtendProperty.setEnabled(true);
                if (this.pInfo.isConfigured()) {
                    this.btnDelExtendProperty.setEnabled(true);
                }
            }
            List epCollection = this.getExtendCollection(this.pInfo);
            this.tb_PropertyExtend.removeRows();
            this.fillExtendTable(this.tb_PropertyExtend, epCollection, (AbstractMDValue)this.pInfo);
            if (this.tb_PropertyExtend.getRowCount() > 0) {
                this.tb_PropertyExtend.getSelectManager().select(0, 0);
            }
        }
    }

    public List getExtendCollection(PropertyInfo pInfo) {
        if (pInfo == null) {
            return null;
        }
        Iterator it = pInfo.getExtendedProperties().keySet().iterator();
        ArrayList<ExdPropertyDelegate> tempList = new ArrayList<ExdPropertyDelegate>();
        while (it.hasNext()) {
            String keyName = (String)it.next();
            if (keyName.indexOf("_") != -1) continue;
            String value = pInfo.getExtendedProperty(keyName);
            ExtendPropertyInfo epInfo = new ExtendPropertyInfo();
            epInfo.setName(keyName);
            epInfo.setValue(value);
            ExdPropertyDelegate tempInfo = new ExdPropertyDelegate();
            tempInfo.setTempExtendProperty(epInfo);
            ExdPropertyDelegate deletage = ReadBosConfigUtil.getExdPropertyByName(keyName, (AbstractMDValue)pInfo);
            String tempName = deletage.getName() == null || deletage.getName().equals("") ? keyName : deletage.getName();
            tempInfo.setTempName(tempName);
            tempInfo.setName(tempName);
            tempInfo.setValue(deletage.getValue());
            tempInfo.setTempValue(deletage.getValue());
            tempInfo.setGroup(deletage.getGroup());
            tempInfo.setAlias(deletage.getAlias());
            tempInfo.setType(deletage.getType());
            tempInfo.setRequired(deletage.getRequired());
            tempInfo.setDescription(deletage.getDescription());
            tempInfo.setUseAble(deletage.isUseAble());
            tempList.add(tempInfo);
        }
        if (tempList.size() > 0) {
            Object[] objs = tempList.toArray();
            GroupComparator comparator = new GroupComparator();
            Arrays.sort(objs, comparator);
            tempList.clear();
            for (int i = 0; i < objs.length; ++i) {
                tempList.add((ExdPropertyDelegate)((Object)objs[i]));
            }
        }
        return tempList;
    }

    public void fillExtendTable(KDTable table, List list, AbstractMDValue object) {
        if (table == null || list == null || object == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            ExdPropertyDelegate extend;
            Object obj = list.get(i);
            if (!(obj instanceof ExdPropertyDelegate) || !(extend = (ExdPropertyDelegate)((Object)obj)).isUseAble()) continue;
            String name = extend.getName();
            IRow row = this.fillExtendTable(table, extend);
            if (row == null) continue;
            KDTableHelper.autoFitRowHeight((KDTable)table, (int)row.getRowIndex());
            if (!this.isDynamic(object, name)) continue;
            row.getStyleAttributes().setFontColor(Color.BLUE);
            if (row.getRowIndex() == 0) continue;
            table.moveRow(row.getRowIndex(), 0);
        }
        table.setUserObject((Object)object);
    }

    public IRow fillExtendTable(KDTable table, ExdPropertyDelegate delegate) {
        if (table == null || delegate == null) {
            return null;
        }
        IRow row = table.addRow();
        row.getCell("group").setValue((Object)delegate.getGroup());
        row.getCell("name").setValue((Object)delegate.getTempName());
        row.getCell("value").setValue((Object)delegate.getTempExtendProperty().getValue());
        row.getCell("alias").setValue((Object)delegate.getAlias());
        row.getCell("description").setValue((Object)delegate.getDescription());
        row.setUserObject((Object)delegate);
        return row;
    }

    public boolean isDynamic(AbstractMDValue object, String name) {
        if (object == null || StringUtils.isEmpty((String)name)) {
            return false;
        }
        String dynProBinds = object.getExtendedProperty("dynExtendPropertyList");
        if (StringUtils.isEmpty((String)dynProBinds)) {
            return false;
        }
        String[] pros = StringUtils.split((String)dynProBinds, (String)"|");
        if (pros != null) {
            for (int i = 0; i < pros.length; ++i) {
                if (!name.equals(pros[i])) continue;
                return true;
            }
        }
        return false;
    }
}

