/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.entity;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.MetaDataOptions;
import com.kingdee.bos.metadata.bizunit.BIMNameFactory;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityToTable;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.BizDataTypeEnum;
import com.kingdee.eas.ep.IUpdateSql;
import com.kingdee.eas.ep.UpdateSqlFactory;
import com.kingdee.eas.ep.client.model.PropertyInfoProxy;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class TableSynchronizer {
    private static final Logger logger = CoreUIObject.getLogger(TableSynchronizer.class);

    private TableSynchronizer() {
    }

    public static DataTableInfo createTable(EntityObjectInfo entity, List list) throws Exception {
        DataTableInfo table = EntityToTable.CreateDataTable((EntityObjectInfo)entity, null);
        table.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        TableSynchronizer.fillContent(entity, table);
        EntityToTable.autoCreateForeignKey((EntityObjectInfo)entity, (DataTableInfo)table, (List)list);
        return table;
    }

    private static void fillContent(EntityObjectInfo entity, DataTableInfo model) {
        String tableName = BIMNameFactory.createTableName((String)entity.getPackage(), (String)entity.getName());
        model.setName(tableName);
    }

    public static ColumnInfo createColumnByBizField(PropertyInfoProxy bf, DataTableInfo tableInfo) throws Exception {
        if (bf == null || tableInfo == null) {
            throw new IllegalArgumentException("PropertyInfoProxy or DataTableInfo cannot be null!");
        }
        ColumnInfo column = new ColumnInfo();
        column.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        if (!"id".equalsIgnoreCase(bf.getName())) {
            column.setNullable(true);
        }
        if (bf.getDataSource() != null && BizDataTypeEnum.OBJECT.equals((Object)bf.getDataType())) {
            String name = TableSynchronizer.generateColumnName(StringUtils.headCharUpperCase((String)bf.getName()) + "ID", tableInfo);
            if (name.length() > 30) {
                name = name.substring(0, 30);
            }
            column.setName(name);
            column.setTypeName(SQLType.VARCHAR);
            column.setLength(44);
            DataTableInfo refTable = bf.getDataSource().getTable();
            if (refTable != null && refTable.getPrimaryKey() != null && refTable.getPrimaryKey().getPKColumns().size() == 1) {
                ForeignKeyInfo fk = new ForeignKeyInfo();
                fk.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
                fk.setName(BIMNameFactory.createTableFKName((String)tableInfo.getPackage(), (String)tableInfo.getName(), (String)refTable.getName(), (String)bf.getName(), (boolean)true));
                fk.setRefTable((AbstractTableInfo)refTable);
                FKColumnPairInfo fkColumnPair = new FKColumnPairInfo();
                fkColumnPair.setPrimaryKeyColumn(refTable.getPrimaryKey().getPKColumns().get(0).getColumn());
                fkColumnPair.setForeignKeyColumn(column);
                fk.getFKColumnPairs().add(fkColumnPair);
                tableInfo.getForeignKeys().add(fk);
            }
        } else {
            String name = TableSynchronizer.generateColumnName(bf, tableInfo);
            column.setName(name);
            if (BizDataTypeEnum.ENUM.equals((Object)bf.getDataType())) {
                BizEnumInfo bizenum = bf.getEnumType();
                TableSynchronizer.updateColumnByEnum(column, bizenum);
            } else {
                column.setTypeName(TableSynchronizer.getColumnType(bf.getDataType()));
                column.setPrecision(bf.getPrecision());
                column.setScale(bf.getScale());
                column.setLength(bf.getLength());
                column.setMultilingual(bf.isMultiLanguage());
            }
        }
        column.setAlias(bf.getAlias() == null ? "" : bf.getAlias());
        column.setDescription(column.getAlias());
        return column;
    }

    public static ColumnInfo createColumnByBizField(LinkPropertyInfo linkprop, DataTableInfo tableInfo, DataTableInfo refTable) throws Exception {
        String name;
        if (tableInfo == null) {
            throw new IllegalArgumentException("DataTableInfo cannot be null!");
        }
        ColumnInfo column = new ColumnInfo();
        column.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        if (!"id".equalsIgnoreCase(linkprop.getName())) {
            column.setNullable(true);
        }
        if ((name = TableSynchronizer.generateColumnName(StringUtils.headCharUpperCase((String)linkprop.getName()) + "ID", tableInfo)).length() > 18) {
            name = name.substring(0, 18);
        }
        column.setName(name);
        column.setTypeName(SQLType.VARCHAR);
        column.setLength(44);
        if (refTable != null && refTable.getPrimaryKey() != null && refTable.getPrimaryKey().getPKColumns().size() == 1) {
            ForeignKeyInfo fk = new ForeignKeyInfo();
            fk.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            fk.setName(BIMNameFactory.createTableFKName((String)tableInfo.getPackage(), (String)tableInfo.getName(), (String)refTable.getName(), (String)linkprop.getName(), (boolean)true));
            fk.setRefTable((AbstractTableInfo)refTable);
            FKColumnPairInfo fkColumnPair = new FKColumnPairInfo();
            fkColumnPair.setPrimaryKeyColumn(refTable.getPrimaryKey().getPKColumns().get(0).getColumn());
            fkColumnPair.setForeignKeyColumn(column);
            fk.getFKColumnPairs().add(fkColumnPair);
            tableInfo.getForeignKeys().add(fk);
        }
        column.setAlias(linkprop.getAlias() == null ? "" : linkprop.getAlias());
        column.setDescription(column.getAlias());
        return column;
    }

    public static String generateColumnName0(PropertyInfoProxy property, DataTableInfo tableInfo) throws BOSException {
        String name = "";
        name = property.getDataSource() != null && BizDataTypeEnum.OBJECT.equals((Object)property.getDataType()) ? TableSynchronizer.generateColumnName(StringUtils.headCharUpperCase((String)property.getName()) + "ID", tableInfo) : TableSynchronizer.generateColumnName(property.getName(), tableInfo);
        if (name.length() > 18) {
            name = name.substring(0, 18);
        }
        return name;
    }

    public static String generateColumnName(PropertyInfoProxy bf, DataTableInfo tableInfo) throws BOSException {
        return TableSynchronizer.generateColumnName(bf.getName(), tableInfo);
    }

    public static String generateColumnName(String name, DataTableInfo tableInfo) throws BOSException {
        ColumnCollection columnCol = tableInfo.getColumns();
        String prefix = MetaDataOptions.isDevelopVersion() ? "F" : "CF";
        name = StringUtils.headCharUpperCase((String)name);
        String tmp = name = prefix + name;
        IUpdateSql instance = UpdateSqlFactory.getRemoteInstance();
        ColumnInfo column = null;
        for (int i = 1; i < Integer.MAX_VALUE && ((column = TableSynchronizer.getColumnByName(columnCol, tmp)) != null || instance.exists(tableInfo.getName(), tmp)); ++i) {
            tmp = name + i;
        }
        return tmp;
    }

    public static ColumnInfo getColumnByName(ColumnCollection columnCol, String name) {
        ColumnInfo column = null;
        int n = columnCol.size();
        for (int i = 0; i < n; ++i) {
            if (!columnCol.get(i).getName().equalsIgnoreCase(name)) continue;
            column = columnCol.get(i);
            break;
        }
        return column;
    }

    public static SQLType getColumnType(BizDataTypeEnum bizType) throws Exception {
        SQLType sqlType = null;
        if (BizDataTypeEnum.STRING.equals((Object)bizType)) {
            sqlType = SQLType.NVARCHAR;
        } else if (BizDataTypeEnum.DATE.equals((Object)bizType)) {
            sqlType = SQLType.DATETIME;
        } else if (BizDataTypeEnum.DECIMAL.equals((Object)bizType)) {
            sqlType = SQLType.NUMERIC;
        } else if (BizDataTypeEnum.INTEGER.equals((Object)bizType)) {
            sqlType = SQLType.INT;
        } else if (BizDataTypeEnum.QUANTITY.equals((Object)bizType)) {
            sqlType = SQLType.NUMERIC;
        } else if (BizDataTypeEnum.AMOUNT.equals((Object)bizType)) {
            sqlType = SQLType.NUMERIC;
        } else if (BizDataTypeEnum.PRICE.equals((Object)bizType)) {
            sqlType = SQLType.NUMERIC;
        } else if (BizDataTypeEnum.NOTE.equals((Object)bizType)) {
            sqlType = SQLType.NVARCHAR;
        } else if (BizDataTypeEnum.BOOLEAN.equals((Object)bizType)) {
            sqlType = SQLType.INT;
        } else if (BizDataTypeEnum.TIME.equals((Object)bizType)) {
            sqlType = SQLType.DATETIME;
        } else if (BizDataTypeEnum.IMAGE.equals((Object)bizType)) {
            sqlType = SQLType.BLOB;
        } else if (BizDataTypeEnum.ENUM.equals((Object)bizType)) {
            sqlType = SQLType.NVARCHAR;
        } else {
            sqlType = SQLType.NVARCHAR;
            Exception ex = new Exception("\u672a\u77e5\u7684\u4e1a\u52a1\u7c7b\u578b\uff1a" + sqlType);
            logger.error((Object)ex, (Throwable)ex);
        }
        return sqlType;
    }

    public static void updateColumnByEnum(ColumnInfo column, BizEnumInfo bizenum) throws Exception {
        BizEnumValueType enumType = bizenum.getDataType();
        SQLType sqlType = null;
        if (BizEnumValueType.STRING.equals((Object)enumType)) {
            sqlType = SQLType.VARCHAR;
            column.setTypeName(sqlType);
            column.setLength(100);
        } else if (BizEnumValueType.INTEGER.equals((Object)enumType)) {
            sqlType = SQLType.INT;
            column.setTypeName(sqlType);
        } else if (BizEnumValueType.DOUBLE.equals((Object)enumType)) {
            sqlType = SQLType.NUMERIC;
            column.setTypeName(sqlType);
        } else if (BizEnumValueType.FLOAT.equals((Object)enumType)) {
            sqlType = SQLType.NUMERIC;
            column.setTypeName(sqlType);
        } else if (BizEnumValueType.LONG.equals((Object)enumType)) {
            sqlType = SQLType.NUMERIC;
            column.setTypeName(sqlType);
        } else {
            throw new Exception("unknow enumType");
        }
    }
}

