/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.enums;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.ui.util.UICommonUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.IEditorTabPanel;
import com.kingdee.eas.ep.client.depend.mutiLan.MutiLanUtil;
import com.kingdee.eas.ep.client.editor.editui.designer.listener.NameListener;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class EnumEditor
extends KDPanel
implements IEditorTabPanel {
    private static final Logger logger = CoreUIObject.getLogger(EnumEditor.class);
    protected ResourceBundleHelper resHelper = null;
    protected KDContainer conBase;
    protected KDContainer conValue;
    protected KDLabel lblTips;
    protected KDLabelContainer conName;
    protected KDLabelContainer conAlias;
    protected KDLabelContainer conDataType;
    protected KDLabelContainer conDesc;
    protected KDTextField txtName;
    protected KDTextField txtAlias;
    protected KDTextArea txtDesc;
    protected KDComboBox txtDataType;
    protected KDLabel lblTips2;
    protected KDTable valueTable;
    protected KDWorkButton btnAdd;
    protected KDWorkButton btnUp;
    protected KDWorkButton btnDown;
    protected KDWorkButton btnDelete;
    private CustomizedUnitUI ui;
    private String customizedSchemeID;
    private Project depend;
    private BizEnumInfo base;
    private BizEnumInfo enumInfo;
    private boolean isDirty;

    public EnumEditor(BizEnumInfo base, BizEnumInfo enumInfo) throws Exception {
        this.base = base;
        this.enumInfo = enumInfo;
        this.init();
        this.initUIContentLayout();
        this.conDataType.setEnabled(false);
        this.loadData();
    }

    private void init() throws Exception {
        this.resHelper = new ResourceBundleHelper(EnumEditor.class.getName());
        this.conBase = new KDContainer();
        this.conValue = new KDContainer();
        this.lblTips = new KDLabel();
        this.conName = new KDLabelContainer();
        this.conAlias = new KDLabelContainer();
        this.conDataType = new KDLabelContainer();
        this.conDesc = new KDLabelContainer();
        this.txtName = new KDTextField();
        this.txtAlias = new KDTextField();
        this.txtDesc = new KDTextArea();
        this.txtDataType = new KDComboBox();
        this.lblTips2 = new KDLabel();
        this.valueTable = new KDTable();
        this.btnAdd = new KDWorkButton();
        this.btnUp = new KDWorkButton();
        this.btnDown = new KDWorkButton();
        this.btnDelete = new KDWorkButton();
        this.conBase.setName("conBase");
        this.conValue.setName("conValue");
        this.lblTips.setName("lblTips");
        this.conName.setName("conName");
        this.conAlias.setName("conAlias");
        this.conDataType.setName("conDataType");
        this.conDesc.setName("conDesc");
        this.txtName.setName("txtName");
        this.txtAlias.setName("txtAlias");
        this.txtDesc.setName("txtDesc");
        this.txtDataType.setName("txtDataType");
        this.lblTips2.setName("lblTips2");
        this.valueTable.setName("valueTable");
        this.btnAdd.setName("btnAdd");
        this.btnUp.setName("btnUp");
        this.btnDown.setName("btnDown");
        this.btnDelete.setName("btnDelete");
        this.conBase.setToolTipText(this.resHelper.getString("conBase.toolTipText"));
        this.conBase.setTitle(this.resHelper.getString("conBase.title"));
        this.conValue.setToolTipText(this.resHelper.getString("conValue.toolTipText"));
        this.conValue.setTitle(this.resHelper.getString("conValue.title"));
        this.lblTips.setText(this.resHelper.getString("lblTips.text"));
        this.conName.setBoundLabelText(this.resHelper.getString("conName.boundLabelText"));
        this.conName.setBoundLabelLength(100);
        this.conAlias.setBoundLabelText(this.resHelper.getString("conAlias.boundLabelText"));
        this.conAlias.setBoundLabelLength(100);
        this.conDataType.setBoundLabelText(this.resHelper.getString("conDataType.boundLabelText"));
        this.conDataType.setBoundLabelLength(100);
        this.conDesc.setBoundLabelText(this.resHelper.getString("conDesc.boundLabelText"));
        this.conDesc.setBoundLabelLength(100);
        this.txtDataType.addItems(EnumUtils.getEnumList((String)"com.kingdee.bos.metadata.resource.BizEnumValueType").toArray());
        this.txtDataType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    EnumEditor.this.txtDataType_itemStateChanged(e);
                }
                catch (Exception exc) {
                    EnumEditor.this.handUIException(exc);
                }
            }
        });
        this.txtAlias.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                EnumEditor.this.setDirty(true);
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.txtName.addKeyListener((KeyListener)new NameListener());
        this.txtDesc.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                EnumEditor.this.setDirty(true);
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.lblTips2.setText(this.resHelper.getString("lblTips2.text"));
        this.valueTable.setFormatXml(this.resHelper.getString("valueTable.formatXml"));
        this.valueTable.checkParsed(true);
        this.valueTable.setEditable(true);
        this.valueTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    EnumEditor.this.valueTable_editStopped(e);
                }
                catch (Exception exc) {
                    EnumEditor.this.handUIException(exc);
                }
            }
        });
        this.btnAdd.setText(this.resHelper.getString("btnAdd.text"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EnumEditor.this.btnAdd_actionPerformed(e);
                }
                catch (Exception exc) {
                    EnumEditor.this.handUIException(exc);
                }
            }
        });
        this.btnUp.setText(this.resHelper.getString("btnUp.text"));
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EnumEditor.this.btnUp_actionPerformed(e);
                }
                catch (Exception exc) {
                    EnumEditor.this.handUIException(exc);
                }
            }
        });
        this.btnDown.setText(this.resHelper.getString("btnDown.text"));
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EnumEditor.this.btnDown_actionPerformed(e);
                }
                catch (Exception exc) {
                    EnumEditor.this.handUIException(exc);
                }
            }
        });
        this.btnDelete.setText(this.resHelper.getString("btnDelete.text"));
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EnumEditor.this.btnDelete_actionPerformed(e);
                }
                catch (Exception exc) {
                    EnumEditor.this.handUIException(exc);
                }
            }
        });
        KDTextField textEditor = new KDTextField();
        textEditor.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                JTextField textField;
                if (Character.getNumericValue(e.getKeyChar()) == -1 && e.getKeyChar() != '\b') {
                    e.consume();
                }
                if ((textField = (JTextField)e.getSource()).getCaretPosition() == 0 && Character.isDigit(e.getKeyChar())) {
                    e.consume();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        KDTextField valueEditor = new KDTextField();
        valueEditor.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (Character.getNumericValue(e.getKeyChar()) == -1 && e.getKeyChar() != '\b') {
                    e.consume();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.valueTable.getColumn("nameColumn").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textEditor));
        this.valueTable.getColumn("valueColumn").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)valueEditor));
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 1016, 600));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 1016, 600));
        this.conBase.setBounds(new Rectangle(5, 5, 1006, 204));
        this.add((Component)this.conBase, new KDLayout.Constraints(5, 5, 1006, 204, 13));
        this.conValue.setBounds(new Rectangle(5, 218, 1005, 375));
        this.add((Component)this.conValue, new KDLayout.Constraints(5, 218, 1005, 375, 15));
        this.conBase.getContentPane().setLayout((LayoutManager)new KDLayout());
        this.conBase.getContentPane().putClientProperty("OriginalBounds", new Rectangle(5, 5, 1006, 204));
        this.lblTips.setBounds(new Rectangle(5, 5, 991, 19));
        this.conBase.getContentPane().add((Component)this.lblTips, new KDLayout.Constraints(5, 5, 991, 19, 12));
        this.conName.setBounds(new Rectangle(5, 30, 991, 19));
        this.conBase.getContentPane().add((Component)this.conName, new KDLayout.Constraints(5, 30, 991, 19, 12));
        this.conAlias.setBounds(new Rectangle(5, 55, 991, 19));
        this.conBase.getContentPane().add((Component)this.conAlias, new KDLayout.Constraints(5, 55, 991, 19, 12));
        this.conDataType.setBounds(new Rectangle(5, 80, 991, 19));
        this.conBase.getContentPane().add((Component)this.conDataType, new KDLayout.Constraints(5, 80, 991, 19, 12));
        this.conDesc.setBounds(new Rectangle(5, 105, 991, 67));
        this.conBase.getContentPane().add((Component)this.conDesc, new KDLayout.Constraints(5, 105, 991, 67, 12));
        this.conName.setBoundEditor((JComponent)this.txtName);
        this.conAlias.setBoundEditor((JComponent)this.txtAlias);
        this.conDataType.setBoundEditor((JComponent)this.txtDataType);
        this.conDesc.setBoundEditor((JComponent)this.txtDesc);
        this.conValue.getContentPane().setLayout((LayoutManager)new KDLayout());
        this.conValue.getContentPane().putClientProperty("OriginalBounds", new Rectangle(5, 218, 1005, 375));
        this.lblTips2.setBounds(new Rectangle(5, 5, 984, 19));
        this.conValue.getContentPane().add((Component)this.lblTips2, new KDLayout.Constraints(5, 5, 984, 19, 13));
        this.valueTable.setBounds(new Rectangle(6, 26, 905, 348));
        this.conValue.getContentPane().add((Component)this.valueTable, new KDLayout.Constraints(6, 26, 905, 348, 15));
        this.btnAdd.setBounds(new Rectangle(920, 26, 70, 19));
        this.conValue.getContentPane().add((Component)this.btnAdd, new KDLayout.Constraints(920, 26, 70, 19, 9));
        this.btnUp.setBounds(new Rectangle(920, 74, 70, 19));
        this.conValue.getContentPane().add((Component)this.btnUp, new KDLayout.Constraints(920, 74, 70, 19, 9));
        this.btnDown.setBounds(new Rectangle(920, 98, 70, 19));
        this.conValue.getContentPane().add((Component)this.btnDown, new KDLayout.Constraints(920, 98, 70, 19, 9));
        this.btnDelete.setBounds(new Rectangle(920, 50, 70, 19));
        this.conValue.getContentPane().add((Component)this.btnDelete, new KDLayout.Constraints(920, 50, 70, 19, 9));
    }

    public void setEnumInfo(BizEnumInfo enumInfo) {
        this.enumInfo = enumInfo;
    }

    public BizEnumInfo getEnumInfo() {
        return this.enumInfo;
    }

    @Override
    public void doSave() throws Exception {
        int i;
        if (this.enumInfo == null) {
            return;
        }
        Locale locale = BOSLocaleUtil.getLocale((Context)ContextManager.getContext());
        MutiLanUtil.setAlias(this.enumInfo, this.txtAlias.getText());
        this.enumInfo.setDescription(this.txtDesc.getText());
        this.enumInfo.setDataType(BizEnumValueType.getEnum((String)this.txtDataType.getSelectedItem().toString()));
        int size = this.valueTable.getRowCount();
        HashSet<String> nameSet = new HashSet<String>();
        for (int i2 = 0; i2 < size; ++i2) {
            IRow row = this.valueTable.getRow(i2);
            if (row.getCell("nameColumn").getValue() == null || StringUtils.isEmpty((String)row.getCell("nameColumn").getValue().toString())) {
                ExceptionHandler.handleError((Component)((Object)this), null, "\u5b58\u5728[\u540d\u79f0]\u4e3a\u7a7a\u7684\u679a\u4e3e\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\uff01");
                SysUtil.abort();
            }
            if (row.getCell("valueColumn").getValue() == null || StringUtils.isEmpty((String)row.getCell("valueColumn").getValue().toString())) {
                ExceptionHandler.handleError((Component)((Object)this), null, "\u5b58\u5728[\u503c]\u4e3a\u7a7a\u7684\u679a\u4e3e\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\uff01");
                SysUtil.abort();
            }
            if (row.getCell("aliasColumn").getValue() == null || StringUtils.isEmpty((String)row.getCell("aliasColumn").getValue().toString())) {
                ExceptionHandler.handleError((Component)((Object)this), null, "\u5b58\u5728[\u522b\u540d]\u4e3a\u7a7a\u7684\u679a\u4e3e\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\uff01");
                SysUtil.abort();
            }
            nameSet.add(row.getCell("nameColumn").getValue().toString().toLowerCase().trim());
        }
        if (size != nameSet.size()) {
            ExceptionHandler.handleError((Component)((Object)this), null, "\u5b58\u5728[\u540d\u79f0]\u4e3a\u76f8\u540c\u7684\u679a\u4e3e\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\uff01");
            SysUtil.abort();
        }
        ArrayList<BizEnumValueInfo> newItem = new ArrayList<BizEnumValueInfo>(size);
        for (i = 0; i < size; ++i) {
            IRow row = this.valueTable.getRow(i);
            try {
                BizEnumValueInfo item = new BizEnumValueInfo();
                String value = row.getCell("valueColumn").getValue().toString();
                if (BizEnumValueType.DOUBLE.toString().equals(this.txtDataType.getSelectedItem().toString())) {
                    double d = Double.parseDouble(value);
                    item.setDouble(d);
                } else if (BizEnumValueType.FLOAT.toString().equals(this.txtDataType.getSelectedItem().toString())) {
                    float f = Float.parseFloat(value);
                    item.setFloat(f);
                } else if (BizEnumValueType.INTEGER.toString().equals(this.txtDataType.getSelectedItem().toString())) {
                    int in = Integer.parseInt(value);
                    item.setInt(in);
                } else if (BizEnumValueType.LONG.toString().equals(this.txtDataType.getSelectedItem().toString())) {
                    long l = Long.parseLong(value);
                    item.setLong(l);
                } else if (BizEnumValueType.STRING.toString().equals(this.txtDataType.getSelectedItem().toString())) {
                    item.setString(value);
                }
                String name = row.getCell("nameColumn").getValue().toString().trim();
                String alias = row.getCell("aliasColumn").getValue().toString().trim();
                item.setName(name);
                item.put("name", (Object)name, locale);
                item.setAlias(alias);
                item.put("alias", (Object)alias, locale);
                newItem.add(item);
                continue;
            }
            catch (Exception e) {
                ExceptionHandler.handleError((Component)((Object)this), null, "\u5b58\u5728[\u503c]\u4e0e\u679a\u4e3e\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\uff01");
                SysUtil.abort();
            }
        }
        this.enumInfo.getEnumValue().clear();
        int size2 = newItem.size();
        for (i = 0; i < size2; ++i) {
            this.enumInfo.getEnumValue().add((BizEnumValueInfo)newItem.get(i));
        }
        UictUtils.saveMetadata((AbstractMetaDataValue)this.enumInfo, this.customizedSchemeID, this.depend);
        this.base = (BizEnumInfo)this.enumInfo.clone();
        this.setDirty(false);
    }

    @Override
    public void loadData() {
        this.valueTable.removeRows();
        if (this.enumInfo == null) {
            return;
        }
        this.txtName.setText(this.enumInfo.getName());
        this.txtAlias.setText(this.enumInfo.getAlias());
        this.txtDesc.setText(this.enumInfo.getDescription());
        this.txtDataType.setSelectedItem((Object)this.enumInfo.getDataType());
        BizEnumValueCollection enumCol = this.enumInfo.getEnumValue();
        int size = enumCol.size();
        for (int i = 0; i < size; ++i) {
            BizEnumValueInfo info = enumCol.get(i);
            IRow row = this.valueTable.addRow();
            row.setUserObject((Object)info);
            row.getCell("nameColumn").setValue((Object)info.getName());
            row.getCell("aliasColumn").setValue((Object)info.getAlias());
            row.getCell("valueColumn").setValue(info.getValue());
        }
        this.setDirty(false);
    }

    protected void txtDataType_itemStateChanged(ItemEvent e) throws Exception {
        this.setDirty(true);
    }

    protected void valueTable_editStopped(KDTEditEvent e) throws Exception {
        this.setDirty(true);
    }

    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        this.setDirty(true);
        this.valueTable.addRow();
    }

    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        this.setDirty(true);
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.valueTable);
        if (rowIndex.length > 0 && rowIndex[0] > 0) {
            this.valueTable.moveRow(rowIndex[0], rowIndex[0] - 1);
            KDTableUtil.setSelectedRow((KDTable)this.valueTable, (int)(rowIndex[0] - 1));
        }
    }

    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        this.setDirty(true);
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.valueTable);
        if (rowIndex.length > 0 && rowIndex[0] < this.valueTable.getRowCount() - 1) {
            this.valueTable.moveRow(rowIndex[0], rowIndex[0] + 1);
            KDTableUtil.setSelectedRow((KDTable)this.valueTable, (int)(rowIndex[0] + 1));
        }
    }

    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        this.setDirty(true);
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.valueTable);
        if (rowIndex.length > 0) {
            this.valueTable.removeRow(rowIndex[0]);
        }
    }

    public void handUIException(Throwable throwable) {
        UICommonUtils.handleException((Throwable)throwable, (Component)((Object)this));
    }

    @Override
    public void destory() {
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    @Override
    public CustomizedUnitUI getCustomizedUnitUI() {
        return this.ui;
    }

    @Override
    public void setCustomizedUnitUI(CustomizedUnitUI ui) {
        this.ui = ui;
    }

    @Override
    public void setBosObjectType(BOSObjectType type) {
    }

    @Override
    public void setCustomizedSchemeID(String id) {
        this.customizedSchemeID = id;
    }

    @Override
    public void setMetadataPK(String pk) {
    }

    @Override
    public void setDepends(Project depend) {
        this.depend = depend;
    }

    @Override
    public void beforeSave() throws Exception {
    }

    @Override
    public Project getDepends() {
        return this.depend;
    }
}

