/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.exception;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ep.ExceptionFactory;
import com.kingdee.eas.ep.ExceptionInfo;
import com.kingdee.eas.ep.IException;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.IEditorTabPanel;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ExceptionEditor
extends KDPanel
implements IEditorTabPanel {
    private static final Logger logger = CoreUIObject.getLogger(ExceptionEditor.class);
    protected ResourceBundleHelper resHelper = null;
    protected KDContainer conBase;
    protected KDLabel lblTips;
    protected KDLabelContainer conName;
    protected KDTextField txtName;
    protected KDTable valueTable;
    protected KDWorkButton btnAdd;
    protected KDWorkButton btnDelete;
    protected KDContainer conValue;
    protected KDLabelContainer lblMainCode;
    protected KDTextField txtMainCode;
    private String name;
    private CustomizedUnitUI ui;
    private String customizedSchemeID;
    private Project depend;
    private boolean isDirty;
    private IException instance;
    private List list = new ArrayList();

    public ExceptionEditor(String name, String customizedSchemeID) throws Exception {
        this.name = name;
        this.customizedSchemeID = customizedSchemeID;
        this.init();
        this.initUIContentLayout();
        this.instance = ExceptionFactory.getRemoteInstance();
        CoreBaseCollection col = this.instance.getCollection("where name='" + name + "' and project='" + customizedSchemeID + "'");
        if (col != null) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                this.list.add((ExceptionInfo)col.get(i));
            }
        }
        this.loadData();
    }

    private void init() throws Exception {
        this.resHelper = new ResourceBundleHelper(ExceptionEditor.class.getName());
        this.conBase = new KDContainer();
        this.lblTips = new KDLabel();
        this.conName = new KDLabelContainer();
        this.txtName = new KDTextField();
        this.valueTable = new KDTable();
        this.btnAdd = new KDWorkButton();
        this.btnDelete = new KDWorkButton();
        this.conValue = new KDContainer();
        this.lblMainCode = new KDLabelContainer();
        this.txtMainCode = new KDTextField();
        this.conBase.setName("conBase");
        this.lblTips.setName("lblTips");
        this.conName.setName("conName");
        this.txtName.setName("txtName");
        this.valueTable.setName("valueTable");
        this.btnAdd.setName("btnAdd");
        this.btnDelete.setName("btnDelete");
        this.conValue.setName("conValue");
        this.lblMainCode.setName("lblMainCode");
        this.txtMainCode.setName("txtMainCode");
        this.conBase.setToolTipText(this.resHelper.getString("conBase.toolTipText"));
        this.conBase.setTitle(this.resHelper.getString("conBase.title"));
        this.lblTips.setText(this.resHelper.getString("lblTips.text"));
        this.conName.setBoundLabelText(this.resHelper.getString("conName.boundLabelText"));
        this.conName.setBoundLabelLength(100);
        this.txtName.setEditable(false);
        this.valueTable.setFormatXml(this.resHelper.getString("valueTable.formatXml"));
        this.valueTable.checkParsed(true);
        this.valueTable.setEditable(true);
        this.valueTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    ExceptionEditor.this.valueTable_editStopped(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.btnAdd.setText(this.resHelper.getString("btnAdd.text"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExceptionEditor.this.btnAdd_actionPerformed(e);
                }
                catch (Exception exception) {
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        });
        this.btnDelete.setText(this.resHelper.getString("btnDelete.text"));
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExceptionEditor.this.btnDelete_actionPerformed(e);
                }
                catch (Exception exception) {
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        });
        this.conValue.setToolTipText(this.resHelper.getString("conValue.toolTipText"));
        this.conValue.setTitle(this.resHelper.getString("conValue.title"));
        this.lblMainCode.setBoundLabelText(this.resHelper.getString("lblMainCode.boundLabelText"));
        this.lblMainCode.setBoundLabelLength(100);
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 1016, 600));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 1016, 600));
        this.conBase.setBounds(new Rectangle(5, 5, 1006, 106));
        this.add((Component)this.conBase, new KDLayout.Constraints(5, 5, 1006, 106, 13));
        this.conValue.setBounds(new Rectangle(5, 127, 1005, 466));
        this.add((Component)this.conValue, new KDLayout.Constraints(5, 127, 1005, 466, 15));
        this.conBase.getContentPane().setLayout((LayoutManager)new KDLayout());
        this.conBase.getContentPane().putClientProperty("OriginalBounds", new Rectangle(5, 5, 1006, 106));
        this.lblTips.setBounds(new Rectangle(5, 5, 991, 19));
        this.conBase.getContentPane().add((Component)this.lblTips, new KDLayout.Constraints(5, 5, 991, 19, 12));
        this.conName.setBounds(new Rectangle(5, 30, 991, 19));
        this.conBase.getContentPane().add((Component)this.conName, new KDLayout.Constraints(5, 30, 991, 19, 0));
        this.lblMainCode.setBounds(new Rectangle(5, 54, 991, 19));
        this.conBase.getContentPane().add((Component)this.lblMainCode, new KDLayout.Constraints(5, 54, 991, 19, 0));
        this.conName.setBoundEditor((JComponent)this.txtName);
        this.lblMainCode.setBoundEditor((JComponent)this.txtMainCode);
        this.conValue.getContentPane().setLayout((LayoutManager)new KDLayout());
        this.conValue.getContentPane().putClientProperty("OriginalBounds", new Rectangle(5, 127, 1005, 466));
        this.valueTable.setBounds(new Rectangle(6, 9, 905, 441));
        this.conValue.getContentPane().add((Component)this.valueTable, new KDLayout.Constraints(6, 9, 905, 441, 15));
        this.btnAdd.setBounds(new Rectangle(920, 26, 70, 19));
        this.conValue.getContentPane().add((Component)this.btnAdd, new KDLayout.Constraints(920, 26, 70, 19, 9));
        this.btnDelete.setBounds(new Rectangle(920, 50, 70, 19));
        this.conValue.getContentPane().add((Component)this.btnDelete, new KDLayout.Constraints(920, 50, 70, 19, 9));
    }

    protected void valueTable_editStopped(KDTEditEvent e) throws Exception {
        this.setDirty(true);
    }

    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        this.setDirty(true);
        this.valueTable.addRow();
    }

    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        this.setDirty(true);
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.valueTable);
        if (rowIndex.length > 0) {
            this.valueTable.removeRow(rowIndex[0]);
        }
    }

    @Override
    public void loadData() throws Exception {
        this.valueTable.removeRows();
        this.txtName.setText(this.name);
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            ExceptionInfo info = (ExceptionInfo)this.list.get(i);
            IRow row = this.valueTable.addRow();
            row.setUserObject((Object)info);
            row.getCell("nameColumn").setValue((Object)info.getSubName());
            row.getCell("codeColumn").setValue((Object)new Integer(info.getSubCode()));
            row.getCell("infoColumn").setValue((Object)info.getInfo());
            if (!StringUtils.isEmpty((String)this.txtMainCode.getText())) continue;
            this.txtMainCode.setText(String.valueOf(info.getMainCode()));
        }
    }

    @Override
    public void doSave() throws Exception {
        ExceptionInfo info;
        IRow row;
        int i;
        if (StringUtils.isEmpty((String)this.txtMainCode.getText())) {
            ExceptionHandler.handleError((Component)((Object)this), null, "\u4e3b\u5f02\u5e38\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\uff01");
            SysUtil.abort();
        }
        try {
            new Integer(this.txtMainCode.getText());
        }
        catch (Exception ex) {
            ExceptionHandler.handleError((Component)((Object)this), null, "\u4e3b\u5f02\u5e38\u53f7\u4e0d\u80fd\u4e3a\u975e\u6570\u5b57\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\uff01");
            SysUtil.abort();
        }
        int size = this.valueTable.getRowCount();
        HashSet<String> nameSet = new HashSet<String>();
        HashSet<String> codeSet = new HashSet<String>();
        for (i = 0; i < size; ++i) {
            row = this.valueTable.getRow(i);
            if (row.getCell("nameColumn").getValue() == null || StringUtils.isEmpty((String)row.getCell("nameColumn").getValue().toString())) {
                ExceptionHandler.handleError((Component)((Object)this), null, "\u5b58\u5728[\u5b50\u5f02\u5e38\u540d\u79f0]\u4e3a\u7a7a\u7684\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\uff01");
                SysUtil.abort();
            }
            if (!this.isValidName(row.getCell("nameColumn").getValue().toString().trim())) {
                ExceptionHandler.handleError((Component)((Object)this), null, "\u5b58\u5728[\u5b50\u5f02\u5e38\u540d\u79f0]\u4e3a\u975e\u82f1\u6587\u5b57\u7b26\u7684\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\uff01");
                SysUtil.abort();
            }
            if (row.getCell("codeColumn").getValue() == null || StringUtils.isEmpty((String)row.getCell("codeColumn").getValue().toString())) {
                ExceptionHandler.handleError((Component)((Object)this), null, "\u5b58\u5728[\u5b50\u5f02\u5e38\u53f7]\u4e3a\u7a7a\u7684\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\uff01");
                SysUtil.abort();
            }
            if (row.getCell("infoColumn").getValue() == null || StringUtils.isEmpty((String)row.getCell("infoColumn").getValue().toString())) {
                ExceptionHandler.handleError((Component)((Object)this), null, "\u5b58\u5728[\u5f02\u5e38\u4fe1\u606f]\u4e3a\u7a7a\u7684\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\uff01");
                SysUtil.abort();
            }
            try {
                new Integer(row.getCell("codeColumn").getValue().toString());
            }
            catch (Exception ex) {
                ExceptionHandler.handleError((Component)((Object)this), null, "\u5b58\u5728[\u5b50\u5f02\u5e38\u53f7]\u4e3a\u975e\u6570\u5b57\u7684\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\uff01");
                SysUtil.abort();
            }
            nameSet.add(row.getCell("nameColumn").getValue().toString().toLowerCase().trim());
            codeSet.add(row.getCell("codeColumn").getValue().toString().toLowerCase().trim());
        }
        if (size != nameSet.size()) {
            ExceptionHandler.handleError((Component)((Object)this), null, "\u5b58\u5728[\u5b50\u5f02\u5e38\u540d\u79f0]\u76f8\u540c\u7684\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\uff01");
            SysUtil.abort();
        }
        if (size != codeSet.size()) {
            ExceptionHandler.handleError((Component)((Object)this), null, "\u5b58\u5728[\u5b50\u5f02\u5e38\u53f7]\u76f8\u540c\u7684\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fdd\u5b58\uff01");
            SysUtil.abort();
        }
        this.list.clear();
        for (i = 0; i < size; ++i) {
            row = this.valueTable.getRow(i);
            info = new ExceptionInfo();
            BOSUuid id = BOSUuid.create((BOSObjectType)info.getBOSType());
            info.setId(id);
            info.setName(this.name);
            info.setMainCode(new Integer(this.txtMainCode.getText()));
            info.setSubName(row.getCell("nameColumn").getValue().toString().trim());
            info.setSubCode(new Integer(row.getCell("codeColumn").getValue().toString()));
            info.setInfo(row.getCell("infoColumn").getValue().toString().trim());
            info.setProject(this.customizedSchemeID);
            this.list.add(info);
        }
        this.instance.delete("where name='" + this.name + "' and project='" + this.customizedSchemeID + "'");
        size = this.list.size();
        CoreBaseCollection col = new CoreBaseCollection();
        for (int i2 = 0; i2 < size; ++i2) {
            info = (ExceptionInfo)this.list.get(i2);
            col.add((CoreBaseInfo)info);
        }
        this.instance.addnew(col);
        this.isDirty = false;
    }

    private boolean isValidName(String name) {
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] >= 'A' && (chars[i] == '_' || chars[i] <= 'Z' || chars[i] >= 'a') && chars[i] <= 'z') continue;
            return false;
        }
        return true;
    }

    @Override
    public void destory() {
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    @Override
    public CustomizedUnitUI getCustomizedUnitUI() {
        return this.ui;
    }

    @Override
    public void setCustomizedUnitUI(CustomizedUnitUI ui) {
        this.ui = ui;
    }

    @Override
    public void setBosObjectType(BOSObjectType type) {
    }

    @Override
    public void setCustomizedSchemeID(String id) {
        this.customizedSchemeID = id;
    }

    @Override
    public void setMetadataPK(String pk) {
    }

    @Override
    public void setDepends(Project depend) {
        this.depend = depend;
    }

    @Override
    public void beforeSave() throws Exception {
    }

    @Override
    public Project getDepends() {
        return this.depend;
    }
}

