/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.kdtable;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.kdtable.AbstractKDTableDesigner4SimpleConfigUI;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class KDTableDesigner4SimpleConfigUI
extends AbstractKDTableDesigner4SimpleConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(KDTableDesigner4SimpleConfigUI.class);
    public static final String KDTABLE = "kdtable";
    protected String EXIT_STATUS = null;
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";
    private TableInfo kdTable;

    public void onLoad() throws Exception {
        super.onLoad();
        Object object = this.getUIContext().get(KDTABLE);
        if (!(object instanceof TableInfo)) {
            throw new IllegalArgumentException("can not get the TableInfo from uicontext!");
        }
        this.kdTable = (TableInfo)object;
        this.tableList.checkParsed(true);
        this.tableList.getColumn(1).getStyleAttributes().setHided(true);
        this.loadData();
    }

    public void loadData() {
        this.tableList.removeRows();
        if (this.kdTable == null) {
            return;
        }
        List columns = this.kdTable.getColumns();
        for (ColumnInfo columnInfo : columns) {
            IRow row = this.tableList.addRow();
            row.setUserObject((Object)columnInfo);
            row.getCell(0).setValue((Object)columnInfo.getName());
        }
    }

    public void refreshFormatXml() {
        int size = this.tableList.getRowCount();
        ArrayList<String> names = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            ColumnInfo columnInfo = (ColumnInfo)this.tableList.getRow(i).getUserObject();
            names.add(columnInfo.getName());
        }
        EditUIEditorHelper.reOrderTableFormatXml(this.kdTable, names);
    }

    public TableInfo getTableInfo() {
        return this.kdTable;
    }

    @Override
    protected void tableList_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    protected void tableList_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    protected void tableList_editStopped(KDTEditEvent e) throws Exception {
    }

    @Override
    protected void butUP_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tableList);
        if (rowIndex.length > 0 && rowIndex[0] > 0) {
            this.tableList.moveRow(rowIndex[0], rowIndex[0] - 1);
            KDTableUtil.setSelectedRow((KDTable)this.tableList, (int)(rowIndex[0] - 1));
            this.refreshFormatXml();
        }
    }

    @Override
    protected void butDown_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tableList);
        if (rowIndex.length > 0 && rowIndex[0] < this.tableList.getRowCount() - 1) {
            this.tableList.moveRow(rowIndex[0], rowIndex[0] + 1);
            KDTableUtil.setSelectedRow((KDTable)this.tableList, (int)(rowIndex[0] + 1));
            this.refreshFormatXml();
        }
    }

    @Override
    protected void butTop_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tableList);
        if (rowIndex.length > 0 && rowIndex[0] > 0) {
            this.tableList.moveRow(rowIndex[0], 0);
            KDTableUtil.setSelectedRow((KDTable)this.tableList, (int)0);
            this.refreshFormatXml();
        }
    }

    @Override
    protected void butBottom_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tableList);
        if (rowIndex.length > 0 && rowIndex[0] < this.tableList.getRowCount() - 1) {
            this.tableList.moveRow(rowIndex[0], this.tableList.getRowCount() - 1);
            KDTableUtil.setSelectedRow((KDTable)this.tableList, (int)(this.tableList.getRowCount() - 1));
            this.refreshFormatXml();
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.EXIT_STATUS = CONFIRM_EXIT;
        this.disposeUIWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.EXIT_STATUS = CANCEL_EXIT;
        this.disposeUIWindow();
    }

    public String getExitStatus() {
        return this.EXIT_STATUS;
    }
}

