/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.kdtable;

import com.kingdee.bos.ctrl.kdf.table.BasicView;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IRows;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTIndexColumnView;
import com.kingdee.bos.ctrl.kdf.table.KDTViewManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDIntTextField;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.webui.transfer.UIType;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditorType;
import com.kingdee.eas.ep.client.editor.editui.designer.PropertyDescriptorUI;
import com.kingdee.eas.ep.client.editor.editui.designer.model.ComboBoxItem;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.EventCellEditor;
import com.kingdee.eas.ep.client.editor.kdtable.AbstractTableDesignerUI;
import com.kingdee.eas.ep.client.editor.kdtable.KDTTableView;
import com.kingdee.eas.ep.client.model.BizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class KDTableDesignerConfigUI
extends AbstractTableDesignerUI {
    public static final String KDTABLE = "kdtable";
    public static final String BIZCONFIGUREITEMCOL = "bizConfigureItemCol";
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";
    public static final String UITYPE = "uitype";
    public static final String CONTEXT = "context";
    public static final String EDITUICONFIGUREINFO = "EditUIConfigureInfo";
    protected static final String NAMECOLUMN = "nameColumn";
    protected static final String HEADCOLUMN = "headColumn";
    protected static final String VISIBLECOLUMN = "visibleColumn";
    protected static final String ENABLEDCOLUMN = "enabledColumn";
    protected static final String REQUIREDCOLUMN = "requiredColumn";
    protected static final String SUMCOLUMN = "sumColumn";
    protected static final String DEFAULTVALCOLUMN = "defaultValColumn";
    protected static final String FROZENCOLUMN = "FrozenColumn";
    protected static final String WIDTHCOLUMN = "widthColumn";
    protected static final String ALIGNCOLUMN = "alignColumn";
    protected String EXIT_STATUS = null;
    protected TableInfo kdTable;
    protected BizConfigureItemCollection configureItemCol;
    protected BizConfigureItemInfo configureItemInfo;
    protected UIType uitype;
    private Context context;
    protected DefaultKingdeeTreeNode treeRoot = new DefaultKingdeeTreeNode();
    private HeaderInfo headInfo = null;
    private List enumList = new ArrayList();

    public KDTableDesignerConfigUI() throws Exception {
        KDTViewManager viewManager = this.table.getViewManager();
        for (int i = viewManager.getViewCount() - 1; i >= 0; --i) {
            if (!(viewManager.getView(i) instanceof KDTIndexColumnView)) continue;
            this.table.getViewManager().removeView((i - 1) / this.table.getHorizonCount(), 1);
            KDTTableView view = new KDTTableView(this, this.table, this.table.getIndexColumn(), this.table.getColumns(), (IRows)this.table.getBody());
            this.table.getViewManager().addView((i - 1) / this.table.getHorizonCount(), 1, (BasicView)view);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                KDTableDesignerConfigUI.this.table_editStarting(e);
            }
        });
        this.btnAdd.setEnabled(false);
        this.btnDelete.setEnabled(false);
        this.setUITitle("\u8868\u683c\u8bbe\u7f6e");
        Object object = this.getUIContext().get(KDTABLE);
        this.kdTable = object instanceof TableInfo ? (TableInfo)object : new TableInfo();
        if (this.getUIContext().get(UITYPE) != null) {
            this.uitype = (UIType)this.getUIContext().get(UITYPE);
        }
        if (this.getUIContext().get(BIZCONFIGUREITEMCOL) != null) {
            this.configureItemCol = (BizConfigureItemCollection)((Object)this.getUIContext().get(BIZCONFIGUREITEMCOL));
        }
        this.table.getStyleAttributes().setWrapText(true);
        this.table.checkParsed();
        this.table.getColumn("hideColumn").getStyleAttributes().setHided(true);
        this.table.getColumn("lockColumn").getStyleAttributes().setHided(true);
        this.table.getColumn("formatStrColumn").getStyleAttributes().setHided(true);
        this.table.getColumn("mergeableCol").getStyleAttributes().setHided(true);
        this.table.getColumn("resizeableCol").getStyleAttributes().setHided(true);
        this.table.getColumn("moveableCol").getStyleAttributes().setHided(true);
        this.table.getColumn("groupCol").getStyleAttributes().setHided(true);
        this.table.getColumn("requiredCol").getStyleAttributes().setHided(true);
        this.table.getColumn(VISIBLECOLUMN).getStyleAttributes().setHided(false);
        this.table.getColumn(FROZENCOLUMN).getStyleAttributes().setHided(false);
        this.table.getColumn(SUMCOLUMN).getStyleAttributes().setHided(false);
        if (this.uitype != null && !"listUI".equals(this.uitype.getName())) {
            this.table.getColumn(DEFAULTVALCOLUMN).getStyleAttributes().setHided(false);
            this.table.getColumn(REQUIREDCOLUMN).getStyleAttributes().setHided(false);
            this.table.getColumn(ENABLEDCOLUMN).getStyleAttributes().setHided(false);
        }
        this.table.getColumn("event").getStyleAttributes().setHided(false);
        this.table.getColumn(NAMECOLUMN).setWidth(100);
        this.table.getColumn(HEADCOLUMN).setWidth(100);
        this.table.getColumn("event").setWidth(120);
        this.table.getColumn(NAMECOLUMN).getStyleAttributes().setLocked(true);
        this.table.getColumn(HEADCOLUMN).getStyleAttributes().setLocked(true);
        this.context = (Context)this.getUIContext().get(CONTEXT);
        if (this.context.getEditorType() == EditorType.userLayout) {
            this.table.getColumn(REQUIREDCOLUMN).getStyleAttributes().setHided(true);
            this.table.getColumn(SUMCOLUMN).getStyleAttributes().setHided(true);
            this.table.getColumn("event").getStyleAttributes().setHided(true);
        }
        this.setColumnEditor();
        this.loadData();
    }

    private void setColumnEditor() {
        KDIntTextField intEditor = new KDIntTextField();
        intEditor.setPrecision(0);
        intEditor.setMinimumValue((Comparable)new Integer(1));
        intEditor.setMaximumValue((Comparable)new Integer(1000));
        this.table.getColumn(WIDTHCOLUMN).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)intEditor));
        KDCheckBox booleanBoxEditor = new KDCheckBox();
        this.table.getColumn(VISIBLECOLUMN).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)booleanBoxEditor));
        this.table.getColumn(ENABLEDCOLUMN).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)booleanBoxEditor));
        this.table.getColumn(REQUIREDCOLUMN).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)booleanBoxEditor));
        this.table.getColumn(SUMCOLUMN).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)booleanBoxEditor));
        this.table.getColumn(FROZENCOLUMN).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)booleanBoxEditor));
        KDComboBox enumBox = new KDComboBox();
        this.enumList.add(new ComboBoxItem("left", "\u5de6\u5bf9\u9f50"));
        this.enumList.add(new ComboBoxItem("center", "\u5c45\u4e2d"));
        this.enumList.add(new ComboBoxItem("right", "\u53f3\u5bf9\u9f50"));
        enumBox.addItems(this.enumList.toArray());
        enumBox.putClientProperty((Object)"jump", (Object)"false");
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)enumBox);
        this.table.getColumn(ALIGNCOLUMN).setEditor((ICellEditor)kdtDefaultCellEditor);
    }

    public void loadData() {
        this.buildColumns(this.kdTable.getColumns());
        this.resizeTable();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.btnUp_actionPerformed(e);
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.table);
        int j = rowIndex.length;
        for (i = 0; i < j; ++i) {
            if (rowIndex[i] <= i) continue;
            IRow row = this.table.getRow(rowIndex[i]);
            KDTTableView.actionByColumn(((ColumnAndConfigure)row.getUserObject()).getColumnInfo(), -1);
        }
        this.loadData();
        j = rowIndex.length;
        for (i = 0; i < j; ++i) {
            int top = rowIndex[i];
            if (rowIndex[i] > i) {
                top = rowIndex[i] - 1;
            }
            if (i == 0) {
                this.table.getSelectManager().select(top, 0, top, this.table.getColumnCount());
                this.table.scrollToVisible(top + rowIndex.length, 0);
                continue;
            }
            this.table.getSelectManager().add(top, 0, top, this.table.getColumnCount());
        }
        if (this.context != null) {
            this.context.setDirty(true);
        }
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.btnDown_actionPerformed(e);
        int maxIndex = this.table.getRowCount() - 1;
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.table);
        for (i = rowIndex.length - 1; i >= 0; --i) {
            if (rowIndex[i] < maxIndex) {
                IRow row = this.table.getRow(rowIndex[i]);
                KDTTableView.actionByColumn(((ColumnAndConfigure)row.getUserObject()).getColumnInfo(), 1);
            }
            --maxIndex;
        }
        this.loadData();
        maxIndex = this.table.getRowCount() - 1;
        for (i = rowIndex.length - 1; i >= 0; --i) {
            int top = rowIndex[i];
            if (rowIndex[i] < maxIndex) {
                top = rowIndex[i] + 1;
            }
            if (i == rowIndex.length - 1) {
                this.table.getSelectManager().select(top, 0, top, this.table.getColumnCount());
                this.table.scrollToVisible(top, 0);
            } else {
                this.table.getSelectManager().add(top, 0, top, this.table.getColumnCount());
            }
            --maxIndex;
        }
        if (this.context != null) {
            this.context.setDirty(true);
        }
    }

    @Override
    protected void btnTop_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.btnTop_actionPerformed(e);
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.table);
        int j = rowIndex.length;
        for (i = 0; i < j; ++i) {
            if (rowIndex[i] <= i) continue;
            IRow row = this.table.getRow(rowIndex[i]);
            this.table.removeRow(rowIndex[i]);
            this.table.addRow(i, row);
            KDTTableView.actionByColumn(((ColumnAndConfigure)row.getUserObject()).getColumnInfo(), -(rowIndex[i] - i));
        }
        this.loadData();
        j = rowIndex.length;
        for (i = 0; i < j; ++i) {
            if (i == 0) {
                this.table.getSelectManager().select(i, 0, i, this.table.getColumnCount());
                this.table.scrollToVisible(i, 0);
                continue;
            }
            this.table.getSelectManager().add(i, 0, i, this.table.getColumnCount());
        }
        if (this.context != null) {
            this.context.setDirty(true);
        }
    }

    @Override
    protected void btnBottom_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.btnBottom_actionPerformed(e);
        int maxIndex = this.table.getRowCount() - 1;
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.table);
        for (i = rowIndex.length - 1; i >= 0; --i) {
            if (rowIndex[i] < maxIndex) {
                IRow row = this.table.getRow(rowIndex[i]);
                this.table.addRow(maxIndex + 1, row);
                this.table.removeRow(rowIndex[i]);
                KDTTableView.actionByColumn(((ColumnAndConfigure)row.getUserObject()).getColumnInfo(), maxIndex - rowIndex[i]);
            }
            --maxIndex;
        }
        this.loadData();
        maxIndex = this.table.getRowCount() - 1;
        for (i = rowIndex.length - 1; i >= 0; --i) {
            if (i == rowIndex.length - 1) {
                this.table.getSelectManager().select(maxIndex, 0, maxIndex, this.table.getColumnCount());
                this.table.scrollToVisible(maxIndex, 0);
            } else {
                this.table.getSelectManager().add(maxIndex, 0, maxIndex, this.table.getColumnCount());
            }
            --maxIndex;
        }
        if (this.context != null) {
            this.context.setDirty(true);
        }
    }

    public void table_editStarting(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex != 16) {
            return;
        }
        boolean isCheck = (Boolean)this.table.getRow(rowIndex).getCell(colIndex).getValue();
        if (isCheck) {
            return;
        }
        block0: for (int i = 0; i < rowIndex; ++i) {
            IRow row = this.table.getRow(i);
            row.getCell(colIndex).setValue((Object)true);
            ColumnAndConfigure columnAndConfigure = (ColumnAndConfigure)row.getUserObject();
            for (int m = 0; m < this.configureItemCol.size(); ++m) {
                BizConfigureItemInfo info = (BizConfigureItemInfo)this.configureItemCol.get(m);
                if (!info.getName().equals(columnAndConfigure.getConfigureItemInfo().getName())) continue;
                this.configureItemInfo = info;
                this.configureItemInfo.setFrozen(true);
                if (this.context == null) continue block0;
                this.context.setDirty(true);
                continue block0;
            }
        }
        MsgBox.showInfo((String)"\u6b64\u5217\u4e4b\u524d\u7684\u6240\u6709\u5217\u4e5f\u88ab\u51bb\u7ed3");
    }

    @Override
    public void table_editStopped(KDTEditEvent e) {
        if (e.getValue() == null && e.getOldValue() == null || e.getValue() == null && "".equals(e.getOldValue().toString()) || e.getValue() != null && e.getOldValue() != null && e.getValue().toString().equals(e.getOldValue().toString())) {
            return;
        }
        this.updateValue();
    }

    private void updateValue() {
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        IRow row = this.table.getRow(rowIndex);
        ColumnAndConfigure columnAndConfigure = (ColumnAndConfigure)row.getUserObject();
        columnAndConfigure.getColumnInfo().setHide((Boolean)row.getCell(VISIBLECOLUMN).getValue() == false);
        columnAndConfigure.getColumnInfo().setWidth(((Integer)row.getCell(WIDTHCOLUMN).getValue()).intValue());
        for (int m = 0; m < this.configureItemCol.size(); ++m) {
            BizConfigureItemInfo info = (BizConfigureItemInfo)this.configureItemCol.get(m);
            if (!info.getName().equals(columnAndConfigure.getConfigureItemInfo().getName())) continue;
            this.configureItemInfo = info;
            this.configureItemInfo.setVisible((Boolean)row.getCell(VISIBLECOLUMN).getValue());
            this.configureItemInfo.setEnabled((Boolean)row.getCell(ENABLEDCOLUMN).getValue());
            this.configureItemInfo.setRequired((Boolean)row.getCell(REQUIREDCOLUMN).getValue());
            this.configureItemInfo.setSum((Boolean)row.getCell(SUMCOLUMN).getValue());
            this.configureItemInfo.setFrozen((Boolean)row.getCell(FROZENCOLUMN).getValue());
            this.configureItemInfo.setWidth((Integer)row.getCell(WIDTHCOLUMN).getValue());
            this.configureItemInfo.setAlign(((ComboBoxItem)row.getCell(ALIGNCOLUMN).getValue()).getValue().toString());
            String cellDisplayText = this.table.getCellDisplayText(row.getCell(DEFAULTVALCOLUMN));
            if (!StringUtils.isEmpty((String)cellDisplayText)) {
                this.configureItemInfo.setDefaultValue(cellDisplayText);
            } else {
                this.configureItemInfo.setDefaultValue(null);
            }
            if (this.context == null) break;
            this.context.setDirty(true);
            break;
        }
        this.resizeTable();
    }

    private void buildColumns(List columns) {
        ColumnInfo columnInfo;
        TableInfo tableInfo;
        List headers;
        ColumnAndConfigure columnAndConfigure = null;
        this.table.removeRows();
        if (columns.size() > 0 && (headers = (tableInfo = (columnInfo = (ColumnInfo)columns.get(0)).getParent()).getHeaders()).size() > 0) {
            this.headInfo = (HeaderInfo)headers.get(headers.size() - 1);
        }
        int m = 0;
        for (ColumnInfo columnInfo2 : columns) {
            int j = this.configureItemCol.size();
            for (int i = 0; i < j; ++i) {
                BizConfigureItemInfo info = (BizConfigureItemInfo)this.configureItemCol.get(i);
                if (!info.getName().equals(columnInfo2.getName())) continue;
                columnAndConfigure = new ColumnAndConfigure(columnInfo2, info);
            }
            IRow row = this.table.addRow();
            row.setUserObject(columnAndConfigure);
            this.configureItemInfo = columnAndConfigure.getConfigureItemInfo();
            row.getCell(NAMECOLUMN).setValue((Object)this.configureItemInfo.getName());
            if (m < this.headInfo.getCellCount() && this.headInfo.getCells().get(m) != null) {
                row.getCell(HEADCOLUMN).setValue((Object)((CellInfo)this.headInfo.getCells().get(m)).getName());
            } else {
                row.getCell(HEADCOLUMN).setValue((Object)"");
            }
            ++m;
            row.getCell(VISIBLECOLUMN).setValue((Object)this.configureItemInfo.isVisible());
            row.getCell(ENABLEDCOLUMN).setValue((Object)this.configureItemInfo.isEnabled());
            row.getCell(REQUIREDCOLUMN).setValue((Object)this.configureItemInfo.isRequired());
            row.getCell(SUMCOLUMN).setValue((Object)this.configureItemInfo.isSum());
            row.getCell(FROZENCOLUMN).setValue((Object)this.configureItemInfo.isFrozen());
            if (this.configureItemInfo.getWidth() == -1) {
                row.getCell(WIDTHCOLUMN).setValue((Object)new Integer(100));
            } else {
                row.getCell(WIDTHCOLUMN).setValue((Object)new Integer(this.configureItemInfo.getWidth()));
            }
            int j2 = this.enumList.size();
            for (int i = 0; i < j2; ++i) {
                if (this.configureItemInfo.getAlign() == null || !this.configureItemInfo.getAlign().equals(((ComboBoxItem)this.enumList.get(i)).getValue())) continue;
                row.getCell(ALIGNCOLUMN).setValue(this.enumList.get(i));
                break;
            }
            ICell eventCell = row.getCell("event");
            MyEventCellEditor event = new MyEventCellEditor(this.configureItemInfo, this.context);
            eventCell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)event));
            eventCell.setValue((Object)event.getAsText());
            ICell defaultCell = row.getCell(DEFAULTVALCOLUMN);
            PropertyDescriptorUI.setDefaultCtrl(this.configureItemInfo, defaultCell, this.context.getDepend());
            defaultCell.setValue((Object)this.configureItemInfo.getDefaultValue());
            if (!columnInfo2.isConfigured()) continue;
            row.getStyleAttributes().setFontColor(Color.BLUE);
        }
    }

    public TableInfo getTableInfo() {
        return this.kdTable;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.kdTable = tableInfo;
    }

    public String getExitStatus() {
        return this.EXIT_STATUS;
    }

    protected void resizeTable() {
        if (this.table != null) {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                KDTableHelper.autoFitRowHeight((KDTable)this.table, (int)i);
            }
        }
    }

    protected void disposeUIWindow() {
        this.table.getEditManager().stopEditing();
        super.disposeUIWindow();
    }

    private class MyEventCellEditor
    extends EventCellEditor {
        public MyEventCellEditor(BizConfigureItemInfo item, Context context) {
            super(item, context);
        }

        @Override
        public Object getValue() {
            return this.getAsText();
        }
    }

    static class ColumnAndConfigure {
        public ColumnInfo columnInfo;
        public BizConfigureItemInfo configureItemInfo;

        public ColumnAndConfigure(ColumnInfo columnInfo, BizConfigureItemInfo configureItemInfo) {
            this.columnInfo = columnInfo;
            this.configureItemInfo = configureItemInfo;
        }

        public ColumnInfo getColumnInfo() {
            return this.columnInfo;
        }

        public BizConfigureItemInfo getConfigureItemInfo() {
            return this.configureItemInfo;
        }
    }
}

