/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.kdtable;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.webui.transfer.UIType;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.MergeBlockInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.kdtable.AbstractKDTableDesignerUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class KDTableDesignerUI
extends AbstractKDTableDesignerUI {
    private static final Logger logger = CoreUIObject.getLogger(KDTableDesignerUI.class);
    public static final String KDTABLE = "kdtable";
    public static final String TABLENAME = "tablename";
    protected String EXIT_STATUS = null;
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";
    private static final String TREE_TABLE = "table";
    private static final String TREE_COLUMN = "column";
    private static final String TREE_HEADER = "header";
    private static final String TREE_MERGEBLOCK = "mergeblocks";
    protected static final String TABLE_PROPERTY = "proColumn";
    protected static final String TABLE_VALUE = "valueColumn";
    private static final String TABLE_SELECTMODE = "table.selectMode";
    private static final String TABLE_MERGEMODE = "table.mergeMode";
    private static final String TABLE_DATAREQUESTMODE = "table.dataRequestMode";
    private static final String TABLE_PAGEROWCOUNT = "table.pageRowCount";
    private static final String TABLE_LOCK = "table.lock";
    protected static final String COLUMN_NAME = "column.name";
    protected static final String COLUMN_HEAD = "column.head";
    protected static final String COLUMN_WIDTH = "column.width";
    private static final String COLUMN_MERGEABLE = "column.mergeable";
    protected static final String COLUMN_RESIZEABLE = "column.resizeable";
    private static final String COLUMN_MOVEABLE = "column.moveable";
    private static final String COLUMN_GROUP = "column.group";
    private static final String COLUMN_LOCK = "column.lock";
    protected static final String COLUMN_HIDE = "column.hide";
    private static final String COLUMN_FORMATSTRING = "column.formatString";
    protected static final String COLUMN_HORIZONALIGN = "column.horizonAlign";
    private static final String COLUMN_REQUIRED = "column.required";
    private static final String HEADER_NAME = "header.name";
    private static final String HEADER_HEIGHT = "header.height";
    private static final String HEADER_MERGEABLE = "header.mergeable";
    private static final String HEADER_RESIZEABLE = "header.resizeable";
    protected static final String CELL_NAME = "cell.name";
    private static final String CELL_ROWSPAN = "cell.rowSpan";
    private static final String CELL_COLSPAN = "cell.colSpan";
    private static final String MERGEBLOCK_TOP = "mergeblock.top";
    private static final String MERGEBLOCK_LEFT = "mergeblock.left";
    private static final String MERGEBLOCK_BOTTOM = "mergeblock.bottom";
    private static final String MERGEBLOCK_RIGHT = "mergeblock.right";
    public static final String UITYPE = "uitype";
    protected UIType uitype;
    private String tableName = "\u8868";
    protected DefaultKingdeeTreeNode treeRoot = new DefaultKingdeeTreeNode();
    protected TableInfo kdTable;
    private boolean simpleTable = false;
    private Context context = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tree.getSelectionModel().setSelectionMode(1);
        Object object = this.getUIContext().get(KDTABLE);
        this.kdTable = object instanceof TableInfo ? (TableInfo)object : new TableInfo();
        if (this.getUIContext().get(UITYPE) != null) {
            this.uitype = (UIType)this.getUIContext().get(UITYPE);
        }
        if (this.getUIContext().get(TABLENAME) != null) {
            this.tableName = this.getUIContext().get(TABLENAME).toString();
        }
        if (this.getUIContext().get("context") != null) {
            this.context = (Context)this.getUIContext().get("context");
        }
        this.tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.treeRoot));
        this.refreshTreeRoot(null);
    }

    protected void refreshTreeRoot(Object locateUserObject) {
        this.treeRoot.removeAllChildren();
        if (this.simpleTable) {
            this.buildSimpleTable(locateUserObject);
        } else {
            this.buildComplexTable(locateUserObject);
        }
    }

    private void buildSimpleTable(Object locateUserObject) {
        this.treeRoot.setText(this.tableName);
        this.treeRoot.setUserObject((Object)this.kdTable);
        DefaultKingdeeTreeNode columnNode = new DefaultKingdeeTreeNode();
        columnNode.setUserObject((Object)TREE_COLUMN);
        columnNode.setText("\u8868\u5217");
        this.treeRoot.add((MutableTreeNode)columnNode);
        List columns = this.kdTable.getColumns();
        for (ColumnInfo columnInfo : columns) {
            DefaultKingdeeTreeNode cNode = new DefaultKingdeeTreeNode();
            cNode.setUserObject((Object)columnInfo);
            cNode.setText(columnInfo.getName());
            if (columnInfo.isConfigured()) {
                cNode.setTextColor(Color.BLUE);
            }
            columnNode.add((MutableTreeNode)cNode);
        }
        ((KingdeeTreeModel)this.tree.getModel()).reload();
        this.tree.expandAllNodes(true, (TreeNode)this.treeRoot);
        this.tree.setRootVisible(false);
        this.locateCurrentNode(this.treeRoot, locateUserObject);
    }

    public void buildComplexTable(Object locateUserObject) {
        this.treeRoot.setText(this.tableName);
        this.treeRoot.setUserObject((Object)this.kdTable);
        DefaultKingdeeTreeNode headerNode = new DefaultKingdeeTreeNode();
        headerNode.setUserObject((Object)TREE_HEADER);
        headerNode.setText("\u8868\u5934");
        this.treeRoot.add((MutableTreeNode)headerNode);
        DefaultKingdeeTreeNode mergeNode = new DefaultKingdeeTreeNode();
        mergeNode.setUserObject((Object)TREE_MERGEBLOCK);
        mergeNode.setText("\u878d\u5408");
        this.treeRoot.add((MutableTreeNode)mergeNode);
        List headers = this.kdTable.getHeaders();
        for (HeaderInfo headerInfo : headers) {
            DefaultKingdeeTreeNode hNode = new DefaultKingdeeTreeNode();
            hNode.setUserObject((Object)headerInfo);
            hNode.setText(headerInfo.getName());
            if (headerInfo.isConfigured()) {
                hNode.setTextColor(Color.BLUE);
            }
            headerNode.add((MutableTreeNode)hNode);
            ArrayList cells = headerInfo.getCells();
            for (CellInfo cellInfo : cells) {
                DefaultKingdeeTreeNode cellNode = new DefaultKingdeeTreeNode();
                cellNode.setUserObject((Object)cellInfo);
                cellNode.setText(cellInfo.getName());
                if (cellInfo.isConfigured()) {
                    cellNode.setTextColor(Color.BLUE);
                }
                hNode.add((MutableTreeNode)cellNode);
            }
        }
        List merges = this.kdTable.getMergeBlocks();
        for (MergeBlockInfo mergeInfo : merges) {
            DefaultKingdeeTreeNode mNode = new DefaultKingdeeTreeNode();
            mNode.setUserObject((Object)mergeInfo);
            mNode.setText("MergeBlock");
            if (mergeInfo.isConfigured()) {
                mNode.setTextColor(Color.BLUE);
            }
            mergeNode.add((MutableTreeNode)mNode);
        }
        ((KingdeeTreeModel)this.tree.getModel()).reload();
        this.tree.expandAllNodes(true, (TreeNode)this.treeRoot);
        this.locateCurrentNode(this.treeRoot, locateUserObject);
    }

    protected void refreshTreeAndLocateCurrentSelected() {
        Object locateUserObject = null;
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null) {
            locateUserObject = treeNode.getUserObject();
        }
        this.refreshTreeRoot(locateUserObject);
    }

    public TableInfo getTableInfo() {
        return this.kdTable;
    }

    public void setTableInfo(TableInfo kdTable) {
        this.kdTable = kdTable;
    }

    @Override
    protected void tree_valueChanged(TreeSelectionEvent e) throws Exception {
        if (e.getOldLeadSelectionPath() == null || e.getOldLeadSelectionPath().getLastPathComponent() != null) {
            // empty if block
        }
        this.tableList.removeRows();
        if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null) {
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
            if (TREE_TABLE.equals(treeNode.getUserObject())) {
                this.loadTableInfo2TableList(this.kdTable);
            } else if (treeNode.getUserObject() instanceof ColumnInfo) {
                this.loadColumnInfo2TableList((ColumnInfo)treeNode.getUserObject());
            } else if (treeNode.getUserObject() instanceof HeaderInfo) {
                this.loadHeaderInfo2TableList((HeaderInfo)treeNode.getUserObject());
            } else if (treeNode.getUserObject() instanceof CellInfo) {
                this.loadCellInfo2TableList((CellInfo)treeNode.getUserObject());
            } else if (treeNode.getUserObject() instanceof MergeBlockInfo) {
                this.loadMergeInfo2TableList((MergeBlockInfo)treeNode.getUserObject());
            }
        }
    }

    protected void loadTableInfo2TableList(TableInfo tableInfo) {
        IRow row = this.tableList.addRow();
        row.setUserObject((Object)TABLE_SELECTMODE);
        row.getCell(TABLE_PROPERTY).setValue((Object)"selectMode");
        row.getCell(TABLE_VALUE).setValue((Object)new Integer(tableInfo.getSelectMode()));
        row = this.tableList.addRow();
        row.setUserObject((Object)TABLE_MERGEMODE);
        row.getCell(TABLE_PROPERTY).setValue((Object)"mergeMode");
        row.getCell(TABLE_VALUE).setValue((Object)new Integer(tableInfo.getMergeMode()));
        row = this.tableList.addRow();
        row.setUserObject((Object)TABLE_DATAREQUESTMODE);
        row.getCell(TABLE_PROPERTY).setValue((Object)"dataRequestMode");
        row.getCell(TABLE_VALUE).setValue((Object)new Integer(tableInfo.getDataRequestMode()));
        row = this.tableList.addRow();
        row.setUserObject((Object)TABLE_PAGEROWCOUNT);
        row.getCell(TABLE_PROPERTY).setValue((Object)"pageRowCount");
        row.getCell(TABLE_VALUE).setValue((Object)new Integer(tableInfo.getPageRowCount()));
        row = this.tableList.addRow();
        row.setUserObject((Object)TABLE_LOCK);
        row.getCell(TABLE_PROPERTY).setValue((Object)"lock");
        row.getCell(TABLE_VALUE).setValue((Object)new Boolean(tableInfo.isLock()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean storeTableInfo2TableList(TableInfo tableInfo, Object userObj, Object newValue) {
        if (TABLE_SELECTMODE.equals(userObj)) {
            if (!this.checkPositiveNumber(newValue)) return false;
            tableInfo.setSelectMode(this.parseInt(newValue));
            return true;
        } else if (TABLE_MERGEMODE.equals(userObj)) {
            if (!this.checkPositiveNumber(newValue)) return false;
            tableInfo.setMergeMode(this.parseInt(newValue));
            return true;
        } else if (TABLE_DATAREQUESTMODE.equals(userObj)) {
            if (!this.checkPositiveNumber(newValue)) return false;
            tableInfo.setDataRequestMode(this.parseInt(newValue));
            return true;
        } else if (TABLE_PAGEROWCOUNT.equals(userObj)) {
            if (!this.checkPositiveNumber(newValue)) return false;
            tableInfo.setPageRowCount(this.parseInt(newValue));
            return true;
        } else {
            if (!TABLE_LOCK.equals(userObj)) return true;
            tableInfo.setLock(this.parseBoolean(newValue));
        }
        return true;
    }

    protected void loadColumnInfo2TableList(ColumnInfo columnInfo) {
        IRow row = this.tableList.addRow();
        row.setUserObject((Object)COLUMN_NAME);
        row.getCell(TABLE_PROPERTY).setValue((Object)"name");
        KDTextField txtName = new KDTextField();
        txtName.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                JTextField textField;
                if (Character.getNumericValue(e.getKeyChar()) == -1 && e.getKeyChar() != '\b') {
                    e.consume();
                }
                if ((textField = (JTextField)e.getSource()).getCaretPosition() == 0) {
                    e.setKeyChar(Character.toLowerCase(e.getKeyChar()));
                }
            }
        });
        ICell cell = row.getCell(TABLE_VALUE);
        KDTextField _TextField = new KDTextField();
        _TextField.setMaxLength(20);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)_TextField);
        cell.setEditor((ICellEditor)cellEditor);
        cell.setValue((Object)columnInfo.getName());
        if (this.simpleTable) {
            int index = -1;
            List columns = this.kdTable.getColumns();
            int n = columns.size();
            for (int i = 0; i < n; ++i) {
                if (!columns.get(i).equals(columnInfo)) continue;
                index = i;
                break;
            }
            if (index != -1) {
                List headers = this.kdTable.getHeaders();
                String title = "head";
                String value = "";
                int n2 = headers.size();
                for (int i = 0; i < n2; ++i) {
                    HeaderInfo headerInfo = (HeaderInfo)headers.get(i);
                    value = ((CellInfo)headerInfo.getCells().get(index)).getName();
                    if (i != 0) {
                        title = title + i;
                    }
                    row = this.tableList.addRow();
                    row.setUserObject((Object)COLUMN_HEAD);
                    row.getCell(TABLE_PROPERTY).setValue((Object)title);
                    row.getCell(TABLE_VALUE).setValue((Object)value);
                }
            }
        }
        row = this.tableList.addRow();
        row.setUserObject((Object)COLUMN_WIDTH);
        row.getCell(TABLE_PROPERTY).setValue((Object)"width");
        row.getCell(TABLE_VALUE).setValue((Object)new Integer(columnInfo.getWidth()));
        row = this.tableList.addRow();
        row.setUserObject((Object)COLUMN_HIDE);
        row.getCell(TABLE_PROPERTY).setValue((Object)"hide");
        row.getCell(TABLE_VALUE).setValue((Object)new Boolean(columnInfo.isHide()));
        row = this.tableList.addRow();
        row.setUserObject((Object)COLUMN_GROUP);
        row.getCell(TABLE_PROPERTY).setValue((Object)"group");
        row.getCell(TABLE_VALUE).setValue((Object)new Boolean(columnInfo.isGroup()));
        row = this.tableList.addRow();
        row.setUserObject((Object)COLUMN_MERGEABLE);
        row.getCell(TABLE_PROPERTY).setValue((Object)"mergeable");
        row.getCell(TABLE_VALUE).setValue((Object)new Boolean(columnInfo.isMergeable()));
        row = this.tableList.addRow();
        row.setUserObject((Object)COLUMN_RESIZEABLE);
        row.getCell(TABLE_PROPERTY).setValue((Object)"resizeable");
        row.getCell(TABLE_VALUE).setValue((Object)new Boolean(columnInfo.isResizeable()));
        row = this.tableList.addRow();
        row.setUserObject((Object)COLUMN_MOVEABLE);
        row.getCell(TABLE_PROPERTY).setValue((Object)"moveable");
        row.getCell(TABLE_VALUE).setValue((Object)new Boolean(columnInfo.isMoveable()));
        row = this.tableList.addRow();
        row.setUserObject((Object)COLUMN_FORMATSTRING);
        row.getCell(TABLE_PROPERTY).setValue((Object)"formatString");
        row.getCell(TABLE_VALUE).setValue((Object)columnInfo.getFormatString());
        if (UIType.EDITUI.equals((Object)this.uitype)) {
            row = this.tableList.addRow();
            row.setUserObject((Object)COLUMN_LOCK);
            row.getCell(TABLE_PROPERTY).setValue((Object)"lock");
            row.getCell(TABLE_VALUE).setValue((Object)new Boolean(columnInfo.isLock()));
            row = this.tableList.addRow();
            row.setUserObject((Object)COLUMN_REQUIRED);
            row.getCell(TABLE_PROPERTY).setValue((Object)"required");
            row.getCell(TABLE_VALUE).setValue((Object)new Boolean(columnInfo.isRequired()));
        }
        row = this.tableList.addRow();
        row.setUserObject((Object)COLUMN_FORMATSTRING);
        row.getCell(TABLE_PROPERTY).setValue((Object)"formatString");
        row.getCell(TABLE_VALUE).setValue((Object)columnInfo.getFormatString());
        row = this.tableList.addRow();
        row.setUserObject((Object)COLUMN_HORIZONALIGN);
        row.getCell(TABLE_PROPERTY).setValue((Object)"horizonAlign");
        row.getCell(TABLE_VALUE).setValue((Object)columnInfo.getHorizonAlign());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean storeColumnInfo2TableList(ColumnInfo columnInfo, Object userObj, Object newValue) {
        if (COLUMN_NAME.equals(userObj)) {
            columnInfo.setName(this.parseString(newValue));
            this.refreshTreeAndLocateCurrentSelected();
            return true;
        } else if (COLUMN_WIDTH.equals(userObj)) {
            if (!this.checkPositiveNumber(newValue)) return false;
            columnInfo.setWidth(this.parseInt(newValue));
            return true;
        } else if (COLUMN_MERGEABLE.equals(userObj)) {
            columnInfo.setMergeable(this.parseBoolean(newValue));
            return true;
        } else if (COLUMN_RESIZEABLE.equals(userObj)) {
            columnInfo.setResizeable(this.parseBoolean(newValue));
            return true;
        } else if (COLUMN_MOVEABLE.equals(userObj)) {
            columnInfo.setMoveable(this.parseBoolean(newValue));
            return true;
        } else if (COLUMN_GROUP.equals(userObj)) {
            columnInfo.setGroup(this.parseBoolean(newValue));
            return true;
        } else if (COLUMN_LOCK.equals(userObj)) {
            columnInfo.setLock(this.parseBoolean(newValue));
            return true;
        } else if (COLUMN_HIDE.equals(userObj)) {
            columnInfo.setHide(this.parseBoolean(newValue));
            return true;
        } else if (COLUMN_FORMATSTRING.equals(userObj)) {
            columnInfo.setFormatString((String)newValue);
            return true;
        } else if (COLUMN_HORIZONALIGN.equals(userObj)) {
            String sTemp = this.parseAlign(newValue);
            if (sTemp == null) return true;
            columnInfo.setHorizonAlign(sTemp);
            return true;
        } else {
            if (!COLUMN_REQUIRED.equals(userObj)) return true;
            columnInfo.setRequired(this.parseBoolean(newValue));
        }
        return true;
    }

    protected void loadHeaderInfo2TableList(HeaderInfo headerInfo) {
        IRow row = this.tableList.addRow();
        row.setUserObject((Object)HEADER_NAME);
        row.getCell(TABLE_PROPERTY).setValue((Object)"name");
        ICell cell = row.getCell(TABLE_VALUE);
        KDTextField _TextField = new KDTextField();
        _TextField.setMaxLength(20);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)_TextField);
        cell.setEditor((ICellEditor)cellEditor);
        cell.setValue((Object)headerInfo.getName());
        row = this.tableList.addRow();
        row.setUserObject((Object)HEADER_HEIGHT);
        row.getCell(TABLE_PROPERTY).setValue((Object)"height");
        row.getCell(TABLE_VALUE).setValue((Object)new Integer(headerInfo.getHeight()));
        row = this.tableList.addRow();
        row.setUserObject((Object)HEADER_MERGEABLE);
        row.getCell(TABLE_PROPERTY).setValue((Object)"mergeable");
        row.getCell(TABLE_VALUE).setValue((Object)new Boolean(headerInfo.isMergeable()));
        row = this.tableList.addRow();
        row.setUserObject((Object)HEADER_RESIZEABLE);
        row.getCell(TABLE_PROPERTY).setValue((Object)"resizeable");
        row.getCell(TABLE_VALUE).setValue((Object)new Boolean(headerInfo.isResizeable()));
    }

    protected boolean storeHeaderInfo2TableList(HeaderInfo headerInfo, Object userObj, Object newValue) {
        if (HEADER_NAME.equals(userObj)) {
            headerInfo.setName(this.parseString(newValue));
            this.refreshTreeAndLocateCurrentSelected();
        } else if (HEADER_HEIGHT.equals(userObj)) {
            if (this.checkPositiveNumber(newValue)) {
                headerInfo.setHeight(this.parseInt(newValue));
            }
        } else if (HEADER_MERGEABLE.equals(userObj)) {
            headerInfo.setMergeable(this.parseBoolean(newValue));
        } else if (HEADER_RESIZEABLE.equals(userObj)) {
            headerInfo.setResizeable(this.parseBoolean(newValue));
        }
        return true;
    }

    protected void loadCellInfo2TableList(CellInfo cellInfo) {
        IRow row = this.tableList.addRow();
        row.setUserObject((Object)CELL_NAME);
        row.getCell(TABLE_PROPERTY).setValue((Object)"name");
        ICell cell = row.getCell(TABLE_VALUE);
        KDTextField _TextField = new KDTextField();
        _TextField.setMaxLength(20);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)_TextField);
        cell.setEditor((ICellEditor)cellEditor);
        cell.setValue((Object)cellInfo.getName());
        row = this.tableList.addRow();
        row.setUserObject((Object)CELL_ROWSPAN);
        row.getCell(TABLE_PROPERTY).setValue((Object)"rowSpan");
        row.getCell(TABLE_VALUE).setValue((Object)new Integer(cellInfo.getRowSpan()));
        row.getStyleAttributes().setLocked(true);
        row = this.tableList.addRow();
        row.setUserObject((Object)CELL_COLSPAN);
        row.getCell(TABLE_PROPERTY).setValue((Object)"colSpan");
        row.getCell(TABLE_VALUE).setValue((Object)new Integer(cellInfo.getColSpan()));
        row.getStyleAttributes().setLocked(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean storeCellInfo2TableList(CellInfo cellInfo, Object userObj, Object newValue) {
        if (CELL_NAME.equals(userObj)) {
            cellInfo.setName(this.parseString(newValue));
            this.refreshTreeAndLocateCurrentSelected();
            return true;
        } else if (CELL_ROWSPAN.equals(userObj)) {
            if (!this.checkPositiveNumber(newValue) || !this.checkRowSpan(cellInfo, newValue)) return false;
            cellInfo.setRowSpan(this.parseInt(newValue));
            return true;
        } else {
            if (!CELL_COLSPAN.equals(userObj)) return true;
            if (!this.checkPositiveNumber(newValue) || !this.checkColSpan(cellInfo, newValue)) return false;
            cellInfo.setColSpan(this.parseInt(newValue));
        }
        return true;
    }

    protected void loadMergeInfo2TableList(MergeBlockInfo mergeInfo) {
        IRow row = this.tableList.addRow();
        row.setUserObject((Object)MERGEBLOCK_TOP);
        row.getCell(TABLE_PROPERTY).setValue((Object)"top");
        row.getCell(TABLE_VALUE).setValue((Object)new Integer(mergeInfo.getTop()));
        row = this.tableList.addRow();
        row.setUserObject((Object)MERGEBLOCK_LEFT);
        row.getCell(TABLE_PROPERTY).setValue((Object)"left");
        row.getCell(TABLE_VALUE).setValue((Object)new Integer(mergeInfo.getLeft()));
        row = this.tableList.addRow();
        row.setUserObject((Object)MERGEBLOCK_BOTTOM);
        row.getCell(TABLE_PROPERTY).setValue((Object)"bottom");
        row.getCell(TABLE_VALUE).setValue((Object)new Integer(mergeInfo.getBottom()));
        row = this.tableList.addRow();
        row.setUserObject((Object)MERGEBLOCK_RIGHT);
        row.getCell(TABLE_PROPERTY).setValue((Object)"right");
        row.getCell(TABLE_VALUE).setValue((Object)new Integer(mergeInfo.getRight()));
    }

    protected boolean storeMergeInfo2TableList(TableInfo tableInfo, MergeBlockInfo mergeInfo, Object userObj, Object newValue) {
        int rowCount = this.tableList.getRowCount();
        int columnCount = tableInfo.getColumnCount();
        int headerCount = tableInfo.getHeaderCount();
        int val = this.parseInt(newValue);
        if (MERGEBLOCK_TOP.equals(userObj)) {
            if (val >= headerCount) {
                MsgBox.showWarning((Component)((Object)this), (String)"\u8f93\u5165\u503c\u5fc5\u987b\u5c0f\u4e8e\u8868\u5934\u884c\u6570\uff0c\u8bf7\u786e\u8ba4\uff01");
                return false;
            }
            mergeInfo.setTop(this.parseInt(newValue));
            this.refreshTreeAndLocateCurrentSelected();
        } else if (MERGEBLOCK_LEFT.equals(userObj)) {
            if (val >= columnCount) {
                MsgBox.showWarning((Component)((Object)this), (String)"\u8f93\u5165\u503c\u5fc5\u987b\u5c0f\u4e8e\u8868\u5217\u6570\uff0c\u8bf7\u786e\u8ba4\uff01");
                return false;
            }
            mergeInfo.setLeft(this.parseInt(newValue));
            this.refreshTreeAndLocateCurrentSelected();
        } else if (MERGEBLOCK_BOTTOM.equals(userObj)) {
            if (val >= headerCount) {
                MsgBox.showWarning((Component)((Object)this), (String)"\u8f93\u5165\u503c\u5fc5\u987b\u5c0f\u4e8e\u8868\u5934\u884c\u6570\uff0c\u8bf7\u786e\u8ba4\uff01");
                return false;
            }
            mergeInfo.setBottom(this.parseInt(newValue));
            this.refreshTreeAndLocateCurrentSelected();
        } else if (MERGEBLOCK_RIGHT.equals(userObj)) {
            if (val >= columnCount) {
                MsgBox.showWarning((Component)((Object)this), (String)"\u8f93\u5165\u503c\u5fc5\u987b\u5c0f\u4e8e\u8868\u5217\u6570\uff0c\u8bf7\u786e\u8ba4\uff01");
                return false;
            }
            mergeInfo.setRight(this.parseInt(newValue));
            this.refreshTreeAndLocateCurrentSelected();
        }
        return true;
    }

    protected boolean checkPositiveNumber(Object obj) {
        int i = this.parseInt(obj);
        if (i < -1) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u8f93\u5165\u7684\u6570\u5b57\u4e0d\u5408\u6cd5\uff01");
            return false;
        }
        return true;
    }

    private boolean checkRowSpan(CellInfo cell, Object obj) {
        HeaderInfo header = cell.getParent();
        int rows = 0;
        int rowSpan = this.parseInt(obj);
        for (int i = 0; i < header.getCellCount(); ++i) {
            if (header.getCells().get(i).equals(cell)) continue;
            rows += ((CellInfo)header.getCells().get(i)).getRowSpan();
        }
        return true;
    }

    private boolean checkColSpan(CellInfo cell, Object obj) {
        return true;
    }

    protected int parseInt(Object obj) {
        int i = -2;
        try {
            i = Integer.parseInt(obj.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return i;
    }

    protected boolean parseBoolean(Object obj) {
        boolean b = false;
        try {
            String s = obj.toString();
            if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equals("1")) {
                b = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return b;
    }

    protected String parseString(Object obj) {
        String s = null;
        try {
            s = obj.toString();
            s = s.trim();
        }
        catch (Throwable t) {
            s = null;
        }
        return s;
    }

    protected String parseAlign(Object obj) {
        String s = null;
        try {
            s = obj.toString();
            if (s.equalsIgnoreCase("0")) {
                s = "left";
            } else if (s.equalsIgnoreCase("1")) {
                s = "center";
            } else if (s.equalsIgnoreCase("2")) {
                s = "right";
            } else if (!(s.equals("left") || s.equals("center") || s.equals("right"))) {
                s = null;
            }
        }
        catch (Throwable t) {
            s = null;
        }
        return s;
    }

    private void addColumn() {
        ColumnInfo column = new ColumnInfo(this.kdTable);
        column.setName(TREE_COLUMN + (this.kdTable.getColumnCount() + 1));
        column.setConfigured(true);
        this.kdTable.addColumn(column);
        if (this.simpleTable) {
            List headers = this.kdTable.getHeaders();
            int n = this.kdTable.getHeaderCount();
            for (int i = 0; i < n; ++i) {
                HeaderInfo headInfo = (HeaderInfo)headers.get(i);
                this.addCell(headInfo);
            }
        }
    }

    private void addHeader() {
        HeaderInfo header = new HeaderInfo(this.kdTable);
        header.setName(TREE_HEADER + (this.kdTable.getHeaderCount() + 1));
        header.setConfigured(true);
        this.kdTable.addHeader(header);
        ArrayList list = (ArrayList)this.kdTable.getHeaders();
        int currentIndex = list.indexOf(header);
        if (currentIndex <= 0 || currentIndex > list.size() - 1) {
            return;
        }
        ArrayList cl = (ArrayList)list.clone();
        int j = cl.size();
        for (int i = 0; i < j; ++i) {
            header = (HeaderInfo)cl.get(i);
            if (i == currentIndex) {
                list.set(0, header);
                continue;
            }
            if (i >= currentIndex) continue;
            list.set(i + 1, header);
        }
    }

    private void addMergeBlock() {
        MergeBlockInfo mb = new MergeBlockInfo(this.kdTable);
        mb.setConfigured(true);
        this.kdTable.addMergeBlock(mb);
    }

    private void addCell(HeaderInfo header) {
        int columnCount = header.getParent().getColumnCount();
        int cellCount = header.getCellCount();
        if (cellCount >= columnCount) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u8868\u5934\u5355\u5143\u683c\u4e2a\u6570\u4e0d\u80fd\u5927\u4e8e\u8868\u7684\u5217\u6570");
            return;
        }
        CellInfo cell = new CellInfo(header);
        cell.setName("cell" + (header.getCellCount() + 1));
        cell.setConfigured(true);
        header.addCell(cell);
        if (this.context != null) {
            this.context.setDirty(true);
        }
    }

    @Override
    protected void butAdd_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null) {
            if (TREE_COLUMN.equals(treeNode.getUserObject())) {
                this.addColumn();
                if (this.context != null) {
                    this.context.setDirty(true);
                }
            } else if (TREE_HEADER.equals(treeNode.getUserObject())) {
                this.addHeader();
                if (this.context != null) {
                    this.context.setDirty(true);
                }
            } else if (TREE_MERGEBLOCK.equals(treeNode.getUserObject())) {
                this.addMergeBlock();
                if (this.context != null) {
                    this.context.setDirty(true);
                }
            } else if (treeNode.getUserObject() instanceof ColumnInfo) {
                this.addColumn();
                if (this.context != null) {
                    this.context.setDirty(true);
                }
            } else if (treeNode.getUserObject() instanceof HeaderInfo) {
                this.addCell((HeaderInfo)treeNode.getUserObject());
            } else if (treeNode.getUserObject() instanceof CellInfo) {
                this.addCell(((CellInfo)treeNode.getUserObject()).getParent());
            }
            this.refreshTreeAndLocateCurrentSelected();
        }
    }

    @Override
    protected void butDelete_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null) {
            Object element = treeNode.getUserObject();
            if (element instanceof ColumnInfo) {
                if (!((ColumnInfo)element).isConfigured()) {
                    MsgBox.showInfo((String)"\u975e\u52a8\u6001\u6570\u636e\u4e0d\u53ef\u5220\u9664,\u8bf7\u91cd\u65b0\u9009\u62e9!");
                    return;
                }
                int isDelete = MsgBox.showConfirm2((Component)((Object)this), (String)"\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\u8be5\u8868\u5217\uff01");
                if (isDelete == 0) {
                    int index = this.kdTable.getColumns().indexOf((ColumnInfo)element);
                    if (this.simpleTable && index >= 0) {
                        List headers = this.kdTable.getHeaders();
                        int n = headers.size();
                        for (int i = 0; i < n; ++i) {
                            HeaderInfo head = (HeaderInfo)headers.get(i);
                            if (index > head.getCellCount() - 1) continue;
                            CellInfo cell = (CellInfo)head.getCells().get(index);
                            head.removeCell(cell);
                        }
                    }
                    this.kdTable.removeColumn((ColumnInfo)element);
                    if (this.context != null) {
                        this.context.setDirty(true);
                    }
                }
            } else if (element instanceof HeaderInfo) {
                if (!((HeaderInfo)element).isConfigured()) {
                    MsgBox.showInfo((String)"\u975e\u52a8\u6001\u6570\u636e\u4e0d\u53ef\u5220\u9664,\u8bf7\u91cd\u65b0\u9009\u62e9!");
                    return;
                }
                this.kdTable.removeHeader((HeaderInfo)element);
                if (this.context != null) {
                    this.context.setDirty(true);
                }
            } else if (element instanceof CellInfo) {
                if (!((CellInfo)element).isConfigured()) {
                    MsgBox.showInfo((String)"\u975e\u52a8\u6001\u6570\u636e\u4e0d\u53ef\u5220\u9664,\u8bf7\u91cd\u65b0\u9009\u62e9!");
                    return;
                }
                int isDelete = MsgBox.showConfirm2((Component)((Object)this), (String)"\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\u8be5\u8868\u5934\uff01");
                if (isDelete == 0) {
                    int index = ((CellInfo)element).getParent().getCells().indexOf((CellInfo)element);
                    ((CellInfo)element).getParent().removeCell((CellInfo)element);
                    if (this.context != null) {
                        this.context.setDirty(true);
                    }
                }
            } else if (element instanceof MergeBlockInfo) {
                if (!((MergeBlockInfo)element).isConfigured()) {
                    MsgBox.showInfo((String)"\u975e\u52a8\u6001\u6570\u636e\u4e0d\u53ef\u5220\u9664,\u8bf7\u91cd\u65b0\u9009\u62e9!");
                    return;
                }
                ((MergeBlockInfo)element).getParent().removeMergeBlock((MergeBlockInfo)element);
                if (this.context != null) {
                    this.context.setDirty(true);
                }
            }
            this.refreshTreeAndLocateCurrentSelected();
        }
    }

    @Override
    protected void butUP_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() != null) {
            Object element = treeNode.getUserObject();
            if (element instanceof ColumnInfo) {
                ColumnInfo columnInfo = (ColumnInfo)element;
                this.upActionByColumn(columnInfo);
            } else if (element instanceof HeaderInfo) {
                HeaderInfo headerInfo = (HeaderInfo)element;
                TableInfo tableInfo = headerInfo.getParent();
                ArrayList list = (ArrayList)tableInfo.getHeaders();
                int currentIndex = list.indexOf(headerInfo);
                if (currentIndex < 1 || currentIndex > list.size()) {
                    return;
                }
                int lastIndex = currentIndex - 1;
                HeaderInfo lastHeader = (HeaderInfo)list.get(lastIndex);
                list.set(lastIndex, headerInfo);
                list.set(currentIndex, lastHeader);
            } else if (element instanceof CellInfo) {
                CellInfo cellInfo = (CellInfo)element;
                HeaderInfo headerInfo = cellInfo.getParent();
                ArrayList list = headerInfo.getCells();
                int currentIndex = list.indexOf(cellInfo);
                if (currentIndex < 1 || currentIndex > list.size()) {
                    return;
                }
                TableInfo tableInfo = headerInfo.getParent();
                ArrayList hlist = (ArrayList)tableInfo.getHeaders();
                ArrayList colList = null;
                ArrayList colListc = null;
                boolean cando = false;
                if (hlist.size() == 1) {
                    cando = true;
                    colList = (ArrayList)tableInfo.getColumns();
                    colListc = (ArrayList)colList.clone();
                }
                int lastIndex = currentIndex - 1;
                CellInfo lastCell = (CellInfo)list.get(lastIndex);
                list.set(lastIndex, cellInfo);
                list.set(currentIndex, lastCell);
                if (cando) {
                    colList.set(lastIndex, colListc.get(currentIndex));
                    ((ColumnInfo)colList.get(lastIndex)).setIndex(lastIndex);
                    colList.set(currentIndex, colListc.get(currentIndex - 1));
                    ((ColumnInfo)colList.get(currentIndex)).setIndex(currentIndex);
                }
            }
            this.refreshTreeAndLocateCurrentSelected();
            if (this.context != null) {
                this.context.setDirty(true);
            }
        }
    }

    protected void upActionByColumn(ColumnInfo columnInfo) {
        TableInfo tableInfo = columnInfo.getParent();
        ArrayList list = (ArrayList)tableInfo.getColumns();
        int currentIndex = list.indexOf(columnInfo);
        if (currentIndex < 1 || currentIndex > list.size()) {
            return;
        }
        ArrayList hlist = (ArrayList)tableInfo.getHeaders();
        ArrayList celllist = null;
        ArrayList celllistc = null;
        boolean cando = false;
        if (hlist.size() == 1) {
            cando = true;
            celllist = ((HeaderInfo)hlist.get(0)).getCells();
            celllistc = (ArrayList)celllist.clone();
        }
        int lastIndex = currentIndex - 1;
        ColumnInfo lastColumn = (ColumnInfo)list.get(lastIndex);
        list.set(lastIndex, columnInfo);
        columnInfo.setIndex(lastIndex);
        list.set(currentIndex, lastColumn);
        lastColumn.setIndex(currentIndex);
        if (cando) {
            celllist.set(lastIndex, celllistc.get(currentIndex));
            celllist.set(currentIndex, celllistc.get(currentIndex - 1));
        }
    }

    @Override
    protected void butDown_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() != null) {
            Object element = treeNode.getUserObject();
            if (element instanceof ColumnInfo) {
                ColumnInfo columnInfo = (ColumnInfo)element;
                this.downActionByColumn(columnInfo);
            } else if (element instanceof HeaderInfo) {
                HeaderInfo headerInfo = (HeaderInfo)element;
                TableInfo tableInfo = headerInfo.getParent();
                ArrayList list = (ArrayList)tableInfo.getHeaders();
                int currentIndex = list.indexOf(headerInfo);
                if (currentIndex < 0 || currentIndex >= list.size() - 1) {
                    return;
                }
                int lastIndex = currentIndex + 1;
                HeaderInfo lastHeader = (HeaderInfo)list.get(lastIndex);
                list.set(lastIndex, headerInfo);
                list.set(currentIndex, lastHeader);
            } else if (element instanceof CellInfo) {
                CellInfo cellInfo = (CellInfo)element;
                HeaderInfo headerInfo = cellInfo.getParent();
                ArrayList list = headerInfo.getCells();
                int currentIndex = list.indexOf(cellInfo);
                if (currentIndex < 0 || currentIndex >= list.size() - 1) {
                    return;
                }
                TableInfo tableInfo = headerInfo.getParent();
                ArrayList hlist = (ArrayList)tableInfo.getHeaders();
                ArrayList colList = null;
                ArrayList colListc = null;
                boolean cando = false;
                if (hlist.size() == 1) {
                    cando = true;
                    colList = (ArrayList)tableInfo.getColumns();
                    colListc = (ArrayList)colList.clone();
                }
                int lastIndex = currentIndex + 1;
                CellInfo lastCell = (CellInfo)list.get(lastIndex);
                list.set(lastIndex, cellInfo);
                list.set(currentIndex, lastCell);
                if (cando) {
                    colList.set(lastIndex, colListc.get(currentIndex));
                    ((ColumnInfo)colList.get(lastIndex)).setIndex(lastIndex);
                    colList.set(currentIndex, colListc.get(currentIndex + 1));
                    ((ColumnInfo)colList.get(currentIndex)).setIndex(currentIndex);
                }
            }
            this.refreshTreeAndLocateCurrentSelected();
            if (this.context != null) {
                this.context.setDirty(true);
            }
        }
    }

    protected void downActionByColumn(ColumnInfo columnInfo) {
        TableInfo tableInfo = columnInfo.getParent();
        ArrayList list = (ArrayList)tableInfo.getColumns();
        int currentIndex = list.indexOf(columnInfo);
        if (currentIndex < 0 || currentIndex >= list.size() - 1) {
            return;
        }
        int lastIndex = currentIndex + 1;
        ColumnInfo lastColumn = (ColumnInfo)list.get(lastIndex);
        ArrayList hlist = (ArrayList)tableInfo.getHeaders();
        ArrayList celllist = null;
        ArrayList celllistc = null;
        boolean cando = false;
        if (hlist.size() == 1) {
            cando = true;
            celllist = ((HeaderInfo)hlist.get(0)).getCells();
            celllistc = (ArrayList)celllist.clone();
        }
        list.set(lastIndex, columnInfo);
        columnInfo.setIndex(lastIndex);
        list.set(currentIndex, lastColumn);
        lastColumn.setIndex(currentIndex);
        if (cando) {
            celllist.set(lastIndex, celllistc.get(currentIndex));
            celllist.set(currentIndex, celllistc.get(currentIndex + 1));
        }
    }

    @Override
    protected void butTop_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() != null) {
            Object element = treeNode.getUserObject();
            if (element instanceof ColumnInfo) {
                ColumnInfo columnInfo = (ColumnInfo)element;
                this.topActionByColumn(columnInfo);
            } else if (element instanceof HeaderInfo) {
                HeaderInfo headerInfo = (HeaderInfo)element;
                TableInfo tableInfo = headerInfo.getParent();
                ArrayList list = (ArrayList)tableInfo.getHeaders();
                int currentIndex = list.indexOf(headerInfo);
                if (currentIndex <= 0 || currentIndex > list.size() - 1) {
                    return;
                }
                ArrayList cl = (ArrayList)list.clone();
                int j = cl.size();
                for (int i = 0; i < j; ++i) {
                    headerInfo = (HeaderInfo)cl.get(i);
                    if (i == currentIndex) {
                        list.set(0, headerInfo);
                        continue;
                    }
                    if (i >= currentIndex) continue;
                    list.set(i + 1, headerInfo);
                }
            } else if (element instanceof CellInfo) {
                CellInfo cellInfo = (CellInfo)element;
                HeaderInfo headerInfo = cellInfo.getParent();
                ArrayList list = headerInfo.getCells();
                int currentIndex = list.indexOf(cellInfo);
                if (currentIndex <= 0 || currentIndex > list.size() - 1) {
                    return;
                }
                TableInfo tableInfo = headerInfo.getParent();
                ArrayList hlist = (ArrayList)tableInfo.getHeaders();
                ArrayList clist = (ArrayList)tableInfo.getColumns();
                ArrayList cclist = (ArrayList)clist.clone();
                boolean cando = false;
                if (hlist.size() == 1) {
                    cando = true;
                }
                ArrayList cl = (ArrayList)list.clone();
                int j = cl.size();
                for (int i = 0; i < j; ++i) {
                    cellInfo = (CellInfo)cl.get(i);
                    ColumnInfo columnInfo = (ColumnInfo)cclist.get(i);
                    if (i == currentIndex) {
                        list.set(0, cellInfo);
                        if (!cando) continue;
                        clist.set(0, columnInfo);
                        columnInfo.setIndex(0);
                        continue;
                    }
                    if (i >= currentIndex) continue;
                    list.set(i + 1, cellInfo);
                    if (!cando) continue;
                    clist.set(i + 1, columnInfo);
                    columnInfo.setIndex(i + 1);
                }
            }
            this.refreshTreeAndLocateCurrentSelected();
            if (this.context != null) {
                this.context.setDirty(true);
            }
        }
    }

    protected void topActionByColumn(ColumnInfo columnInfo) {
        TableInfo tableInfo = columnInfo.getParent();
        ArrayList list = (ArrayList)tableInfo.getColumns();
        int currentIndex = list.indexOf(columnInfo);
        if (currentIndex <= 0 || currentIndex > list.size() - 1) {
            return;
        }
        ArrayList hlist = (ArrayList)tableInfo.getHeaders();
        boolean cando = false;
        if (hlist.size() == 1) {
            cando = true;
        }
        ArrayList cellList = null;
        ArrayList ccl = null;
        if (cando) {
            HeaderInfo header = (HeaderInfo)hlist.get(0);
            cellList = header.getCells();
            ccl = (ArrayList)cellList.clone();
        }
        ArrayList cl = (ArrayList)list.clone();
        int j = cl.size();
        for (int i = 0; i < j; ++i) {
            columnInfo = (ColumnInfo)cl.get(i);
            if (i == currentIndex) {
                list.set(0, columnInfo);
                columnInfo.setIndex(0);
                if (!cando || i >= ccl.size()) continue;
                cellList.set(0, ccl.get(i));
                continue;
            }
            if (i >= currentIndex) continue;
            list.set(i + 1, columnInfo);
            columnInfo.setIndex(i + 1);
            if (!cando || i >= ccl.size()) continue;
            cellList.set(i + 1, ccl.get(i));
        }
    }

    @Override
    protected void butBottom_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() != null) {
            Object element = treeNode.getUserObject();
            if (element instanceof ColumnInfo) {
                ColumnInfo columnInfo = (ColumnInfo)element;
                this.bottomActionByColumn(columnInfo);
            } else if (element instanceof HeaderInfo) {
                HeaderInfo headerInfo = (HeaderInfo)element;
                TableInfo tableInfo = headerInfo.getParent();
                ArrayList list = (ArrayList)tableInfo.getHeaders();
                int currentIndex = list.indexOf(headerInfo);
                if (currentIndex < 0 || currentIndex >= list.size() - 1) {
                    return;
                }
                ArrayList cl = (ArrayList)list.clone();
                int j = cl.size();
                for (int i = 0; i < j; ++i) {
                    headerInfo = (HeaderInfo)cl.get(i);
                    if (i == currentIndex) {
                        list.set(j - 1, headerInfo);
                        continue;
                    }
                    if (i <= currentIndex) continue;
                    list.set(i - 1, headerInfo);
                }
            } else if (element instanceof CellInfo) {
                CellInfo cellInfo = (CellInfo)element;
                HeaderInfo headerInfo = cellInfo.getParent();
                ArrayList list = headerInfo.getCells();
                int currentIndex = list.indexOf(cellInfo);
                if (currentIndex < 0 || currentIndex >= list.size() - 1) {
                    return;
                }
                TableInfo tableInfo = headerInfo.getParent();
                ArrayList headerList = (ArrayList)tableInfo.getHeaders();
                ArrayList clist = (ArrayList)tableInfo.getColumns();
                ArrayList cclist = (ArrayList)clist.clone();
                boolean cando = false;
                if (headerList.size() == 1) {
                    cando = true;
                }
                ArrayList cl = (ArrayList)list.clone();
                int j = cl.size();
                for (int i = 0; i < j; ++i) {
                    cellInfo = (CellInfo)cl.get(i);
                    if (i == currentIndex) {
                        list.set(j - 1, cellInfo);
                        if (!cando) continue;
                        clist.set(j - 1, cclist.get(i));
                        ((ColumnInfo)clist.get(j - 1)).setIndex(j - 1);
                        continue;
                    }
                    if (i <= currentIndex) continue;
                    list.set(i - 1, cellInfo);
                    if (!cando) continue;
                    clist.set(i - 1, cclist.get(i));
                    ((ColumnInfo)clist.get(i - 1)).setIndex(i - 1);
                }
            }
            this.refreshTreeAndLocateCurrentSelected();
            if (this.context != null) {
                this.context.setDirty(true);
            }
        }
    }

    protected void bottomActionByColumn(ColumnInfo columnInfo) {
        TableInfo tableInfo = columnInfo.getParent();
        ArrayList list = (ArrayList)tableInfo.getColumns();
        int currentIndex = list.indexOf(columnInfo);
        if (currentIndex < 0 || currentIndex >= list.size() - 1) {
            return;
        }
        ArrayList cl = (ArrayList)list.clone();
        ArrayList hlist = (ArrayList)tableInfo.getHeaders();
        boolean cando = false;
        if (hlist.size() == 1) {
            cando = true;
        }
        ArrayList cellList = null;
        ArrayList ccl = null;
        if (cando) {
            HeaderInfo header = (HeaderInfo)hlist.get(0);
            cellList = header.getCells();
            ccl = (ArrayList)cellList.clone();
        }
        int j = cl.size();
        for (int i = 0; i < j; ++i) {
            columnInfo = (ColumnInfo)cl.get(i);
            if (i == currentIndex) {
                list.set(j - 1, columnInfo);
                columnInfo.setIndex(j - 1);
                if (!cando) continue;
                cellList.set(j - 1, ccl.get(i));
                continue;
            }
            if (i <= currentIndex) continue;
            list.set(i - 1, columnInfo);
            columnInfo.setIndex(i - 1);
            if (!cando) continue;
            cellList.set(i - 1, ccl.get(i));
        }
    }

    @Override
    protected void tableList_editStopped(KDTEditEvent e) throws Exception {
        IRow row = this.tableList.getRow(e.getRowIndex());
        ICell cell = row.getCell(e.getColIndex());
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode != null) {
            if (newValue == null && oldValue == null || newValue == null && "".equals(oldValue.toString()) || newValue != null && oldValue != null && newValue.toString().equals(oldValue.toString())) {
                return;
            }
            if (this.context != null) {
                this.context.setDirty(true);
            }
            if (TREE_TABLE.equals(treeNode.getUserObject())) {
                if (!this.storeTableInfo2TableList(this.kdTable, row.getUserObject(), newValue)) {
                    cell.setValue(oldValue);
                } else {
                    this.refreshTreeAndLocateCurrentSelected();
                }
            } else if (treeNode.getUserObject() instanceof ColumnInfo) {
                if (COLUMN_HEAD.equals(row.getUserObject())) {
                    int index = -1;
                    List columns = this.kdTable.getColumns();
                    int n = columns.size();
                    for (int i = 0; i < n; ++i) {
                        if (!columns.get(i).equals(treeNode.getUserObject())) continue;
                        index = i;
                        break;
                    }
                    if (index != -1 && !StringUtils.isEmpty((String)((String)newValue))) {
                        String title = ((String)newValue).trim();
                        String headName = (String)row.getCell(TABLE_PROPERTY).getValue();
                        headName = headName.replaceFirst("head", "");
                        List headers = this.kdTable.getHeaders();
                        int n2 = headers.size();
                        for (int i = 0; i < n2; ++i) {
                            if (!headName.equals(i == 0 ? "" : "" + i)) continue;
                            HeaderInfo headerInfo = (HeaderInfo)headers.get(i);
                            ((CellInfo)headerInfo.getCells().get(index)).setName(title);
                            break;
                        }
                    }
                } else if (!this.storeColumnInfo2TableList((ColumnInfo)treeNode.getUserObject(), row.getUserObject(), newValue)) {
                    cell.setValue(oldValue);
                } else {
                    this.refreshTreeAndLocateCurrentSelected();
                }
            } else if (treeNode.getUserObject() instanceof HeaderInfo) {
                if (!this.storeHeaderInfo2TableList((HeaderInfo)treeNode.getUserObject(), row.getUserObject(), newValue)) {
                    cell.setValue(oldValue);
                } else {
                    this.refreshTreeAndLocateCurrentSelected();
                }
            } else if (treeNode.getUserObject() instanceof CellInfo) {
                if (!this.storeCellInfo2TableList((CellInfo)treeNode.getUserObject(), row.getUserObject(), newValue)) {
                    cell.setValue(oldValue);
                } else {
                    this.refreshTreeAndLocateCurrentSelected();
                }
            } else if (treeNode.getUserObject() instanceof MergeBlockInfo) {
                if (!this.storeMergeInfo2TableList(this.kdTable, (MergeBlockInfo)treeNode.getUserObject(), row.getUserObject(), newValue)) {
                    cell.setValue(oldValue);
                } else {
                    this.refreshTreeAndLocateCurrentSelected();
                }
            }
        }
    }

    @Override
    protected void tableList_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    protected void tableList_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected boolean locateCurrentNode(DefaultKingdeeTreeNode root, Object userObj) {
        if (this.tree != null && root != null && userObj != null) {
            if (root.getUserObject().equals(userObj)) {
                this.tree.setSelectionNode(root);
                return true;
            }
            Enumeration children = root.children();
            while (children.hasMoreElements()) {
                DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)children.nextElement();
                boolean ret = this.locateCurrentNode(child, userObj);
                if (!ret) continue;
                return true;
            }
        }
        return false;
    }

    public String getExitStatus() {
        return this.EXIT_STATUS;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public KDTable getTable() {
        return this.tableList;
    }
}

