/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.kdtable;

import com.kingdee.bos.ctrl.kdf.table.BasicView;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IRows;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTIndexColumnView;
import com.kingdee.bos.ctrl.kdf.table.KDTViewManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDIntTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.webui.transfer.UIType;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.EditorType;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.model.ComboBoxItem;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.BizRuleCellEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.ColumnFilterItemsEditor;
import com.kingdee.eas.ep.client.editor.kdtable.AbstractTableDesignerUI;
import com.kingdee.eas.ep.client.editor.kdtable.KDTTableView;
import com.kingdee.eas.ep.client.model.BizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.util.EntriesManagerUtils;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class TableDesignerUI
extends AbstractTableDesignerUI {
    private static final Logger logger = CoreUIObject.getLogger(TableDesignerUI.class);
    public static final String KDTABLE = "kdtable";
    protected String EXIT_STATUS = null;
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";
    protected static final String NAMECOLUMN = "nameColumn";
    protected static final String HEADCOLUMN = "headColumn";
    protected static final String WIDTHCOLUMN = "widthColumn";
    protected static final String HIDECOLUMN = "hideColumn";
    protected static final String LOCKCOLUMN = "lockColumn";
    protected static final String FORMATSTRCOLUMN = "formatStrColumn";
    protected static final String ALIGNCOLUMN = "alignColumn";
    protected static final String MERGEABLECOL = "mergeableCol";
    protected static final String RESIZEABLECOL = "resizeableCol";
    protected static final String MOVEABLECOL = "moveableCol";
    protected static final String GROUPCOL = "groupCol";
    protected static final String REQUIREDCOL = "requiredCol";
    protected static final String SUMCOLUMN = "sumColumn";
    public static final String UITYPE = "uitype";
    public static final String QUERYINFO = "queryInfo";
    public static final String ISDISPLAYEVENT = "isDisplayEvent";
    private static final String DYNPROPERTYBINDS = "dynpropertybinds";
    protected static final String F7FILTERITEM = "f7FilterItem";
    private EntityObjectInfo bindEntity;
    protected UIType uitype;
    protected Context context;
    protected TableInfo kdTable;
    private List enumList = new ArrayList();
    private ComponentInfo tableComponent;
    private PropertyBindingCollection bindCollection;
    private QueryInfo queryInfo;
    PropertyUnitCollection unitCol;
    private HeaderInfo headInfo = null;
    protected BizConfigureItemCollection configureItemCol;
    protected BizConfigureItemInfo configureItemInfo;
    private boolean isDisplayEvent = true;

    public TableDesignerUI() throws Exception {
        KDTViewManager viewManager = this.table.getViewManager();
        for (int i = viewManager.getViewCount() - 1; i >= 0; --i) {
            if (!(viewManager.getView(i) instanceof KDTIndexColumnView)) continue;
            this.table.getViewManager().removeView((i - 1) / this.table.getHorizonCount(), 1);
            KDTTableView view = new KDTTableView(this, this.table, this.table.getIndexColumn(), this.table.getColumns(), (IRows)this.table.getBody());
            this.table.getViewManager().addView((i - 1) / this.table.getHorizonCount(), 1, (BasicView)view);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle("\u8868\u683c\u8bbe\u7f6e");
        Object object = this.getUIContext().get(KDTABLE);
        this.kdTable = object instanceof TableInfo ? (TableInfo)object : new TableInfo();
        if (this.getUIContext().get(UITYPE) != null) {
            this.uitype = (UIType)this.getUIContext().get(UITYPE);
        }
        if (this.getUIContext().get("context") != null) {
            this.context = (Context)this.getUIContext().get("context");
        }
        if (this.getUIContext().get("bizConfigureItemCol") != null) {
            this.configureItemCol = (BizConfigureItemCollection)((Object)this.getUIContext().get("bizConfigureItemCol"));
        }
        if (this.getUIContext().get(ISDISPLAYEVENT) != null) {
            this.isDisplayEvent = (Boolean)this.getUIContext().get(ISDISPLAYEVENT);
        }
        this.table.checkParsed();
        if (UIType.LISTUI.equals((Object)this.uitype)) {
            this.table.getColumn(REQUIREDCOL).getStyleAttributes().setHided(true);
            this.table.getColumn(LOCKCOLUMN).getStyleAttributes().setHided(true);
            this.queryInfo = (QueryInfo)this.getUIContext().get(QUERYINFO);
            IUIEditor editor = this.context.getEditorUI();
            if (editor instanceof EditUIEditor) {
                ((EditUIEditor)editor).getMetas().add(this.queryInfo);
            }
            this.unitCol = this.queryInfo.getUnits();
            this.table.getColumn(SUMCOLUMN).getStyleAttributes().setHided(false);
        } else if (UIType.EDITUI.equals((Object)this.uitype)) {
            this.table.getColumn(F7FILTERITEM).getStyleAttributes().setHided(false);
            if (this.getUIContext().get("entity") != null) {
                this.bindEntity = (EntityObjectInfo)this.getUIContext().get("entity");
            }
        }
        if (this.isDisplayEvent) {
            this.table.getColumn("event").getStyleAttributes().setHided(false);
            this.table.getHeadRow(0).getCell("event").setValue((Object)"\u503c\u66f4\u65b0\u4e8b\u4ef6");
        } else {
            this.table.getColumn("event").getStyleAttributes().setHided(true);
        }
        this.setColumnEditor();
        this.tableComponent = (ComponentInfo)this.getUIContext().get("Table");
        this.bindCollection = TableDesignerUI.getPropertyMap(this.tableComponent);
        this.loadData();
    }

    public static PropertyBindingCollection getPropertyMap(ComponentInfo table) {
        if (table != null) {
            return table.getPropertyBindings();
        }
        return null;
    }

    private void setColumnEditor() {
        KDTextField txtName = new KDTextField();
        txtName.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                JTextField textField;
                if (Character.getNumericValue(e.getKeyChar()) == -1 && e.getKeyChar() != '\b') {
                    e.consume();
                }
                if ((textField = (JTextField)e.getSource()).getCaretPosition() == 0) {
                    e.setKeyChar(Character.toLowerCase(e.getKeyChar()));
                }
            }
        });
        this.table.getColumn(NAMECOLUMN).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtName));
        KDIntTextField intEditor = new KDIntTextField();
        intEditor.setPrecision(0);
        intEditor.setMinimumValue((Comparable)new Integer(1));
        intEditor.setMaximumValue((Comparable)new Integer(1000));
        this.table.getColumn(WIDTHCOLUMN).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)intEditor));
        KDCheckBox booleanBoxEditor = new KDCheckBox();
        this.table.getColumn(HIDECOLUMN).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)booleanBoxEditor));
        this.table.getColumn(LOCKCOLUMN).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)booleanBoxEditor));
        KDComboBox enumBox = new KDComboBox();
        this.enumList.add(new ComboBoxItem("left", "\u5de6\u5bf9\u9f50"));
        this.enumList.add(new ComboBoxItem("center", "\u5c45\u4e2d"));
        this.enumList.add(new ComboBoxItem("right", "\u53f3\u5bf9\u9f50"));
        enumBox.addItems(this.enumList.toArray());
        enumBox.putClientProperty((Object)"jump", (Object)"false");
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)enumBox);
        this.table.getColumn(ALIGNCOLUMN).setEditor((ICellEditor)kdtDefaultCellEditor);
        this.table.getColumn(MERGEABLECOL).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)booleanBoxEditor));
        this.table.getColumn(RESIZEABLECOL).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)booleanBoxEditor));
        this.table.getColumn(MOVEABLECOL).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)booleanBoxEditor));
        this.table.getColumn(GROUPCOL).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)booleanBoxEditor));
        this.table.getColumn(REQUIREDCOL).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)booleanBoxEditor));
        this.table.getColumn(SUMCOLUMN).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)booleanBoxEditor));
    }

    public void loadData() {
        this.table.removeRows();
        List headers = this.kdTable.getHeaders();
        List columns = this.kdTable.getColumns();
        if (headers.size() < 1 && columns.size() > 0) {
            this.addHeader();
        }
        if (headers.size() > 0) {
            this.headInfo = (HeaderInfo)headers.get(headers.size() - 1);
        }
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            PropertyBindingInfo bindingInfo;
            int j;
            ColumnInfo columnInfo = (ColumnInfo)columns.get(i);
            IRow row = this.table.addRow();
            row.setUserObject((Object)columnInfo);
            row.getCell(NAMECOLUMN).setValue((Object)columnInfo.getName());
            if (i < this.headInfo.getCellCount() && this.headInfo.getCells().get(i) != null) {
                row.getCell(HEADCOLUMN).setValue((Object)((CellInfo)this.headInfo.getCells().get(i)).getName());
            } else {
                row.getCell(HEADCOLUMN).setValue((Object)"");
            }
            if (columnInfo.getWidth() == -1) {
                row.getCell(WIDTHCOLUMN).setValue((Object)new Integer(100));
            } else {
                row.getCell(WIDTHCOLUMN).setValue((Object)new Integer(columnInfo.getWidth()));
            }
            row.getCell(HIDECOLUMN).setValue((Object)new Boolean(columnInfo.isHide()));
            row.getCell(LOCKCOLUMN).setValue((Object)new Boolean(columnInfo.isLock()));
            row.getCell(FORMATSTRCOLUMN).setValue((Object)columnInfo.getFormatString());
            if (columnInfo.isHide() || columnInfo.isLock()) {
                row.getCell(REQUIREDCOL).getStyleAttributes().setLocked(true);
            }
            int m = this.enumList.size();
            for (j = 0; j < m; ++j) {
                if (!columnInfo.getHorizonAlign().equals(((ComboBoxItem)this.enumList.get(j)).getValue())) continue;
                row.getCell(ALIGNCOLUMN).setValue(this.enumList.get(j));
                break;
            }
            if (columnInfo.isConfigured()) {
                row.getStyleAttributes().setFontColor(Color.BLUE);
            }
            row.getCell(MERGEABLECOL).setValue((Object)new Boolean(columnInfo.isMergeable()));
            row.getCell(RESIZEABLECOL).setValue((Object)new Boolean(columnInfo.isResizeable()));
            row.getCell(MOVEABLECOL).setValue((Object)new Boolean(columnInfo.isMoveable()));
            row.getCell(GROUPCOL).setValue((Object)new Boolean(columnInfo.isGroup()));
            row.getCell(REQUIREDCOL).setValue((Object)new Boolean(columnInfo.isRequired()));
            if (UIType.LISTUI.equals((Object)this.uitype)) {
                row.getCell(SUMCOLUMN).setValue((Object)new Boolean(this.getColumnSumInfo(columnInfo)));
            } else if (UIType.EDITUI.equals((Object)this.uitype) && this.bindEntity != null && (bindingInfo = this.bindCollection.get(columnInfo.getName() + ".text")) != null) {
                String bindingField = bindingInfo.getBingdingField();
                PropertyInfo propertyInfo = this.bindEntity.getPropertyByName(bindingField = bindingField.substring(bindingField.lastIndexOf(".") + 1));
                if (propertyInfo instanceof LinkPropertyInfo) {
                    row.getCell(F7FILTERITEM).setValue((Object)columnInfo.getExtendedProperty(F7FILTERITEM));
                    row.getCell(F7FILTERITEM).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)new ColumnFilterItemsEditor(this.context, propertyInfo)));
                } else {
                    row.getCell(F7FILTERITEM).getStyleAttributes().setLocked(true);
                }
            }
            if (this.configureItemCol == null || this.configureItemCol.size() == 0) continue;
            m = this.configureItemCol.size();
            for (j = 0; j < m; ++j) {
                BizConfigureItemInfo info = (BizConfigureItemInfo)this.configureItemCol.get(j);
                if (!info.getName().equals(columnInfo.getName())) continue;
                this.configureItemInfo = info;
            }
            ICell eventCell = row.getCell("event");
            if (this.context.getEditorType() != EditorType.baseLayout) continue;
            MyBizRuleCellEditor event = new MyBizRuleCellEditor(this.configureItemInfo, this.context);
            eventCell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)event));
            eventCell.setValue((Object)event.getAsText());
        }
    }

    protected boolean getColumnSumInfo(ColumnInfo columnInfo) {
        String value;
        QueryFieldInfo queryFieldInfo = this.getQueryFieldInfo(columnInfo);
        return queryFieldInfo != null && (value = queryFieldInfo.getExtendedProperty("isSumField")) != null && value.equalsIgnoreCase("true");
    }

    protected QueryFieldInfo getQueryFieldInfo(ColumnInfo columnInfo) {
        PropertyBindingInfo bindingInfo = this.bindCollection.get(columnInfo.getName() + ".text");
        if (bindingInfo != null) {
            String bindingField = bindingInfo.getBingdingField();
            return (QueryFieldInfo)this.unitCol.get(bindingField);
        }
        return null;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        this.addColumn();
        this.loadData();
        IRow row = this.table.getRow(this.table.getRowCount() - 1);
        this.table.getSelectManager().select(this.table.getRowCount(), -1);
        this.table.scrollToVisible(this.table.getRowCount(), 0);
        row.getStyleAttributes().setFontColor(Color.BLUE);
        if (this.context != null) {
            this.context.setDirty(true);
        }
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.table);
        StringBuffer alias = new StringBuffer();
        if (this.isAllConfigured()) {
            for (int i = rowIndex.length - 1; i >= 0; --i) {
                IRow row = this.table.getRow(rowIndex[i]);
                if (row.getCell(HEADCOLUMN).getValue() == null || row.getCell(HEADCOLUMN).getValue().equals("")) {
                    alias.append(row.getCell(NAMECOLUMN).getValue());
                } else {
                    alias.append(row.getCell(HEADCOLUMN).getValue());
                }
                if (i <= 0) continue;
                alias.append(";");
            }
            int confirm = MsgBox.showConfirm2((String)("\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\u3010" + alias + "\u3011"));
            if (confirm != 0) {
                return;
            }
            for (int i = rowIndex.length - 1; i >= 0; --i) {
                IRow row = this.table.getRow(rowIndex[i]);
                if (row.getUserObject() != null) {
                    int currentIndex = this.kdTable.getColumns().indexOf((ColumnInfo)row.getUserObject());
                    this.kdTable.removeColumn((ColumnInfo)row.getUserObject());
                    this.removeCell(currentIndex);
                }
                EntriesManagerUtils.deleteBindData(this.tableComponent, ((ColumnInfo)row.getUserObject()).getName());
                this.table.removeRow(rowIndex[i]);
            }
            if (this.context != null) {
                this.context.setDirty(true);
            }
        }
    }

    private boolean isAllConfigured() {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.table);
        StringBuffer alias = new StringBuffer();
        if (rowIndex.length > 0) {
            for (int i = rowIndex.length - 1; i >= 0; --i) {
                IRow row = this.table.getRow(rowIndex[i]);
                if (((ColumnInfo)row.getUserObject()).isConfigured()) continue;
                if (row.getCell(HEADCOLUMN).getValue() == null || row.getCell(HEADCOLUMN).getValue().equals("")) {
                    alias.append(row.getCell(NAMECOLUMN).getValue());
                } else {
                    alias.append(row.getCell(HEADCOLUMN).getValue());
                }
                if (i <= 0) continue;
                alias.append(";");
            }
            if (alias.toString().length() > 0) {
                MsgBox.showInfo((String)("\u3010" + alias + "\u3011\u975e\u52a8\u6001\u5b57\u6bb5\u4e0d\u53ef\u5220\u9664,\u8bf7\u91cd\u65b0\u9009\u62e9!"));
                return false;
            }
            return true;
        }
        MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u5b57\u6bb5");
        return false;
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.btnUp_actionPerformed(e);
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.table);
        int j = rowIndex.length;
        for (i = 0; i < j; ++i) {
            if (rowIndex[i] <= i) continue;
            IRow row = this.table.getRow(rowIndex[i]);
            KDTTableView.actionByColumn((ColumnInfo)row.getUserObject(), -1);
        }
        this.loadData();
        j = rowIndex.length;
        for (i = 0; i < j; ++i) {
            int top = rowIndex[i];
            if (rowIndex[i] > i) {
                top = rowIndex[i] - 1;
            }
            if (i == 0) {
                this.table.getSelectManager().select(top, -1, top, this.table.getColumnCount());
                this.table.scrollToVisible(top + rowIndex.length - 1, 0);
                continue;
            }
            this.table.getSelectManager().add(top, -1, top, this.table.getColumnCount());
        }
        if (this.context != null) {
            this.context.setDirty(true);
        }
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.btnDown_actionPerformed(e);
        int maxIndex = this.table.getRowCount() - 1;
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.table);
        for (i = rowIndex.length - 1; i >= 0; --i) {
            if (rowIndex[i] < maxIndex) {
                IRow row = this.table.getRow(rowIndex[i]);
                KDTTableView.actionByColumn((ColumnInfo)row.getUserObject(), 1);
            }
            --maxIndex;
        }
        this.loadData();
        maxIndex = this.table.getRowCount() - 1;
        for (i = rowIndex.length - 1; i >= 0; --i) {
            int top = rowIndex[i];
            if (rowIndex[i] < maxIndex) {
                top = rowIndex[i] + 1;
            }
            if (i == rowIndex.length - 1) {
                this.table.getSelectManager().select(top, -1, top, this.table.getColumnCount());
                this.table.scrollToVisible(top, 0);
            } else {
                this.table.getSelectManager().add(top, -1, top, this.table.getColumnCount());
            }
            --maxIndex;
        }
        if (this.context != null) {
            this.context.setDirty(true);
        }
    }

    @Override
    protected void btnTop_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.btnTop_actionPerformed(e);
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.table);
        int j = rowIndex.length;
        for (i = 0; i < j; ++i) {
            if (rowIndex[i] <= i) continue;
            IRow row = this.table.getRow(rowIndex[i]);
            KDTTableView.actionByColumn((ColumnInfo)row.getUserObject(), -(rowIndex[i] - i));
        }
        this.loadData();
        j = rowIndex.length;
        for (i = 0; i < j; ++i) {
            if (i == 0) {
                this.table.getSelectManager().select(i, -1, i, this.table.getColumnCount());
                this.table.scrollToVisible(0, 0);
                continue;
            }
            this.table.getSelectManager().add(i, -1, i, this.table.getColumnCount());
        }
        if (this.context != null) {
            this.context.setDirty(true);
        }
    }

    @Override
    protected void btnBottom_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.btnBottom_actionPerformed(e);
        int maxIndex = this.table.getRowCount() - 1;
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.table);
        for (i = rowIndex.length - 1; i >= 0; --i) {
            if (rowIndex[i] < maxIndex) {
                IRow row = this.table.getRow(rowIndex[i]);
                KDTTableView.actionByColumn((ColumnInfo)row.getUserObject(), maxIndex - rowIndex[i]);
            }
            --maxIndex;
        }
        this.loadData();
        maxIndex = this.table.getRowCount() - 1;
        for (i = rowIndex.length - 1; i >= 0; --i) {
            if (i == rowIndex.length - 1) {
                this.table.getSelectManager().select(maxIndex, -1, maxIndex, this.table.getColumnCount());
                this.table.scrollToVisible(maxIndex, 0);
            } else {
                this.table.getSelectManager().add(maxIndex, -1, maxIndex, this.table.getColumnCount());
            }
            --maxIndex;
        }
        if (this.context != null) {
            this.context.setDirty(true);
        }
    }

    private void addHeader() {
        HeaderInfo header = new HeaderInfo(this.kdTable);
        header.setName("header" + (this.kdTable.getHeaderCount() + 1));
        header.setConfigured(true);
        this.kdTable.addHeader(header);
    }

    private void addColumn() {
        ColumnInfo column = new ColumnInfo(this.kdTable);
        String name = "column" + (this.table.getRowCount() + 1);
        if (!EntriesManagerUtils.isValidateName(this.kdTable, name, this.kdTable.getColumnCount())) {
            name = EntriesManagerUtils.getNameByName(this.kdTable, "column", this.table.getRowCount() + 2);
        }
        column.setName(name);
        column.setWidth(100);
        column.setHide(false);
        column.setLock(false);
        column.setMergeable(true);
        column.setResizeable(true);
        column.setMoveable(true);
        column.setGroup(false);
        column.setRequired(false);
        if (this.enumList != null && this.enumList.size() > 0) {
            column.setHorizonAlign(((ComboBoxItem)this.enumList.get(0)).getValue().toString());
        }
        column.setConfigured(true);
        this.kdTable.addColumn(column);
        List headers = this.kdTable.getHeaders();
        if (headers.size() < 1) {
            this.addHeader();
        }
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            HeaderInfo headerInfo = (HeaderInfo)headers.get(i);
            this.addCell(headerInfo, "cell" + (headerInfo.getCellCount() + 1));
        }
    }

    private void addCell(HeaderInfo header, String headName) {
        CellInfo cell = new CellInfo(header);
        cell.setName(headName);
        cell.setConfigured(true);
        header.addCell(cell);
    }

    private void removeCell(int index) {
        List headers = this.kdTable.getHeaders();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            HeaderInfo head = (HeaderInfo)headers.get(i);
            if (index > head.getCellCount() - 1) continue;
            CellInfo cell = (CellInfo)head.getCells().get(index);
            head.removeCell(cell);
        }
    }

    private void editCell(int index, String name) {
        List headers = this.kdTable.getHeaders();
        if (headers.size() > 0) {
            int n = headers.size();
            for (int i = 0; i < n; ++i) {
                HeaderInfo head = (HeaderInfo)headers.get(i);
                if (index <= head.getCellCount() - 1) {
                    CellInfo cell = (CellInfo)head.getCells().get(index);
                    cell.setName(name);
                    continue;
                }
                if (StringUtils.isEmpty((String)name)) continue;
                this.addCell(head, name);
            }
        }
    }

    @Override
    public void table_editStopped(KDTEditEvent e) {
        if (e.getValue() == null && e.getOldValue() == null || e.getValue() == null && "".equals(e.getOldValue().toString()) || e.getValue() != null && e.getOldValue() != null && e.getValue().toString().equals(e.getOldValue().toString())) {
            return;
        }
        List columns = this.kdTable.getColumns();
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        IRow row = this.table.getRow(rowIndex);
        if (e.getColIndex() == 0 && e.getValue() == null) {
            MsgBox.showInfo((String)"\u5217\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            row.getCell(NAMECOLUMN).setValue(e.getOldValue());
            return;
        }
        if (e.getColIndex() == 0 && !EntriesManagerUtils.isValidateName(this.kdTable, e.getValue() == null ? "" : e.getValue().toString(), rowIndex)) {
            MsgBox.showInfo((String)"\u5217\u540d\u4e0d\u80fd\u91cd\u590d\uff01");
            row.getCell(NAMECOLUMN).setValue(e.getOldValue());
        } else {
            QueryFieldInfo queryFieldInfo;
            if (row.getCell(HIDECOLUMN).getValue().equals(true) || row.getCell(LOCKCOLUMN).getValue().equals(true)) {
                row.getCell(REQUIREDCOL).setValue((Object)false);
                row.getCell(REQUIREDCOL).getStyleAttributes().setLocked(true);
            } else {
                row.getCell(REQUIREDCOL).getStyleAttributes().setLocked(false);
            }
            ColumnInfo columnInfo = (ColumnInfo)columns.get(rowIndex);
            if (row.getCell(NAMECOLUMN).getValue() != null) {
                columnInfo.setName(row.getCell(NAMECOLUMN).getValue().toString());
            }
            Integer width = (Integer)row.getCell(WIDTHCOLUMN).getValue();
            columnInfo.setWidth(width.intValue());
            columnInfo.setHide(((Boolean)row.getCell(HIDECOLUMN).getValue()).booleanValue());
            columnInfo.setLock(((Boolean)row.getCell(LOCKCOLUMN).getValue()).booleanValue());
            columnInfo.setMergeable(((Boolean)row.getCell(MERGEABLECOL).getValue()).booleanValue());
            columnInfo.setResizeable(((Boolean)row.getCell(RESIZEABLECOL).getValue()).booleanValue());
            columnInfo.setMoveable(((Boolean)row.getCell(MOVEABLECOL).getValue()).booleanValue());
            columnInfo.setGroup(((Boolean)row.getCell(GROUPCOL).getValue()).booleanValue());
            columnInfo.setRequired(((Boolean)row.getCell(REQUIREDCOL).getValue()).booleanValue());
            columnInfo.setHorizonAlign(((ComboBoxItem)row.getCell(ALIGNCOLUMN).getValue()).getValue().toString());
            if (row.getCell(FORMATSTRCOLUMN).getValue() != null) {
                columnInfo.setFormatString(row.getCell(FORMATSTRCOLUMN).getValue().toString());
            } else {
                columnInfo.setFormatString("");
            }
            this.editCell(rowIndex, row.getCell(HEADCOLUMN).getValue() == null ? "" : row.getCell(HEADCOLUMN).getValue().toString());
            if (this.context != null) {
                this.context.setDirty(true);
            }
            if (this.bindCollection != null) {
                PropertyBindingInfo bindingInfo;
                if (e.getColIndex() == 0 && e.getOldValue() != null) {
                    bindingInfo = this.bindCollection.get(e.getOldValue().toString() + ".text");
                    if (bindingInfo != null && e.getValue() != null) {
                        bindingInfo.setPropertyName(e.getValue().toString() + ".text");
                        String dynBinds = this.tableComponent.getExtendedProperty(DYNPROPERTYBINDS);
                        if (columnInfo.isConfigured()) {
                            dynBinds = StringUtils.replace((String)dynBinds, (String)e.getOldValue().toString(), (String)e.getValue().toString());
                            this.tableComponent.setExtendedProperty(DYNPROPERTYBINDS, dynBinds);
                        }
                    }
                } else if (e.getColIndex() == 1 && (bindingInfo = this.bindCollection.get(columnInfo.getName() + ".text")) != null && e.getValue() != null) {
                    bindingInfo.setString("propertyAlias", e.getValue().toString());
                }
                this.bindCollection.updateIndex();
            }
            if (UIType.LISTUI.equals((Object)this.uitype) && (queryFieldInfo = this.getQueryFieldInfo(columnInfo)) != null) {
                String value = queryFieldInfo.getExtendedProperty("isSumField");
                boolean isSum = (Boolean)row.getCell(SUMCOLUMN).getValue();
                if (isSum) {
                    queryFieldInfo.setExtendedProperty("isSumField", "true");
                } else if (!isSum && value != null) {
                    queryFieldInfo.setExtendedProperty("isSumField", "false");
                }
            }
            columnInfo.setExtendedProperty(F7FILTERITEM, row.getCell(F7FILTERITEM).getValue() == null ? "" : row.getCell(F7FILTERITEM).getValue().toString());
        }
    }

    public void table_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        int rowIndex;
        IRow row;
        if (e.getColumnIndex() == 0 && (row = this.table.getRow(rowIndex = this.table.getSelectManager().getActiveRowIndex())) != null && row.getUserObject() != null) {
            if (((ColumnInfo)row.getUserObject()).isConfigured()) {
                this.table.getColumn(NAMECOLUMN).getStyleAttributes().setLocked(false);
            } else {
                this.table.getColumn(NAMECOLUMN).getStyleAttributes().setLocked(true);
            }
        }
    }

    protected void disposeUIWindow() {
        this.table.getEditManager().stopEditing();
        super.disposeUIWindow();
    }

    public TableInfo getTableInfo() {
        return this.kdTable;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.kdTable = tableInfo;
    }

    public KDTable getTable() {
        return this.table;
    }

    public String getExitStatus() {
        return this.EXIT_STATUS;
    }

    public void setTableComponent(ComponentInfo tableComponent) {
        this.tableComponent = tableComponent;
        this.bindCollection = TableDesignerUI.getPropertyMap(tableComponent);
    }

    public void setBindEntity(EntityObjectInfo bindEntity) {
        this.bindEntity = bindEntity;
    }

    private class MyBizRuleCellEditor
    extends BizRuleCellEditor {
        public MyBizRuleCellEditor(BizConfigureItemInfo item, Context context) {
            super(item, context);
        }

        @Override
        public Object getValue() {
            return this.getAsText();
        }
    }
}

