/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.listui.designer.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.engine.difftool.PathsHelper;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectAssembler;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.ep.client.editor.listui.designer.model.ColumnItemData;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ListUIEditorHelper {
    private static final Logger logger = CoreUIObject.getLogger(ListUIEditorHelper.class);

    public static HashMap loadEditTable(QueryInfo queryInfo, ComponentInfo table) {
        ColumnItemData columnData;
        HashMap<String, ColumnItemData> fieldMap = new HashMap<String, ColumnItemData>();
        Map bindInfos = ListUIEditorHelper.getPropertyMap(table);
        PropertyInfo property = table.getProperties().get("formatXml");
        TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
        List columns = tableInfo.getColumns();
        for (int col = 0; col < columns.size(); ++col) {
            ColumnInfo columnInfo = (ColumnInfo)columns.get(col);
            String columnName = columnInfo.getName();
            columnData = new ColumnItemData();
            columnData.setIndex(col);
            columnData.setKey(columnName);
            if (bindInfos.get(columnInfo.getName()) != null) {
                columnData.setFieldName(bindInfos.get(columnInfo.getName()).toString());
            }
            if (tableInfo.getHeaderCount() == 1) {
                HeaderInfo headInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
                CellInfo cellInfo = null;
                if (headInfo.getCellCount() > col) {
                    cellInfo = (CellInfo)headInfo.getCells().get(col);
                }
                if (cellInfo != null) {
                    String title = cellInfo.getName();
                    columnData.setTitle(title);
                } else {
                    columnData.setTitle("");
                }
            }
            int width = columnInfo.getWidth();
            columnData.setWidth(width);
            columnData.setAlign(ListUIEditorHelper.getAlignment(columnInfo.getHorizonAlign()));
            columnData.setHidden(columnInfo.isHide());
            columnData.setLocked(columnInfo.isLock());
            fieldMap.put(columnData.getKey(), columnData);
        }
        if (queryInfo != null) {
            PropertyUnitCollection unitsCollection = queryInfo.getUnits();
            for (int i = 0; i < unitsCollection.size(); ++i) {
                PropertyUnitInfo propertyInfo = unitsCollection.get(i);
                if (!propertyInfo.isIsSelector() || ListUIEditorHelper.isExistFieldName(fieldMap, propertyInfo.getName())) continue;
                columnData = new ColumnItemData();
                columnData.setWidth(-1);
                columnData.setAlign(ListUIEditorHelper.getAlignment("left"));
                columnData.setHidden(true);
                columnData.setLocked(false);
                columnData.setTitle(propertyInfo.getName());
                columnData.setFieldName(propertyInfo.getName());
                columnData.setKey(propertyInfo.getName());
                fieldMap.put(columnData.getKey(), columnData);
            }
        }
        return fieldMap;
    }

    public static boolean isExistFieldName(Map fieldMap, String propertyName) {
        Set keySet = fieldMap.keySet();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            ColumnItemData columnData = (ColumnItemData)fieldMap.get(iterator.next());
            if (!columnData.getFieldName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public static Map getPropertyMap(ComponentInfo table) {
        HashMap<String, String> pm = new HashMap<String, String>();
        if (table != null) {
            logger.info((Object)"-----create bind map---------------");
            int n = table.getPropertyBindings().size();
            for (int j = 0; j < n; ++j) {
                PropertyBindingInfo pbInfo = table.getPropertyBindings().get(j);
                if (pbInfo.getPropertyName().indexOf(".text") < 0) continue;
                String columnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"");
                String sbindField = pbInfo.getBingdingField();
                pm.put(columnName, sbindField);
                logger.info((Object)("columnName:" + columnName + ";bindField:" + sbindField));
            }
            logger.info((Object)"-----end bind map---------------");
        }
        return pm;
    }

    public static Styles.HorizontalAlignment getAlignment(String alignment) {
        if (StringUtils.indexOfIgnoreCase((String)alignment, (String)"LEFT") >= 0) {
            return Styles.HorizontalAlignment.LEFT;
        }
        if (StringUtils.indexOfIgnoreCase((String)alignment, (String)"RIGHT") >= 0) {
            return Styles.HorizontalAlignment.RIGHT;
        }
        if (StringUtils.indexOfIgnoreCase((String)alignment, (String)"CENTER") >= 0) {
            return Styles.HorizontalAlignment.CENTER;
        }
        return Styles.HorizontalAlignment.LEFT;
    }

    public static UIObjectInfo loadUIObject(MetaDataPK pk) {
        UIObjectInfo uiObj = null;
        if (pk != null) {
            try {
                uiObj = new UIObjectCtrl(ContextManager.getContext()).getValueNotCache((IMetaDataPK)pk);
                if (!uiObj.isAssembled()) {
                    uiObj = UIObjectAssembler.assembleUI((Context)ContextManager.getContext(), (UIObjectInfo)uiObj);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return uiObj;
    }

    public static ComponentInfo getEditTable(UIObjectInfo uiObjectInfo) {
        ComponentInfo cInfo = null;
        if (uiObjectInfo != null && uiObjectInfo.getComponents() != null) {
            ComponentCollection col = uiObjectInfo.getComponents();
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                if (!"tblMain".equals(col.get(i).getName()) || !"com.kingdee.bos.ctrl.kdf.table.KDTable".equals(col.get(i).getClassType())) continue;
                cInfo = col.get(i);
                break;
            }
        }
        return cInfo;
    }

    private static String getColTitle(KDTable tb, int colIndex) {
        int rowCnt = tb.getHeadRowCount();
        String result = "";
        for (int k = 0; k < rowCnt; ++k) {
            IRow row = tb.getHeadRow(k);
            ICell cell = row.getCell(colIndex);
            Object cellValue = cell.getValue();
            if (cell.getStyleAttributes().isHided()) continue;
            if (cellValue == null) {
                if (cell.getMergeBlock() == null || cell.getMergeBlock().getRight() - cell.getMergeBlock().getLeft() <= 0) continue;
                if (result != null && result.length() > 0) {
                    result = result + "-";
                }
                result = result + String.valueOf(row.getCell(cell.getMergeBlock().getLeft()).getValue());
                continue;
            }
            String tmpValue = String.valueOf(cell.getValue());
            if (cell.getMergeBlock() != null) {
                if (cell.getMergeBlock().getRight() - cell.getMergeBlock().getLeft() > 0) {
                    tmpValue = String.valueOf(row.getCell(cell.getMergeBlock().getLeft()).getValue());
                }
                if (cell.getMergeBlock().getBottom() - cell.getMergeBlock().getTop() > 0 && result != null && result.length() > 0) {
                    tmpValue = "";
                }
            }
            if (result != null && result.length() > 0 && tmpValue.length() > 0) {
                result = result + "-";
            }
            result = result + tmpValue;
        }
        return result;
    }

    private static boolean isShow(ColumnItemData columnData) {
        return (!columnData.getKey().equals("id") || !columnData.isHidden()) && columnData.getWidth() > 0;
    }

    public static BizUnitInfo loadBizUnit(IMetaDataPK pk) {
        BizUnitInfo bizUnit = null;
        if (pk != null) {
            try {
                Context ctx = ContextManager.getContext();
                String path = (String)ctx.get((Object)"METADATAPATH");
                ctx.put((Object)"METADATAPATH", (Object)PathsHelper.expandPathstoString((String)path));
                BizUnitCtrl bizUnitCtrl = new BizUnitCtrl(ctx);
                bizUnit = bizUnitCtrl.getValue(pk);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return bizUnit;
    }

    public static QueryInfo loadQuery(IMetaDataPK pk, Project depend) {
        QueryInfo queryInfo = UictUtils.loadQuery(pk, depend);
        return queryInfo;
    }

    public static UIObjectInfo loadUIObject(String uiObjectXml) {
        UIObjectInfo uiObj = null;
        if (!StringUtils.isEmpty((String)uiObjectXml)) {
            try {
                uiObj = (UIObjectInfo)new UIObjectCtrl(ContextManager.getContext()).load((InputStream)new ByteArrayInputStream(uiObjectXml.getBytes("UTF-8")));
                uiObj.setAssembled(false);
                uiObj = UIObjectAssembler.assembleUI((Context)ContextManager.getContext(), (UIObjectInfo)uiObj);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return uiObj;
    }

    public static String getUIModelXml(UIObjectInfo uiObj) throws DataAccessException, UnsupportedEncodingException {
        if (uiObj == null) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
        new UIObjectCtrl(ContextManager.getContext()).store((IObjectValue)uiObj, (OutputStream)out);
        return new String(out.toByteArray(), "UTF-8");
    }

    public static OrgType getOrgType(String orgType) {
        if (StringUtils.isEmpty((String)orgType)) {
            return null;
        }
        List enumList = OrgType.getEnumList();
        if (enumList != null) {
            int size = enumList.size();
            for (int i = 0; i < size; ++i) {
                OrgType type = (OrgType)enumList.get(i);
                if (!type.getName().equalsIgnoreCase(orgType.trim())) continue;
                return type;
            }
        }
        return null;
    }
}

