/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.packageset;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.packageset.AbstractPackageAddUI;
import com.kingdee.eas.ep.client.editor.packageset.PackageConfigureUI;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PackageAddUI
extends AbstractPackageAddUI {
    private static final Logger logger = CoreUIObject.getLogger(PackageAddUI.class);
    private List listAllPackage = null;
    private PackageConfigureUI parent;
    private MetaDataBriefInfo parentModel;
    private PackageInfo packageInfo;
    public boolean exitStatus;

    public void onLoad() throws Exception {
        super.onLoad();
        this.packageInfo = new PackageInfo();
        this.btnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageAddUI.this.btnConfirmActionPerformed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageAddUI.this.btnCancelActionPerformed();
            }
        });
        this.tfName.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                PackageAddUI.this.tfNamePropertyChange();
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (Character.getNumericValue(e.getKeyChar()) == -1 && e.getKeyChar() != '\b') {
                    e.consume();
                }
                e.setKeyChar(Character.toLowerCase(e.getKeyChar()));
            }
        });
        this.tfAlias.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                PackageAddUI.this.tfAliasFocusGained();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.tfAlias.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                PackageAddUI.this.tfAliasPropertyChange();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.tfBaseCode.setMaxLength(3);
        this.tfBaseCode.setText("CUS");
        this.tfBaseCode.setEnabled(false);
        this.tfBaseCode.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                PackageAddUI.this.tfBaseCodePropertyChange();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.lbText.setText("\u65b0\u589e\u5305 : ");
        Map uiContext = this.getUIContext();
        if (uiContext.get("Owner") == null) {
            logger.error((Object)"parent\u8282\u70b9\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        this.parent = (PackageConfigureUI)((Object)uiContext.get("Owner"));
        if (this.parent.getSelectedTreeNode().getUserObject() == null) {
            logger.error((Object)"parent\u8282\u70b9\u5305\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        this.parentModel = (MetaDataBriefInfo)this.parent.getSelectedTreeNode().getUserObject();
        this.tfPackage.setText(this.parentModel.getPackgeName());
        this.tfPackage.setEditable(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        String name = "";
        if (this.tfName.getText() != null) {
            name = this.tfName.getText().trim();
            if (name != null || name.equals("")) {
                this.packageInfo.setName(name);
            } else {
                logger.error((Object)"\u5305\u540d\u4e3a\u7a7a");
                return;
            }
        }
        if (this.tfPackage.getText() != null) {
            String _package = this.tfPackage.getText().trim();
            this.packageInfo.setPackage(_package + "." + name);
        }
        if (this.tfAlias.getText() != null) {
            String alias = this.tfAlias.getText().trim();
            this.packageInfo.setAlias(alias);
        }
        if (this.tfDescription.getText() != null) {
            String description = this.tfDescription.getText().trim();
            this.packageInfo.setDescription(description);
        }
    }

    private boolean isValidPackageName() {
        if (this.listAllPackage == null) {
            this.listAllPackage = this.getAllChildren();
        }
        String s = this.tfName.getText().trim();
        boolean b = false;
        if (StringUtils.isEmpty((String)s)) {
            return false;
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (i == 0 && Character.isDigit(chars[i])) {
                b = false;
                break;
            }
            b = (30 >> Character.getType(chars[i]) & 1) != 0 || Character.isDigit(chars[i]);
        }
        if (b) {
            b = b && !this.listAllPackage.contains(this.getNewPackage());
        }
        return b;
    }

    private String getNewPackage() {
        String parentPackage = this.parentModel.getPackgeName();
        if (parentPackage != null && parentPackage.length() > 0) {
            return parentPackage + "." + this.tfName.getText().trim();
        }
        return this.tfName.getText().trim();
    }

    private List getAllChildren() {
        ArrayList<String> listAllPackage = new ArrayList<String>();
        DefaultKingdeeTreeNode selectNode = this.parent.getSelectedTreeNode();
        for (int i = 0; i < selectNode.getChildCount(); ++i) {
            MetaDataBriefInfo childModel;
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)selectNode.getChildAt(i);
            if (childNode.getUserObject() == null || (childModel = (MetaDataBriefInfo)childNode.getUserObject()).getPackgeName() == null) continue;
            listAllPackage.add(childModel.getPackgeName() + "." + childModel.getName());
        }
        return listAllPackage;
    }

    private void tfNamePropertyChange() {
        String alias = this.tfAlias.getText();
        String name = this.tfName.getText();
        this.tfName.setText(name.toLowerCase());
        this.tfName.setCaretPosition(this.tfName.getText().length());
        if (StringUtils.isEmpty((String)alias)) {
            this.tfAlias.setText(name.toLowerCase());
        } else if (name.startsWith(alias)) {
            this.tfAlias.setText(name.toLowerCase());
        } else if (alias.startsWith(name) && alias.length() == name.length() + 1) {
            this.tfAlias.setText(name.toLowerCase());
        }
        this.btnConfirm.setEnabled(this.verify());
    }

    private void tfAliasFocusGained() {
        String name = this.tfName.getText();
        if (name != null && name.equals(this.tfAlias.getText())) {
            this.tfAlias.selectAll();
            this.tfAlias.cut();
        }
    }

    private void tfBaseCodePropertyChange() {
        this.tfBaseCode.setText(this.tfBaseCode.getText().toUpperCase());
        this.tfBaseCode.setCaretPosition(this.tfBaseCode.getText().length());
        this.btnConfirm.setEnabled(this.verify());
    }

    public boolean isValidBasicCode(String code) {
        if (StringUtils.isEmpty((String)code) || code.length() > 3) {
            return false;
        }
        char[] chars = code.trim().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetter(chars[i]) && Character.isUpperCase(chars[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean verify() {
        if (!this.isValidPackageName() || !StringUtils.isJavaClassName((String)this.tfName.getText().trim())) {
            this.lbText.setText("\u540d\u79f0\u4e0d\u5408\u6cd5,\u540d\u79f0\u9996\u5b57\u6bcd\u4e0d\u80fd\u4e3a\u6570\u5b57\u4e14\u4e0d\u80fd\u4e3a\u5173\u952e\u5b57");
            return false;
        }
        this.lbText.setText("\u65b0\u589e\u5305 : ");
        if (this.tfAlias.getText().trim().length() == 0) {
            this.lbText.setText("\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        this.lbText.setText("\u65b0\u589e\u5305 : ");
        if (!this.isValidBasicCode(this.tfBaseCode.getText())) {
            this.lbText.setText("\u5b50\u7cfb\u7edf\u7f16\u7801\u4e0d\u5408\u6cd5");
            return false;
        }
        return true;
    }

    private void btnConfirmActionPerformed() {
        this.storeFields();
        this.exitStatus = true;
        this.destroyWindow();
    }

    private void btnCancelActionPerformed() {
        this.exitStatus = false;
        this.destroyWindow();
    }

    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    public void setPackageInfo(PackageInfo packageInfo) {
        this.packageInfo = packageInfo;
    }

    private void tfAliasPropertyChange() {
        this.verify();
    }
}

