/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.packageset;

import com.kingdee.bos.ctrl.data.wizard.icons.Icons;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.client.editor.packageset.AbstractPackageConfigureUI;
import com.kingdee.eas.ep.client.editor.packageset.PackageAddUI;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class PackageConfigureUI
extends AbstractPackageConfigureUI {
    private static final Logger logger = CoreUIObject.getLogger(PackageConfigureUI.class);
    private String customizedSchemeID;
    private Project depend;
    public static final String ID = "CUSTOMIZEDSCHEMEID";
    public static final String DEPEND = "DEPEND";
    public PackageInfo packageInfo;
    public boolean isCanceled = true;

    public PackageConfigureUI() throws Exception {
    }

    public PackageConfigureUI(String customizedSchemeID, Project depend) throws Exception {
        this.customizedSchemeID = customizedSchemeID;
        this.depend = depend;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle("\u5305\u8def\u5f84\u7ba1\u7406");
        Map uiContext = this.getUIContext();
        this.customizedSchemeID = uiContext.get(ID).toString();
        this.depend = (Project)uiContext.get(DEPEND);
        this.packageInfo = new PackageInfo();
        this.kDTreeView.setShowButton(false);
        KDWorkButton btnNew = new KDWorkButton();
        btnNew.setToolTipText("\u65b0\u589e\u4e00\u4e2a\u5305");
        btnNew.setIcon((Icon)Icons.ICN_NEW);
        btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageConfigureUI.this.beforeActionPerformed(e);
                try {
                    PackageConfigureUI.this.btnNew_actionPerformed();
                }
                catch (Exception exc) {
                    PackageConfigureUI.this.handUIException(exc);
                }
                finally {
                    PackageConfigureUI.this.afterActionPerformed(e);
                }
            }
        });
        KDWorkButton btnDel = new KDWorkButton();
        btnDel.setToolTipText("\u5220\u9664\u5f53\u524d\u9009\u4e2d\u7684\u5305");
        btnDel.setIcon((Icon)Icons.ICN_DELETE);
        btnDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageConfigureUI.this.beforeActionPerformed(e);
                try {
                    PackageConfigureUI.this.btnDel_actionPerformed();
                }
                catch (Exception exc) {
                    PackageConfigureUI.this.handUIException(exc);
                }
                finally {
                    PackageConfigureUI.this.afterActionPerformed(e);
                }
            }
        });
        this.kDTreeView.getControlPane().add((Component)btnNew);
        this.kDTreeView.getControlPane().add((Component)btnDel);
        this.loadData();
        this.btnComfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageConfigureUI.this.btnConfirmActionPerformed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageConfigureUI.this.btnCancelActionPerformed();
            }
        });
    }

    public void loadData() {
        try {
            SysContext.getSysContext().setProperty((Object)"DTKF_DEPEND", (Object)this.depend);
            DefaultKingdeeTreeNode root = SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_packages", (BOSObjectType)MetaDataTypeList.PACKAGE));
            this.kDTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
            this.kDTree.setSelectionNode(root);
        }
        finally {
            SysContext.getSysContext().setProperty((Object)"DTKF_DEPEND", null);
        }
    }

    public void btnNew_actionPerformed() {
        if (this.kDTree.getSelectionPath() == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PackageAddUI.class.getName(), (Map)uiContext);
            PackageAddUI pflu = (PackageAddUI)uiWindow.getUIObject();
            uiWindow.show();
            if (pflu.exitStatus) {
                this.packageInfo = pflu.getPackageInfo();
                if (this.packageInfo != null) {
                    IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                    SolutionInfo slnInfo = loader.getSolution();
                    Locale[] supportedLocales = slnInfo.getSupportedLocales();
                    Locale current = slnInfo.getSolutionDefaultLocale();
                    MetaDataBriefInfo userObj = new MetaDataBriefInfo(current, supportedLocales, (AbstractMetaDataValue)this.packageInfo);
                    DefaultKingdeeTreeNode node = this.packageInfo.getAlias() != null ? new DefaultKingdeeTreeNode((Object)userObj.getAlias()) : new DefaultKingdeeTreeNode((Object)userObj.getName());
                    node.setUserObject((Object)userObj);
                    UictUtils.saveMetadata((AbstractMetaDataValue)this.packageInfo, this.customizedSchemeID, this.depend);
                    this.kDTree.insertNodeInto((MutableTreeNode)node, (MutableTreeNode)this.getSelectedTreeNode(), this.getSelectedTreeNode().getChildCount());
                    this.kDTree.repaint();
                }
            }
        }
        catch (Exception e1) {
            ExceptionHandler.handleError((Component)((Object)this), e1, "\u521b\u5efapackage\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7");
        }
    }

    public void btnDel_actionPerformed() {
        MetaDataBriefInfo metadataInfo = (MetaDataBriefInfo)this.getSelectedTreeNode().getUserObject();
        String xml = UictUtils.getXml(this.depend, metadataInfo.getMetaDataPK(), MetaDataTypeList.PACKAGE);
        if (StringUtils.isEmpty((String)xml)) {
            MsgBox.showInfo((String)"\u53ea\u80fd\u5220\u9664\u5728\u6b64\u65b9\u6848\u4e2d\u6dfb\u52a0\u7684\u5305");
        } else if (MsgBox.showConfirm2((String)"\u662f\u5426\u786e\u8ba4\u5220\u9664") == 0) {
            this.deletePackage(this.getSelectedTreeNode());
            this.loadData();
        }
    }

    public void deletePackage(DefaultKingdeeTreeNode node) {
        MetaDataBriefInfo metadataInfo = (MetaDataBriefInfo)node.getUserObject();
        UictUtils.deleteMetadata(this.depend, metadataInfo.getMetaDataPK(), MetaDataTypeList.PACKAGE);
        DefaultKingdeeTreeNode childNode = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            this.deletePackage(childNode);
        }
    }

    public DefaultKingdeeTreeNode getSelectedTreeNode() {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.kDTree.getSelectionPath().getLastPathComponent();
        return treeNode;
    }

    public String getPackageFullName() {
        DefaultKingdeeTreeNode node = this.getSelectedTreeNode();
        if (node == null) {
            return null;
        }
        MetaDataBriefInfo mbf = (MetaDataBriefInfo)node.getUserObject();
        return mbf.getPackgeName();
    }

    public void btnConfirmActionPerformed() {
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    public void btnCancelActionPerformed() {
        this.isCanceled = true;
        this.getUIWindow().close();
    }
}

