/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.permission;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.MutableTreeNode;

public class FacadeTreeCreator {
    public DefaultKingdeeTreeNode create(FacadeInfo facade) {
        if (facade == null) {
            return null;
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText("root");
        FacadeEntry[] ee = this.getParents(facade);
        for (int i = 0; i < ee.length; ++i) {
            DefaultKingdeeTreeNode facadeNode = new DefaultKingdeeTreeNode();
            facadeNode.setText(ee[i].facade.getName());
            facadeNode.setUserObject((Object)ee[i].facade);
            this.createChildren(facadeNode, ee[i]);
            root.add((MutableTreeNode)facadeNode);
        }
        return root;
    }

    public void createChildren(DefaultKingdeeTreeNode facadeNode, FacadeEntry facadeEntry) {
        if (facadeNode != null && facadeEntry != null) {
            FacadeInfo entity = facadeEntry.facade;
            MethodCollection methods = entity.getMethods();
            int n = methods.size();
            for (int i = 0; i < n; ++i) {
                MethodInfo method = methods.get(i);
                DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode();
                child.setText(this.getMethodDeclares(method));
                child.setUserObject((Object)method);
                facadeNode.add((MutableTreeNode)child);
            }
        }
    }

    public FacadeEntry[] getParents(FacadeInfo facade) {
        if (facade == null) {
            return new FacadeEntry[0];
        }
        ArrayList parents = new ArrayList();
        this.listParents(parents, facade);
        FacadeEntry[] entries = new FacadeEntry[parents.size()];
        for (int i = 0; i < parents.size(); ++i) {
            FacadeInfo e = (FacadeInfo)parents.get(i);
            entries[i] = new FacadeEntry(e);
        }
        return entries;
    }

    private void listParents(List list, FacadeInfo facade) {
        FacadeInfo parent = facade.getBaseFacade();
        if (parent != null) {
            this.listParents(list, parent);
        }
        list.add(facade);
    }

    private String getMethodDeclares(MethodInfo info) {
        StringBuffer sb = new StringBuffer(info.getName());
        sb.append("(");
        ParameterCollection parmas = info.getParameters();
        for (int i = 0; i < parmas.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(parmas.get(i).getDataType());
            sb.append(" ");
            sb.append(parmas.get(i).getName());
        }
        sb.append(")");
        return sb.toString();
    }

    static class FacadeEntry {
        public FacadeInfo facade;

        public FacadeEntry(FacadeInfo facade) {
            this.facade = facade;
        }
    }

    public static class MethodEntry {
        public MethodInfo method;
        public FacadeInfo parent;

        public MethodEntry(MethodInfo m, FacadeInfo f) {
            this.method = m;
            this.parent = f;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodEntry) {
                MethodEntry that = (MethodEntry)obj;
                String otherInnerID = that.method.getString("innerID");
                String thisInnerID = this.method.getString("innerID");
                return otherInnerID.equals(thisInnerID);
            }
            return false;
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }
    }
}

