/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.permission;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeTreeUI;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.configure.Saver4;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.service.permission.PermissionType;
import com.kingdee.bos.service.permission.metadata.BizPropertyCollection;
import com.kingdee.bos.service.permission.metadata.BizPropertyInfo;
import com.kingdee.bos.service.permission.metadata.BizRefCollection;
import com.kingdee.bos.service.permission.metadata.BizRefInfo;
import com.kingdee.bos.service.permission.metadata.DependenceInfo;
import com.kingdee.bos.service.permission.metadata.EntityObjectRefInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.service.permission.metadata.RefPermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.RefPermissionItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.ICustomizedScheme;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.ExtendPropertyChooseUI;
import com.kingdee.eas.ep.client.IEditorTabPanel;
import com.kingdee.eas.ep.client.SelectBizUI;
import com.kingdee.eas.ep.client.depend.mutiLan.MutiLanUtil;
import com.kingdee.eas.ep.client.editor.editui.designer.util.CustomSchemeUtil;
import com.kingdee.eas.ep.client.editor.permission.AbstractPermissionEditor;
import com.kingdee.eas.ep.client.editor.permission.BizRefDialogUI;
import com.kingdee.eas.ep.client.editor.permission.DepenceDialogUI;
import com.kingdee.eas.ep.client.editor.permission.ExtendedPropertyDialogUI;
import com.kingdee.eas.ep.client.editor.permission.PropertyRefDialogUI;
import com.kingdee.eas.ep.client.model.extendproperty.ExdPropertyDelegate;
import com.kingdee.eas.ep.client.model.extendproperty.ReadBosConfigUtil;
import com.kingdee.eas.ep.client.util.PermissionDefineHelper;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class PermissionEditorUI
extends AbstractPermissionEditor
implements IEditorTabPanel {
    public static final String PERMISSION_INFO = "permission_info";
    private static final Logger logger = CoreUIObject.getLogger(PermissionEditorUI.class);
    private CustomizedUnitUI ui;
    private String customizedSchemeID;
    private String customizedSchemeAlias;
    private Project depend;
    private Saver4 saver4;
    private static String[] itemType = EnumUtils.getEnumNames(PermissionType.class);
    private PermissionInfo base;
    private PermissionInfo model;
    private PermissionItemInfo selectedItem;
    private DefaultKingdeeTreeNode treeRoot = new DefaultKingdeeTreeNode();
    private String oldAlias = null;
    private String oldGroup = null;

    public PermissionEditorUI(PermissionInfo base, PermissionInfo model, String customizedSchemeID, Project depend) throws Exception {
        this.initUIContentLayout();
        this.base = base;
        this.customizedSchemeID = customizedSchemeID;
        this.depend = depend;
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.saver4 = new Saver4(MetaDataLoaderFactory.getRemoteMetaDataLoader());
        for (int i = 0; i < itemType.length; ++i) {
            this.cobType.addItem((Object)itemType[i]);
        }
        if (model != null) {
            this.model = model;
            this.tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.treeRoot));
            this.refreshTreeRoot();
        }
    }

    @Override
    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.synLastSelected();
        this.refreshTreeRoot();
    }

    protected void refreshTreeRoot() {
        this.treeRoot.removeAllChildren();
        PermissionItemCollection col = this.model.getPermissionItems();
        if (col == null) {
            col = new PermissionItemCollection();
            this.model.put("permissionItems", (Object)col);
        }
        PermissionDefineHelper.generateItemTree(this.treeRoot, col);
        ((KingdeeTreeModel)this.tree.getModel()).reload();
    }

    private boolean locateCurrentNode(DefaultKingdeeTreeNode root, Object userObj) {
        if (this.tree != null && root != null && userObj != null) {
            if (root.getUserObject() == userObj) {
                this.tree.setSelectionNode(root);
                this.tree.expandPath(this.tree.getSelectionPath());
                return true;
            }
            Enumeration children = root.children();
            while (children.hasMoreElements()) {
                DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)children.nextElement();
                boolean ret = this.locateCurrentNode(child, userObj);
                if (!ret) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void tree_valueChanged(TreeSelectionEvent e) {
        DefaultKingdeeTreeNode treeNode;
        if (e.getOldLeadSelectionPath() != null && e.getOldLeadSelectionPath().getLastPathComponent() != null && (treeNode = (DefaultKingdeeTreeNode)e.getOldLeadSelectionPath().getLastPathComponent()).getUserObject() instanceof PermissionItemInfo) {
            this.storeField((PermissionItemInfo)treeNode.getUserObject());
            this.storeFields((PermissionItemInfo)treeNode.getUserObject());
        }
        treeNode = null;
        if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null) {
            treeNode = (DefaultKingdeeTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
            if (treeNode.getUserObject() instanceof PermissionItemInfo) {
                this.loadField((PermissionItemInfo)treeNode.getUserObject());
                this.selectedItem = (PermissionItemInfo)treeNode.getUserObject();
            } else {
                this.loadField(null);
                this.selectedItem = null;
            }
        }
        this.refreshGlobal();
    }

    private void synLastSelected() {
        Object userobj;
        DefaultKingdeeTreeNode selectedNode;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && (selectedNode = (DefaultKingdeeTreeNode)path.getLastPathComponent()) != null && (userobj = selectedNode.getUserObject()) instanceof PermissionItemInfo) {
            PermissionItemInfo pii = (PermissionItemInfo)userobj;
            this.storeField(pii);
            this.storeFields(pii);
        }
    }

    private void storeField(PermissionItemInfo pi) {
        if (!StringUtils.isEmpty((String)pi.getName()) || !StringUtils.isEmpty((String)this.txtName.getText())) {
            pi.setName(this.txtName.getText());
        }
        if (!StringUtils.isEmpty((String)pi.getDescription()) || !StringUtils.isEmpty((String)this.txtDes.getText())) {
            pi.setDescription(this.txtDes.getText());
        }
        pi.setType((String)this.cobType.getSelectedItem());
        if (!StringUtils.isEmpty((String)pi.getGroupName()) || !StringUtils.isEmpty((String)this.txtGroupName.getText())) {
            pi.setGroupName(this.txtGroupName.getText());
        }
    }

    private void loadField(PermissionItemInfo pi) {
        if (pi != null) {
            this.txtName.setText(pi.getName());
            this.txtAlias.setText(pi.getAlias());
            this.txtDes.setText(pi.getDescription());
            this.txtGroup.setText(pi.getGroup());
            this.txtGroupName.setText(pi.getGroupName());
            String type = pi.getType();
            if (StringUtils.isEmpty((String)type)) {
                this.cobType.setSelectedItem((Object)itemType[itemType.length - 1]);
            } else {
                this.cobType.setSelectedItem((Object)type);
            }
            EntityObjectRefInfo eori = pi.getEntityObjectMetadataRef();
            if (eori != null) {
                this.txtEntity.setText(eori.getEntityMetaInfo().getFullName());
            } else {
                this.txtEntity.setText("");
            }
            this.oldAlias = pi.getAlias();
            this.oldGroup = pi.getGroup();
        } else {
            this.txtName.setText(null);
            this.txtAlias.setText(null);
            this.txtDes.setText(null);
            this.txtGroup.setText(null);
            this.txtGroupName.setText(null);
            this.cobType.setSelectedItem((Object)itemType[itemType.length - 1]);
            this.txtEntity.setText("");
        }
    }

    @Override
    protected void btnEntity_actionPerformed(ActionEvent e) throws Exception {
        Object obj;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("selectBizType", "bizentity");
        uiContext.put("depend", this.depend);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelectBizUI.class.getName(), (Map)uiContext);
        SelectBizUI sbUI = (SelectBizUI)uiWindow.getUIObject();
        uiWindow.show();
        if ("confirm".equals(sbUI.getExitStatus()) && (obj = sbUI.getReturnValue()) != null && obj instanceof EntityObjectInfo && this.selectedItem != null) {
            EntityObjectInfo newModel = (EntityObjectInfo)obj;
            if (newModel.getType() == null) {
                logger.error((Object)("the selected entity [" + newModel.getFullName() + "] type is null"));
                return;
            }
            MetaDataInfo md = new MetaDataInfo();
            md.setPackage(newModel.getPackage());
            md.setName(newModel.getName());
            md.setMetaDataType(MetaDataTypeList.ENTITY.toString());
            EntityObjectRefInfo eori = this.selectedItem.getEntityObjectMetadataRef();
            if (eori == null) {
                eori = new EntityObjectRefInfo();
                this.selectedItem.setEntityObjectMetadataRef(eori);
            }
            eori.setEntityMetaInfo(md);
            eori.setEnitityType(newModel.getType().toString());
            String fullName = newModel.getFullName();
            this.txtEntity.setText(fullName);
        }
    }

    @Override
    protected void btnListAdd_actionPerformed(ActionEvent e) throws Exception {
        String group = null;
        String groupName = null;
        TreePath path = this.tree.getSelectionPath();
        DefaultKingdeeTreeNode selectedNode = null;
        DefaultKingdeeTreeNode parentNode = null;
        int count = this.treeRoot.getChildCount();
        if (count == 0 || path == null) {
            parentNode = this.treeRoot;
        } else {
            selectedNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (selectedNode != null) {
                Object userobj = selectedNode.getUserObject();
                if (userobj instanceof String && selectedNode.getChildCount() > 0) {
                    selectedNode = (DefaultKingdeeTreeNode)selectedNode.getChildAt(0);
                }
                parentNode = (DefaultKingdeeTreeNode)selectedNode.getParent();
                userobj = selectedNode.getUserObject();
                if (userobj instanceof PermissionItemInfo) {
                    group = ((PermissionItemInfo)userobj).getGroup();
                    groupName = ((PermissionItemInfo)userobj).getGroupName();
                } else {
                    groupName = "";
                    for (DefaultKingdeeTreeNode un = parentNode; un != null && !"root".equals(un.getText()); un = (DefaultKingdeeTreeNode)un.getParent()) {
                        groupName = !StringUtils.isEmpty((String)groupName) ? un.getText() + "." + groupName : un.getText();
                    }
                }
            }
        }
        if (StringUtils.isEmpty(group)) {
            group = "EAS\u7cfb\u7edf";
        }
        if (StringUtils.isEmpty(groupName)) {
            groupName = "EAS\u7cfb\u7edf";
        }
        PermissionItemInfo item = new PermissionItemInfo();
        item.setUserDefined(false);
        item.setName("NewPermissionItem" + this.model.getPermissionItems().size());
        item.setString("innerID", BOSUuid.create((String)"PERMITEM").toString());
        String alias = "\u65b0\u589e\u6743\u9650\u9879" + this.model.getPermissionItems().size();
        MutiLanUtil.setAllMutiLanAlias(item, alias);
        MutiLanUtil.setAllMutiLanGroup(item, group);
        item.setGroupName(groupName);
        item.setType(PermissionType.OTHER.getName());
        item.setExtendedProperty("orgRelation", "ControlUnit");
        item.setExtendedProperty("permItemType", "30");
        item.setExtendedProperty("enableDataPermission", "false");
        this.model.getPermissionItems().add(item);
        this.refreshTreeRoot();
        this.refreshGlobal();
        PermissionDefineHelper.setSelectedByUserObject(this.tree, this.treeRoot, item);
    }

    @Override
    protected void txtAlias_focusLost(FocusEvent e) throws Exception {
        DefaultKingdeeTreeNode selectedNode;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && path.getLastPathComponent() != null && (selectedNode = (DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject() != null && selectedNode.getUserObject() instanceof PermissionItemInfo) {
            selectedNode.setText(this.txtAlias.getText());
            PermissionItemInfo pi = (PermissionItemInfo)selectedNode.getUserObject();
            this.storeFields(pi);
            ((KingdeeTreeUI)this.tree.getUI()).resetSize();
            this.tree.repaint();
        }
    }

    @Override
    protected void txtGroup_focusLost(FocusEvent e) throws Exception {
        DefaultKingdeeTreeNode selectedNode;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && path.getLastPathComponent() != null && (selectedNode = (DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject() != null && selectedNode.getUserObject() instanceof PermissionItemInfo) {
            PermissionItemInfo pi = (PermissionItemInfo)selectedNode.getUserObject();
            this.storeFields(pi);
        }
    }

    private void storeFields(PermissionItemInfo pi) {
        if (!StringUtils.equals((String)this.oldAlias, (String)this.txtAlias.getText())) {
            MutiLanUtil.setAllMutiLanAlias(pi, this.txtAlias.getText());
            this.oldAlias = this.txtAlias.getText();
        }
        if (!StringUtils.equals((String)this.oldGroup, (String)this.txtGroup.getText())) {
            MutiLanUtil.setAllMutiLanGroup(pi, this.txtGroup.getText());
            this.oldGroup = this.txtGroup.getText();
        }
    }

    @Override
    protected void btnListUp_actionPerformed(ActionEvent e) throws Exception {
        super.btnListUp_actionPerformed(e);
    }

    @Override
    protected void btnListDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnListDown_actionPerformed(e);
    }

    @Override
    protected void btnListDelete_actionPerformed(ActionEvent e) throws Exception {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (selectedNode != null && selectedNode.getUserObject() instanceof PermissionItemInfo) {
            this.model.getPermissionItems().remove((PermissionItemInfo)selectedNode.getUserObject());
            this.tree.removeNodeFromParent((MutableTreeNode)selectedNode);
        }
        this.refreshGlobal();
    }

    @Override
    protected void btnBizRefAdd_actionPerformed(ActionEvent e) throws Exception {
        BizRefInfo bizRefInfo;
        if (this.selectedItem == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("depend", this.depend);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BizRefDialogUI.class.getName(), (Map)uiContext);
        BizRefDialogUI brdUI = (BizRefDialogUI)uiWindow.getUIObject();
        uiWindow.show();
        if ("confirm".equals(brdUI.getExitStatus()) && (bizRefInfo = brdUI.getBizRefInfo()) != null && bizRefInfo.getBizMetadataInfo() != null && this.selectedItem != null) {
            bizRefInfo.setUserDefined(false);
            this.selectedItem.getBizRefs().add(bizRefInfo);
        }
        this.refreshBizRef();
    }

    @Override
    protected void btnBizRefUp_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void btnBizRefDown_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void btnBizRefDelete_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.bizRefSectionTable);
        for (int i = 0; i < rowIndex.length; ++i) {
            BizRefInfo bri = (BizRefInfo)this.bizRefSectionTable.getRow(rowIndex[i]).getUserObject();
            if (bri == null || this.selectedItem == null) continue;
            this.selectedItem.getBizRefs().remove(bri);
        }
        this.refreshBizRef();
    }

    @Override
    public void bizRefSectionTable_tableSelectChanged(KDTSelectEvent e) {
        this.refreshBizProperty();
    }

    @Override
    protected void btnExtendAdd_actionPerformed(ActionEvent e) throws Exception {
        PermissionDefineHelper.ExtendPropertyInfo epi;
        ExdPropertyDelegate delegate;
        if (this.selectedItem == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("useobject", "permissionitem");
        uiContext.put("metadata", this.model);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ExtendPropertyChooseUI.class.getName(), (Map)uiContext);
        ExtendPropertyChooseUI epdUI = (ExtendPropertyChooseUI)uiWindow.getUIObject();
        epdUI.setOprtState("ADDNEW");
        uiWindow.show();
        if ("confirm".equals(epdUI.getExitStatus()) && (delegate = epdUI.getSelected()) != null && (epi = new PermissionDefineHelper.ExtendPropertyInfo(delegate.getName(), delegate.getDefaultValue())) != null && this.selectedItem != null) {
            this.selectedItem.setExtendedProperty(epi.getKey().toString(), epi.getValue().toString());
        }
        this.refreshExt();
    }

    @Override
    protected void btnExtendEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.selectedItem == null) {
            return;
        }
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.extendSectionTable);
        if (rowIndex.length > 0) {
            PermissionDefineHelper.ExtendPropertyInfo epi;
            PermissionDefineHelper.ExtendPropertyInfo exist = (PermissionDefineHelper.ExtendPropertyInfo)this.extendSectionTable.getRow(rowIndex[0]).getUserObject();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put("Owner", this);
            uiContext.put("info", exist);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ExtendedPropertyDialogUI.class.getName(), (Map)uiContext);
            ExtendedPropertyDialogUI epdUI = (ExtendedPropertyDialogUI)uiWindow.getUIObject();
            epdUI.setOprtState("EDIT");
            uiWindow.show();
            if ("confirm".equals(epdUI.getExitStatus()) && (epi = epdUI.getExt()) != null && this.selectedItem != null) {
                this.selectedItem.setExtendedProperty(epi.getKey().toString(), epi.getValue().toString());
            }
        }
        this.refreshExt();
    }

    @Override
    protected void btnExtendDelete_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.extendSectionTable);
        if (rowIndex.length > 0) {
            PermissionDefineHelper.ExtendPropertyInfo exist = (PermissionDefineHelper.ExtendPropertyInfo)this.extendSectionTable.getRow(rowIndex[0]).getUserObject();
            if (this.selectedItem != null) {
                this.selectedItem.removeExtendedProperty(exist.getKey().toString());
            }
        }
        this.refreshExt();
    }

    @Override
    protected void btnBizPropertyAdd_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.bizRefSectionTable);
        if (rowIndex.length > 0) {
            BizRefInfo bri = (BizRefInfo)this.bizRefSectionTable.getRow(rowIndex[0]).getUserObject();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put("Owner", this);
            uiContext.put("project info", this.depend);
            uiContext.put("biz ref info", bri);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PropertyRefDialogUI.class.getName(), (Map)uiContext);
            PropertyRefDialogUI brdUI = (PropertyRefDialogUI)uiWindow.getUIObject();
            uiWindow.show();
        }
        this.refreshBizProperty();
    }

    @Override
    protected void btnBizPropertyUp_actionPerformed(ActionEvent e) throws Exception {
        super.btnBizPropertyUp_actionPerformed(e);
    }

    @Override
    protected void btnBizPropertyDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnBizPropertyDown_actionPerformed(e);
    }

    @Override
    protected void btnBizPropertyDelete_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.bizRefSectionTable);
        if (rowIndex.length > 0) {
            BizRefInfo bri = (BizRefInfo)this.bizRefSectionTable.getRow(rowIndex[0]).getUserObject();
            int[] rowIndex2 = KDTableUtil.getSelectedRows((KDTable)this.bizPropertySectionTable);
            for (int i = 0; i < rowIndex2.length; ++i) {
                BizPropertyInfo bpi = (BizPropertyInfo)this.bizPropertySectionTable.getRow(rowIndex2[i]).getUserObject();
                if (bpi == null) continue;
                bri.getBizPropertys().remove(bpi);
            }
        }
        this.refreshBizProperty();
    }

    @Override
    protected void btnDepedenceAdd_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("PermissionInfo", this.model);
        uiContext.put("DependenceInfo", this.getDependenceInfo());
        uiContext.put("depend", this.depend);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DepenceDialogUI.class.getName(), (Map)uiContext);
        DepenceDialogUI depUI = (DepenceDialogUI)uiWindow.getUIObject();
        uiWindow.show();
        this.refreshDepence();
    }

    @Override
    protected void btnDepedenceUp_actionPerformed(ActionEvent e) throws Exception {
        super.btnDepedenceUp_actionPerformed(e);
    }

    @Override
    protected void btnDepedenceDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnDepedenceDown_actionPerformed(e);
    }

    @Override
    protected void btnDepedenceDelete_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.depedenceSectionTable);
        DependenceInfo di = this.getDependenceInfo();
        for (int i = 0; i < rowIndex.length; ++i) {
            RefPermissionItemInfo refing = (RefPermissionItemInfo)this.depedenceSectionTable.getRow(rowIndex[i]).getUserObject();
            if (refing == null || di == null) continue;
            di.getNewReferingItems().remove(refing);
        }
        this.refreshDepence();
    }

    private DependenceInfo getDependenceInfo() {
        if (this.selectedItem != null) {
            DependenceInfo dInfo2 = null;
            for (DependenceInfo dInfo2 : this.model.getDependences()) {
                if (dInfo2 == null || dInfo2.getReferedItem() == null || dInfo2.getReferedItem().getName() == null || !dInfo2.getReferedItem().getName().equals(this.selectedItem.getName())) continue;
                return dInfo2;
            }
            dInfo2 = new DependenceInfo();
            dInfo2.setReferedItem(this.selectedItem);
            return dInfo2;
        }
        return null;
    }

    public void refreshGlobal() {
        PermissionDefineHelper.refreshTreeText(this.treeRoot);
        this.refreshBizRef();
        this.refreshBizProperty();
        this.refreshDepence();
        this.refreshExt();
        ((KingdeeTreeUI)this.tree.getUI()).resetSize();
    }

    protected void refreshBizRef() {
        this.bizRefSectionTable.removeRows();
        if (this.selectedItem == null) {
            return;
        }
        BizRefCollection brc = this.selectedItem.getBizRefs();
        int size = brc.size();
        for (int i = 0; i < size; ++i) {
            BizRefInfo bri = brc.get(i);
            MetaDataInfo mdi = bri.getBizMetadataInfo();
            IRow row = this.bizRefSectionTable.addRow();
            row.setUserObject((Object)bri);
            row.getCell("bizRefColumn").setValue((Object)mdi.getFullName());
        }
    }

    protected void refreshBizProperty() {
        this.bizPropertySectionTable.removeRows();
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.bizRefSectionTable);
        if (rowIndex.length > 0) {
            BizRefInfo bri = (BizRefInfo)this.bizRefSectionTable.getRow(rowIndex[0]).getUserObject();
            BizPropertyCollection bpc = bri.getBizPropertys();
            int size = bpc.size();
            for (int i = 0; i < size; ++i) {
                BizPropertyInfo bpi = bpc.get(i);
                IRow row = this.bizPropertySectionTable.addRow();
                row.setUserObject((Object)bpi);
                row.getCell("bizPropertyColumn").setValue((Object)PermissionDefineHelper.getPropertyText(bpi, bri, this.depend));
            }
        }
    }

    protected void refreshDepence() {
        this.depedenceSectionTable.removeRows();
        if (this.selectedItem == null) {
            return;
        }
        DependenceInfo di = this.getDependenceInfo();
        RefPermissionItemCollection rpic = di.getNewReferingItems();
        for (RefPermissionItemInfo refing : rpic) {
            IRow row = this.depedenceSectionTable.addRow();
            row.setUserObject((Object)refing);
            PermissionInfo md = refing.getPermission();
            row.getCell("perNameColumn").setValue((Object)(md == null ? "" : md.getFullName()));
            String name = refing.getPermissionItem().getName();
            row.getCell("perItemNameColumn").setValue((Object)(name != null ? name : ""));
            String alias = refing.getPermissionItem().getAlias();
            row.getCell("perAliasColumn").setValue((Object)(alias != null ? alias : ""));
            String description = refing.getPermissionItem().getDescription();
            row.getCell("perDesColumn").setValue((Object)(description != null ? description : ""));
            row.getCell("perTypeColumn").setValue((Object)"");
        }
    }

    protected void refreshExt() {
        this.extendSectionTable.removeRows();
        if (this.selectedItem == null) {
            return;
        }
        Map extMap = this.selectedItem.getExtendedProperties();
        Set keySet = extMap.keySet();
        for (Object key : keySet) {
            Object value = extMap.get(key);
            PermissionDefineHelper.ExtendPropertyInfo epi = new PermissionDefineHelper.ExtendPropertyInfo(key, value);
            ExdPropertyDelegate deletage = ReadBosConfigUtil.getExdPropertyByName(key.toString(), (AbstractMDValue)this.model);
            if (deletage == null) {
                deletage = new ExdPropertyDelegate();
            }
            epi.setDesc(deletage.getDescription());
            IRow row = this.extendSectionTable.addRow();
            row.setUserObject((Object)epi);
            row.getCell("groupColumn").setValue((Object)deletage.getGroup());
            row.getCell("aliasColumn").setValue((Object)deletage.getAlias());
            row.getCell("nameColumn").setValue(key);
            row.getCell("valueColumn").setValue(value);
            row.getCell("typeColumn").setValue((Object)deletage.getType());
            row.getCell("requireColumn").setValue((Object)deletage.getRequired());
            row.getCell("desColumn").setValue((Object)deletage.getDescription());
        }
    }

    @Override
    public void doSave() throws Exception {
        ICustomizedScheme ics = CustomizedSchemeFactory.getRemoteInstance();
        CustomizedSchemeInfo csInfo = ics.getCustomizedSchemeInfo("where id='" + this.customizedSchemeID + "'");
        if (csInfo != null && csInfo.isStart()) {
            boolean confirm;
            boolean bl = confirm = MsgBox.showConfirm2((Component)((Object)this), (String)"\u5f53\u524d\u52a8\u6001\u6269\u5c55\u65b9\u6848\u5904\u4e8e\u542f\u52a8\u72b6\u6001\uff0c\u662f\u5426\u786e\u8ba4\u53cd\u542f\u7528\u5e76\u4fdd\u5b58\u65b9\u6848?") == 0;
            if (!confirm) {
                SysUtil.abort();
            } else {
                CustomSchemeUtil.disableScheme(this.customizedSchemeID);
                this.ui.actionCancel_actionPerformed(null);
            }
        }
        this.synLastSelected();
        PermissionItemCollection col = this.model.getPermissionItems();
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            PermissionItemInfo pi = col.get(i);
            MutiLanUtil.setAllMutiLanAlias(pi, pi.getAlias());
            MutiLanUtil.setAllMutiLanGroup(pi, pi.getGroup());
        }
        UictUtils.saveMetadata((AbstractMetaDataValue)this.model, this.customizedSchemeID, null);
        this.base = (PermissionInfo)this.model.trueClone();
        this.refreshTreeRoot();
    }

    @Override
    public void loadData() {
        this.synLastSelected();
        PermissionDefineHelper.refreshTreeText(this.treeRoot);
    }

    @Override
    public void destory() {
    }

    @Override
    public boolean isDirty() {
        try {
            return this.saver4.diffStore((AbstractMetaDataValue)this.model, (AbstractMetaDataValue)this.base) != null || this.saver4.diffStore((AbstractMetaDataValue)this.base, (AbstractMetaDataValue)this.model) != null;
        }
        catch (Exception e) {
            logger.error((Object)"Error,", (Throwable)e);
            return false;
        }
    }

    @Override
    public CustomizedUnitUI getCustomizedUnitUI() {
        return this.ui;
    }

    @Override
    public void setCustomizedUnitUI(CustomizedUnitUI ui) {
        this.ui = ui;
    }

    @Override
    public void setBosObjectType(BOSObjectType type) {
    }

    @Override
    public void setCustomizedSchemeID(String id) {
        this.customizedSchemeID = id;
    }

    public String getCustomizedSchemeID() {
        return this.customizedSchemeID;
    }

    @Override
    public void setMetadataPK(String pk) {
    }

    @Override
    public void setDepends(Project depend) {
        this.depend = depend;
    }

    @Override
    public Project getDepends() {
        return this.depend;
    }

    @Override
    public void beforeSave() throws Exception {
    }

    public void setCustomizedSchemeAlias(String customizedSchemeAlias) {
        this.customizedSchemeAlias = customizedSchemeAlias;
    }
}

