/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.query.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinItemCollection;
import com.kingdee.bos.metadata.query.JoinItemInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.eas.ep.DynQueryJoinTypeEnum;
import com.kingdee.eas.ep.client.editor.query.exception.DynQuery_NotExistException;
import com.kingdee.eas.ep.client.editor.query.model.DynQueryFieldModel;
import com.kingdee.eas.ep.client.editor.query.model.DynQueryLinkType;
import com.kingdee.eas.ep.client.editor.query.model.DynQueryUtil;
import com.kingdee.eas.ep.client.util.EntityEditorHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class DynQueryEntityTreeModel {
    private DynQueryEntityTreeModel _parentNode;
    private List _children;
    private boolean isSubmited = true;
    private boolean _isSystem = true;
    private String _bosObjectId;
    private String _name;
    private String _alias;
    private DynQueryLinkType _linkType;
    private DynQueryJoinTypeEnum joinType;
    private JoinItemCollection _oldConditions = new JoinItemCollection();
    private List _selectedFields = new ArrayList();
    private JoinQueryInfo model;
    private boolean _isSubQuery;
    public SubObjectInfo subObjectInfo;
    public JoinInfo joinInfo;

    public DynQueryEntityTreeModel getParent() {
        return this._parentNode;
    }

    private void setParent(DynQueryEntityTreeModel parent) {
        this._parentNode = parent;
    }

    private List getChildren() {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        return this._children;
    }

    public void addChild(DynQueryEntityTreeModel childNode) {
        childNode.setParent(this);
        this.getChildren().add(childNode);
    }

    public void removeChild(DynQueryEntityTreeModel childNode) {
        childNode.setParent(null);
        this.getChildren().remove(childNode);
    }

    public int getChildrenCount() {
        return this.getChildren().size();
    }

    public DynQueryEntityTreeModel getChild(int idx) {
        return (DynQueryEntityTreeModel)this.getChildren().get(idx);
    }

    public boolean isSystem() {
        return this._isSystem;
    }

    public void setSystem(boolean isSystem) {
        this._isSystem = isSystem;
    }

    public void addCondition(JoinItemInfo condition) {
        JoinItemCollection items = this.joinInfo.getJoinItems();
        items.add(condition);
    }

    public void addJoinItem(JoinItemInfo newItem) {
        if (newItem == null) {
            return;
        }
        JoinQueryInfo queryInfo = this.joinInfo.getQuery();
        JoinItemCollection joinItems = this.joinInfo.getJoinItems();
        PropertyUnitInfo leftField = newItem.getLeftField();
        PropertyUnitInfo rightField = newItem.getRightField();
        if (leftField == null || rightField == null || queryInfo.getUnits() == null) {
            return;
        }
        PropertyUnitCollection units = queryInfo.getUnits();
        if (!units.contains(leftField)) {
            units.add(newItem.getLeftField());
        }
        if (!units.contains(rightField)) {
            units.add(newItem.getRightField());
        }
        joinItems.add(newItem);
        if (!this.isSubmited) {
            queryInfo.getJoins().add(this.joinInfo);
            queryInfo.getSubObjects().add(this.joinInfo.getRightObject());
            this.isSubmited = true;
        }
    }

    public void editJoinItem(JoinItemInfo newItem, PropertyUnitInfo oldUnit, PropertyUnitInfo newUnit) {
        if (oldUnit == null || newItem == null) {
            return;
        }
        JoinQueryInfo queryInfo = this.joinInfo.getQuery();
        PropertyUnitInfo leftField = newItem.getLeftField();
        PropertyUnitInfo rightField = newItem.getRightField();
        if (leftField == null || rightField == null || queryInfo.getUnits() == null) {
            return;
        }
        PropertyUnitCollection units = queryInfo.getUnits();
        if (units.contains(oldUnit)) {
            units.remove(oldUnit);
        }
        if (!units.contains(newUnit)) {
            units.add(newUnit);
        }
    }

    public void removeJoinItem(JoinItemInfo oldItem) {
        if (oldItem == null || !this.joinInfo.getJoinItems().contains(oldItem)) {
            return;
        }
        JoinQueryInfo queryInfo = this.joinInfo.getQuery();
        PropertyUnitInfo leftField = oldItem.getLeftField();
        PropertyUnitInfo rightField = oldItem.getRightField();
        if (leftField == null || rightField == null || queryInfo.getUnits() == null) {
            return;
        }
        PropertyUnitCollection units = queryInfo.getUnits();
        if (units.contains(leftField)) {
            units.remove(leftField);
        }
        if (units.contains(rightField)) {
            units.remove(rightField);
        }
        this.joinInfo.getJoinItems().remove(oldItem);
        if (this.joinInfo.getJoinItems().size() == 0) {
            queryInfo.getJoins().remove(this.joinInfo);
            queryInfo.getSubObjects().remove(this.joinInfo.getRightObject());
            this.isSubmited = false;
        }
    }

    public void submitJoinInfo(JoinItemCollection newItems) {
        JoinItemInfo joinItemInfo;
        int i;
        JoinQueryInfo queryInfo = this.joinInfo.getQuery();
        JoinItemCollection oldItems = this._oldConditions;
        if (oldItems == null) {
            return;
        }
        int newSize = newItems.size();
        int oldSize = oldItems.size();
        if (oldSize == 0 && newSize > 0) {
            for (i = 0; i < newItems.size(); ++i) {
                joinItemInfo = newItems.get(i);
                PropertyUnitInfo leftField = joinItemInfo.getLeftField();
                PropertyUnitInfo rightField = joinItemInfo.getRightField();
                if (leftField == null || rightField == null || queryInfo.getUnits() == null) continue;
                PropertyUnitCollection units = queryInfo.getUnits();
                if (!units.contains(leftField)) {
                    units.add(joinItemInfo.getLeftField());
                }
                if (!units.contains(rightField)) {
                    units.add(joinItemInfo.getRightField());
                }
                oldItems.add(newItems.get(i));
            }
            queryInfo.getJoins().add(this.joinInfo);
            queryInfo.getSubObjects().add(this.joinInfo.getRightObject());
        }
        if (oldSize > 0 && newSize > 0) {
            for (i = 0; i < oldItems.size(); ++i) {
                joinItemInfo = oldItems.get(i);
                queryInfo.getUnits().remove(joinItemInfo.getLeftField());
                queryInfo.getUnits().remove(joinItemInfo.getRightField());
            }
            for (i = 0; i < newItems.size(); ++i) {
                joinItemInfo = newItems.get(i);
                queryInfo.getUnits().add(joinItemInfo.getLeftField());
                queryInfo.getUnits().add(joinItemInfo.getRightField());
            }
        }
        if (oldSize <= 0 || newSize == 0) {
            // empty if block
        }
        this.isSubmited = true;
    }

    public void removeAllConditions() {
        this._oldConditions.clear();
        this._oldConditions = (JoinItemCollection)this.joinInfo.getJoinItems().clone();
        this.joinInfo.getJoinItems().clear();
    }

    public void setBosObjectId(String bosType) {
        this._bosObjectId = bosType;
    }

    public String getBosObjectId() {
        return this._bosObjectId;
    }

    public void setEntityName(String name) {
        this._name = name;
    }

    public String getEntityName() {
        return this._name;
    }

    public void setEntityAlias(String entityAlias) {
        this._alias = entityAlias;
    }

    public String getEntityAlias() {
        return this._alias;
    }

    public void setLinkType(DynQueryLinkType linkType) {
        this._linkType = linkType;
    }

    public void setLinkType(DynQueryJoinTypeEnum joinType) {
        this.joinType = joinType;
    }

    public DynQueryJoinTypeEnum getJoinType() {
        return this.joinType;
    }

    public DynQueryLinkType getLinkType() {
        return this._linkType;
    }

    public String toString() {
        if (StringUtils.isEmpty((String)this._alias)) {
            return this._name;
        }
        return this._alias;
    }

    public void addSelectedField(DynQueryFieldModel field) {
        this._selectedFields.add(field);
    }

    public void removeSelectedField(DynQueryFieldModel field) {
        this._selectedFields.remove(field);
    }

    public int getSelectedFieldsCount() {
        return this._selectedFields.size();
    }

    public DynQueryFieldModel getSelectedField(int idx) {
        return (DynQueryFieldModel)this._selectedFields.get(idx);
    }

    public DynQueryFieldModel[] getAllFields() throws Exception {
        ArrayList<DynQueryFieldModel> result = new ArrayList<DynQueryFieldModel>();
        if (this.isSubQuery()) {
            QueryInfo queryInfo = DynQueryUtil.getQueryInfo(this.getBosObjectId());
            ArrayList fields = queryInfo.getSelector().getFields();
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                QueryFieldInfo fieldInfo = (QueryFieldInfo)fields.get(i);
                DynQueryFieldModel fieldNode = new DynQueryFieldModel(fieldInfo.getName(), fieldInfo.getDisplayName());
                try {
                    fieldNode.setDataType(com.kingdee.bos.ctrl.common.DataType.fromJdbcType((int)fieldInfo.getMappingFieldType().getSQLType()));
                    fieldNode.setQueryFieldInfo(fieldInfo);
                    fieldNode.setSystem(!fieldInfo.isConfigured());
                }
                catch (BOSException ex) {
                    fieldNode.setDataType(com.kingdee.bos.ctrl.common.DataType.NULL);
                    fieldNode.setQueryFieldInfo(fieldInfo);
                    fieldNode.setSystem(!fieldInfo.isConfigured());
                }
                result.add(fieldNode);
            }
        } else {
            EntityObjectInfo entityObjectInfo = ((SubEntityInfo)this.subObjectInfo).getEntityRef();
            PropertyCollection pc = entityObjectInfo.getInheritedNoDuplicatedProperties();
            int size = pc.size();
            for (int i = 0; i < size; ++i) {
                com.kingdee.bos.ctrl.common.DataType dataType;
                PropertyInfo propertyInfo = pc.get(i);
                if (!(propertyInfo instanceof OwnPropertyInfo)) continue;
                DynQueryFieldModel field = new DynQueryFieldModel(propertyInfo.getName(), propertyInfo.getAlias());
                if (propertyInfo.getMappingField() == null || (dataType = com.kingdee.bos.ctrl.common.DataType.fromJdbcType((int)propertyInfo.getMappingField().getSQLType())) == null) continue;
                field.setDataType(dataType);
                field.setEntityBizDataType(EntityEditorHelper.getDataTypeAlias(propertyInfo));
                field.setPropertyInfo(propertyInfo);
                field.setSystem(!propertyInfo.isConfigured());
                result.add(field);
            }
        }
        return result.toArray(new DynQueryFieldModel[0]);
    }

    public DynQueryFieldModel[] getAllPropertiesForLink() {
        if (this.isSubQuery()) {
            return new DynQueryFieldModel[0];
        }
        EntityObjectInfo entityObjectInfo = DynQueryUtil.getEntity(this.getBosObjectId());
        PropertyCollection pc = entityObjectInfo.getInheritedNoDuplicatedProperties();
        ArrayList<PropertyInfo> result = new ArrayList<PropertyInfo>();
        int size = pc.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = pc.get(i);
            boolean ok = false;
            if (propertyInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo opi = (OwnPropertyInfo)propertyInfo;
                DataType dataType = opi.getDataType();
                if (DataType.BOSUUID.equals((Object)dataType) || DataType.UUID.equals((Object)dataType) || DataType.STRING.equals((Object)dataType)) {
                    ok = true;
                }
            } else {
                ok = true;
            }
            if (!ok) continue;
            result.add(propertyInfo);
        }
        return result.toArray(new DynQueryFieldModel[0]);
    }

    public DynQueryFieldModel getAppointedProperty(String propertyName) throws DynQuery_NotExistException {
        DynQueryFieldModel[] allProps = this.getAllPropertiesForLink();
        for (int i = 0; i < allProps.length; ++i) {
            if (!StringUtils.equals((String)propertyName, (String)allProps[i].getFieldName())) continue;
            return allProps[i];
        }
        throw new DynQuery_NotExistException("Not found property: " + propertyName + ", at entity: " + this.getEntityName());
    }

    public DynQueryEntityTreeModel searchNode(String entityNme) {
        if (StringUtils.equals((String)this.getEntityName(), (String)entityNme)) {
            return this;
        }
        int c = this.getChildrenCount();
        for (int i = 0; i < c; ++i) {
            DynQueryEntityTreeModel result = this.getChild(i).searchNode(entityNme);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void setSubQuery(boolean isSubQuery) {
        this._isSubQuery = isSubQuery;
    }

    public boolean isSubQuery() {
        return this._isSubQuery;
    }

    public SubObjectInfo getSubObjectInfo() {
        return this.subObjectInfo;
    }

    public void setSubObjectInfo(SubObjectInfo subObjectInfo) {
        this.subObjectInfo = subObjectInfo;
    }

    public JoinInfo getJoinInfo() {
        return this.joinInfo;
    }

    public void setJoinInfo(JoinInfo joinInfo) {
        this.joinInfo = joinInfo;
    }

    public boolean isSubmited() {
        return this.isSubmited;
    }

    public void setSubmited(boolean isSubmited) {
        this.isSubmited = isSubmited;
    }
}

