/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.query.ui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.ICustomizedScheme;
import com.kingdee.eas.ep.client.CustomizedUnitUI;
import com.kingdee.eas.ep.client.IEditorTabPanel;
import com.kingdee.eas.ep.client.editor.editui.designer.util.CustomSchemeUtil;
import com.kingdee.eas.ep.client.editor.query.exception.DynQuery_MainQueryParseException;
import com.kingdee.eas.ep.client.editor.query.model.DynQueryModel;
import com.kingdee.eas.ep.client.editor.query.ui.EntityTabbedUI;
import com.kingdee.eas.ep.client.editor.query.ui.FieldTabbedUI;
import com.kingdee.eas.ep.client.editor.query.ui.OtherTabbedUI;
import com.kingdee.eas.ep.client.editor.query.ui.QuerySQLUI;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DynQueryEditor
extends KDPanel
implements IEditorTabPanel {
    private static final Logger log = LogUtil.getPackageLogger(DynQueryEditor.class);
    private CustomizedUnitUI ui;
    private String customizedSchemeID;
    private Project depend;
    private boolean isDirty;
    private KDTextField _lblMainQueryPK;
    private KDTextField txtAlias;
    private KDTabbedPane _tabbedPane;
    private EntityTabbedUI _tabbedUIEntity;
    private FieldTabbedUI _tabbedUIField;
    private QuerySQLUI _tabbedUISQL;
    private OtherTabbedUI _tabbedUIOther;
    private DynQueryModel _model;
    private String currentTab;

    public DynQueryEditor() {
        this.init();
    }

    private void init() {
        this.setBounds(new Rectangle(10, 10, 1016, 600));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 1016, 600));
        this._lblMainQueryPK = new KDTextField();
        this._lblMainQueryPK.setEditable(false);
        this.txtAlias = new KDTextField();
        KDLabelContainer lblName = new KDLabelContainer("\u540d\u79f0");
        lblName.setBoundEditor((JComponent)this._lblMainQueryPK);
        lblName.setBounds(10, 10, 490, 19);
        lblName.setBoundLabelLength(70);
        this.add((Component)lblName, new KDLayout.Constraints(10, 10, 490, 19, 384));
        KDLabelContainer lblAlias = new KDLabelContainer("\u522b\u540d");
        lblAlias.setBoundEditor((JComponent)this.txtAlias);
        lblAlias.setBounds(520, 10, 490, 19);
        lblAlias.setBoundLabelLength(70);
        this.add((Component)lblAlias, new KDLayout.Constraints(520, 10, 490, 19, 384));
        this._tabbedPane = new KDTabbedPane();
        this._tabbedPane.setBounds(10, 35, 1000, 565);
        this.add((Component)this._tabbedPane, new KDLayout.Constraints(10, 35, 1000, 565, 387));
        this._tabbedUIEntity = new EntityTabbedUI();
        try {
            this._tabbedUIField = new FieldTabbedUI();
        }
        catch (Exception e1) {
            log.error((Object)"DynQueryEditor.init ", (Throwable)e1);
        }
        this._tabbedUISQL = new QuerySQLUI();
        try {
            this._tabbedUIOther = new OtherTabbedUI();
        }
        catch (Exception e1) {
            log.error((Object)"DynQueryEditor.init ", (Throwable)e1);
        }
        JScrollPane sp = new JScrollPane((Component)((Object)this._tabbedUIOther));
        sp.setHorizontalScrollBarPolicy(30);
        sp.setVerticalScrollBarPolicy(20);
        this._tabbedPane.addTab(MultiLanguageUtil.getMLS((String)"ui.NoteDynQueryEditor.entity", (String)"\u5b9e\u4f53"), (Component)this._tabbedUIEntity.getUI());
        this._tabbedPane.addTab(MultiLanguageUtil.getMLS((String)"ui.NoteDynQueryEditor.field", (String)"\u5b57\u6bb5"), (Component)((Object)this._tabbedUIField));
        this._tabbedPane.addTab(MultiLanguageUtil.getMLS((String)"ui.NoteDynQueryEditor.sql", (String)"\u5176\u4ed6"), (Component)sp);
        this._tabbedPane.addTab(MultiLanguageUtil.getMLS((String)"ui.NoteDynQueryEditor.sql", (String)"SQL"), (Component)this._tabbedUISQL.getUI());
        this._tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if ("FieldTabbedUI".equals(DynQueryEditor.this.currentTab)) {
                    if (!DynQueryEditor.this._tabbedUIField.vertify()) {
                        DynQueryEditor.this._tabbedPane.setSelectedComponent((Component)((Object)DynQueryEditor.this._tabbedUIField));
                        SysUtil.abort();
                    }
                    DynQueryEditor.this._tabbedUIField.storeFields();
                }
                DynQueryEditor.this.currentTab = DynQueryEditor.this._tabbedPane.getSelectedComponent().getName();
                if ("QuerySQLUI".equals(DynQueryEditor.this._tabbedPane.getSelectedComponent().getName())) {
                    DynQueryEditor.this._tabbedUISQL.updateCtrl(DynQueryEditor.this._model);
                }
            }
        });
        this._tabbedUIEntity.setTabbedSynchronizer(new EntityTabbedSynchronizer());
        this._tabbedUIField.setTabbedSynchronizer(new FieldTabbedSynchronizer());
        this._tabbedUISQL.setTabbedSynchronizer(new QueryTabbedTabbedSynchronizer());
        this._tabbedUIOther.setTabbedSynchronizer(new OhterTabbedSynchronizer());
    }

    public JComponent getMainFrame() {
        return this;
    }

    public DynQueryModel getModel() {
        return this._model;
    }

    private void updateCtrl() {
        this._lblMainQueryPK.setText(this._model == null ? null : this._model.getMainQueryPath());
        this.txtAlias.setText(this._model == null ? null : this._model.getMainQuery().getAlias());
        this._tabbedUIEntity.updateCtrl(this._model);
        this._tabbedUIField.updateCtrl(this._model);
        this._tabbedUIOther.updateCtrl(this._model);
    }

    @Override
    public void setMetadataPK(String pk) {
        if (!StringUtils.isEmpty((String)pk)) {
            try {
                QueryInfo queryInfo = UictUtils.loadQuery((IMetaDataPK)new MetaDataPK(pk), this.depend);
                QueryInfo qi = (QueryInfo)queryInfo.clone();
                JoinQueryInfo oldInfo = (JoinQueryInfo)queryInfo;
                JoinQueryInfo newInfo = (JoinQueryInfo)qi;
                JoinCollection joinColl = newInfo.getJoins();
                JoinCollection oldJoinColl = oldInfo.getJoins();
                int size = joinColl.size();
                for (int i = 0; i < size; ++i) {
                    JoinInfo sub = joinColl.get(i);
                    JoinInfo oldSub = oldJoinColl.get(i);
                    SubObjectInfo left = oldSub.getLeftObject();
                    SubObjectInfo right = oldSub.getRightObject();
                    int length = oldInfo.getSubObjects().size();
                    for (int t = 0; t < length; ++t) {
                        if (left == oldInfo.getSubObjects().get(t)) {
                            sub.setLeftObject(newInfo.getSubObjects().get(t));
                        }
                        if (right != oldInfo.getSubObjects().get(t)) continue;
                        sub.setRightObject(newInfo.getSubObjects().get(t));
                    }
                }
                Map extendedProperties = queryInfo.getExtendedProperties();
                if (extendedProperties != null) {
                    qi.getExtendedProperties().clear();
                    for (Object next : extendedProperties.keySet()) {
                        Object value = extendedProperties.get(next);
                        qi.getExtendedProperties().put(next, value);
                    }
                }
                this._model = new DynQueryModel(qi);
            }
            catch (DynQuery_MainQueryParseException ex) {
                log.error((Object)"", (Throwable)ex);
                WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS((String)"ui.NoteDynQueryEditor.selectMainQueryError", (String)"\u65e0\u6548\u7684\u4e3b\u67e5\u8be2\u5bf9\u8c61\uff0c\u4e0d\u80fd\u6b63\u786e\u89e3\u6790\u3002"), (String)MultiLanguageUtil.getMLS((String)"ui.NoteDynQueryEditor.selectMainQuery", (String)"\u9009\u62e9\u4e3b\u67e5\u8be2"), (Component)this.getMainFrame());
            }
        } else {
            this._model = null;
            log.error((Object)"PK\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.updateCtrl();
    }

    public boolean verify() {
        return this._model != null;
    }

    @Override
    public void doSave() throws Exception {
        ICustomizedScheme ics = CustomizedSchemeFactory.getRemoteInstance();
        CustomizedSchemeInfo csInfo = ics.getCustomizedSchemeInfo("where id='" + this.customizedSchemeID + "'");
        if (csInfo != null && csInfo.isStart()) {
            boolean confirm;
            boolean bl = confirm = MsgBox.showConfirm2((Component)((Object)this), (String)"\u5f53\u524d\u52a8\u6001\u6269\u5c55\u65b9\u6848\u5904\u4e8e\u542f\u52a8\u72b6\u6001\uff0c\u662f\u5426\u786e\u8ba4\u53cd\u542f\u7528\u5e76\u4fdd\u5b58\u65b9\u6848?") == 0;
            if (!confirm) {
                SysUtil.abort();
            } else {
                CustomSchemeUtil.disableScheme(this.customizedSchemeID);
                this.ui.actionCancel_actionPerformed(null);
            }
        }
        try {
            this._tabbedUIEntity.checkJoinCondition();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        QueryInfo query = this._model.getMainQuery();
        query.setAlias(this.txtAlias.getText());
        UictUtils.saveMetadata((AbstractMetaDataValue)query, this.customizedSchemeID, this.depend);
        this.setDirty(false);
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    @Override
    public void setCustomizedSchemeID(String id) {
        this.customizedSchemeID = id;
    }

    public String getCustomizedSchemeID() {
        return this.customizedSchemeID;
    }

    @Override
    public CustomizedUnitUI getCustomizedUnitUI() {
        return this.ui;
    }

    @Override
    public void setCustomizedUnitUI(CustomizedUnitUI ui) {
        this.ui = ui;
    }

    @Override
    public void destory() throws Exception {
    }

    @Override
    public void loadData() throws Exception {
    }

    @Override
    public void setBosObjectType(BOSObjectType type) {
    }

    @Override
    public void setDepends(Project depend) {
        this.depend = depend;
        this._tabbedUIEntity.setDepend(depend);
    }

    @Override
    public void beforeSave() throws Exception {
        if (!this._tabbedUIField.vertify()) {
            this._tabbedPane.setSelectedComponent((Component)((Object)this._tabbedUIField));
            SysUtil.abort();
        }
        this._tabbedUIField.storeFields();
    }

    @Override
    public Project getDepends() {
        return this.depend;
    }

    private class QueryTabbedTabbedSynchronizer
    implements ITabbedSynchronizer {
        private QueryTabbedTabbedSynchronizer() {
        }

        @Override
        public void announce(Map params) {
            DynQueryEditor.this._tabbedUISQL.updateCtrl(DynQueryEditor.this._model);
            if (params.get("type").equals("isdirty")) {
                DynQueryEditor.this.setDirty(true);
            }
        }
    }

    private class FieldTabbedSynchronizer
    implements ITabbedSynchronizer {
        private FieldTabbedSynchronizer() {
        }

        @Override
        public void announce(Map params) {
            if ("isdirty".equals(params.get("type"))) {
                DynQueryEditor.this.setDirty(true);
            }
            if ("refresh_otherpane".equals(params.get("refresh"))) {
                DynQueryEditor.this._tabbedUIOther.updateCtrl(DynQueryEditor.this._model);
            }
        }
    }

    private class OhterTabbedSynchronizer
    implements ITabbedSynchronizer {
        private OhterTabbedSynchronizer() {
        }

        @Override
        public void announce(Map params) {
            if ("ItemChanged".equals(params.get("type"))) {
                // empty if block
            }
            if (params.get("type").equals("isdirty")) {
                DynQueryEditor.this.setDirty(true);
            }
        }
    }

    private class EntityTabbedSynchronizer
    implements ITabbedSynchronizer {
        private EntityTabbedSynchronizer() {
        }

        @Override
        public void announce(Map params) {
            if ("ItemChanged".equals(params.get("type"))) {
                // empty if block
            }
            if ("isdirty".equals(params.get("type"))) {
                DynQueryEditor.this.setDirty(true);
            }
        }
    }

    static interface ITabbedSynchronizer {
        public static final String ISDIRTY = "isdirty";
        public static final String REFRESH_OTHERPANE = "refresh_otherpane";

        public void announce(Map var1);
    }
}

