/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.query.ui;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.query.ui.AbstractExtendedPropertySelectUI;
import com.kingdee.eas.ep.client.model.extendproperty.ExdPropertyDelegate;
import com.kingdee.eas.ep.client.model.extendproperty.ReadBosConfigUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExtendedPropertySelectUI
extends AbstractExtendedPropertySelectUI {
    private static final Logger logger = CoreUIObject.getLogger(ExtendedPropertySelectUI.class);
    public static final String model = "model";
    public static final String mainQuery = "mainQuery";
    public static final String propertyCollection = "epCollection";
    private boolean confirmExit;
    private List leftList;
    private List rightList;
    public static final String ENTITY = "entity";
    public static final String FIELD = "field";
    public static final String PROPERTY = "property";
    public static final String QUERY = "query";
    public static final String[] types = new String[]{"entity", "field", "property", "query"};
    private String type = "field";
    public static final String MDTYPE = "mdtype";
    public static final String DYNEXTENDPROPERTYLIST = "dynExtendPropertyList";
    private AbstractMDValue mdValue;
    private List staticList = new ArrayList();

    public ExtendedPropertySelectUI() throws Exception {
        this.leftList = new ArrayList();
        this.rightList = new ArrayList();
        this.tbAllEP.getSelectManager().setSelectMode(2);
        this.tbSelectedEP.getSelectManager().setSelectMode(2);
        this.tbAllEP.setEditable(false);
        this.tbAllEP.getStyleAttributes().setWrapText(true);
        this.tbAllEP.setAutoResize(true);
        this.tbAllEP.setColumnsAutoResizeMode(3);
        this.tbSelectedEP.setEditable(false);
        this.tbSelectedEP.setAutoResize(true);
        this.tbSelectedEP.getStyleAttributes().setWrapText(true);
        this.tbSelectedEP.setColumnsAutoResizeMode(3);
        this.tbAllEP.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        ExtendedPropertySelectUI.this.btnAdd_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        ExtendedPropertySelectUI.this.handUIException(e1);
                    }
                }
            }
        });
        this.tbSelectedEP.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        ExtendedPropertySelectUI.this.btnRemove_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        ExtendedPropertySelectUI.this.handUIException(e1);
                    }
                }
            }
        });
    }

    public ExtendedPropertySelectUI(String type) throws Exception {
        this();
        if (!CtrlUtil.Array.containElement((Object[])types, (Object)type)) {
            throw new IllegalArgumentException("illegal argument : type");
        }
        this.type = type;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiContext = this.getUIContext();
        Object obj = uiContext.get(model);
        if (obj != null && obj instanceof AbstractMDValue) {
            this.mdValue = (AbstractMDValue)uiContext.get(model);
            Map properties = this.mdValue.getExtendedProperties();
            if (properties != null) {
                Set keySet = properties.keySet();
                String dynProBinds = this.mdValue.getExtendedProperty(DYNEXTENDPROPERTYLIST);
                List<Object> dynList = new ArrayList();
                if (!StringUtils.isEmpty((String)dynProBinds)) {
                    String[] pros = StringUtils.split((String)dynProBinds, (String)"|");
                    dynList = Arrays.asList(pros);
                }
                Iterator iterator = keySet.iterator();
                while (iterator.hasNext()) {
                    String next = iterator.next().toString();
                    if (dynList.contains(next)) continue;
                    this.staticList.add(next);
                }
            }
        } else {
            throw new Exception("model is not a AbstractMDValue object ");
        }
        List epCollection = (List)uiContext.get(propertyCollection);
        Object object = uiContext.get(MDTYPE);
        if (object != null && object instanceof String) {
            String mdtype = object.toString();
            if (!CtrlUtil.Array.containElement((Object[])types, (Object)mdtype)) {
                throw new IllegalArgumentException("illegal argument : type");
            }
            this.type = mdtype;
        }
        List list = ReadBosConfigUtil.getAllExtendProperty(this.type, this.mdValue);
        this.wrapModel(list, epCollection);
        this.loadFields();
    }

    private void wrapModel(List list, List inHereCol) {
        int i;
        if (list == null || list.size() == 0) {
            return;
        }
        int j = list.size();
        for (i = 0; i < j; ++i) {
            if (!(list.get(i) instanceof ExdPropertyDelegate)) continue;
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)list.get(i));
            boolean exist = false;
            int l = inHereCol.size();
            for (int k = 0; k < l; ++k) {
                ExdPropertyDelegate info = (ExdPropertyDelegate)((Object)inHereCol.get(k));
                String name = info.getTempExtendProperty().getName();
                if (name == null || !name.equals(delegate.getName())) continue;
                delegate.setValue(info.getTempExtendProperty().getValue());
                exist = true;
                break;
            }
            if (exist) {
                this.rightList.add(delegate);
                continue;
            }
            this.leftList.add(delegate);
        }
        j = inHereCol.size();
        for (i = 0; i < j; ++i) {
            ExdPropertyDelegate info = (ExdPropertyDelegate)((Object)inHereCol.get(i));
            String infoName = info.getTempExtendProperty().getName();
            if (infoName == null) continue;
            boolean hasEqu = false;
            int l = list.size();
            for (int k = 0; k < l; ++k) {
                ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)list.get(k));
                String dName = delegate.getName();
                if (dName == null || !infoName.equals(dName)) continue;
                hasEqu = true;
                break;
            }
            if (hasEqu) continue;
            String infoValue = info.getTempExtendProperty().getValue();
            ExdPropertyDelegate dele = new ExdPropertyDelegate();
            dele.setName(infoName);
            dele.setValue(infoValue);
            this.rightList.add(dele);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.refreshTables();
    }

    private void refreshTables() {
        int i;
        this.tbAllEP.removeRows();
        this.tbSelectedEP.removeRows();
        this.setTableData(this.leftList, this.tbAllEP);
        this.fillRightTabel(this.rightList, this.tbSelectedEP);
        if (this.tbAllEP.getRowCount() > 0) {
            this.tbAllEP.getSelectManager().add(0, 0);
        }
        if (this.tbSelectedEP.getRowCount() > 0) {
            this.tbSelectedEP.getSelectManager().add(0, 0);
        }
        if (this.tbAllEP != null) {
            for (i = 0; i < this.tbAllEP.getRowCount(); ++i) {
                KDTableHelper.autoFitRowHeight((KDTable)this.tbAllEP, (int)i);
            }
        }
        if (this.tbSelectedEP != null) {
            for (i = 0; i < this.tbSelectedEP.getRowCount(); ++i) {
                KDTableHelper.autoFitRowHeight((KDTable)this.tbSelectedEP, (int)i);
            }
        }
    }

    private void fillRightTabel(List list, KDTable table) {
        if (list == null || table == null) {
            return;
        }
        table.removeRows();
        for (int i = 0; i < list.size(); ++i) {
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)list.get(i));
            if (!delegate.isUseAble()) continue;
            String name = delegate.getName();
            IRow row = table.addRow();
            row.getCell("group").setValue((Object)delegate.getGroup());
            row.getCell("name").setValue((Object)delegate.getName());
            row.getCell("alias").setValue((Object)delegate.getAlias());
            row.getCell("type").setValue((Object)delegate.getType());
            row.getCell("descript").setValue((Object)delegate.getDescription());
            row.setUserObject((Object)delegate);
            if (this.staticList.contains(name)) continue;
            row.getStyleAttributes().setFontColor(Color.BLUE);
            int rowIndex = row.getRowIndex();
            if (rowIndex == 0) continue;
            table.moveRow(rowIndex, 0);
        }
        table.repaint();
    }

    private void setTableData(List list, KDTable table) {
        if (list == null || table == null) {
            return;
        }
        table.removeRows();
        for (int i = 0; i < list.size(); ++i) {
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)list.get(i));
            if (!delegate.isUseAble()) continue;
            IRow row = table.addRow();
            row.getCell("group").setValue((Object)delegate.getGroup());
            row.getCell("name").setValue((Object)delegate.getName());
            row.getCell("alias").setValue((Object)delegate.getAlias());
            row.getCell("type").setValue((Object)delegate.getType());
            row.getCell("descript").setValue((Object)delegate.getDescription());
            row.setUserObject((Object)delegate);
        }
        table.repaint();
    }

    private void addRowRightTabel(ExdPropertyDelegate delegate) {
        if (delegate == null || this.tbSelectedEP == null) {
            return;
        }
        String name = delegate.getName();
        IRow row = this.tbSelectedEP.addRow();
        row.getCell("group").setValue((Object)delegate.getGroup());
        row.getCell("name").setValue((Object)delegate.getName());
        row.getCell("alias").setValue((Object)delegate.getAlias());
        row.getCell("type").setValue((Object)delegate.getType());
        row.getCell("descript").setValue((Object)delegate.getDescription());
        row.setUserObject((Object)delegate);
        if (!this.staticList.contains(name)) {
            row.getStyleAttributes().setFontColor(Color.BLUE);
            int rowIndex = row.getRowIndex();
            if (rowIndex != 0) {
                this.tbSelectedEP.moveRow(rowIndex, 0);
            }
        }
        KDTableHelper.autoFitRowHeight((KDTable)this.tbSelectedEP, (int)0);
    }

    private void addRowTableData(ExdPropertyDelegate delegate) {
        if (delegate == null || this.tbAllEP == null) {
            return;
        }
        IRow row = this.tbAllEP.addRow();
        row.getCell("group").setValue((Object)delegate.getGroup());
        row.getCell("name").setValue((Object)delegate.getName());
        row.getCell("alias").setValue((Object)delegate.getAlias());
        row.getCell("type").setValue((Object)delegate.getType());
        row.getCell("descript").setValue((Object)delegate.getDescription());
        row.setUserObject((Object)delegate);
        int rowIndex = row.getRowIndex();
        KDTableHelper.autoFitRowHeight((KDTable)this.tbAllEP, (int)rowIndex);
    }

    public boolean canDelete(Object model) {
        if (!(model instanceof ExdPropertyDelegate)) {
            return false;
        }
        ExdPropertyDelegate dele = (ExdPropertyDelegate)((Object)model);
        if (dele.getName().trim().equals("configured")) {
            return false;
        }
        String required = dele.getRequired();
        if (required != null && required.equalsIgnoreCase("true")) {
            return false;
        }
        String name = dele.getName();
        return this.staticList == null || !this.staticList.contains(name);
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tbAllEP);
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = this.tbAllEP.getRow(selectRows[i]);
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
            this.rightList.add(delegate);
            this.leftList.remove((Object)delegate);
            this.addRowRightTabel(delegate);
            this.tbSelectedEP.getSelectManager().add(0, 0);
            this.tbAllEP.removeRow(selectRows[i]);
        }
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemove_actionPerformed(e);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tbSelectedEP);
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = this.tbSelectedEP.getRow(selectRows[i]);
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
            Object obj = this.getUIContext().get(model);
            if (!(this.canDelete((Object)delegate) || obj instanceof PropertyInfo && ((PropertyInfo)obj).isConfigured())) {
                MsgBox.showInfo((String)"\u9759\u6001\u548c\u5fc5\u9009\u6269\u5c55\u5c5e\u6027\u4e0d\u5141\u8bb8\u5220\u9664");
                continue;
            }
            this.leftList.add(delegate);
            this.rightList.remove((Object)delegate);
            this.addRowTableData(delegate);
            this.tbSelectedEP.removeRow(selectRows[i]);
        }
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        for (int i = 0; i < this.tbAllEP.getRowCount(); ++i) {
            IRow row = this.tbAllEP.getRow(i);
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
            this.rightList.add(delegate);
            this.leftList.remove((Object)delegate);
        }
        this.refreshTables();
    }

    @Override
    protected void btnRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemoveAll_actionPerformed(e);
        Object obj = this.getUIContext().get(model);
        for (int i = 0; i < this.tbSelectedEP.getRowCount(); ++i) {
            IRow row = this.tbSelectedEP.getRow(i);
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
            if (!this.canDelete((Object)delegate) && (!(obj instanceof PropertyInfo) || !((PropertyInfo)obj).isConfigured())) continue;
            this.leftList.add(delegate);
            this.rightList.remove((Object)delegate);
        }
        this.refreshTables();
    }

    @Override
    protected void btnPrevious_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tbSelectedEP);
        if (this.tbSelectedEP.getSelectManager().getBlocks() != null && this.tbSelectedEP.getSelectManager().getBlocks().size() > 0) {
            this.tbSelectedEP.getSelectManager().removeAll();
            for (int i = 0; i <= selectRows.length - 1; ++i) {
                int rowIndex = selectRows[i];
                if (rowIndex <= 0 || rowIndex > this.tbSelectedEP.getRowCount() - 1) continue;
                IRow row = this.tbSelectedEP.getRow(rowIndex);
                ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
                this.rightList.remove((Object)delegate);
                this.rightList.add(rowIndex - 1, delegate);
                this.tbSelectedEP.moveRow(rowIndex, rowIndex - 1);
                this.tbSelectedEP.getSelectManager().add(rowIndex - 1, 0);
            }
        }
    }

    @Override
    protected void btnBottom_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tbSelectedEP);
        if (this.tbSelectedEP.getSelectManager().getBlocks() != null && this.tbSelectedEP.getSelectManager().getBlocks().size() > 0) {
            this.tbSelectedEP.getSelectManager().removeAll();
            for (int i = selectRows.length - 1; i >= 0; --i) {
                int rowIndex = selectRows[i];
                if (rowIndex < 0 || rowIndex >= this.tbSelectedEP.getRowCount() - 1) continue;
                int moveVolume = this.tbSelectedEP.getRowCount() - 1 - rowIndex - (selectRows.length - 1 - i);
                IRow row = this.tbSelectedEP.getRow(rowIndex);
                ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
                this.rightList.remove((Object)delegate);
                this.rightList.add(rowIndex + moveVolume, delegate);
                this.tbSelectedEP.moveRow(rowIndex, rowIndex + moveVolume);
                this.tbSelectedEP.getSelectManager().add(rowIndex + moveVolume, 0);
            }
        }
    }

    @Override
    protected void btnTop_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tbSelectedEP);
        if (this.tbSelectedEP.getSelectManager().getBlocks() != null && this.tbSelectedEP.getSelectManager().getBlocks().size() > 0) {
            this.tbSelectedEP.getSelectManager().removeAll();
            for (int i = 0; i <= selectRows.length - 1; ++i) {
                int rowIndex = selectRows[i];
                if (rowIndex <= 0 || rowIndex > this.tbSelectedEP.getRowCount() - 1) continue;
                int moveVolume = 0 - rowIndex + i;
                IRow row = this.tbSelectedEP.getRow(rowIndex);
                ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
                this.rightList.remove((Object)delegate);
                this.rightList.add(rowIndex + moveVolume, delegate);
                this.tbSelectedEP.moveRow(rowIndex, rowIndex + moveVolume);
                this.tbSelectedEP.getSelectManager().add(rowIndex + moveVolume, 0);
            }
        }
    }

    @Override
    protected void btnNext_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tbSelectedEP);
        if (this.tbSelectedEP.getSelectManager().getBlocks() != null && this.tbSelectedEP.getSelectManager().getBlocks().size() > 0) {
            this.tbSelectedEP.getSelectManager().removeAll();
            for (int i = selectRows.length - 1; i >= 0; --i) {
                int rowIndex = selectRows[i];
                if (this.tbSelectedEP.getRowCount() - 1 <= rowIndex || rowIndex < 0) continue;
                IRow row = this.tbSelectedEP.getRow(rowIndex);
                ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
                this.rightList.remove((Object)delegate);
                this.rightList.add(rowIndex + 1, delegate);
                this.tbSelectedEP.moveRow(rowIndex, rowIndex + 1);
                this.tbSelectedEP.getSelectManager().add(rowIndex + 1, 0);
            }
        }
    }

    @Override
    protected void tbAllEP_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tbAllEP_tableSelectChanged(e);
    }

    @Override
    protected void tbSelectedEP_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int rowIndex;
        if (this.tbSelectedEP.getSelectManager().getBlocks() != null && this.tbSelectedEP.getSelectManager().getBlocks().size() > 0 && this.tbSelectedEP.getRow(rowIndex = this.tbSelectedEP.getSelectManager().get().getTop()).getUserObject() instanceof ExdPropertyDelegate) {
            ExdPropertyDelegate model = (ExdPropertyDelegate)((Object)this.tbSelectedEP.getRow(rowIndex).getUserObject());
            Object obj = this.getUIContext().get(model);
            if (this.canDelete((Object)model) || obj instanceof PropertyInfo && ((PropertyInfo)obj).isConfigured()) {
                this.btnRemove.setEnabled(true);
            } else {
                this.btnRemove.setEnabled(false);
            }
        }
    }

    public List getLeftList() {
        return this.leftList;
    }

    public void setLeftList(List leftList) {
        this.leftList = leftList;
    }

    public List getRightList() {
        return this.rightList;
    }

    public void setRightList(List rightList) {
        this.rightList = rightList;
    }

    public boolean isConfirmExit() {
        return this.confirmExit;
    }

    public void setConfirmExit(boolean confirmExit) {
        this.confirmExit = confirmExit;
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.setConfirmExit(true);
        this.destroyWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setConfirmExit(false);
        this.destroyWindow();
    }
}

