/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.query.ui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.DefaultKingdeeListCellRenderer;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.model.KingdeeListModel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.ExtendPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.QueryPKInfo;
import com.kingdee.bos.metadata.query.QuerySorterItemCollection;
import com.kingdee.bos.metadata.query.QuerySorterItemInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.query.util.GroupType;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.dtp.model.ComponentNameManager;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.client.depend.mutiLan.MutiLanUtil;
import com.kingdee.eas.ep.client.editor.query.model.DynQueryEntityTreeModel;
import com.kingdee.eas.ep.client.editor.query.model.DynQueryFieldModel;
import com.kingdee.eas.ep.client.editor.query.model.DynQueryModel;
import com.kingdee.eas.ep.client.editor.query.model.DynQueryUtil;
import com.kingdee.eas.ep.client.editor.query.ui.AbstractFieldTabbedUI;
import com.kingdee.eas.ep.client.editor.query.ui.CustomListItem;
import com.kingdee.eas.ep.client.editor.query.ui.DynQueryEditor;
import com.kingdee.eas.ep.client.editor.query.ui.ExtendedPropertySelectUI;
import com.kingdee.eas.ep.client.editor.query.ui.QueryFieldExtendPropertyUI;
import com.kingdee.eas.ep.client.editor.query.ui.QueryFieldSelectUI;
import com.kingdee.eas.ep.client.model.extendproperty.ExdPropertyDelegate;
import com.kingdee.eas.ep.client.model.extendproperty.GroupComparator;
import com.kingdee.eas.ep.client.model.extendproperty.ReadBosConfigUtil;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.ep.client.validate.imp.QueryFieldValidater;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FieldTabbedUI
extends AbstractFieldTabbedUI {
    private static final Logger logger = CoreUIObject.getLogger(FieldTabbedUI.class);
    private DynQueryModel model;
    private KingdeeListModel modelFieldList;
    private KingdeeListModel modelProRefList;
    private boolean needupdate;
    private DynQueryEditor.ITabbedSynchronizer _synchronizer;
    private ComponentNameManager nameManager;
    private QueryFieldInfo currentField;

    public FieldTabbedUI() throws Exception {
        this.init();
    }

    public void init() {
        this.groupTypeComboBox.addItems(GroupType.getEnumList().toArray());
        this.dataTypeComboBox.addItems(ConstDataType.getFieldReturnTypes().toArray());
        this.listQueryField.setCellRenderer((ListCellRenderer)((Object)new CustomListCellRender()));
        this.listPropertyRef.setCellRenderer((ListCellRenderer)((Object)new ProRefListCellRender()));
        this.modelFieldList = new KingdeeListModel();
        this.modelProRefList = new KingdeeListModel();
        this.listQueryField.setModel((ListModel)this.modelFieldList);
        this.listPropertyRef.setModel((ListModel)this.modelProRefList);
        this.extensionTable.getSelectManager().setSelectMode(2);
        this.addListeners();
    }

    @Override
    public void storeFields() {
        if (this.currentField != null) {
            this.storeQueryFieldInfo(this.currentField);
        }
    }

    public void addListeners() {
        this.aliasField.addKeyListener((KeyListener)new fieldAdapter());
        this.expressionArea.addKeyListener((KeyListener)new expressionAreaAdapter());
    }

    @Override
    protected void fieldAddbtn_actionPerformed(ActionEvent e) throws Exception {
        super.fieldAddbtn_actionPerformed(e);
        QueryFieldInfo queryField = new QueryFieldInfo(this.model.getMainQuery());
        queryField.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        QueryFieldCollection fieldCollection = this.model.getMainQuery().getUnits().getQueryFields();
        if (this.nameManager == null) {
            this.nameManager = new ComponentNameManager(false);
            int n = fieldCollection.size();
            for (int i = 0; i < n; ++i) {
                this.nameManager.put(fieldCollection.get(i).getName());
            }
        }
        String fieldName = this.nameManager.getNameByName("queryField");
        queryField.setName(fieldName);
        queryField.setIsSelector(true);
        queryField.setIsFilter(true);
        queryField.setConfigured(true);
        queryField.setReturnType(ConstDataType.STRING);
        if (DynQueryUtil.isGrouping(this.model.getMainQuery())) {
            queryField.setGroupType(GroupType.GROUPING);
        }
        this.model.getMainQuery().getUnits().add((PropertyUnitInfo)queryField);
        int selectedIndex = this.model.getMainQuery().getUnits().getQueryFields().size() - 1;
        this.updateFieldList();
        this.listQueryField.setSelectedIndex(selectedIndex);
        this.setDirty(true);
    }

    @Override
    protected void fieldFirstbtn_actionPerformed(ActionEvent e) throws Exception {
        super.fieldFirstbtn_actionPerformed(e);
        Object[] selectedObjs = this.listQueryField.getSelectedValues();
        if (selectedObjs == null || selectedObjs.length == 0) {
            return;
        }
        int[] targetIndexs = new int[selectedObjs.length];
        for (int i = 0; i < selectedObjs.length; ++i) {
            PropertyUnitInfo fieldInfo = (PropertyUnitInfo)selectedObjs[i];
            if (fieldInfo == null) {
                return;
            }
            int n = this.listQueryField.getIndexOfElement((Object)fieldInfo);
            if (n < 0) continue;
            PropertyUnitInfo prefieldInfo = (PropertyUnitInfo)this.listQueryField.getElement(n - 1);
            PropertyUnitCollection col = this.model.getMainQuery().getUnits();
            int index = -1;
            int previousIndex = -1;
            for (int j = 0; j < col.size(); ++j) {
                PropertyUnitInfo tmpUnit = col.get(j);
                if (tmpUnit == prefieldInfo) {
                    previousIndex = j;
                    continue;
                }
                if (tmpUnit != fieldInfo) continue;
                index = j;
            }
            if (index > -1 && previousIndex > -1) {
                this.model.getMainQuery().getUnits().changeIndex(index, previousIndex);
                this.modelFieldList.removeElementAt(n);
                this.modelFieldList.insertElementAt((Object)fieldInfo, n - 1);
            }
            targetIndexs[i] = n - 1;
        }
        this.listQueryField.setSelectedIndices(targetIndexs);
        this.resetCompentstatus();
        this.setDirty(true);
    }

    @Override
    protected void fieldNextbtn_actionPerformed(ActionEvent e) throws Exception {
        super.fieldNextbtn_actionPerformed(e);
        Object[] selectedObjs = this.listQueryField.getSelectedValues();
        if (selectedObjs == null || selectedObjs.length == 0) {
            return;
        }
        int[] targetIndexs = new int[selectedObjs.length];
        for (int i = 0; i < selectedObjs.length; ++i) {
            PropertyUnitInfo fieldInfo = (PropertyUnitInfo)selectedObjs[i];
            if (fieldInfo == null) {
                return;
            }
            int n = this.listQueryField.getIndexOfElement((Object)fieldInfo);
            if (n < 0) continue;
            PropertyUnitInfo nextfieldInfo = (PropertyUnitInfo)this.listQueryField.getElement(n + 1);
            PropertyUnitCollection col = this.model.getMainQuery().getUnits();
            int index = -1;
            int previousIndex = -1;
            for (int j = 0; j < col.size(); ++j) {
                PropertyUnitInfo tmpUnit = col.get(j);
                if (tmpUnit == nextfieldInfo) {
                    previousIndex = j;
                    continue;
                }
                if (tmpUnit != fieldInfo) continue;
                index = j;
            }
            if (index > -1 && previousIndex > -1) {
                this.model.getMainQuery().getUnits().changeIndex(index, previousIndex);
                this.modelFieldList.remove(n);
                this.modelFieldList.insertElementAt((Object)fieldInfo, n + 1);
            }
            targetIndexs[i] = n + 1;
        }
        this.listQueryField.setSelectedIndices(targetIndexs);
        this.resetCompentstatus();
        this.setDirty(true);
    }

    @Override
    protected void fieldTopbtn_actionPerformed(ActionEvent e) throws Exception {
        super.fieldTopbtn_actionPerformed(e);
        Object[] selectedObjs = this.listQueryField.getSelectedValues();
        if (selectedObjs == null || selectedObjs.length == 0) {
            return;
        }
        int[] targetIndexs = new int[selectedObjs.length];
        for (int n = selectedObjs.length - 1; n >= 0; --n) {
            PropertyUnitInfo fieldInfo = (PropertyUnitInfo)selectedObjs[n];
            if (fieldInfo == null) {
                return;
            }
            int i = this.listQueryField.getIndexOfElement((Object)fieldInfo);
            if (i >= 0) {
                PropertyUnitCollection col = this.model.getMainQuery().getUnits();
                int index = -1;
                for (int j = 0; j < col.size(); ++j) {
                    PropertyUnitInfo tmpUnit = col.get(j);
                    if (tmpUnit != fieldInfo) continue;
                    index = j;
                }
                if (index > -1) {
                    this.model.getMainQuery().getUnits().changeIndex(index, 0);
                    this.modelFieldList.removeElementAt(i);
                    this.modelFieldList.insertElementAt((Object)fieldInfo, 0);
                }
            }
            targetIndexs[n] = n;
        }
        this.listQueryField.setSelectedIndices(targetIndexs);
        this.resetCompentstatus();
        this.setDirty(true);
    }

    @Override
    protected void fieldBottombtn_actionPerformed(ActionEvent e) throws Exception {
        super.fieldBottombtn_actionPerformed(e);
        Object[] selectedObjs = this.listQueryField.getSelectedValues();
        if (selectedObjs == null || selectedObjs.length == 0) {
            return;
        }
        int[] targetIndexs = new int[selectedObjs.length];
        for (int n = 0; n < selectedObjs.length; ++n) {
            PropertyUnitInfo fieldInfo = (PropertyUnitInfo)selectedObjs[n];
            if (fieldInfo == null) {
                return;
            }
            int i = this.listQueryField.getIndexOfElement((Object)fieldInfo);
            if (i >= 0) {
                PropertyUnitCollection col = this.model.getMainQuery().getUnits();
                int index = -1;
                for (int j = 0; j < col.size(); ++j) {
                    PropertyUnitInfo tmpUnit = col.get(j);
                    if (tmpUnit != fieldInfo) continue;
                    index = j;
                }
                if (index > -1) {
                    int lastIndex = this.model.getMainQuery().getUnits().size() - 1;
                    this.model.getMainQuery().getUnits().changeIndex(index, lastIndex);
                    this.modelFieldList.removeElementAt(i);
                    this.modelFieldList.insertElementAt((Object)fieldInfo, this.modelFieldList.size());
                }
            }
            targetIndexs[n] = this.modelFieldList.size() - n - 1;
        }
        this.listQueryField.setSelectedIndices(targetIndexs);
        this.resetCompentstatus();
        this.setDirty(true);
    }

    @Override
    protected void fieldImportbtn_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        try {
            uiContext.put((Object)"model", (Object)this.model);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(QueryFieldSelectUI.class.getName(), (Map)uiContext);
            QueryFieldSelectUI qfs = (QueryFieldSelectUI)uiWindow.getUIObject();
            uiWindow.show();
            if (qfs.isConfirmExit()) {
                List list = qfs.getSelectedList();
                int[] selected = new int[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    CustomListItem item = (CustomListItem)list.get(i);
                    if (item.getEntityNode() == null || item.getFieldNode() == null) continue;
                    QueryFieldInfo queryFieldInfo = this.submitField(item.getEntityNode(), item.getFieldNode());
                    this.modelFieldList.addElement((Object)queryFieldInfo);
                    selected[i] = this.modelFieldList.getSize() - 1;
                }
                this.listQueryField.setSelectedIndices(selected);
            }
        }
        catch (UIException e1) {
            logger.error((Object)e1);
        }
        this.setDirty(true);
    }

    @Override
    protected void fieldRemovebtn_actionPerformed(ActionEvent e) throws Exception {
        super.fieldRemovebtn_actionPerformed(e);
        int index = this.listQueryField.getSelectedIndex();
        if (index == -1) {
            return;
        }
        QueryInfo queryInfo = this.model.getMainQuery();
        Object[] selecteds = this.listQueryField.getSelectedValues();
        for (int i = 0; i < selecteds.length; ++i) {
            QueryFieldInfo queryFieldInfo = (QueryFieldInfo)selecteds[i];
            DynQueryUtil.deleteFromQuery(queryInfo, queryFieldInfo);
        }
        this.updateFieldList();
        if (index > this.modelFieldList.size() - 1) {
            index = this.modelFieldList.size() - 1;
        }
        this.listQueryField.setSelectedIndex(index);
        this.setDirty(true);
    }

    public QueryFieldInfo getQueryFieldInfo() {
        int i = 0;
        if (i < this.listQueryField.getSelectedIndices().length) {
            QueryFieldInfo queryFieldInfo = (QueryFieldInfo)this.modelFieldList.getElementAt(this.listQueryField.getSelectedIndices()[i]);
            return queryFieldInfo;
        }
        return null;
    }

    @Override
    protected void propertyEdit_actionPerformed(ActionEvent e) throws Exception {
        block11: {
            UIContext uiContext = new UIContext((Object)this);
            try {
                uiContext.put((Object)"model", (Object)this.model);
                uiContext.put((Object)"selectedqueryfieldinfo", (Object)this.getQueryFieldInfo());
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(QueryFieldSelectUI.class.getName(), (Map)uiContext);
                QueryFieldSelectUI qfs = (QueryFieldSelectUI)uiWindow.getUIObject();
                uiWindow.show();
                if (!qfs.isConfirmExit()) break block11;
                List list = qfs.getSelectedList();
                QueryFieldInfo field = this.getQueryFieldInfo();
                PropertyRefCollection refCol = this.getQueryFieldInfo().getPropertyRefs();
                refCol.clear();
                for (int i = 0; i < list.size(); ++i) {
                    SubQueryInfo query;
                    QueryFieldInfo queryField;
                    CustomListItem item = (CustomListItem)list.get(i);
                    if (item.getEntityNode() == null || item.getFieldNode() == null) continue;
                    SubObjectInfo subObjectInfo = item.getEntityNode().getSubObjectInfo();
                    String fieldName = item.getFieldNode().getFieldName();
                    if (subObjectInfo instanceof SubEntityInfo) {
                        EntityObjectInfo entity = ((SubEntityInfo)subObjectInfo).getEntityRef();
                        IObjectValue p = entity.getInheritedNoDuplicatedProperties().getObject((Object)fieldName);
                        if (!(p instanceof OwnPropertyInfo)) continue;
                        OwnPropertyInfo prop = (OwnPropertyInfo)p;
                        field.setDisplayName(prop.getAlias());
                        if (prop.getDataType().equals((Object)DataType.ENUM)) {
                            String dataType = prop.getDataType().getJavaTypeName();
                            if ("int".equals(dataType) || "long".equals(dataType)) {
                                field.setReturnType(ConstDataType.INT);
                            }
                            if ("float".equals(dataType) || "double".equals(dataType)) {
                                field.setReturnType(ConstDataType.NUMBER);
                            }
                            if ("String".equals(dataType)) {
                                field.setReturnType(ConstDataType.STRING);
                            }
                        }
                        PropertyRefInfo refInfo = new PropertyRefInfo((PropertyUnitInfo)field, (SubEntityInfo)subObjectInfo, (PropertyInfo)prop);
                        field.getPropertyRefs().add(refInfo);
                        continue;
                    }
                    if (!(subObjectInfo instanceof SubQueryInfo) || (queryField = (query = (SubQueryInfo)subObjectInfo).getQueryRef().getUnits().getQueryFields().get(fieldName)) == null) continue;
                    PropertyRefInfo refInfo = new PropertyRefInfo();
                    refInfo.setRefUnit((PropertyUnitInfo)queryField);
                    refInfo.setSubQuery(query);
                    field.getPropertyRefs().add(refInfo);
                    field.setDisplayName(queryField.getDisplayName());
                }
                try {
                    if (field.getReturnType() != null) {
                        field.setReturnType(field.getReturnType());
                    }
                }
                catch (BOSException err) {
                    field.setReturnType(ConstDataType.OBJECT);
                }
            }
            catch (UIException e1) {
                logger.error((Object)e1);
            }
        }
        this.updateListPropertyRef();
        this.setDirty(true);
    }

    @Override
    protected void listQueryFieldSC_actionPerormed(ListSelectionEvent e) {
        QueryFieldInfo field;
        if (this.listQueryField.getSelectedIndex() == -1) {
            return;
        }
        if (this.listQueryField.getSelectedIndices().length == 1 && this.currentField == (field = (QueryFieldInfo)this.modelFieldList.getElementAt(this.listQueryField.getSelectedIndex()))) {
            return;
        }
        if (this.currentField != null) {
            if (!this.vertify()) {
                SysUtil.abort();
            }
            this.storeQueryFieldInfo(this.currentField);
        }
        this.currentField = this.listQueryField.getSelectedIndices().length > 1 ? null : (QueryFieldInfo)this.modelFieldList.getElementAt(this.listQueryField.getSelectedIndex());
        this.resetCompentstatus();
        if (this.listQueryField.getSelectedIndices().length == 1) {
            this.loadFields(this.currentField);
            this.refreshExtensionTable();
            this.updateListPropertyRef();
        }
    }

    public boolean vertify() {
        String text;
        if (this.currentField == null) {
            return true;
        }
        QueryFieldValidater validater = new QueryFieldValidater(this.model.getMainQuery(), this.currentField);
        if (!validater.validateName(text = this.nameField.getText())) {
            MsgBox.showInfo((String)validater.getMessage());
            this.nameField.requestFocusInWindow();
            this.nameField.setText(this.currentField.getName());
            this.listQueryField.setSelectedValue((Object)this.currentField, true);
            return false;
        }
        return true;
    }

    protected void storeQueryFieldInfo(QueryFieldInfo queryFieldInfo) {
        String text;
        String name = this.nameField.getText().trim();
        String alias = this.aliasField.getText().trim();
        if (!StringUtils.isEmpty((String)name)) {
            queryFieldInfo.setName(name);
        }
        if (!StringUtils.isEmpty((String)alias)) {
            queryFieldInfo.setDisplayName(alias);
        }
        if ((text = this.expressionArea.getText().trim()).length() != 0) {
            try {
                queryFieldInfo.setFormulaString(DynQueryUtil.replaceFormula(text, "||", "&"));
            }
            catch (ParserException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public void resetCompentstatus() {
        if (this.listQueryField.getSelectedIndices().length > 1 || this.currentField == null) {
            this.setComponetStatus(false);
            return;
        }
        this.setComponetStatus(DynQueryUtil.isFieldConfigured(this.currentField));
        this.aliasField.setEnabled(true);
        if (this.currentField.getGroupType().equals((Object)GroupType.NONE)) {
            this.groupTypeComboBox.setEnabled(false);
        }
        if (!DynQueryUtil.isGrouping(this.model.getMainQuery())) {
            this.groupTypeComboBox.setEnabled(false);
        }
        if (this.listQueryField.getSelectedIndex() <= 0) {
            this.fieldFirstbtn.setEnabled(false);
            this.fieldTopbtn.setEnabled(false);
        }
        if (this.listQueryField.getSelectedIndex() >= this.listQueryField.getElementCount() - 1) {
            this.fieldNextbtn.setEnabled(false);
            this.fieldBottombtn.setEnabled(false);
        }
    }

    public void refreshExtensionTable() {
        if (this.listQueryField.getSelectedValues().length > 1) {
            this.extensionTable.removeRows();
            this.extensionTable.setEditable(false);
        } else {
            QueryFieldInfo queryFieldInfo = (QueryFieldInfo)this.modelFieldList.getElementAt(this.listQueryField.getSelectedIndex());
            List epCollection = this.getExtendCollection(queryFieldInfo);
            this.extensionTable.removeRows();
            for (int i = 0; i < epCollection.size(); ++i) {
                ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)epCollection.get(i));
                boolean isConfigured = this.isDynamic((AbstractMDValue)queryFieldInfo, delegate.getName());
                if (!delegate.isUseAble()) continue;
                this.addExtensionRow(delegate, isConfigured);
            }
            this.extensionTable.repaint();
        }
    }

    public void addExtensionRow(ExdPropertyDelegate delegate, boolean isConfigured) {
        IRow row = this.extensionTable.addRow();
        row.getCell("group").setValue((Object)delegate.getGroup());
        row.getCell("name").setValue((Object)delegate.getTempName());
        row.getCell("value").setValue((Object)delegate.getTempExtendProperty().getValue());
        row.getCell("alias").setValue((Object)delegate.getAlias());
        row.getCell("type").setValue((Object)delegate.getType());
        row.getCell("required").setValue((Object)delegate.getRequired());
        row.getCell("description").setValue((Object)delegate.getDescription());
        if (isConfigured) {
            row.getStyleAttributes().setFontColor(Color.BLUE);
        }
        row.setUserObject((Object)delegate);
    }

    public List getExtendCollection(QueryFieldInfo queryFieldInfo) {
        if (queryFieldInfo == null) {
            return null;
        }
        Iterator it = queryFieldInfo.getExtendedProperties().keySet().iterator();
        ArrayList<ExdPropertyDelegate> tempList = new ArrayList<ExdPropertyDelegate>();
        while (it.hasNext()) {
            String keyName = (String)it.next();
            if (keyName.indexOf("_") != -1) continue;
            String value = queryFieldInfo.getExtendedProperty(keyName);
            ExtendPropertyInfo epInfo = new ExtendPropertyInfo();
            epInfo.setName(keyName);
            epInfo.setValue(value);
            ExdPropertyDelegate tempInfo = new ExdPropertyDelegate();
            tempInfo.setTempExtendProperty(epInfo);
            ExdPropertyDelegate deletage = ReadBosConfigUtil.getExdPropertyByName(keyName, (AbstractMDValue)queryFieldInfo);
            String tempName = deletage.getName() == null || deletage.getName().equals("") ? keyName : deletage.getName();
            tempInfo.setTempName(tempName);
            tempInfo.setName(tempName);
            tempInfo.setValue(deletage.getValue());
            tempInfo.setTempValue(deletage.getValue());
            tempInfo.setGroup(deletage.getGroup());
            tempInfo.setAlias(deletage.getAlias());
            tempInfo.setType(deletage.getType());
            tempInfo.setRequired(deletage.getRequired());
            tempInfo.setDescription(deletage.getDescription());
            tempInfo.setUseAble(deletage.isUseAble());
            tempList.add(tempInfo);
        }
        if (tempList.size() > 0) {
            Object[] objs = tempList.toArray();
            GroupComparator comparator = new GroupComparator();
            Arrays.sort(objs, comparator);
            tempList.clear();
            for (int i = 0; i < objs.length; ++i) {
                tempList.add((ExdPropertyDelegate)((Object)objs[i]));
            }
        }
        return tempList;
    }

    public void setExtendCollection(QueryFieldInfo queryFieldInfo) {
    }

    public void setComponetStatus(boolean isconfigure) {
        this.fieldFirstbtn.setEnabled(isconfigure);
        this.fieldTopbtn.setEnabled(isconfigure);
        this.fieldNextbtn.setEnabled(isconfigure);
        this.fieldBottombtn.setEnabled(isconfigure);
        this.visibleBox.setEnabled(isconfigure);
        this.filterBox.setEnabled(isconfigure);
        this.sorterBox.setEnabled(isconfigure);
        this.dynModifyBox.setEnabled(isconfigure);
        this.extensionRemovebtn.setEnabled(isconfigure);
        this.aliasField.setEnabled(isconfigure);
        this.dataTypeComboBox.setEnabled(isconfigure);
        this.fieldRemovebtn.setEnabled(isconfigure);
        this.groupTypeComboBox.setEnabled(isconfigure);
        this.nameField.setEnabled(isconfigure);
        this.expressionArea.setEnabled(isconfigure);
        this.listPropertyRef.setEnabled(isconfigure);
        this.propertyEdit.setEnabled(isconfigure);
    }

    public void updateCtrl(DynQueryModel _model) {
        this.model = _model;
        this.updateFieldList();
    }

    public void updateFieldList() {
        this.listQueryField.removeAllElements();
        PropertyUnitCollection fields = this.model.getMainQuery().getUnits();
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                PropertyUnitInfo unitInfo = fields.get(i);
                if (!(unitInfo instanceof QueryFieldInfo)) continue;
                this.modelFieldList.addElement((Object)fields.get(i));
            }
            this.listQueryField.setSelectedIndex(0);
        }
        this.listQueryField.repaint();
    }

    private void loadFields(QueryFieldInfo queryFieldInfo) {
        if (queryFieldInfo == null) {
            return;
        }
        this.nameField.setText(queryFieldInfo.getName());
        this.aliasField.setText(queryFieldInfo.getDisplayName());
        try {
            this.dataTypeComboBox.setSelectedItem((Object)queryFieldInfo.getReturnType());
        }
        catch (BOSException e) {
            logger.error((Object)"FieldTabbedUI.loadFields", (Throwable)e);
        }
        if (!queryFieldInfo.getGroupType().equals((Object)GroupType.NONE)) {
            this.groupTypeComboBox.setSelectedItem((Object)queryFieldInfo.getGroupType());
        }
        this.visibleBox.setSelected(queryFieldInfo.isIsSelector());
        this.filterBox.setSelected(queryFieldInfo.isIsFilter());
        this.sorterBox.setSelected(queryFieldInfo.isIsSorter());
        String dynmodify = queryFieldInfo.getExtendedProperty("DYNAMIC_CAN_DELETE");
        this.dynModifyBox.setSelected(Boolean.valueOf(dynmodify).booleanValue());
        if (queryFieldInfo.getFormulaString() != null) {
            try {
                this.expressionArea.setText(DynQueryUtil.replaceFormula(queryFieldInfo.getFormulaString(), "&", "||"));
            }
            catch (ParserException e) {
                logger.error((Object)"FieldTabbedUI.loadFields", (Throwable)e);
            }
        }
    }

    public void updateListPropertyRef() {
        this.modelProRefList.removeAllElements();
        if (this.listQueryField.getSelectedValues().length == 1) {
            QueryFieldInfo queryFieldInfo = (QueryFieldInfo)this.modelFieldList.getElementAt(this.listQueryField.getSelectedIndex());
            PropertyRefCollection col = queryFieldInfo.getPropertyRefs();
            for (int i = 0; i < col.size(); ++i) {
                PropertyRefInfo refInfo = col.get(i);
                this.modelProRefList.addElement((Object)refInfo);
            }
            return;
        }
    }

    public QueryFieldInfo submitField(DynQueryEntityTreeModel entityNode, DynQueryFieldModel fieldNode) {
        PropertyRefInfo refInfo;
        boolean grouping;
        QueryFieldInfo field = new QueryFieldInfo(this.model.getMainQuery());
        field.setIsSelector(true);
        field.setIsFilter(true);
        String mainObjectName = null;
        if (this.model.getMainQuery() instanceof JoinQueryInfo) {
            try {
                mainObjectName = QueryUtil.getMainObject((JoinQueryInfo)((JoinQueryInfo)this.model.getMainQuery())).getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (grouping = DynQueryUtil.isGrouping(this.model.getMainQuery())) {
            field.setGroupType(GroupType.GROUPING);
        }
        String unitName = "newUnitName";
        SubObjectInfo subObjectInfo = entityNode.getSubObjectInfo();
        if (subObjectInfo instanceof SubEntityInfo) {
            PropertyInfo p = fieldNode.getPropertyInfo();
            if (p instanceof OwnPropertyInfo) {
                OwnPropertyInfo prop = (OwnPropertyInfo)p;
                MutiLanUtil.setDisplayName(field, prop.getAlias());
                if (prop.getDataType().equals((Object)DataType.ENUM)) {
                    ConstDataType fieldType = null;
                    String metadataRef = prop.getMetaDataRef();
                    if (metadataRef != null) {
                        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)metadataRef);
                        BizEnumInfo enumItem = UictUtils.loadBizEnum(pk);
                        if (enumItem != null) {
                            BizEnumValueType valueType = enumItem.getDataType();
                            if (valueType.equals((Object)BizEnumValueType.INTEGER) || valueType.equals((Object)BizEnumValueType.LONG)) {
                                fieldType = ConstDataType.INT;
                            } else if (valueType.equals((Object)BizEnumValueType.FLOAT) || valueType.equals((Object)BizEnumValueType.DOUBLE)) {
                                fieldType = ConstDataType.NUMBER;
                            } else if (valueType.equals((Object)BizEnumValueType.STRING)) {
                                fieldType = ConstDataType.STRING;
                            }
                        }
                        if (fieldType != null) {
                            field.setReturnType(fieldType);
                        }
                    }
                }
                refInfo = new PropertyRefInfo((PropertyUnitInfo)field, (SubEntityInfo)subObjectInfo, (PropertyInfo)prop);
                field.getPropertyRefs().add(refInfo);
                unitName = mainObjectName != null && mainObjectName.equals(refInfo.getSubEntity().getName()) ? refInfo.getRefProperty().getName() : refInfo.getSubEntity().getName() + "." + refInfo.getRefProperty().getName();
            }
        } else if (subObjectInfo instanceof SubQueryInfo) {
            SubQueryInfo query = (SubQueryInfo)subObjectInfo;
            QueryFieldInfo queryField = fieldNode.getQueryFieldInfo();
            if (queryField instanceof QueryFieldInfo) {
                refInfo = new PropertyRefInfo();
                refInfo.setRefUnit((PropertyUnitInfo)queryField);
                refInfo.setSubQuery(query);
                field.getPropertyRefs().add(refInfo);
                MutiLanUtil.setDisplayName(field, queryField.getDisplayName());
                unitName = refInfo.getSubQuery().getName() + "." + refInfo.getRefUnit().getName();
            }
        }
        PropertyUnitCollection unitColleciton = this.model.getMainQuery().getUnits();
        if (this.nameManager == null) {
            this.nameManager = new ComponentNameManager(false);
            int n = unitColleciton.size();
            for (int j = 0; j < n; ++j) {
                this.nameManager.put(unitColleciton.get(j).getName().toLowerCase());
            }
        }
        if (this.nameManager.isUsed(unitName.toLowerCase())) {
            unitName = this.nameManager.getNameByName(unitName.toLowerCase());
        } else {
            this.nameManager.put(unitName);
        }
        field.setName(unitName);
        try {
            if (field.getReturnType() != null) {
                field.setReturnType(field.getReturnType());
            }
        }
        catch (BOSException err) {
            field.setReturnType(ConstDataType.OBJECT);
        }
        field.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        field.setConfigured(true);
        this.refreshExtendPropertiesList((AbstractMDValue)field, "configured", 1);
        unitColleciton.add((PropertyUnitInfo)field);
        return field;
    }

    @Override
    protected void extensionRemove_Performed(ActionEvent e) throws Exception {
        int rowIndex = this.extensionTable.getSelectManager().get().getTop();
        if (rowIndex < 0) {
            return;
        }
        if (!(this.extensionTable.getRow(rowIndex).getUserObject() instanceof ExdPropertyDelegate)) {
            return;
        }
        ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)this.extensionTable.getRow(rowIndex).getUserObject());
        if (delegate.getName().trim().equals("configured")) {
            return;
        }
        ExtendPropertyInfo item = delegate.getTempExtendProperty();
        if (item != null) {
            String required = delegate.getRequired();
            if (required != null && required.equalsIgnoreCase("true")) {
                return;
            }
            QueryFieldInfo queryFieldInfo = (QueryFieldInfo)this.listQueryField.getSelectedValue();
            if (this.isDynamic((AbstractMDValue)queryFieldInfo, delegate.getName()) && queryFieldInfo.getExtendedProperties().containsKey(delegate.getName())) {
                queryFieldInfo.removeExtendedProperty(delegate.getName());
            }
        }
        this.refreshExtensionTable();
        this.setDirty(true);
        if (this.extensionTable.getRowCount() > 0) {
            if (--rowIndex > 0 && rowIndex < this.extensionTable.getRowCount() - 1) {
                this.extensionTable.getSelectManager().select(rowIndex, 0);
            } else {
                this.extensionTable.getSelectManager().select(0, 0);
            }
        }
    }

    public boolean isDynamic(AbstractMDValue object, String name) {
        boolean isconfig;
        if (object == null || StringUtils.isEmpty((String)name)) {
            return false;
        }
        if (object instanceof QueryFieldInfo && (isconfig = DynQueryUtil.isFieldConfigured((QueryFieldInfo)object))) {
            return true;
        }
        String dynProBinds = object.getExtendedProperty("dynExtendPropertyList");
        if (StringUtils.isEmpty((String)dynProBinds)) {
            return false;
        }
        String[] pros = StringUtils.split((String)dynProBinds, (String)"|");
        if (pros != null) {
            for (int i = 0; i < pros.length; ++i) {
                if (!name.equals(pros[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void extensionEdit_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.extensionTable.getSelectManager().get().getTop();
        if (!(this.extensionTable.getRow(rowIndex).getUserObject() instanceof ExdPropertyDelegate)) {
            return;
        }
        ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)this.extensionTable.getRow(rowIndex).getUserObject());
        if (delegate.getName().trim().equals("configured")) {
            return;
        }
        ExtendPropertyInfo item = delegate.getTempExtendProperty();
        if (item == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        try {
            uiContext.put((Object)"model", (Object)item);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(QueryFieldExtendPropertyUI.class.getName(), (Map)uiContext);
            QueryFieldExtendPropertyUI qfs = (QueryFieldExtendPropertyUI)uiWindow.getUIObject();
            uiWindow.show();
            if (qfs.isConfirmExit()) {
                QueryFieldInfo queryFieldInfo = (QueryFieldInfo)this.listQueryField.getSelectedValue();
                queryFieldInfo.setExtendedProperty(item.getName(), item.getValue());
                this.refreshExtensionTable();
            }
        }
        catch (UIException e1) {
            logger.error((Object)e1);
        }
        this.setDirty(true);
    }

    @Override
    protected void extesionAdd_actionPerformed(ActionEvent e) throws Exception {
        QueryFieldInfo queryFieldInfo = (QueryFieldInfo)this.modelFieldList.getElementAt(this.listQueryField.getSelectedIndex());
        List epCollection = this.getExtendCollection(queryFieldInfo);
        UIContext uiContext = new UIContext((Object)this);
        try {
            uiContext.put((Object)"model", (Object)queryFieldInfo);
            uiContext.put((Object)"epCollection", (Object)epCollection);
            uiContext.put((Object)"mdtype", (Object)"field");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ExtendedPropertySelectUI.class.getName(), (Map)uiContext);
            ExtendedPropertySelectUI qfs = (ExtendedPropertySelectUI)uiWindow.getUIObject();
            uiWindow.show();
            if (qfs.isConfirmExit()) {
                int i;
                List rightList = qfs.getRightList();
                int size = rightList.size();
                ArrayList _old = new ArrayList();
                ArrayList<String> _new = new ArrayList<String>();
                Iterator iterator = queryFieldInfo.getExtendedProperties().keySet().iterator();
                while (iterator.hasNext()) {
                    _old.add(iterator.next());
                }
                queryFieldInfo.getExtendedProperties().clear();
                String[] name = new String[size];
                String[] value = new String[size];
                for (i = 0; i < size; ++i) {
                    ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)rightList.get(i));
                    name[i] = delegate.getName();
                    value[i] = queryFieldInfo.getExtendedProperty(name[i]) == null ? (delegate.getType() != null && delegate.getType().trim().equals("boolean") ? (delegate.getValue().trim().equals("false") ? "false" : (delegate.getValue().trim().equals("true") ? "true" : delegate.getValue())) : delegate.getValue()) : queryFieldInfo.getExtendedProperty(name[i]);
                    _new.add(name[i]);
                    if (_old.contains(name[i])) continue;
                    this.refreshExtendPropertiesList((AbstractMDValue)queryFieldInfo, name[i], 1);
                }
                for (i = 0; i < size; ++i) {
                    queryFieldInfo.setExtendedProperty(name[i], value[i]);
                }
                String deletename = "";
                for (int i2 = 0; i2 < _old.size(); ++i2) {
                    deletename = _old.get(i2).toString();
                    if (_new.contains(deletename)) continue;
                    this.refreshExtendPropertiesList((AbstractMDValue)queryFieldInfo, deletename, -1);
                }
                this.refreshExtensionTable();
            }
        }
        catch (UIException e1) {
            logger.error((Object)e1);
        }
        this.setDirty(true);
    }

    public void refreshExtendPropertiesList(AbstractMDValue object, String name, int operate) {
        if (object == null || StringUtils.isEmpty((String)name)) {
            return;
        }
        if (operate == -1) {
            String dynProBinds = object.getExtendedProperty("dynExtendPropertyList");
            if (!StringUtils.isEmpty((String)dynProBinds)) {
                int i;
                boolean exists = false;
                String[] pros = StringUtils.split((String)dynProBinds, (String)"|");
                if (pros != null && pros.length > 0) {
                    for (i = 0; i < pros.length; ++i) {
                        if (!name.equals(pros[i])) continue;
                        pros[i] = null;
                        exists = true;
                    }
                }
                if (exists) {
                    dynProBinds = null;
                    for (i = 0; i < pros.length; ++i) {
                        if (StringUtils.isEmpty((String)pros[i])) continue;
                        dynProBinds = dynProBinds == null ? pros[i] : dynProBinds + "|" + pros[i];
                    }
                    if (!StringUtils.isEmpty((String)dynProBinds)) {
                        object.setExtendedProperty("dynExtendPropertyList", dynProBinds);
                    } else {
                        object.removeExtendedProperty("dynExtendPropertyList");
                    }
                }
            }
        } else if (operate == 1) {
            String dynProBinds = object.getExtendedProperty("dynExtendPropertyList");
            if (StringUtils.isEmpty((String)dynProBinds)) {
                object.setExtendedProperty("dynExtendPropertyList", name);
            } else {
                String[] pros = StringUtils.split((String)dynProBinds, (String)"|");
                boolean exists = false;
                if (pros != null && pros.length > 0) {
                    for (int i = 0; i < pros.length; ++i) {
                        if (!name.equals(pros[i])) continue;
                        exists = true;
                        break;
                    }
                }
                if (!exists) {
                    dynProBinds = dynProBinds + "|" + name;
                    object.setExtendedProperty("dynExtendPropertyList", dynProBinds);
                }
            }
        }
    }

    @Override
    protected void listPropertyRefSC_actionPerormed() {
    }

    @Override
    protected void btndynModifyBox_actionPerformed(ActionEvent e) throws Exception {
        QueryFieldInfo queryFieldInfo = (QueryFieldInfo)this.modelFieldList.getElementAt(this.listQueryField.getSelectedIndex());
        String value = String.valueOf(this.dynModifyBox.isSelected());
        String key = "DYNAMIC_CAN_DELETE";
        String oldValue = queryFieldInfo.getExtendedProperty("DYNAMIC_CAN_DELETE");
        if (value == null ? oldValue == null : value.equals(oldValue)) {
            return;
        }
        queryFieldInfo.setExtendedProperty(key, value);
        this.setDirty(true);
    }

    @Override
    protected void btnvisibleBox_actionPerformed(ActionEvent e) throws Exception {
        boolean oldIsSelector;
        int index = this.listQueryField.getSelectedIndex();
        if (index < 0 || index > this.modelFieldList.size() - 1) {
            return;
        }
        QueryFieldInfo queryFieldInfo = (QueryFieldInfo)this.modelFieldList.getElementAt(index);
        boolean isSelector = this.visibleBox.isSelected();
        if (isSelector == (oldIsSelector = queryFieldInfo.isIsSelector())) {
            return;
        }
        queryFieldInfo.setIsSelector(this.visibleBox.isSelected());
        if (!isSelector) {
            QueryPKInfo pk;
            QueryFieldCollection pks;
            QueryInfo mainQuery = this.model.getMainQuery();
            QuerySorterItemCollection sorters = mainQuery.getDefaultSorters();
            if (sorters != null) {
                int n = sorters.size();
                for (int i = 0; i < n; ++i) {
                    QuerySorterItemInfo sorter = sorters.get(i);
                    QueryFieldInfo sortField = sorter.getQueryField();
                    if (!queryFieldInfo.equals((Object)sortField)) continue;
                    sorters.remove(sorter);
                }
            }
            if ((pks = (pk = this.model.getMainQuery().getQueryPK()).getKeyPropertys()) != null) {
                int n = pks.size();
                for (int i = 0; i < n; ++i) {
                    QueryFieldInfo pkField = pks.get(i);
                    if (!queryFieldInfo.equals((Object)pkField)) continue;
                    pks.remove(pkField);
                }
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("refresh", "refresh_otherpane");
            this._synchronizer.announce(params);
        }
        this.setDirty(true);
    }

    @Override
    protected void btnfilterBox_actionPerformed(ActionEvent e) throws Exception {
        QueryFieldInfo queryFieldInfo = (QueryFieldInfo)this.modelFieldList.getElementAt(this.listQueryField.getSelectedIndex());
        String value = String.valueOf(this.filterBox.isSelected());
        String oldValue = String.valueOf(queryFieldInfo.isIsFilter());
        if (value == null ? oldValue == null : value.equals(oldValue)) {
            return;
        }
        queryFieldInfo.setIsFilter(this.filterBox.isSelected());
        this.setDirty(true);
    }

    @Override
    protected void btnsorterBox_actionPerformed(ActionEvent e) throws Exception {
        QueryFieldInfo queryFieldInfo = (QueryFieldInfo)this.modelFieldList.getElementAt(this.listQueryField.getSelectedIndex());
        String value = String.valueOf(this.sorterBox.isSelected());
        String oldValue = String.valueOf(queryFieldInfo.isIsSorter());
        if (value == null ? oldValue == null : value.equals(oldValue)) {
            return;
        }
        queryFieldInfo.setIsSorter(this.sorterBox.isSelected());
        this.setDirty(true);
    }

    @Override
    protected void tbExtension_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex;
        this.extensionEditbtn.setEnabled(true);
        if (this.extensionTable.getSelectManager().getBlocks() != null && this.extensionTable.getSelectManager().getBlocks().size() > 0 && this.extensionTable.getRow(rowIndex = this.extensionTable.getSelectManager().get().getTop()).getUserObject() instanceof ExdPropertyDelegate) {
            ExdPropertyDelegate model = (ExdPropertyDelegate)((Object)this.extensionTable.getRow(rowIndex).getUserObject());
            if (model.getName().trim().equals("configured")) {
                this.extensionEditbtn.setEnabled(false);
                this.extensionRemovebtn.setEnabled(false);
            }
            if (e.getClickCount() == 2 && !model.getName().trim().equals("configured")) {
                this.extensionEdit_actionPerformed(null);
            }
            if (this.isDynamic((AbstractMDValue)((QueryFieldInfo)this.listQueryField.getSelectedValue()), model.getName())) {
                this.extensionEditbtn.setEnabled(true);
                this.extensionRemovebtn.setEnabled(true);
            }
        }
    }

    public void setTabbedSynchronizer(DynQueryEditor.ITabbedSynchronizer synchronizer) {
        this._synchronizer = synchronizer;
    }

    @Override
    protected void nameFieldFocusLost(FocusEvent e) {
        if (this.listQueryField.getSelectedIndex() == -1) {
            return;
        }
        String name = this.nameField.getText().trim();
        if (this.currentField != null && name != null && !name.equals(this.currentField.getName())) {
            this.setDirty(true);
            this.setNeedupdate(true);
        }
    }

    @Override
    protected void aliasFieldFocusLost(FocusEvent e) {
    }

    @Override
    protected void expressionAreaFieldFocusLost(FocusEvent e) {
    }

    public void setDirty(boolean dirty) {
        if (dirty) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("type", "isdirty");
            this._synchronizer.announce(params);
        }
    }

    public void setNeedupdate(boolean needupdate) {
        this.needupdate = needupdate;
    }

    @Override
    protected void dataTypeCBpropertyChange(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (this.listQueryField.getSelectedIndex() == -1) {
                return;
            }
            QueryFieldInfo queryFieldInfo = (QueryFieldInfo)this.modelFieldList.getElementAt(this.listQueryField.getSelectedIndex());
            try {
                ConstDataType type = queryFieldInfo.getReturnType();
                if (type == (ConstDataType)this.dataTypeComboBox.getSelectedItem()) {
                    return;
                }
                queryFieldInfo.setReturnType((ConstDataType)this.dataTypeComboBox.getSelectedItem());
                this.setDirty(true);
            }
            catch (BOSException e1) {
                logger.error((Object)"FieldTabbedUI.dataTypeCBpropertyChange", (Throwable)e1);
            }
        }
    }

    @Override
    protected void groupTypeCBpropertyChange(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (this.listQueryField.getSelectedIndex() == -1) {
                return;
            }
            QueryFieldInfo queryFieldInfo = (QueryFieldInfo)this.modelFieldList.getElementAt(this.listQueryField.getSelectedIndex());
            GroupType groupType = queryFieldInfo.getGroupType();
            if (groupType == (GroupType)this.groupTypeComboBox.getSelectedItem()) {
                return;
            }
            queryFieldInfo.setGroupType((GroupType)this.groupTypeComboBox.getSelectedItem());
            this.setDirty(true);
        }
    }

    public boolean isNeedupdate() {
        return this.needupdate;
    }

    private static class ProRefListCellRender
    extends DefaultKingdeeListCellRenderer {
        private ProRefListCellRender() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component ctrl = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            PropertyRefInfo refInfo = (PropertyRefInfo)value;
            String name = "?";
            if (refInfo.getSubEntity() != null) {
                SubEntityInfo subEntity = refInfo.getSubEntity();
                PropertyInfo prop = refInfo.getRefProperty();
                name = subEntity.getName() + "." + prop.getName() + "(#" + index + ")";
            } else if (refInfo.getSubQuery() != null) {
                SubQueryInfo subQuery = refInfo.getSubQuery();
                PropertyUnitInfo unit = refInfo.getRefUnit();
                name = subQuery.getName() + "." + unit.getName() + "(#" + index + ")";
            }
            this.setText(name);
            return ctrl;
        }
    }

    private static class CustomListCellRender
    extends DefaultKingdeeListCellRenderer {
        private CustomListCellRender() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component ctrl = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            QueryFieldInfo item = (QueryFieldInfo)value;
            if (DynQueryUtil.isFieldConfigured(item)) {
                Color fc = Color.BLUE;
                Color bc = list.getBackground();
                if (isSelected) {
                    ctrl.setForeground(bc);
                    ctrl.setBackground(fc);
                } else {
                    ctrl.setForeground(fc);
                    ctrl.setBackground(bc);
                }
            }
            this.setIcon(EASResource.getIcon((String)"imgTbtn_sortorder"));
            return ctrl;
        }
    }

    private class expressionAreaAdapter
    extends KeyAdapter {
        private expressionAreaAdapter() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            Object comp = e.getSource();
            if (comp instanceof KDTextArea) {
                String text = ((KDTextArea)comp).getText();
                if (FieldTabbedUI.this.listQueryField.getSelectedIndex() == -1) {
                    return;
                }
                QueryFieldInfo queryFieldInfo = (QueryFieldInfo)FieldTabbedUI.this.modelFieldList.getElementAt(FieldTabbedUI.this.listQueryField.getSelectedIndex());
                try {
                    String formula;
                    if (!StringUtils.isEmpty((String)text) && !(text = text.trim()).equals(formula = DynQueryUtil.replaceFormula(queryFieldInfo.getFormulaString(), "||", "&"))) {
                        queryFieldInfo.setFormulaString(DynQueryUtil.replaceFormula(text, "||", "&"));
                    }
                }
                catch (Exception ec) {
                    logger.error((Object)ec.getStackTrace());
                }
            }
        }
    }

    private class fieldAdapter
    extends KeyAdapter {
        private fieldAdapter() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            Object comp = e.getSource();
            if (comp == null) {
                return;
            }
            if (comp instanceof KDTextField) {
                String text = ((KDTextField)comp).getText();
                if (FieldTabbedUI.this.listQueryField.getSelectedIndex() == -1) {
                    return;
                }
                QueryFieldInfo queryFieldInfo = (QueryFieldInfo)FieldTabbedUI.this.modelFieldList.getElementAt(FieldTabbedUI.this.listQueryField.getSelectedIndex());
                String compName = ((KDTextField)comp).getName();
                if (FieldTabbedUI.this.aliasField.getName().equals(compName)) {
                    if (!StringUtils.isEmpty((String)text)) {
                        String alias;
                        if (!(text = text.trim()).equals(alias = queryFieldInfo.getDisplayName())) {
                            MutiLanUtil.setDisplayName(queryFieldInfo, text);
                        }
                    } else if (!StringUtils.isEmpty((String)queryFieldInfo.getDisplayName())) {
                        queryFieldInfo.setDisplayName("");
                    }
                }
            }
        }
    }
}

