/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.query.ui;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.eas.ep.client.editor.query.ui.AbstractExtendedPropertySelectUI;
import com.kingdee.eas.ep.client.model.extendproperty.ExdPropertyDelegate;
import com.kingdee.eas.ep.client.model.extendproperty.ReadBosConfigUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class QueryFieldExtendedPropertySelectUI
extends AbstractExtendedPropertySelectUI {
    public static final String propertyCollection = "epCollection";
    public static final String FIELD = "field";
    private String type = "field";
    public static final String MDTYPE = "mdtype";
    private List leftList = new ArrayList();
    private List rightList = new ArrayList();
    private boolean confirmExit;

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiContext = this.getUIContext();
        List epCollection = (List)uiContext.get(propertyCollection);
        Object object = uiContext.get(MDTYPE);
        if (object != null && object instanceof String) {
            String mdtype;
            this.type = mdtype = object.toString();
        }
        List list = ReadBosConfigUtil.getAllExtendProperty(this.type, null);
        this.wrapModel(list, epCollection);
        this.loadFields();
    }

    private void wrapModel(List list, List inHereCol) {
        int i;
        if (list == null || list.size() == 0) {
            return;
        }
        int j = list.size();
        for (i = 0; i < j; ++i) {
            if (!(list.get(i) instanceof ExdPropertyDelegate)) continue;
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)list.get(i));
            boolean exist = false;
            if (inHereCol != null) {
                for (int k = 0; k < inHereCol.size(); ++k) {
                    ExdPropertyDelegate info = (ExdPropertyDelegate)((Object)inHereCol.get(k));
                    String name = info.getName();
                    if (name == null || !name.equals(delegate.getName())) continue;
                    delegate.setValue(info.getValue());
                    exist = true;
                    break;
                }
            }
            if (exist) {
                this.rightList.add(delegate);
                continue;
            }
            this.leftList.add(delegate);
        }
        if (inHereCol != null) {
            j = inHereCol.size();
            for (i = 0; i < j; ++i) {
                ExdPropertyDelegate info = (ExdPropertyDelegate)((Object)inHereCol.get(i));
                String infoName = info.getName();
                if (infoName == null) continue;
                boolean hasEqu = false;
                int l = list.size();
                for (int k = 0; k < l; ++k) {
                    ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)list.get(k));
                    String dName = delegate.getName();
                    if (dName == null || !infoName.equals(dName)) continue;
                    hasEqu = true;
                    break;
                }
                if (hasEqu) continue;
                String infoValue = info.getValue();
                ExdPropertyDelegate dele = new ExdPropertyDelegate();
                dele.setName(infoName);
                dele.setValue(infoValue);
                this.rightList.add(dele);
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.refreshTables();
    }

    private void refreshTables() {
        this.tbAllEP.removeRows();
        this.tbSelectedEP.removeRows();
        this.setTableData(this.leftList, this.tbAllEP);
        this.fillRightTabel(this.rightList, this.tbSelectedEP);
        if (this.tbAllEP.getRowCount() > 0) {
            this.tbAllEP.getSelectManager().add(0, 0);
        }
        if (this.tbSelectedEP.getRowCount() > 0) {
            this.tbSelectedEP.getSelectManager().add(this.tbSelectedEP.getRowCount() - 1, 0);
        }
    }

    private void setTableData(List list, KDTable table) {
        if (list == null || table == null) {
            return;
        }
        table.removeRows();
        for (int i = 0; i < list.size(); ++i) {
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)list.get(i));
            if (!delegate.isUseAble()) continue;
            IRow row = table.addRow();
            row.getCell("group").setValue((Object)delegate.getGroup());
            row.getCell("name").setValue((Object)delegate.getName());
            row.getCell("alias").setValue((Object)delegate.getAlias());
            row.getCell("type").setValue((Object)delegate.getType());
            row.getCell("required").setValue((Object)delegate.getRequired());
            row.getCell("descript").setValue((Object)delegate.getDescription());
            row.getCell("default").setValue((Object)delegate.getDefaultValue());
            row.setUserObject((Object)delegate);
        }
        table.repaint();
    }

    private void fillRightTabel(List list, KDTable table) {
        if (list == null || table == null) {
            return;
        }
        table.removeRows();
        for (int i = 0; i < list.size(); ++i) {
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)list.get(i));
            if (!delegate.isUseAble()) continue;
            String name = delegate.getName();
            IRow row = table.addRow();
            row.getCell("group").setValue((Object)delegate.getGroup());
            row.getCell("name").setValue((Object)delegate.getName());
            row.getCell("alias").setValue((Object)delegate.getAlias());
            row.getCell("type").setValue((Object)delegate.getType());
            row.getCell("required").setValue((Object)delegate.getRequired());
            row.getCell("descript").setValue((Object)delegate.getDescription());
            row.getCell("default").setValue((Object)delegate.getDefaultValue());
            row.setUserObject((Object)delegate);
        }
        table.repaint();
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tbAllEP);
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = this.tbAllEP.getRow(selectRows[i]);
            if (row == null) continue;
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
            this.rightList.add(delegate);
            this.leftList.remove((Object)delegate);
        }
        this.refreshTables();
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemove_actionPerformed(e);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tbSelectedEP);
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = this.tbSelectedEP.getRow(selectRows[i]);
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
            this.leftList.add(delegate);
            this.rightList.remove((Object)delegate);
        }
        this.refreshTables();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        for (int i = 0; i < this.tbAllEP.getRowCount(); ++i) {
            IRow row = this.tbAllEP.getRow(i);
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
            this.rightList.add(delegate);
            this.leftList.remove((Object)delegate);
        }
        this.refreshTables();
    }

    @Override
    protected void btnRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemoveAll_actionPerformed(e);
        for (int i = 0; i < this.tbSelectedEP.getRowCount(); ++i) {
            IRow row = this.tbSelectedEP.getRow(i);
            ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
            this.leftList.add(delegate);
            this.rightList.remove((Object)delegate);
        }
        this.refreshTables();
    }

    @Override
    protected void btnPrevious_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tbSelectedEP);
        if (this.tbSelectedEP.getSelectManager().getBlocks() != null && this.tbSelectedEP.getSelectManager().getBlocks().size() > 0) {
            this.tbSelectedEP.getSelectManager().removeAll();
            for (int i = 0; i <= selectRows.length - 1; ++i) {
                int rowIndex = selectRows[i];
                if (rowIndex <= 0 || rowIndex > this.tbSelectedEP.getRowCount() - 1) continue;
                IRow row = this.tbSelectedEP.getRow(rowIndex);
                ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
                this.rightList.remove((Object)delegate);
                this.rightList.add(rowIndex - 1, delegate);
                this.tbSelectedEP.moveRow(rowIndex, rowIndex - 1);
                this.tbSelectedEP.getSelectManager().add(rowIndex - 1, 0);
            }
        }
    }

    @Override
    protected void btnBottom_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tbSelectedEP);
        if (this.tbSelectedEP.getSelectManager().getBlocks() != null && this.tbSelectedEP.getSelectManager().getBlocks().size() > 0) {
            this.tbSelectedEP.getSelectManager().removeAll();
            for (int i = selectRows.length - 1; i >= 0; --i) {
                int rowIndex = selectRows[i];
                if (rowIndex < 0 || rowIndex >= this.tbSelectedEP.getRowCount() - 1) continue;
                int moveVolume = this.tbSelectedEP.getRowCount() - 1 - rowIndex - (selectRows.length - 1 - i);
                IRow row = this.tbSelectedEP.getRow(rowIndex);
                ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
                this.rightList.remove((Object)delegate);
                this.rightList.add(rowIndex + moveVolume, delegate);
                this.tbSelectedEP.moveRow(rowIndex, rowIndex + moveVolume);
                this.tbSelectedEP.getSelectManager().add(rowIndex + moveVolume, 0);
            }
        }
    }

    @Override
    protected void btnTop_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tbSelectedEP);
        if (this.tbSelectedEP.getSelectManager().getBlocks() != null && this.tbSelectedEP.getSelectManager().getBlocks().size() > 0) {
            this.tbSelectedEP.getSelectManager().removeAll();
            for (int i = 0; i <= selectRows.length - 1; ++i) {
                int rowIndex = selectRows[i];
                if (rowIndex <= 0 || rowIndex > this.tbSelectedEP.getRowCount() - 1) continue;
                int moveVolume = 0 - rowIndex + i;
                IRow row = this.tbSelectedEP.getRow(rowIndex);
                ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
                this.rightList.remove((Object)delegate);
                this.rightList.add(rowIndex + moveVolume, delegate);
                this.tbSelectedEP.moveRow(rowIndex, rowIndex + moveVolume);
                this.tbSelectedEP.getSelectManager().add(rowIndex + moveVolume, 0);
            }
        }
    }

    @Override
    protected void btnNext_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tbSelectedEP);
        if (this.tbSelectedEP.getSelectManager().getBlocks() != null && this.tbSelectedEP.getSelectManager().getBlocks().size() > 0) {
            this.tbSelectedEP.getSelectManager().removeAll();
            for (int i = selectRows.length - 1; i >= 0; --i) {
                int rowIndex = selectRows[i];
                if (this.tbSelectedEP.getRowCount() - 1 <= rowIndex || rowIndex < 0) continue;
                IRow row = this.tbSelectedEP.getRow(rowIndex);
                ExdPropertyDelegate delegate = (ExdPropertyDelegate)((Object)row.getUserObject());
                this.rightList.remove((Object)delegate);
                this.rightList.add(rowIndex + 1, delegate);
                this.tbSelectedEP.moveRow(rowIndex, rowIndex + 1);
                this.tbSelectedEP.getSelectManager().add(rowIndex + 1, 0);
            }
        }
    }

    public boolean isConfirmExit() {
        return this.confirmExit;
    }

    public void setConfirmExit(boolean confirmExit) {
        this.confirmExit = confirmExit;
    }

    public List getRightList() {
        return this.rightList;
    }

    public void setRightList(List rightList) {
        this.rightList = rightList;
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.setConfirmExit(true);
        this.destroyWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setConfirmExit(false);
        this.destroyWindow();
    }
}

