/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.query.ui;

import com.kingdee.bos.ctrl.common.ui.ListView;
import com.kingdee.bos.ctrl.common.ui.NormalSelector;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.query.model.DynQueryEntityTreeModel;
import com.kingdee.eas.ep.client.editor.query.model.DynQueryFieldModel;
import com.kingdee.eas.ep.client.editor.query.model.DynQueryModel;
import com.kingdee.eas.ep.client.editor.query.ui.AbstractQueryFieldSelectUI;
import com.kingdee.eas.ep.client.editor.query.ui.CustomListItem;
import com.kingdee.eas.ep.client.editor.query.ui.EntityTabbedUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class QueryFieldSelectUI
extends AbstractQueryFieldSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(QueryFieldSelectUI.class);
    public static final String SELECTEDQUERYFIELDINFO = "selectedqueryfieldinfo";
    private CustomSelector _fieldSelector;
    private KDTree _treSupply;
    private DynQueryModel model;
    private boolean confirmExit;
    private QueryFieldInfo queryFieldInfo;

    public void init() {
        this._fieldSelector = new CustomSelector();
        this._fieldSelector.setVisible(true);
        this.kDPanel1.add((Component)((Object)this._fieldSelector), (Object)"Center");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        Map uiContext = this.getUIContext();
        if (uiContext.get("model") == null || !(uiContext.get("model") instanceof DynQueryModel)) {
            logger.error((Object)"\u52a0\u8f7dmodel\u5931\u8d25");
            throw new Exception();
        }
        this.model = (DynQueryModel)uiContext.get("model");
        if (uiContext.get("model") != null && uiContext.get("model") instanceof DynQueryModel) {
            this.queryFieldInfo = (QueryFieldInfo)uiContext.get(SELECTEDQUERYFIELDINFO);
        }
        DefaultKingdeeTreeNode root = this.createTreeNode(this.model.getRootEntityNode());
        this._treSupply.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this._treSupply.setRootVisible(true);
        this._treSupply.expandPath(new TreePath(root));
        this._treSupply.setSelectionPath(new TreePath(root));
        if (this.queryFieldInfo != null) {
            this.initSelectedList();
        }
    }

    public void initSelectedList() {
        PropertyRefCollection col = this.queryFieldInfo.getPropertyRefs();
        for (int i = 0; i < col.size(); ++i) {
            CustomListItem item = new CustomListItem();
            PropertyRefInfo propRef = col.get(i);
            if (propRef.getSubEntity() == null) {
                if (propRef.getSubQuery() != null) {
                    return;
                }
                return;
            }
            PropertyInfo refProp = propRef.getRefProperty();
            SubEntityInfo subObjectInfo = propRef.getSubEntity();
            DynQueryFieldModel fieldNode = new DynQueryFieldModel(refProp.getName(), refProp.getAlias());
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this._treSupply.getModel().getRoot();
            DynQueryEntityTreeModel entityNode = (DynQueryEntityTreeModel)root.getUserObject();
            DynQueryEntityTreeModel parentNode = entityNode.searchNode(subObjectInfo.getName());
            item.setEntityNode(parentNode);
            item.setFieldNode(fieldNode);
            if (this._fieldSelector.getSelectedList().isContainsElement((Object)item)) continue;
            this._fieldSelector.getSelectedList().addElement((Object)item);
        }
    }

    public void getTreeNode() {
    }

    private DefaultKingdeeTreeNode createTreeNode(DynQueryEntityTreeModel entityNode) {
        DefaultKingdeeTreeNode entityTreeNode = EntityTabbedUI.createTreeNode(entityNode);
        if (!StringUtil.isEmptyString((String)entityNode.getEntityAlias())) {
            StringBuffer sb = new StringBuffer();
            sb.append(entityNode.getEntityAlias());
            sb.append(" (");
            sb.append(entityNode.getEntityName());
            sb.append(")");
            entityTreeNode.setText(sb.toString());
        }
        int c = entityNode.getChildrenCount();
        for (int i = 0; i < c; ++i) {
            entityTreeNode.add((MutableTreeNode)this.createTreeNode(entityNode.getChild(i)));
        }
        try {
            DynQueryFieldModel[] fields = entityNode.getAllFields();
            int c2 = fields.length;
            for (int i = 0; i < c2; ++i) {
                DefaultKingdeeTreeNode fieldTreeNode = new DefaultKingdeeTreeNode((Object)fields[i]);
                if (!fields[i].isSystem()) {
                    fieldTreeNode.setTextColor(Color.BLUE);
                }
                entityTreeNode.add((MutableTreeNode)fieldTreeNode);
            }
        }
        catch (Exception e) {
            logger.error((Object)"QueryFieldSelectUI.createTreeNode", (Throwable)e);
        }
        return entityTreeNode;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public List getSelectedList() {
        ArrayList<CustomListItem> selectedList = new ArrayList<CustomListItem>();
        KDList list = this._fieldSelector.getSelectedList();
        for (int i = 0; i < list.getElementCount(); ++i) {
            CustomListItem item = (CustomListItem)list.getElement(i);
            selectedList.add(item);
        }
        return selectedList;
    }

    public boolean isConfirmExit() {
        return this.confirmExit;
    }

    public void setConfirmExit(boolean confirmExit) {
        this.confirmExit = confirmExit;
    }

    @Override
    public void btnConfirm_actionPerform() {
        this.setConfirmExit(true);
        this.destroyWindow();
    }

    @Override
    public void btnCancel_actionPerform() {
        this.setConfirmExit(false);
        this.destroyWindow();
    }

    private class CustomSelector
    extends NormalSelector {
        public CustomSelector() {
            QueryFieldSelectUI.this._treSupply = new KDTree();
            QueryFieldSelectUI.this._treSupply.setShowsRootHandles(true);
            this.getSelected().getButton(ListView.BUTTON_MOVE_UP).setEnabled(false);
            this.getSelected().getButton(ListView.BUTTON_MOVE_DOWN).setEnabled(false);
            QueryFieldSelectUI.this._treSupply.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                    QueryFieldSelectUI.this._treSupply.clearSelection();
                }

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    QueryFieldSelectUI.this._treSupply.clearSelection();
                }
            });
            QueryFieldSelectUI.this._treSupply.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        CustomSelector.this.onSelect();
                    }
                }
            });
            this.getSelectedList().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        CustomSelector.this.onDelete();
                    }
                    if (e.getClickCount() == 1) {
                        CustomSelector.this.getSelected().getButton(ListView.BUTTON_MOVE_UP).setEnabled(true);
                        CustomSelector.this.getSelected().getButton(ListView.BUTTON_MOVE_DOWN).setEnabled(true);
                    }
                }
            });
            KDTreeView treeView = new KDTreeView();
            treeView.setName("treeView");
            treeView.setTree(QueryFieldSelectUI.this._treSupply);
            this.setSupplyCtrlNoScroll((JComponent)treeView);
            this.setSupplyTitle(MultiLanguageUtil.getMLS((String)"ui.FieldTabbedUI.fieldSupplyTitle", (String)"\u5b9e\u4f53\u53ca\u5176\u6240\u6709\u5b57\u6bb5\uff1a"));
            this.setSelectedTitle(MultiLanguageUtil.getMLS((String)"ui.FieldTabbedUI.fieldSelectedTitle", (String)"\u5df2\u9009\u5b57\u6bb5\uff1a"));
            this.btnSelectAll.setVisible(false);
            this.btnDeleteAll.setVisible(false);
            this.btnSelect.setToolTipText("\u9009\u62e9");
            this.btnDelete.setToolTipText("\u5220\u9664");
        }

        protected void syncListViewButton() {
            super.syncListViewButton();
            this.btnDeleteAll.setEnabled(false);
        }

        protected void onSelect() {
            TreePath[] paths = QueryFieldSelectUI.this._treSupply.getSelectionPaths();
            if (paths != null) {
                for (int i = 0; i < paths.length; ++i) {
                    DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)paths[i].getLastPathComponent();
                    if (treeNode.getUserObject() instanceof DynQueryFieldModel) {
                        DefaultKingdeeTreeNode parentTreeNode = (DefaultKingdeeTreeNode)treeNode.getParent();
                        CustomListItem item = new CustomListItem();
                        item.setEntityNode((DynQueryEntityTreeModel)parentTreeNode.getUserObject());
                        item.setFieldNode((DynQueryFieldModel)treeNode.getUserObject());
                        if (this.getSelectedList().isContainsElement((Object)item)) continue;
                        this.getSelectedList().addElement((Object)item);
                        continue;
                    }
                    if (!(treeNode.getUserObject() instanceof DynQueryEntityTreeModel)) continue;
                    for (int j = 0; j < treeNode.getChildCount(); ++j) {
                        DefaultKingdeeTreeNode childTreeNode = (DefaultKingdeeTreeNode)treeNode.getChildAt(j);
                        if (!(treeNode.getUserObject() instanceof DynQueryFieldModel)) continue;
                        CustomListItem item = new CustomListItem();
                        item.setEntityNode((DynQueryEntityTreeModel)treeNode.getUserObject());
                        item.setFieldNode((DynQueryFieldModel)childTreeNode.getUserObject());
                        if (this.getSelectedList().isContainsElement((Object)item)) continue;
                        this.getSelectedList().addElement((Object)item);
                    }
                }
            }
        }

        protected boolean onDelete() {
            int[] selectedIndexs = this.getSelectedList().getSelectedIndices();
            for (int i = selectedIndexs.length - 1; i >= 0; --i) {
                this.getSelectedList().removeElementAt(selectedIndexs[i]);
            }
            this.getSelectedList().setSelectedIndex(0);
            return true;
        }
    }
}

