/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.query.ui;

import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryFilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.QuerySorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.query.ui.AbstractQueryFilterDefineUI;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import org.apache.log4j.Logger;

public class QueryFilterDefineUI
extends AbstractQueryFilterDefineUI {
    private static final Logger logger = CoreUIObject.getLogger(QueryFilterDefineUI.class);
    private String[] COMPARE_TYPE = new String[]{CompareType.EQUALS.getName(), CompareType.GREATER.getName(), CompareType.LESS.getName(), CompareType.GREATER_EQUALS.getName(), CompareType.LESS_EQUALS.getName(), CompareType.NOTEQUALS.getName(), CompareType.LIKE.getName(), CompareType.NOTLIKE.getName(), CompareType.INCLUDE.getName(), CompareType.NOTINCLUDE.getName()};
    private boolean confirmExit;
    public static final String MODEL = "model";
    public static final String QUERYFILTERINFO = "queryfilterinfo";
    private QueryInfo queryInfo;
    private QueryFilterItemInfo itemInfo;
    private DefaultListModel modelIncludeCollection;
    boolean invalid = false;

    @Override
    public void storeFields() {
        super.storeFields();
        String compareValue = this.fieldCompareValue.getText().trim();
        String compareType = this.combCompareType.getSelectedItem().toString();
        if (this.combField.getSelectedItem() == null || this.combCompareType.getSelectedItem() == null) {
            this.invalid = true;
            MsgBox.showError((String)"\u8f93\u5165\u7684\u4fe1\u606f\u4e0d\u5b8c\u6574\uff01");
            return;
        }
        String queryField = this.combField.getSelectedItem().toString();
        ArrayList<String> includedItems = new ArrayList<String>();
        for (int i = 0; i < this.modelIncludeCollection.size(); ++i) {
            includedItems.add(this.modelIncludeCollection.getElementAt(i).toString());
        }
        this.invalid = false;
        if (StringUtils.isEmpty((String)compareType) || StringUtils.isEmpty((String)queryField)) {
            this.invalid = true;
        } else if (compareType.equals(CompareType.INCLUDE.getName()) || compareType.equals(CompareType.NOTINCLUDE.getName())) {
            if (includedItems == null || includedItems.size() == 0) {
                this.invalid = true;
            }
        } else if (compareValue == null || compareValue.length() == 0) {
            this.invalid = true;
        }
        if (this.invalid) {
            MsgBox.showError((String)"\u8f93\u5165\u7684\u4fe1\u606f\u4e0d\u5b8c\u6574\uff01");
            return;
        }
        this.itemInfo.setCompareType(CompareType.getEnum((String)compareType));
        QueryFieldCollection col = this.queryInfo.getUnits().getQueryFields();
        for (int i = 0; i < col.size(); ++i) {
            String qname = col.get(i).getName();
            if (!qname.equals(queryField)) continue;
            this.itemInfo.setQueryField(col.get(i));
        }
        if (compareType.equals(CompareType.INCLUDE.getName()) || compareType.equals(CompareType.NOTINCLUDE.getName())) {
            HashSet itemsSet = new HashSet();
            for (int i = 0; i < includedItems.size(); ++i) {
                itemsSet.add(includedItems.get(i));
            }
            this.itemInfo.setCompareValue(itemsSet);
        } else if ("null".equalsIgnoreCase(compareValue)) {
            this.itemInfo.setCompareValue(null);
        } else {
            this.itemInfo.setCompareValue((Object)compareValue);
        }
        this.setConfirmExit(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiContext = this.getUIContext();
        if (uiContext.get(MODEL) == null || !(uiContext.get(MODEL) instanceof QueryInfo)) {
            logger.error((Object)"\u52a0\u8f7dqueryInfo\u5931\u8d25");
            return;
        }
        this.queryInfo = (QueryInfo)uiContext.get(MODEL);
        if (uiContext.get(QUERYFILTERINFO) != null || uiContext.get(QUERYFILTERINFO) instanceof QuerySorterItemInfo) {
            this.itemInfo = (QueryFilterItemInfo)uiContext.get(QUERYFILTERINFO);
        } else {
            this.itemInfo = new QueryFilterItemInfo();
            this.itemInfo.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        }
        this.init();
    }

    public void init() {
        this.modelIncludeCollection = new DefaultListModel();
        this.lstIncludeCollection.setModel((ListModel)this.modelIncludeCollection);
        this.combCompareType.addItems((Object[])this.COMPARE_TYPE);
        QueryFieldCollection col = this.queryInfo.getUnits().getQueryFields();
        ArrayList<String> qfList = new ArrayList<String>();
        for (int i = 0; i < col.size(); ++i) {
            QueryFieldInfo qf = col.get(i);
            if (!qf.isIsFilter()) continue;
            qfList.add(qf.getName());
        }
        this.combField.addItems(qfList.toArray());
        if (this.itemInfo != null) {
            this.combField.setSelectedItem((Object)(this.itemInfo.getQueryField() == null ? "" : this.itemInfo.getQueryField().getName()));
            this.combCompareType.setSelectedItem((Object)(this.itemInfo.getCompareType() == null ? "" : this.itemInfo.getCompareType().getName()));
            if (this.itemInfo.getCompareType() == null) {
                this.panelIn.setVisible(false);
            } else if (this.itemInfo.getCompareType().equals((Object)CompareType.INCLUDE) || this.itemInfo.getCompareType().equals((Object)CompareType.NOTINCLUDE)) {
                this.panelIn.setVisible(true);
                this.fieldCompareValue.setVisible(false);
                this.combCompareType.setSelectedItem((Object)this.itemInfo.getCompareType().getName());
                Set values = (Set)this.itemInfo.getCompareValue();
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    this.modelIncludeCollection.addElement(iterator.next());
                }
            } else {
                this.panelIn.setVisible(false);
                this.combCompareType.setSelectedItem((Object)this.itemInfo.getCompareType().getName());
                this.fieldCompareValue.setText(this.itemInfo.getCompareValue() == null ? "" : this.itemInfo.getCompareValue().toString());
            }
        }
    }

    public QueryFilterItemInfo getFilterItemInfo() {
        return this.itemInfo;
    }

    public boolean isConfirmExit() {
        return this.confirmExit;
    }

    public void setConfirmExit(boolean confirmExit) {
        this.confirmExit = confirmExit;
    }

    @Override
    protected void txtIncludeItem_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        if (this.txtIncludeItem.getText().trim().length() > 0) {
            String value = this.txtIncludeItem.getText().trim();
            for (int i = 0; i < this.modelIncludeCollection.getSize(); ++i) {
                Object element = this.modelIncludeCollection.getElementAt(i);
                if (!value.equals(element.toString())) continue;
                MsgBox.showWarning((Component)((Object)this), (String)"\u91cd\u590d\u7684\u6761\u76ee");
                return;
            }
            this.modelIncludeCollection.addElement(value);
            this.txtIncludeItem.setText("");
            this.lstIncludeCollection.setSelectedIndex(this.modelIncludeCollection.size() - 1);
        }
    }

    @Override
    protected void btnUpdate_actionPerformed(ActionEvent e) throws Exception {
        if (this.lstIncludeCollection.getSelectedIndices().length == 1) {
            String value = this.txtIncludeItem.getText().trim();
            for (int i = 0; i < this.modelIncludeCollection.size(); ++i) {
                if (i == this.lstIncludeCollection.getSelectedIndex() || !this.modelIncludeCollection.getElementAt(i).equals(value)) continue;
                MsgBox.showWarning((Component)((Object)this), (String)"\u91cd\u590d\u7684\u6761\u76ee");
                return;
            }
            this.modelIncludeCollection.setElementAt(value, this.lstIncludeCollection.getSelectedIndex());
        }
    }

    @Override
    protected void combCompareType_actionPerformed(ActionEvent e) throws Exception {
        String compareType = this.combCompareType.getSelectedItem().toString();
        this.fieldCompareValue.requestFocus();
        if (compareType.equals(CompareType.INCLUDE.getName()) || compareType.equals(CompareType.NOTINCLUDE.getName())) {
            this.panelIn.setVisible(true);
            this.fieldCompareValue.setVisible(false);
        } else if (compareType.equals(CompareType.LIKE.getName()) || compareType.equals(CompareType.NOTLIKE.getName())) {
            this.fieldCompareValue.setText("%%");
            this.fieldCompareValue.setVisible(true);
            this.panelIn.setVisible(false);
            this.fieldCompareValue.setCaretPosition(1);
        } else {
            this.panelIn.setVisible(false);
            this.fieldCompareValue.setVisible(true);
            this.fieldCompareValue.setText("");
        }
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        Object[] selected = this.lstIncludeCollection.getSelectedValues();
        for (int i = 0; i < selected.length; ++i) {
            this.modelIncludeCollection.removeElement(selected[i]);
        }
        if (this.modelIncludeCollection.size() > 0) {
            this.lstIncludeCollection.setSelectedIndex(0);
        }
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        int selectedIndex = this.lstIncludeCollection.getSelectedIndex();
        Object selectObject = this.lstIncludeCollection.getSelectedValue();
        if (selectedIndex < 0 || selectedIndex >= this.modelIncludeCollection.size() - 1) {
            return;
        }
        this.modelIncludeCollection.removeElementAt(selectedIndex);
        this.modelIncludeCollection.insertElementAt(selectObject, selectedIndex + 1);
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        int selectedIndex = this.lstIncludeCollection.getSelectedIndex();
        Object selectObject = this.lstIncludeCollection.getSelectedValue();
        if (selectedIndex <= 0) {
            return;
        }
        this.modelIncludeCollection.removeElementAt(selectedIndex);
        this.modelIncludeCollection.insertElementAt(selectObject, selectedIndex - 1);
    }

    @Override
    protected void btnComfirm_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        if (!this.invalid) {
            this.destroyWindow();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setConfirmExit(false);
        this.destroyWindow();
    }

    @Override
    protected void lstIncludeCollection_actionPerormed(ListSelectionEvent e) {
        if (this.lstIncludeCollection.getSelectedIndex() == -1) {
            return;
        }
        if (this.lstIncludeCollection.getSelectedIndices().length == 1) {
            String selectValue = this.modelIncludeCollection.getElementAt(this.lstIncludeCollection.getSelectedIndex()).toString();
            this.txtIncludeItem.setText(selectValue);
        }
    }
}

