/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.query.ui;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.QueryPKInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.query.ui.AbstractQueryPKDefineUI;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class QueryPKDefineUI
extends AbstractQueryPKDefineUI {
    private static final Logger logger = CoreUIObject.getLogger(QueryPKDefineUI.class);
    private boolean confirmExit;
    public static final String MODEL = "model";
    public static final String QUERYPKINFO = "querypkinfo";
    private QueryInfo queryInfo;
    private QueryPKInfo pkInfo;
    private List selectedFields = new ArrayList();

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiContext = this.getUIContext();
        if (uiContext.get(MODEL) == null || !(uiContext.get(MODEL) instanceof QueryInfo)) {
            logger.error((Object)"\u52a0\u8f7dqueryInfo\u5931\u8d25");
            return;
        }
        this.queryInfo = (QueryInfo)uiContext.get(MODEL);
        if (uiContext.get(QUERYPKINFO) != null || uiContext.get(QUERYPKINFO) instanceof QueryPKInfo) {
            this.pkInfo = (QueryPKInfo)uiContext.get(QUERYPKINFO);
        }
        this.init();
    }

    public void init() {
        this.kDTreeView1.setShowButton(false);
        this.loadFieldTree();
    }

    public void loadFieldTree() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)this.pkInfo);
        root.setText("\u5b57\u6bb5");
        QueryFieldCollection needSelectedCol = this.pkInfo.getKeyPropertys();
        ArrayList fields = this.queryInfo.getSelector().getFields();
        for (int i = 0; i < fields.size(); ++i) {
            if (!(fields.get(i) instanceof QueryFieldInfo)) continue;
            QueryFieldInfo fieldInfo = (QueryFieldInfo)fields.get(i);
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)fieldInfo);
            if (needSelectedCol.contains(fieldInfo)) {
                node.setChecked(true);
                if (fieldInfo.getExtendedProperty("querydynconfigureditem") == null || !fieldInfo.getExtendedProperty("querydynconfigureditem").equalsIgnoreCase("true")) {
                    node.setCheckBoxEnabled(false);
                }
            }
            node.setText(fieldInfo.getName());
            root.add((MutableTreeNode)node);
        }
        ((KingdeeTreeModel)this.treeField.getModel()).setRoot((TreeNode)root);
        this.treeField.setRootVisible(false);
        this.treeField.setShowCheckBox(true);
        this.treeField.expandAllNodes(true, (TreeNode)root);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeField.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (!node.isChecked() || !(node.getUserObject() instanceof QueryFieldInfo)) continue;
            this.selectedFields.add((QueryFieldInfo)node.getUserObject());
        }
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeField.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (!node.isCheckBoxEnabled()) continue;
            node.setChecked(true);
        }
        this.treeField.repaint();
    }

    @Override
    protected void btnSelectNone_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectNone_actionPerformed(e);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeField.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (!node.isCheckBoxEnabled()) continue;
            node.setChecked(false);
        }
        this.treeField.repaint();
    }

    public List getSelectedFields() {
        return this.selectedFields;
    }

    public boolean isConfirmExit() {
        return this.confirmExit;
    }

    public void setConfirmExit(boolean confirmExit) {
        this.confirmExit = confirmExit;
    }

    @Override
    protected void btnComfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnComfirm_actionPerformed(e);
        this.storeFields();
        this.setConfirmExit(true);
        this.destroyWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.setConfirmExit(false);
        this.destroyWindow();
    }
}

