/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.query.ui;

import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.QueryParameterInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.query.ui.AbstractQueryParamDefineUI;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class QueryParamDefineUI
extends AbstractQueryParamDefineUI {
    private static final Logger logger = CoreUIObject.getLogger(QueryParamDefineUI.class);
    private boolean confirmExit;
    public static final String MODEL = "model";
    public static final String QUERYPARAMETERINFO = "queryparameterinfo";
    private static String[] COMPARE_TYPE = new String[]{CompareType.EQUALS.getName(), CompareType.GREATER.getName(), CompareType.LESS.getName(), CompareType.GREATER_EQUALS.getName(), CompareType.LESS_EQUALS.getName(), CompareType.NOTEQUALS.getName(), CompareType.LIKE.getName()};
    private QueryInfo model;
    private QueryParameterInfo parameterInfo;

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiContext = this.getUIContext();
        if (uiContext.get(MODEL) == null || !(uiContext.get(MODEL) instanceof QueryInfo)) {
            logger.error((Object)"\u52a0\u8f7dqueryInfo\u5931\u8d25");
            return;
        }
        this.model = (QueryInfo)uiContext.get(MODEL);
        if (uiContext.get(QUERYPARAMETERINFO) != null || uiContext.get(QUERYPARAMETERINFO) instanceof QueryParameterInfo) {
            this.parameterInfo = (QueryParameterInfo)uiContext.get(QUERYPARAMETERINFO);
        } else {
            this.parameterInfo = new QueryParameterInfo(this.model);
            this.parameterInfo.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        }
        this.init();
    }

    public void init() {
        this.combCount.addItems((Object[])COMPARE_TYPE);
        this.combField.addItems(this.model.getUnits().getQueryFields().toArray());
        if (this.parameterInfo != null) {
            this.fieldName.setText(this.parameterInfo.getName() == null ? "" : this.parameterInfo.getName());
            this.combCount.setSelectedItem((Object)(this.parameterInfo.getCompareType() == null ? "" : this.parameterInfo.getCompareType().getName()));
            this.combField.setSelectedItem(this.parameterInfo.getQueryField() == null ? null : this.parameterInfo.getQueryField());
            this.combField.setSelectedItem((Object)this.parameterInfo.getQueryField());
            if (!this.parameterInfo.isUserDefined()) {
                this.fieldName.setEnabled(false);
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        String name = this.fieldName.getText().trim();
        String compareType = this.combCount.getSelectedItem().toString();
        Object fieldInfo = this.combField.getSelectedItem();
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)compareType) || fieldInfo == null || !(fieldInfo instanceof QueryFieldInfo)) {
            return;
        }
        this.parameterInfo.setName(this.fieldName.getText().trim());
        this.parameterInfo.setCompareType(CompareType.getEnum((String)compareType));
        this.parameterInfo.setQueryField((QueryFieldInfo)this.combField.getSelectedItem());
        this.setConfirmExit(true);
    }

    public QueryParameterInfo getParameterInfo() {
        return this.parameterInfo;
    }

    public void setParameterInfo(QueryParameterInfo parameterInfo) {
        this.parameterInfo = parameterInfo;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean isConfirmExit() {
        return this.confirmExit;
    }

    public void setConfirmExit(boolean confirmExit) {
        this.confirmExit = confirmExit;
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.loadFields();
        this.destroyWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setConfirmExit(false);
        this.destroyWindow();
    }
}

