/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.query.ui;

import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.QuerySorterItemCollection;
import com.kingdee.bos.metadata.query.QuerySorterItemInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.query.ui.AbstractQuerySortDefineUI;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class QuerySortDefineUI
extends AbstractQuerySortDefineUI {
    private static final Logger logger = CoreUIObject.getLogger(QuerySortDefineUI.class);
    private boolean confirmExit;
    public static final String MODEL = "model";
    public static final String QUERYSORTINFO = "querysortinfo";
    private QueryInfo queryInfo;
    private QuerySorterItemInfo sorterItemInfo;
    private static String[] SORT_TYPE = EnumUtils.getEnumNames(SortType.class);

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiContext = this.getUIContext();
        if (uiContext.get(MODEL) == null || !(uiContext.get(MODEL) instanceof QueryInfo)) {
            logger.error((Object)"\u52a0\u8f7dqueryInfo\u5931\u8d25");
            return;
        }
        this.queryInfo = (QueryInfo)uiContext.get(MODEL);
        if (uiContext.get(QUERYSORTINFO) != null || uiContext.get(QUERYSORTINFO) instanceof QuerySorterItemInfo) {
            this.sorterItemInfo = (QuerySorterItemInfo)uiContext.get(QUERYSORTINFO);
        } else {
            this.sorterItemInfo = new QuerySorterItemInfo(this.queryInfo);
            this.sorterItemInfo.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        }
        this.init();
    }

    public void init() {
        QuerySorterItemInfo sortInfo;
        int i;
        ArrayList<String> qfNameList;
        this.combSortType.addItems((Object[])SORT_TYPE);
        if (this.queryInfo instanceof JoinQueryInfo) {
            ArrayList col = this.queryInfo.getSelector().getFields();
            qfNameList = new ArrayList();
            for (i = 0; i < col.size(); ++i) {
                QueryFieldInfo qf = (QueryFieldInfo)col.get(i);
                if (!qf.isIsSorter() || this.isSorterFiledExist(qf)) continue;
                qfNameList.add(qf.getName());
            }
        } else if (this.queryInfo instanceof UnionQueryInfo) {
            ArrayList qfList = ((UnionQueryInfo)this.queryInfo).getSelector().getFields();
            qfNameList = new ArrayList(qfList.size());
            for (i = 0; i < qfList.size(); ++i) {
                QueryFieldInfo qf = (QueryFieldInfo)qfList.get(i);
                if (!qf.isIsSorter() || this.isSorterFiledExist(qf)) continue;
                qfNameList.add(qf.getName());
            }
        } else {
            qfNameList = new ArrayList<String>();
        }
        if ((sortInfo = (QuerySorterItemInfo)this.getUIContext().get("editSelectFiled")) != null) {
            qfNameList.add(sortInfo.getPropertyName());
        }
        Object[] queryFields = new String[qfNameList.size()];
        qfNameList.toArray(queryFields);
        this.combField.addItems(queryFields);
        if (this.sorterItemInfo != null) {
            this.combField.setSelectedItem((Object)(this.sorterItemInfo.getQueryField() == null ? "" : this.sorterItemInfo.getQueryField().getName()));
            this.combSortType.setSelectedItem((Object)(this.sorterItemInfo.getSortType() == null ? "" : this.sorterItemInfo.getSortType().getName()));
        }
        if (!this.sorterItemInfo.isConfigured()) {
            this.combField.setEnabled(false);
        }
    }

    private boolean isSorterFiledExist(QueryFieldInfo field) {
        if (field == null) {
            return false;
        }
        QuerySorterItemCollection sorters = this.queryInfo.getDefaultSorters();
        int n = sorters.size();
        for (int i = 0; i < n; ++i) {
            QuerySorterItemInfo sorterItem = sorters.get(i);
            QueryFieldInfo queryField = sorterItem.getQueryField();
            if (!field.equals((Object)queryField)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.combField.getSelectedItem() == null) {
            MsgBox.showInfo((String)"\u6ca1\u6709\u53ef\u4f9b\u9009\u62e9\u7684\u6392\u5e8f\u5b57\u6bb5\u3002");
            return;
        }
        String compareType = this.combSortType.getSelectedItem().toString();
        String queryField = this.combField.getSelectedItem().toString();
        if (compareType == null || queryField == null) {
            return;
        }
        this.sorterItemInfo.setSortType(SortType.getEnum((String)compareType));
        if (this.queryInfo instanceof JoinQueryInfo) {
            QueryFieldCollection col = this.queryInfo.getUnits().getQueryFields();
            for (int i = 0; i < col.size(); ++i) {
                String qname = col.get(i).getName();
                if (!qname.equals(queryField)) continue;
                this.sorterItemInfo.setQueryField(col.get(i));
                break;
            }
        } else {
            ArrayList qfList = ((UnionQueryInfo)this.queryInfo).getSelector().getFields();
            int n = qfList.size();
            for (int i = 0; i < n; ++i) {
                String qname = ((QueryFieldInfo)qfList.get(i)).getName();
                if (!qname.equals(queryField)) continue;
                this.sorterItemInfo.setQueryField((QueryFieldInfo)qfList.get(i));
                break;
            }
        }
        this.setConfirmExit(true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public QuerySorterItemInfo getSorterItemInfo() {
        return this.sorterItemInfo;
    }

    public boolean isConfirmExit() {
        return this.confirmExit;
    }

    public void setConfirmExit(boolean confirmExit) {
        this.confirmExit = confirmExit;
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.destroyWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setConfirmExit(false);
        this.destroyWindow();
    }
}

