/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.tabpane;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.client.editor.bind.DataBindUI;
import com.kingdee.eas.ep.client.editor.editui.designer.NewCtrlDialog;
import com.kingdee.eas.ep.client.editor.editui.designer.TabbedPaneEditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.UictEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.tabpane.AbstractKDTabPaneConfigUI;
import com.kingdee.eas.ep.client.editor.tabpane.TabConfigUI;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.BizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class KDTabPaneConfigUI
extends AbstractKDTabPaneConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(KDTabPaneConfigUI.class);
    public static final String VIEWER = "viewer";
    public static final String TABPANE_EDITPART = "tabpane_editpart";
    private TabbedPaneEditPart tabEditPart;
    private UictEditPartViewer viewer;

    public void onLoad() throws Exception {
        super.onLoad();
        Object object = this.getUIContext().get(TABPANE_EDITPART);
        if (!(object instanceof TabbedPaneEditPart)) {
            throw new IllegalArgumentException("can not get the TabbedPaneEditPart from uicontext!");
        }
        this.tabEditPart = (TabbedPaneEditPart)object;
        object = this.getUIContext().get(VIEWER);
        if (!(object instanceof UictEditPartViewer)) {
            throw new IllegalArgumentException("can not get the UictEditPartViewer from uicontext!");
        }
        this.viewer = (UictEditPartViewer)object;
        this.tableList.checkParsed(true);
        if (this.viewer.getContext().isBase()) {
            this.butUP.setVisible(false);
            this.butDown.setVisible(false);
            this.butAddNew.setBounds(new Rectangle(380, 10, 60, 19));
            this.add((Component)this.butAddNew, null);
            this.butDelete.setBounds(new Rectangle(380, 54, 60, 19));
            this.add((Component)this.butDelete, null);
            this.butEdit.setBounds(new Rectangle(380, 32, 60, 19));
            this.add((Component)this.butEdit, null);
        } else {
            this.butAddNew.setEnabled(false);
            this.butDelete.setEnabled(false);
        }
        this.tableList.getSelectManager().setSelectMode(2);
        this.loadData();
    }

    public void loadData() {
        this.tableList.removeRows();
        BizConfigureTreeNode node = this.tabEditPart.getTabbedPanelNode();
        List col = node.getNodeChildren();
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            BizConfigureTreeNode child = (BizConfigureTreeNode)((Object)col.get(i));
            if (!(child.getUserObject() instanceof ComponentInfo)) continue;
            ComponentInfo cInfo = (ComponentInfo)child.getUserObject();
            String title = "";
            BizConfigureItemInfo item = EditUIEditorHelper.getItemByComponent(node, cInfo);
            if (item != null) {
                title = item.getLabel();
            }
            if (StringUtils.isEmpty((String)title)) {
                title = cInfo.getConstraint() instanceof String ? cInfo.getConstraint().toString() : "\u5206\u7ec4";
            }
            IRow row = this.tableList.addRow();
            row.setUserObject((Object)child);
            row.getCell(0).setValue((Object)child.getName());
            row.getCell(1).setValue((Object)title);
            row.getCell(2).setValue((Object)item.isVisible());
            if (!cInfo.isConfigured()) continue;
            row.getStyleAttributes().setBackground(DataBindUI.dynColor);
        }
    }

    private void resetTabOrder() {
        BizConfigureTreeNode node = this.tabEditPart.getTabbedPanelNode();
        int size = this.tableList.getRowCount();
        ArrayList<BizConfigureTreeNode> col = new ArrayList<BizConfigureTreeNode>(size);
        for (int i = 0; i < size; ++i) {
            col.add((BizConfigureTreeNode)((Object)this.tableList.getRow(i).getUserObject()));
        }
        node.resetChildNode(col);
    }

    @Override
    protected void tableList_tableSelectChanged(KDTSelectEvent e) throws Exception {
        BizConfigureTreeNode node;
        ComponentInfo cInfo;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tableList);
        if (row != null && row.getUserObject() != null && row.getUserObject() instanceof BizConfigureTreeNode && (cInfo = (ComponentInfo)(node = (BizConfigureTreeNode)((Object)row.getUserObject())).getUserObject()).isConfigured()) {
            this.butDelete.setEnabled(true);
            return;
        }
        this.butDelete.setEnabled(false);
    }

    @Override
    protected void tableList_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    protected void tableList_editStopped(KDTEditEvent e) throws Exception {
    }

    @Override
    protected void butUP_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tableList);
        if (rowIndex.length > 0 && rowIndex[0] > 0) {
            this.tableList.moveRow(rowIndex[0], rowIndex[0] - 1);
            this.resetTabOrder();
            this.loadData();
            this.tabEditPart.reload();
            KDTableUtil.setSelectedRow((KDTable)this.tableList, (int)(rowIndex[0] - 1));
        }
    }

    @Override
    protected void butDown_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.tableList);
        if (rowIndex.length > 0 && rowIndex[0] < this.tableList.getRowCount() - 1) {
            this.tableList.moveRow(rowIndex[0], rowIndex[0] + 1);
            this.resetTabOrder();
            this.loadData();
            this.tabEditPart.reload();
            KDTableUtil.setSelectedRow((KDTable)this.tableList, (int)(rowIndex[0] + 1));
        }
    }

    @Override
    protected void butAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(NewCtrlDialog.class.getName(), (Map)uiContext);
            NewCtrlDialog ncUI = (NewCtrlDialog)uiWindow.getUIObject();
            ncUI.setUIObjectInfo((UIObjectInfo)this.viewer.getContext().getUiModel());
            ncUI.setNode(this.tabEditPart.getTabbedPanelNode());
            ncUI.setClassType("com.kingdee.bos.ctrl.swing.KDPanel");
            ncUI.init(null, "new");
            ncUI.setUITitle("\u65b0\u589e\u9875\u7b7e");
            uiWindow.show();
            if ("confirm".equals(ncUI.getExitStatus())) {
                this.tabEditPart.reload();
                this.loadData();
                this.viewer.getContext().setDirty(true);
                this.viewer.getCommandStack().flush();
            }
        }
        catch (UIException ue) {
            ExceptionHandler.handleError(null, (Exception)((Object)ue), "\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
        }
    }

    @Override
    protected void butEdit_actionPerformed(ActionEvent e) throws Exception {
        super.butEdit_actionPerformed(e);
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tableList);
        if (row != null && row.getUserObject() != null && row.getUserObject() instanceof BizConfigureTreeNode) {
            String label;
            BizConfigureTreeNode selectNode = (BizConfigureTreeNode)((Object)row.getUserObject());
            ComponentInfo cInfo = (ComponentInfo)selectNode.getUserObject();
            String string = label = row.getCell(1).getValue() == null ? "" : row.getCell(1).getValue().toString();
            if (cInfo != null) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put("Owner", this);
                try {
                    IUIWindow uiWindow = this.viewer.getContext().isBase() ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TabConfigUI.class.getName(), (Map)uiContext) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TabConfigUI.class.getName(), (Map)uiContext);
                    NewCtrlDialog ncUI = (NewCtrlDialog)uiWindow.getUIObject();
                    ncUI.setUIObjectInfo((UIObjectInfo)this.viewer.getContext().getUiModel());
                    ncUI.setNode(this.tabEditPart.getTabbedPanelNode());
                    ncUI.setClassType("com.kingdee.bos.ctrl.swing.KDPanel");
                    ncUI.init(cInfo, "edit", label);
                    ncUI.setUITitle("\u4fee\u6539\u9875\u7b7e");
                    uiWindow.show();
                    if ("confirm".equals(ncUI.getExitStatus())) {
                        this.tabEditPart.reload();
                        this.loadData();
                        this.viewer.getContext().setDirty(true);
                        this.viewer.getCommandStack().flush();
                    }
                }
                catch (UIException ue) {
                    ExceptionHandler.handleError(null, (Exception)((Object)ue), "\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
                }
            }
        } else {
            MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u9875\u7b7e.");
        }
    }

    @Override
    protected void butDelete_actionPerformed(ActionEvent e) throws Exception {
        BizConfigureTreeNode selectNode;
        ComponentInfo cInfo;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tableList);
        if (row != null && row.getUserObject() != null && row.getUserObject() instanceof BizConfigureTreeNode && (cInfo = (ComponentInfo)(selectNode = (BizConfigureTreeNode)((Object)row.getUserObject())).getUserObject()) != null) {
            if (cInfo.isConfigured()) {
                int confirm = MsgBox.showConfirm2((String)("\u5220\u9664[" + cInfo.getConstraint().toString() + "]"));
                if (confirm != 0) {
                    return;
                }
                BizConfigureItemInfoAdapter adapter = (BizConfigureItemInfoAdapter)this.tabEditPart.getModel();
                ComponentInfo tabbedPane = adapter.getItem().getComponent();
                BizConfigureTreeNode tabbedPaneNode = this.tabEditPart.getTabbedPanelNode();
                tabbedPaneNode.remove((MutableTreeNode)((Object)selectNode));
                BizConfigureItemCollection items = (BizConfigureItemCollection)tabbedPaneNode.getConfigureItems();
                int n = items.size();
                for (int i = 0; i < n; ++i) {
                    BizConfigureItemInfo itemInfo = (BizConfigureItemInfo)items.get(i);
                    if (!cInfo.equals((Object)itemInfo.getComponent())) continue;
                    items.remove(itemInfo);
                    this.viewer.getContext().getUiModel().getNameManager().remove(itemInfo.getName());
                    break;
                }
                tabbedPane.removeChild(this.viewer.getContext().getUiModel(), cInfo);
                this.tabEditPart.reload();
                this.loadData();
                this.viewer.getContext().setDirty(true);
                this.viewer.getCommandStack().flush();
            } else {
                MsgBox.showWarning((String)("[" + cInfo.getName() + "]\u662f\u9759\u6001\u5143\u6570\u636e\u63a7\u4ef6\uff0c\u4e0d\u80fd\u5220\u9664\uff01"));
            }
        }
    }
}

