/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.figure;

import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.TableItemInfo;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class FigureHelper {
    private static final Logger logger = CoreUIObject.getLogger(FigureHelper.class);
    private static Map figureMap = new HashMap();
    public static final ImageIcon rootIcon = new ImageIcon(FigureHelper.class.getResource("type/root.gif"));
    public static final ImageIcon customizedUnitIcon = new ImageIcon(FigureHelper.class.getResource("type/customizedunit.gif"));
    public static final ImageIcon uiIcon = new ImageIcon(FigureHelper.class.getResource("type/ui.gif"));
    public static final ImageIcon entityIcon = new ImageIcon(FigureHelper.class.getResource("type/entity.gif"));
    public static final ImageIcon enumIcon = new ImageIcon(FigureHelper.class.getResource("type/enum.gif"));
    public static final ImageIcon facadeIcon = new ImageIcon(FigureHelper.class.getResource("type/facade.gif"));
    public static final ImageIcon functionIcon = new ImageIcon(FigureHelper.class.getResource("type/function.gif"));
    public static final ImageIcon exceptionIcon = new ImageIcon(FigureHelper.class.getResource("type/exception.gif"));
    public static final ImageIcon listuiIcon = new ImageIcon(FigureHelper.class.getResource("type/listui.gif"));
    public static final ImageIcon queryIcon = new ImageIcon(FigureHelper.class.getResource("type/query.gif"));
    public static final ImageIcon relationIcon = new ImageIcon(FigureHelper.class.getResource("type/relation.gif"));
    public static final ImageIcon logIcon = new ImageIcon(FigureHelper.class.getResource("type/log.gif"));
    public static final ImageIcon tableIcon = new ImageIcon(FigureHelper.class.getResource("type/table.gif"));
    public static final ImageIcon permissionIcon = new ImageIcon(FigureHelper.class.getResource("type/permission.gif"));
    public static final ImageIcon edituiIcon = new ImageIcon(FigureHelper.class.getResource("type/editui.gif"));
    public static final ImageIcon otheruiIcon = new ImageIcon(FigureHelper.class.getResource("type/otherui.gif"));
    public static final ImageIcon errorIcon = new ImageIcon(FigureHelper.class.getResource("wizard/error.gif"));
    public static final ImageIcon warnIcon = new ImageIcon(FigureHelper.class.getResource("wizard/warn.gif"));
    public static final Icon lockIcon = EASResource.getIcon((String)"imgTree_allotpopedom");
    public static final Image rootImage = rootIcon.getImage();
    public static final Image customizedUnitImage = customizedUnitIcon.getImage();
    public static final Image uiImage = uiIcon.getImage();
    public static final Image entityImage = entityIcon.getImage();
    public static final Image enumImage = enumIcon.getImage();
    public static final Image facadeImage = facadeIcon.getImage();
    public static final Image functionImage = functionIcon.getImage();
    public static final Image exceptionImage = exceptionIcon.getImage();
    public static final Image listuiImage = listuiIcon.getImage();
    public static final Image queryImage = queryIcon.getImage();
    public static final Image relationImage = relationIcon.getImage();
    public static final Image logImage = logIcon.getImage();
    public static final Image tableImage = tableIcon.getImage();
    public static final Image permissionImage = permissionIcon.getImage();
    public static final Image edituiImage = edituiIcon.getImage();
    public static final Image otheruiImage = otheruiIcon.getImage();
    public static final Image errorImage = errorIcon.getImage();
    public static final Image warnImage = warnIcon.getImage();
    public static final Image lockImage = EASResource.getImage((String)"imgTree_allotpopedom");
    public static final int EAST = 1;
    public static final int WEST = 2;
    public static final int SOUTH = 4;
    public static final int NORTH = 8;

    public static Image getImage(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        return new ImageIcon(FigureHelper.class.getResource(path)).getImage();
    }

    public static ImageIcon getImageIcon(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        ImageIcon img = (ImageIcon)figureMap.get(path);
        if (img == null) {
            try {
                img = new ImageIcon(FigureHelper.class.getResource(path));
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
            figureMap.put(path, img);
        }
        return img;
    }

    public static void clearFigureMap() {
        figureMap.clear();
    }

    public static BufferedImage drawAlphaImage(Dimension size, float alpha, Color color, boolean border) {
        boolean isAdjust = false;
        if (size.width <= 0) {
            isAdjust = true;
            size.width = 1;
            logger.info((Object)"\u5bbd\u5ea6\u5c0f\u4e8e0,\u81ea\u52a8\u8c03\u6574\u4e3a1px");
        }
        if (size.height <= 0) {
            isAdjust = true;
            size.height = 19;
            logger.info((Object)"\u9ad8\u5ea6\u5c0f\u4e8e0,\u81ea\u52a8\u8c03\u6574\u4e3a19px");
        }
        BufferedImage image = new BufferedImage(size.width, size.height, 6);
        Graphics2D gm = image.createGraphics();
        gm.setColor(color);
        gm.setComposite(AlphaComposite.getInstance(4, alpha));
        gm.fillRect(0, 0, size.width, size.height);
        if (border || isAdjust) {
            gm.setComposite(AlphaComposite.getInstance(4, 1.0f));
            gm.setColor(Color.black);
            gm.drawRect(0, 0, size.width - 1, size.height - 1);
        }
        return image;
    }

    public static void drawPoint(Graphics g, Rectangle rect, int dir, Color color) {
        if (g != null && rect != null) {
            Point p;
            if ((dir & 1) != 0) {
                p = new Point(rect.x + rect.width - 4, rect.height / 2 + rect.y - 2);
                FigureHelper.drawSquare(g, p, color);
            }
            if ((dir & 2) != 0) {
                p = new Point(rect.x - 2, rect.height / 2 + rect.y - 2);
                FigureHelper.drawSquare(g, p, color);
            }
            if ((dir & 4) != 0) {
                p = new Point(rect.width / 2 + rect.x - 2, rect.y + rect.height - 4);
                FigureHelper.drawSquare(g, p, color);
            }
            if ((dir & 8) != 0) {
                p = new Point(rect.width / 2 + rect.x - 2, rect.y - 2);
                FigureHelper.drawSquare(g, p, color);
            }
        }
    }

    private static void drawSquare(Graphics g, Point point, Color color) {
        Color old = g.getColor();
        g.setColor(Color.white);
        g.fillRect(point.x, point.y, 6, 6);
        g.setColor(color);
        g.fillRect(point.x + 1, point.y + 1, 4, 4);
        g.setColor(old);
    }

    public static ComponentParam getComponentParam(BizConfigureItemInfo item) {
        if (item == null) {
            return null;
        }
        ComponentParam cp = new ComponentParam();
        ComponentInfo cInfo = item.getComponent();
        if (cInfo == null) {
            return cp;
        }
        cp.enabled = item.isEnabled();
        cp.required = item.isRequired();
        cp.horizontalAlignment = item.getHorizontalAlignment();
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(cInfo.getClassType())) {
            cp.boundLabelText = StringUtils.isEmpty((String)cInfo.getAlias()) ? cInfo.getName() : cInfo.getAlias();
            cp.formatXml = FigureHelper.getFormatXml(item);
        } else if ("com.kingdee.bos.ctrl.swing.KDLabel".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDRadioButton".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDCheckBox".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDContainer".equals(cInfo.getClassType())) {
            cp.text = item.getLabel();
        } else if ("com.kingdee.bos.ctrl.swing.KDWorkButton".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDButton".equals(cInfo.getClassType())) {
            String icon;
            cp.text = item.getLabel();
            PropertyInfo propertyInfo = cInfo.getPropertyByName("icon");
            if (propertyInfo != null && (icon = cInfo.getPropertyByName("icon").getValue()) != null) {
                cp.icon = EASResource.getIcon((String)icon);
            }
        } else if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(cInfo.getClassType())) {
            FigureHelper.processLabelContainer(cp, item);
        } else if (cInfo.getParent() != null) {
            if ("com.kingdee.bos.ctrl.swing.KDScrollPane".equals(cInfo.getParent().getClassType())) {
                cInfo = cInfo.getParent();
            }
            if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(cInfo.getParent().getClassType())) {
                FigureHelper.processLabelContainer(cp, item);
            }
        } else {
            PropertyInfo property = cInfo.getPropertyByName("text");
            if (property != null) {
                cp.boundLabelText = property.getValue();
            }
        }
        return cp;
    }

    private static String getFormatXml(BizConfigureItemInfo item) {
        String order = item instanceof TableItemInfo ? ((TableItemInfo)item).getColumnOrder() : item.getComponent().getExtendedProperty("column_order");
        PropertyInfo property = item.getComponent().getProperties().get("formatXml");
        if (property != null) {
            TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
            EditUIEditorHelper.reOrderTableFormatXml(tableInfo, order);
            return KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo);
        }
        return null;
    }

    private static void processLabelContainer(ComponentParam cp, BizConfigureItemInfo item) {
        cp.boundLabelText = item.getLabel();
        cp.boundLabelLength = item.getLabelLength();
        cp.boundLabelUnderline = item.isLabelUnderLine();
        cp.boundLabelAlignment = item.getLabelAlignment();
    }

    public static class ComponentParam {
        public String boundLabelText = "";
        public int boundLabelLength = 100;
        public boolean boundLabelUnderline = true;
        public int boundLabelAlignment = 7;
        public Color foreground = new Color(0, 0, 0);
        public boolean enabled = true;
        public boolean required = false;
        public String text = "";
        public String formatXml = "";
        public int horizontalAlignment = 2;
        public Icon icon;
    }
}

