/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.handle;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.xml.impl.ElementProxyStateManager;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.IUpdateSql;
import com.kingdee.eas.ep.UpdateSqlFactory;
import com.kingdee.eas.ep.client.TableFieldAlterUI;
import com.kingdee.eas.ep.client.depend.mutiLan.MutiLanUtil;
import com.kingdee.eas.ep.client.editor.entity.EntityExtendedPropertyUI;
import com.kingdee.eas.ep.client.editor.entity.PropertyDefineUI;
import com.kingdee.eas.ep.client.editor.entity.TableSynchronizer;
import com.kingdee.eas.ep.client.model.PropertyInfoProxy;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractPropertyDefineUIManager {
    private EntityObjectInfo entity;
    private DataTableInfo table;
    private KDPanel editor;
    private Project depend;
    private List addPropList = new ArrayList();
    private List editPropList = new ArrayList();
    private Map listVisbleMap = new HashMap();
    private Map filterMap = new HashMap();
    private List deletePropList = new ArrayList();
    private boolean isUseAddFiled = false;
    private boolean isVisiblelistVisible = false;
    protected PropertyDefineUI propertyDefineUI;
    private List shouldDeleteRelation = new ArrayList();

    public AbstractPropertyDefineUIManager(KDPanel editor, EntityObjectInfo entity, DataTableInfo table, Project depend) {
        this.editor = editor;
        this.entity = entity;
        this.table = table;
        this.depend = depend;
    }

    public void view(PropertyInfo pInfo, boolean isListVisible, boolean isFilter) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getPropertyDefineUIClass(), this.getUIContext());
        this.propertyDefineUI = (PropertyDefineUI)uiWindow.getUIObject();
        this.propertyDefineUI.setOprtState("VIEW");
        PropertyInfoProxy proxy = new PropertyInfoProxy(this.entity, pInfo);
        proxy.setDepend(this.depend);
        proxy.syn2Proxy();
        this.propertyDefineUI.setPropertyProxy(proxy);
        this.propertyDefineUI.setDepend(this.depend);
        this.propertyDefineUI.setListVisible(isListVisible);
        this.propertyDefineUI.setCommonQueryFilter(isFilter);
        this.propertyDefineUI.setListVisibleEnabled(false);
        uiWindow.show();
    }

    public boolean edit(PropertyInfo pInfo, boolean isListVisible, boolean isFilter) throws Exception {
        this.listVisbleMap.clear();
        this.filterMap.clear();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getPropertyDefineUIClass(), this.getUIContext());
        this.propertyDefineUI = (PropertyDefineUI)uiWindow.getUIObject();
        this.propertyDefineUI.setOprtState("EDIT");
        PropertyInfoProxy proxy = new PropertyInfoProxy(this.entity, pInfo);
        proxy.setDepend(this.depend);
        proxy.syn2Proxy();
        this.propertyDefineUI.setPropertyProxy(proxy);
        this.propertyDefineUI.setDepend(this.depend);
        this.propertyDefineUI.setListVisible(isListVisible);
        this.propertyDefineUI.setCommonQueryFilter(isFilter);
        uiWindow.show();
        if ("confirm".equals(this.propertyDefineUI.getExitStatus())) {
            MutiLanUtil.setAlias(pInfo, proxy.getAlias());
            this.renameProperty(pInfo, proxy, this.table);
            this.listVisbleMap.put(pInfo.getName(), this.propertyDefineUI.getListVisible());
            this.filterMap.put(pInfo.getName(), this.propertyDefineUI.getCommonQueryFilter());
            this.entity.getProperties().add(pInfo);
            this.isUseAddFiled = true;
            this.editPropList.add(pInfo);
            return true;
        }
        return false;
    }

    private void renameProperty(PropertyInfo pInfo, PropertyInfoProxy proxy, DataTableInfo tableInfo) throws BOSException {
        String name = proxy.getName();
        if (StringUtils.isEmpty((String)name) || name.equals(pInfo.getName())) {
            return;
        }
        pInfo.setName(name);
        pInfo.getName();
        ColumnInfo column = pInfo.getMappingField();
        String columnName = column.getName();
        IUpdateSql instance = UpdateSqlFactory.getRemoteInstance();
        if (!instance.exists(tableInfo.getName(), columnName)) {
            String columnName0 = TableSynchronizer.generateColumnName0(proxy, tableInfo);
            IStateManager stateManager = column.getStateManager();
            if (stateManager instanceof ElementProxyStateManager) {
                IStateManager delegate = ((ElementProxyStateManager)stateManager).getDelegate();
                column.setStateManager(delegate);
            }
            column.setName(columnName0);
        }
    }

    public boolean addNew() throws Exception {
        this.listVisbleMap.clear();
        this.filterMap.clear();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getPropertyDefineUIClass(), this.getUIContext());
        this.propertyDefineUI = (PropertyDefineUI)uiWindow.getUIObject();
        this.propertyDefineUI.setOprtState("ADDNEW");
        PropertyDefineUI ui = this.propertyDefineUI;
        PropertyInfoProxy proxy = new PropertyInfoProxy(this.entity);
        proxy.setDepend(this.depend);
        this.propertyDefineUI.setPropertyProxy(proxy);
        this.propertyDefineUI.setDepend(this.depend);
        uiWindow.show();
        if ("confirm".equals(ui.getExitStatus())) {
            this.dealPinfoList(ui);
            proxy.syn2Property();
            PropertyInfo pInfo = proxy.getPropertyInfo();
            this.listVisbleMap.put(pInfo.getName(), ui.getListVisible());
            this.filterMap.put(pInfo.getName(), ui.getCommonQueryFilter());
            this.entity.getProperties().add(pInfo);
            this.addPropList.add(pInfo);
            this.isUseAddFiled = true;
            if (pInfo.getMappingField() == null) {
                ColumnInfo column = TableSynchronizer.createColumnByBizField(proxy, this.table);
                this.table.getColumns().add(column);
                pInfo.setMappingField(column);
            }
            return true;
        }
        return this.dealPinfoList(ui);
    }

    protected Map getUIContext() {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this.editor);
        uiContext.put("isVisiblelistVisible", this.isVisiblelistVisible);
        uiContext.put("ENTITY_OBJECT_INFO", this.entity);
        return uiContext;
    }

    private boolean dealPinfoList(PropertyDefineUI ui) {
        int i;
        List pinfoList = ui.getPInfoLIst();
        List columnLIst = ui.getColumnLIst();
        int size = pinfoList.size();
        for (i = 0; i < size; ++i) {
            this.entity.getProperties().add((PropertyInfo)pinfoList.get(i));
        }
        size = columnLIst.size();
        for (i = 0; i < size; ++i) {
            this.table.getColumns().add((ColumnInfo)columnLIst.get(i));
        }
        this.listVisbleMap = ui.getListVisbleMap();
        this.filterMap = ui.getFilterMap();
        this.addPropList.addAll(pinfoList);
        return pinfoList.size() > 0;
    }

    public void delete(PropertyInfo pInfo) throws Exception {
        ColumnInfo column;
        if (pInfo == null) {
            return;
        }
        int n = this.entity.getProperties().size();
        for (int i = 0; i < n; ++i) {
            String entityPropName = this.entity.getProperties().get(i).getName();
            if (StringUtils.isEmpty((String)entityPropName) || !entityPropName.equalsIgnoreCase(pInfo.getName())) continue;
            boolean retValue = this.entity.getProperties().remove(this.entity.getProperties().get(i));
            if (!retValue) {
                MsgBox.showInfo((String)("[" + pInfo.getAlias() + "]\u5220\u9664\u5931\u8d25"));
                break;
            }
            this.deletePropList.add(pInfo);
            break;
        }
        if (pInfo instanceof LinkPropertyInfo) {
            String metaPK = ((LinkPropertyInfo)pInfo).getRelationship().getFullName();
            this.shouldDeleteRelation.add(metaPK);
        }
        if ((column = pInfo.getMappingField()) != null) {
            this.table.getColumns().remove(column);
        }
        this.isUseAddFiled = true;
    }

    public void setExtendedProperty(PropertyInfo pInfo) throws Exception {
        if (pInfo == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this.editor);
        uiContext.put("ENTITY_OBJECT_INFO", this.entity);
        uiContext.put("PROPERTY_INFO", pInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EntityExtendedPropertyUI.class.getName(), (Map)uiContext);
        EntityExtendedPropertyUI ui = (EntityExtendedPropertyUI)uiWindow.getUIObject();
        uiWindow.show();
        if ("confirm".equals(ui.getExitStatus())) {
            // empty if block
        }
    }

    public boolean alterTableField(PropertyInfo pInfo) throws Exception {
        boolean confirm;
        if (pInfo == null || pInfo.getMappingField() == null) {
            return false;
        }
        String oldField = pInfo.getMappingField().getName();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this.editor);
        uiContext.put("FIELD", oldField);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TableFieldAlterUI.class.getName(), (Map)uiContext);
        TableFieldAlterUI ui = (TableFieldAlterUI)uiWindow.getUIObject();
        uiWindow.show();
        boolean bl = confirm = !ui.isCancel();
        if (confirm) {
            String field = ui.getField();
            ColumnInfo column = this.table.getColumnByName(oldField);
            if (column != null) {
                column.setName(field);
                column.setAlias(field);
            }
            pInfo.setMappingField(column);
        }
        return confirm;
    }

    public List getPropList() {
        return this.addPropList;
    }

    public void setPropList(List addPropList) {
        this.addPropList = addPropList;
    }

    public List getEditPropList() {
        return this.editPropList;
    }

    public boolean isUseAddFiled() {
        return this.isUseAddFiled;
    }

    public void setUseAddFiled(boolean isUseAddFiled) {
        this.isUseAddFiled = isUseAddFiled;
    }

    public List getDeletePropList() {
        return this.deletePropList;
    }

    public void setDeletePropList(List deletePropList) {
        this.deletePropList = deletePropList;
    }

    public Map getListVisbleMap() {
        return this.listVisbleMap;
    }

    public void setVisiblelistVisible(boolean isVisiblelistVisible) {
        this.isVisiblelistVisible = isVisiblelistVisible;
    }

    public Map getFilterMap() {
        return this.filterMap;
    }

    public List getShouldDeleteRelation() {
        return this.shouldDeleteRelation;
    }

    public void addShouldDeleteRelation(String metaDataPK) {
        this.shouldDeleteRelation.add(metaDataPK);
    }

    public abstract String getPropertyDefineUIClass();
}

